/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.dialogs;

import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Optional;
import javax.swing.JDialog;
import org.omegat.gui.dialogs.PasswordSetPanel;
import org.omegat.util.OStrings;
import org.omegat.util.gui.StaticUIUtils;

public class PasswordEnterDialogController {
    private char[] password;

    public void show(Window parent, String message) {
        final JDialog dialog = new JDialog(parent);
        dialog.setTitle(OStrings.getString("PASSWORD_DIALOG_TITLE"));
        dialog.setModal(true);
        StaticUIUtils.setWindowIcon(dialog);
        StaticUIUtils.setEscapeClosable(dialog);
        final PasswordSetPanel panel = new PasswordSetPanel();
        dialog.getContentPane().add(panel);
        dialog.getRootPane().setDefaultButton(panel.okButton);
        panel.confirmLabel.setVisible(false);
        panel.confirmPasswordField.setVisible(false);
        panel.doNotSetButton.setVisible(false);
        panel.messageTextArea.setText(message);
        panel.okButton.addActionListener(e -> {
            char[] entered = panel.passwordField.getPassword();
            if (entered.length == 0) {
                panel.errorTextArea.setText(OStrings.getString("PASSWORD_ERROR_EMPTY"));
            } else {
                panel.errorTextArea.setText(null);
                this.password = entered;
                StaticUIUtils.closeWindowByEvent(dialog);
            }
        });
        panel.cancelButton.addActionListener(e -> StaticUIUtils.closeWindowByEvent(dialog));
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                dialog.pack();
                panel.passwordField.requestFocusInWindow();
            }
        });
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
    }

    public Optional<char[]> getResult() {
        return Optional.ofNullable(this.password);
    }
}

