/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.glossary.taas;

import gen.taas.TaasExtractionResult;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.omegat.core.glossaries.IGlossary;
import org.omegat.gui.glossary.GlossaryEntry;
import org.omegat.gui.glossary.GlossaryReaderTBX;
import org.omegat.gui.glossary.taas.TaaSPlugin;
import org.omegat.util.Language;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;

public class TaaSGlossary
implements IGlossary {
    private static final Logger LOGGER = Logger.getLogger(TaaSGlossary.class.getName());

    @Override
    public List<GlossaryEntry> search(Language sLang, Language tLang, String srcText) throws Exception {
        if (!Preferences.isPreferenceDefault("taas_lookup", false) || !TaaSPlugin.getClient().isAllowed()) {
            return Collections.emptyList();
        }
        TaasExtractionResult res = TaaSPlugin.getClient().termExtraction(sLang, tLang, srcText, Preferences.getPreference("taas_domain"));
        String data = TaaSPlugin.filterTaasResult(res.getTerms());
        List<GlossaryEntry> entries = GlossaryReaderTBX.read(data, false, OStrings.getString("TAAS_GLOSSARY_NAME"));
        Log.logDebug(LOGGER, "TaaS returns {0} glossary entries", entries.size());
        return entries;
    }
}

