/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.machinetranslators;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.awt.Window;
import java.util.TreeMap;
import org.omegat.core.Core;
import org.omegat.core.machinetranslators.BaseCachedTranslate;
import org.omegat.gui.exttrans.MTConfigDialog;
import org.omegat.util.HttpConnectionUtils;
import org.omegat.util.Language;
import org.omegat.util.Log;
import org.omegat.util.OStrings;

public class DeepLTranslate
extends BaseCachedTranslate {
    protected static final String PROPERTY_API_KEY = "deepl.api.key";
    protected static final String DEEPL_URL = "https://api.deepl.com/v1/translate";
    private static final int MAX_TEXT_LENGTH = 5000;

    @Override
    protected String getPreferenceName() {
        return "allow_deepl_translate";
    }

    @Override
    public String getName() {
        return OStrings.getString("MT_ENGINE_DEEPL");
    }

    @Override
    protected String translate(Language sLang, Language tLang, String text) throws Exception {
        Object trText = text.length() > 5000 ? text.substring(0, 4997) + "..." : text;
        String prev = this.getFromCache(sLang, tLang, (String)trText);
        if (prev != null) {
            return prev;
        }
        String apiKey = this.getCredential(PROPERTY_API_KEY);
        if (apiKey == null || apiKey.isEmpty()) {
            throw new Exception(OStrings.getString("DEEPL_API_KEY_NOTFOUND"));
        }
        TreeMap<String, String> params = new TreeMap<String, String>();
        params.put("text", (String)trText);
        params.put("source_lang", sLang.getLanguageCode().toUpperCase());
        params.put("target_lang", tLang.getLanguageCode().toUpperCase());
        params.put("tag_handling", "xml");
        String splitSentence = Core.getProject().getProjectProperties().isSentenceSegmentingEnabled() ? "1" : "0";
        params.put("split_sentences", splitSentence);
        params.put("preserve_formatting", "1");
        params.put("auth_key", apiKey);
        TreeMap<String, String> headers = new TreeMap<String, String>();
        String v = HttpConnectionUtils.get(DEEPL_URL, params, headers, "UTF-8");
        String tr = this.getJsonResults(v);
        if (tr == null) {
            return null;
        }
        tr = DeepLTranslate.unescapeHTML(tr);
        tr = this.cleanSpacesAroundTags(tr, (String)trText);
        this.putToCache(sLang, tLang, (String)trText, tr);
        return tr;
    }

    protected String getJsonResults(String json) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            JsonNode rootNode = mapper.readTree(json);
            JsonNode translations = rootNode.get("translations");
            if (translations.has(0)) {
                return translations.get(0).get("text").asText();
            }
        }
        catch (Exception e) {
            Log.logErrorRB(e, "MT_JSON_ERROR", new Object[0]);
            return OStrings.getString("MT_JSON_ERROR");
        }
        return null;
    }

    @Override
    public boolean isConfigurable() {
        return true;
    }

    @Override
    public void showConfigurationUI(Window parent) {
        MTConfigDialog dialog = new MTConfigDialog(parent, this.getName()){

            @Override
            protected void onConfirm() {
                String key = this.panel.valueField1.getText().trim();
                boolean temporary = this.panel.temporaryCheckBox.isSelected();
                DeepLTranslate.this.setCredential(DeepLTranslate.PROPERTY_API_KEY, key, temporary);
            }
        };
        dialog.panel.valueLabel1.setText(OStrings.getString("MT_ENGINE_DEEPL_API_KEY_LABEL"));
        dialog.panel.valueField1.setText(this.getCredential(PROPERTY_API_KEY));
        dialog.panel.valueLabel2.setVisible(false);
        dialog.panel.valueField2.setVisible(false);
        dialog.panel.temporaryCheckBox.setSelected(this.isCredentialStoredTemporarily(PROPERTY_API_KEY));
        dialog.show();
    }
}

