/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters4.xml.xliff;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.omegat.filters4.xml.xliff.AbstractXliffFilter;
import org.omegat.util.OStrings;

public class Xliff2Filter
extends AbstractXliffFilter {
    private Pattern intPattern = Pattern.compile("-?\\d+");
    private String segId = null;
    private boolean flushedSegment = false;

    @Override
    public String getFileFormatName() {
        return OStrings.getString("XLIFF2FILTER_FILTER_NAME");
    }

    @Override
    protected final String versionPrefix() {
        return "2.";
    }

    @Override
    protected boolean checkCurrentCursorPosition(XMLStreamReader reader, boolean doWrite) {
        if (reader.getEventType() == 1 && reader.getLocalName().equals("xliff")) {
            this.isEventMode = true;
            if (this.namespace == null) {
                this.namespace = reader.getName().getNamespaceURI();
            }
        }
        return this.isEventMode;
    }

    @Override
    protected boolean processStartElement(StartElement startElement, XMLStreamWriter writer) throws XMLStreamException {
        switch (startElement.getName().getLocalPart()) {
            case "xliff": {
                if (this.namespace != null) break;
                this.namespace = startElement.getName().getNamespaceURI();
                break;
            }
            case "file": 
            case "group": 
            case "unit": {
                Attribute idAttr = startElement.getAttributeByName(new QName("id"));
                if (idAttr == null) {
                    throw new XMLStreamException(OStrings.getString("XLIFF_MANDATORY_ORIGINAL_MISSING", "id", startElement.getName().getLocalPart()));
                }
                this.path = this.path + "/" + idAttr.getValue();
                this.updateIgnoreScope(startElement);
                break;
            }
            case "segment": {
                Attribute idAttr = startElement.getAttributeByName(new QName("id"));
                this.segId = idAttr != null ? idAttr.getValue() : (this.segId == null ? "1" : (this.intPattern.matcher(this.segId).matches() ? Integer.toString(Integer.parseInt(this.segId) + 1) : "1"));
                this.flushedSegment = false;
                break;
            }
            case "source": {
                this.currentBuffer = this.source;
                this.source.clear();
                break;
            }
            case "target": {
                this.target = new LinkedList();
                this.currentBuffer = this.target;
                this.inTarget = true;
                break;
            }
            case "notes": {
                this.note.clear();
                break;
            }
            case "note": {
                if (startElement.getAttributeByName(new QName("id")) != null) {
                    this.note.add(this.eFactory.createCharacters("\n\n[" + startElement.getAttributeByName(new QName("id")).getValue() + "] "));
                } else if (!this.note.isEmpty()) {
                    this.note.add(this.eFactory.createCharacters("\n\n"));
                }
                this.currentBuffer = this.note;
                break;
            }
            default: {
                if (this.currentBuffer != null) {
                    this.currentBuffer.add(startElement);
                    break;
                }
                if (this.ignoreScope != null && !this.ignoreScope.startsWith("!") || this.segId == null || startElement.getName().getNamespaceURI().equals(this.namespace)) break;
                this.flushTranslations(writer);
            }
        }
        return !this.inTarget;
    }

    @Override
    protected boolean processEndElement(EndElement endElement, XMLStreamWriter writer) throws XMLStreamException {
        switch (endElement.getName().getLocalPart()) {
            case "source": 
            case "note": {
                this.currentBuffer = null;
                break;
            }
            case "target": {
                this.currentBuffer = null;
                if (this.ignoreScope == null || this.ignoreScope.startsWith("!")) {
                    this.flushTranslations(writer);
                }
                this.inTarget = false;
                return false;
            }
            case "segment": {
                if (this.ignoreScope == null || this.ignoreScope.startsWith("!")) {
                    this.flushTranslations(writer);
                }
                if (this.ignoreScope == null || this.ignoreScope.startsWith("!")) {
                    this.registerCurrentTransUnit(this.segId, this.source, this.target, ".*");
                }
                this.segId = null;
                this.cleanBuffers();
                break;
            }
            case "unit": 
            case "group": 
            case "file": {
                this.segId = "";
                this.path = this.path.substring(0, this.path.lastIndexOf(47));
                this.cleanBuffers();
                if (endElement.getName().getLocalPart().equals(this.ignoreScope)) {
                    this.ignoreScope = null;
                    break;
                }
                if (this.ignoreScope == null || !this.ignoreScope.startsWith("!" + endElement.getName().getLocalPart())) break;
                this.ignoreScope = this.ignoreScope.substring(endElement.getName().getLocalPart().length() + 2);
                break;
            }
            default: {
                if (this.currentBuffer == null) break;
                this.currentBuffer.add(endElement);
            }
        }
        return !this.inTarget;
    }

    @Override
    protected String[] getPairIdNames(boolean start) {
        if (start) {
            return new String[]{"id"};
        }
        return new String[]{"startRef", "id"};
    }

    @Override
    protected String buildTags(List<XMLEvent> srcList, boolean reuse) {
        if (!reuse) {
            this.tagsMap.clear();
            for (Character c : this.tagsCount.keySet()) {
                this.tagsCount.put(c, 0);
            }
        }
        StringBuffer res = new StringBuffer();
        block29: for (XMLEvent ev : srcList) {
            if (ev.isCharacters()) {
                res.append(ev.asCharacters().getData());
                continue;
            }
            if (ev.isStartElement()) {
                StartElement stEl = ev.asStartElement();
                String name = stEl.getName().getLocalPart();
                char prefix = this.findPrefix(stEl);
                Integer count = (Integer)this.tagsCount.get(Character.valueOf(prefix));
                if (count == null) {
                    count = 0;
                    this.tagsCount.put(Character.valueOf(prefix), count + 1);
                }
                switch (name) {
                    case "mrk": {
                        break;
                    }
                    case "ph": 
                    case "cp": {
                        res.append(this.startPair(reuse, true, stEl, prefix, count, this.toPair(stEl)));
                        break;
                    }
                    case "sc": 
                    case "sm": {
                        res.append(this.startPair(reuse, false, stEl, prefix, count, this.toPair(stEl)));
                        break;
                    }
                    case "ec": 
                    case "em": {
                        res.append(this.endPair(reuse, stEl, prefix, count, this.toPair(stEl)));
                        break;
                    }
                    default: {
                        this.startStackElement(reuse, stEl, prefix, count, res);
                        break;
                    }
                }
                continue;
            }
            if (!ev.isEndElement()) continue;
            EndElement endEl = ev.asEndElement();
            switch (endEl.getName().getLocalPart()) {
                case "mrk": {
                    continue block29;
                }
                case "ph": 
                case "cp": 
                case "sc": 
                case "ec": {
                    continue block29;
                }
            }
            String pop = (String)this.tagStack.pop();
            this.tagsMap.put("/" + pop, Collections.singletonList(ev));
            res.append("</").append(pop).append(">");
        }
        return res.toString();
    }

    protected char findPrefix(StartElement stEl) {
        Attribute type = stEl.getAttributeByName(new QName("type"));
        if (type != null && type.getValue().equals("fmt")) {
            type = stEl.getAttributeByName(new QName("subType"));
            if (type != null && type.getValue().startsWith("xlf:")) {
                return type.getValue().charAt(4);
            }
            return 'f';
        }
        String name = stEl.getName().getLocalPart();
        if (name.equals("pc")) {
            return 'g';
        }
        if (name.equals("sc") || name.equals("ec")) {
            return 't';
        }
        if (name.equals("sm") || name.equals("em")) {
            return 'a';
        }
        if (!stEl.getName().getNamespaceURI().equals(this.namespace)) {
            return 'o';
        }
        return name.charAt(0);
    }

    private void flushTranslations(XMLStreamWriter writer) throws XMLStreamException {
        if (writer == null) {
            return;
        }
        if (this.flushedSegment) {
            return;
        }
        String src = this.buildTags(this.source, false);
        String tra = this.entryTranslateCallback.getTranslation(this.segId, src, this.path);
        if (tra != null) {
            writer.writeStartElement(this.namespace, "target");
            for (XMLEvent ev : this.restoreTags(tra)) {
                this.fromEventToWriter(ev, writer);
            }
        } else {
            if (this.target == null) {
                return;
            }
            writer.writeStartElement(this.namespace, "target");
            for (XMLEvent ev : this.target) {
                this.fromEventToWriter(ev, writer);
            }
        }
        writer.writeEndElement();
        this.flushedSegment = true;
    }
}

