; Beginning of Licence
;
; This software is licensed only for personal and educational use and
; not for the production of commercial software.  Modifications to this
; program are allowed but the resulting source must be annotated to
; indicate the nature of and the author of these changes.  
;
; Any modified source is bound by this licence and must remain available 
; as open source under the same conditions it was supplied and with this 
; licence at the top.

; This software is supplied AS IS without any warranty.  In no way shall 
; Mark Tarver or Lambda Associates be held liable for any damages resulting 
; from the use of this program.

; The terms of these conditions remain binding unless the individual 
; holds a valid license to use Qi commercially.  This license is found 
; in the final page of 'Functional Programming in Qi'.  In that event 
; the terms of that license apply to the license holder. 
;
; (c) copyright Mark Tarver, 2008
; End of Licence

(IN-PACKAGE :qi)

(DEFUN maxinferences (V505) (SETQ *maxinferences* V505))

(SETQ *maxinferences* 1000000)

(DEFUN maxinferences-exceeded? ()
  (IF (> (inferences '_) *maxinferences*)
      (ERROR "error: ~A inferences exceeded.~%" *maxinferences*)
      'false))

(DEFUN type-error (V503 V504)
 (error "type error in rule ~A of ~A~%" V503 V504))

(DEFUN beta-reduce (V497 V498 V499)
 (COND ((wrapper (qi_= V499 V498)) V497)
  ((AND (CONSP V499) (EQ 'let (CAR V499)) (CONSP (CDR V499))
    (wrapper (qi_= (CAR (CDR V499)) V498)))
   V499)
  ((AND (CONSP V499) (EQ '/. (CAR V499)) (CONSP (CDR V499))
    (CONSP (CDR (CDR V499))) (NULL (CDR (CDR (CDR V499))))
    (wrapper (qi_= (CAR (CDR V499)) V498)))
   V499)
  ((CONSP V499)
   (CONS (beta-reduce V497 V498 (CAR V499))
    (beta-reduce V497 V498 (CDR V499))))
  (T V499)))

(DEFUN show-typing (V486 V487)
 (COND
  ((AND (CONSP V486) (CONSP (CDR V486)) (EQ '|:| (CAR (CDR V486)))
    (CONSP (CDR (CDR V486))) (NULL (CDR (CDR (CDR V486)))))
   (if (number? V487)
    (output-math "~A. ~S : ~A" V487 (CAR V486) (CAR (CDR (CDR V486))))
    (output-math "~A ~S : ~A" V487 (CAR V486) (CAR (CDR (CDR V486))))))
  (T
   (if (number? V487) (output-math "~A. ~S" V487 V486)
    (output-math "~A  ~S" V487 V486)))))

(DEFUN enum (V484 V485)
 (COND ((NULL V484) NIL)
  ((CONSP V484)
   (LET ((ShowA (show-typing (CAR V484) V485)))
    (LET ((Terpri (output "~%"))) (enum (CDR V484) (+ V485 1)))))
  (T (implementation_error 'enum))))

(DEFUN help (V481)
 (COND
  ((EQL #\h V481)
    (output "Command Set~%~%h ..... help~%^ ..... abort~%f ..... fail")
    (output "~%~%> ") (help (read-char (GENSYM "X"))))
  ((EQL #\f V481) 'f) ((EQL #\^ V481) (error "aborted")) (T V481)))

(DEFUN show (V479 V480)
 (LET ((Inferences (inferences (GENSYM "X"))))
  (LET
   ((Line
     (output "__________________________________ ~A inference~P ~%" Inferences
      Inferences)))
   (LET ((ShowC (show-typing V480 '?-)))
    (LET ((Terpris (output "~%~%")))
     (LET ((ShowA (enum V479 1)))
      (LET ((Prompt (output "~%~%> ")))
       (LET ((Read (help (read-char (GENSYM "X"))))) Read))))))))

(DEFUN track-proof? NIL *spy*)

(SETQ *spy* 'false)

(DEFUN datatypes NIL *datatypes*)

(SETQ *datatypes* NIL)

(DEFUN result-type (V477 V478)
 (COND ((NULL V477) V478)
  ((AND (CONSP V477) (CONSP V478) (CONSP (CDR V478)) (EQ '--> (CAR (CDR V478)))
    (CONSP (CDR (CDR V478))) (NULL (CDR (CDR (CDR V478)))))
   (result-type (CDR V477) (CAR (CDR (CDR V478)))))
  (T (implementation_error 'result-type))))

(DEFUN patthyps (V466 V467 V468)
 (COND ((NULL V466) V468)
  ((AND (CONSP V466) (CONSP V467) (CONSP (CDR V467)) (EQ '--> (CAR (CDR V467)))
    (CONSP (CDR (CDR V467))) (NULL (CDR (CDR (CDR V467)))))
   (CONS (CONS (CAR V466) (CONS '|:| (CONS (CAR V467) NIL)))
    (patthyps (CDR V466) (CAR (CDR (CDR V467))) V468)))
  (T (implementation_error 'patthyps))))

(DEFUN sk (V463) (concat '&& V463))

(DEFUN skhyp (V462) (CONS V462 (CONS '|:| (CONS (gensym "A") NIL))))

(DEFUN st-help (V460 V461)
 (COND ((NULL V460) V461)
  ((CONSP V460)
   (st-help (CDR V460) (subst (concat '&& (CAR V460)) (CAR V460) V461)))
  (T (implementation_error 'st-help))))

(DEFUN specialise-type (V459) (st-help (extract-vars V459) V459))

(DEFUN elim-backtrack (V458)
 (COND ((NULL V458) NIL)
  ((AND (CONSP V458) (CONSP (CDR V458)) (CONSP (CAR (CDR V458)))
    (EQ 'fail-if (CAR (CAR (CDR V458)))) (CONSP (CDR (CAR (CDR V458))))
    (CONSP (CDR (CDR (CAR (CDR V458)))))
    (NULL (CDR (CDR (CDR (CAR (CDR V458)))))) (wrapper (qi_= (CAR V458) '<-)))
   (CONS '->
    (CONS
     (CONS 'where
      (CONS (CONS 'not (CONS (CDR (CAR (CDR V458))) NIL))
       (CDR (CDR (CAR (CDR V458))))))
     (elim-backtrack (CDR (CDR V458))))))
  ((AND (CONSP V458) (CONSP (CDR V458)) (wrapper (qi_= (CAR V458) '<-)))
   (CONS '->
    (CONS
     (CONS 'where
      (CONS
       (CONS 'not
        (CONS (CONS '== (CONS #\Escape (CONS (CAR (CDR V458)) NIL))) NIL))
       (CONS (CAR (CDR V458)) NIL)))
     (elim-backtrack (CDR (CDR V458))))))
  ((CONSP V458) (CONS (CAR V458) (elim-backtrack (CDR V458))))
  (T (implementation_error 'elim-backtrack))))

(DEFUN rule+rules (V456 V457)
 (LET ((Parse (<rules> (CONS V457 (CONS NIL NIL)))))
  (if (empty? (head Parse)) (head (tail Parse))
   (error "the first ~A has a syntax error~%" V456))))

(DEFUN sigdef (V454 V455)
 (LET ((Parse (<signature> (CONS V455 (CONS NIL NIL)))))
  (if (empty? Parse) (error "~A has no signature.~%" V454) Parse)))

(DEFUN arbterm NIL (gensym "&&"))

(DEFUN error-mess (V452 V453)
 (error "patterns = ~{~A ~}~% type = ~A" V452 V453))

(DEFUN extract-vars-from-tuple (V1 V2)
 (COND
  ((TUPLE-P V2)
   (LET ((Vs (union (extract-vars (fst V2)) (extract-vars (snd V2)))))
    (LET ((Flat (flatten V1))) (LET ((FVs (free-sequent-vars Vs Flat))) FVs))))
  (T (implementation_error 'extract-vars-from-tuple))))

(DEFUN free-sequent-vars (V5 V6)
 (COND ((NULL V5) NIL)
  ((CONSP V5)
   (LET ((X7 (CAR V5)))
    (LET ((X8 (CDR V5)))
     (IF (wrapper (element? X7 V6)) (free-sequent-vars X8 V6)
      (CONS X7 (free-sequent-vars X8 V6))))))
  (T (implementation_error 'free-sequent-vars))))

(DEFUN assemblenewhyps (V446 V447)
 (COND
  ((TUPLE-P V446)
   (LET ((Vs (extract-vars (CONS (fst V446) (CONS (snd V446) NIL)))))
    (LET ((Flat (flatten V447)))
     (LET ((FVs (free-sequent-vars Vs Flat)))
      (APPEND
       (MAPCAR #'(LAMBDA (X) (CONS X (CONS '|:| (CONS (GENSYM "X") NIL)))) FVs)
       V447)))))
  (T (implementation_error 'assemblenewhyps))))

(DEFUN checkpremisses (V442 V443 Continuation)
 (BLOCK failure
  (OR
   (LET ((X444 (lazyderef V442))) (IF (NULL X444) (FUNCALL Continuation) NIL))
   (LET ((X445 (lazyderef V442)))
    (IF (CONSP X445)
     (LET ((P (CAR X445)))
      (LET ((Ps (CDR X445)))
       (PROG2 (+infs)
        (checksequent P V443
         #'(LAMBDA NIL
            (checkpremisses Ps V443 #'(LAMBDA NIL (FUNCALL Continuation))))))))
     NIL)))))

(DEFUN checksides (V427 V428 V429 Continuation)
 (BLOCK failure
  (OR
   (LET ((X430 (lazyderef V427)))
    (IF (NULL X430)
     (PROG2 (+infs) (unify V429 V428 #'(LAMBDA NIL (FUNCALL Continuation))))
     NIL))
   (LET ((X431 (lazyderef V427)))
    (IF (CONSP X431)
     (LET ((X432 (lazyderef (CAR X431))))
      (IF (CONSP X432)
       (LET ((X433 (lazyderef (CAR X432))))
        (IF (EQ 'let X433)
         (LET ((X434 (lazyderef (CDR X432))))
          (IF (CONSP X434)
           (LET ((X (CAR X434)))
            (LET ((X435 (lazyderef (CDR X434))))
             (IF (CONSP X435)
              (LET ((Y (CAR X435)))
               (LET ((X436 (lazyderef (CDR X435))))
                (IF (NULL X436)
                 (LET ((Sides (CDR X431)))
                  (LET ((CurryY (GENSYM "X")))
                   (LET ((A (GENSYM "X")))
                    (PROG2 (+infs)
                     (bind CurryY (curry (lazyderef Y))
                      #'(LAMBDA NIL
                         (t* (CONS CurryY (CONS '|:| (CONS A NIL))) V428
                          #'(LAMBDA NIL
                             (checksides Sides
                              (CONS (CONS X (CONS '|:| (CONS A NIL))) V428)
                              V429
                              #'(LAMBDA NIL (FUNCALL Continuation)))))))))))
                 NIL)))
              NIL)))
           NIL))
         NIL))
       NIL))
     NIL))
   (LET ((X437 (lazyderef V427)))
    (IF (CONSP X437)
     (LET ((X438 (lazyderef (CAR X437))))
      (IF (CONSP X438)
       (LET ((X439 (lazyderef (CAR X438))))
        (IF (EQ 'if X439)
         (LET ((X440 (lazyderef (CDR X438))))
          (IF (CONSP X440)
           (LET ((P (CAR X440)))
            (LET ((X441 (lazyderef (CDR X440))))
             (IF (NULL X441)
              (LET ((Sides (CDR X437)))
               (LET ((CurryP (GENSYM "X")))
                (PROG2 (+infs)
                 (bind CurryP (curry (lazyderef P))
                  #'(LAMBDA NIL
                     (t* (CONS CurryP (CONS '|:| (CONS 'boolean NIL))) V428
                      #'(LAMBDA NIL
                         (checksides Sides V428 V429
                          #'(LAMBDA NIL (FUNCALL Continuation))))))))))
              NIL)))
           NIL))
         NIL))
       NIL))
     NIL)))))

(DEFUN checkassumptions (V422 V423 Continuation)
 (BLOCK failure
  (OR
   (LET ((X424 (lazyderef V422))) (IF (NULL X424) (FUNCALL Continuation) NIL))
   (LET ((X425 (lazyderef V422)))
    (IF (CONSP X425)
     (LET ((Assumption (CAR X425)))
      (LET ((Assumptions (CDR X425)))
       (LET ((A (GENSYM "X")))
        (PROG2 (+infs)
         (bind A (walk_cons_form (lazyderef Assumption))
          #'(LAMBDA NIL
             (t* (CONS A (CONS '|:| (CONS 'wff NIL))) V423
              #'(LAMBDA NIL
                 (checkassumptions Assumptions V423
                  #'(LAMBDA NIL (FUNCALL Continuation)))))))))))
     NIL)))))

(DEFUN checksequent (V420 V421 Continuation)
 (BLOCK failure
  (LET ((Conc (GENSYM "X")))
   (LET ((Assumptions (GENSYM "X")))
    (PROG2 (+infs)
     (bind Conc (walk_cons_form (snd (lazyderef V420)))
      #'(LAMBDA NIL
         (bind Assumptions (fst (lazyderef V420))
          #'(LAMBDA NIL
             (t* (CONS Conc (CONS '|:| (CONS 'wff NIL))) V421
              #'(LAMBDA NIL
                 (checkassumptions Assumptions V421
                  #'(LAMBDA NIL (FUNCALL Continuation))))))))))))))

(DEFUN checkrule (V2852 V2853 Continuation)
 (BLOCK failure
  (LET ((X2854 (lazyderef V2852)))
   (IF (CONSP X2854)
    (LET ((S (CAR X2854)))
     (LET ((X2855 (lazyderef (CDR X2854))))
      (IF (CONSP X2855)
       (LET ((P (CAR X2855)))
        (LET ((X2856 (lazyderef (CDR X2855))))
         (IF (CONSP X2856)
          (LET ((C (CAR X2856)))
           (LET ((X2857 (lazyderef (CDR X2856))))
            (IF (NULL X2857)
             (LET ((X (GENSYM "X")))
              (LET ((V (GENSYM "X")))
               (LET ((C* (GENSYM "X")))
                (LET ((NewHyps (GENSYM "X")))
                 (LET ((S* (GENSYM "X")))
                  (LET ((NewerHyps (GENSYM "X")))
                   (LET ((Vs&& (GENSYM "X")))
                    (LET ((Vs (GENSYM "X")))
                     (LET ((P* (GENSYM "X")))
                      (LET ((NewestHyps (GENSYM "X")))
                       (PROG2 (+infs)
                        (bind Vs
                         (extract-vars-from-tuple (lazyderef V2853)
                          (lazyderef C))
                         #'(LAMBDA NIL
                            (bind Vs&&
                             (map #'(LAMBDA (X) (concat '&& X)) (lazyderef Vs))
                             #'(LAMBDA NIL
                                (bind NewHyps
                                 (APPEND
                                  (MAPCAR
                                   #'(LAMBDA (X)
                                      (CONS X
                                       (CONS '|:| (CONS (newvar V) NIL))))
                                   (lazyderef Vs&&))
                                  (lazyderef V2853))
                                 #'(LAMBDA NIL
                                    (bind C*
                                     (mult_subst (lazyderef Vs&&)
                                      (lazyderef Vs) (lazyderef C))
                                     #'(LAMBDA NIL
                                        (checksequent C* NewHyps
                                         #'(LAMBDA NIL
                                            (bind NewerHyps
                                             (CONS
                                              (CONS
                                               (mult_subst (lazyderef Vs&&)
                                                (lazyderef Vs)
                                                (walk_cons_form
                                                 (fst (lazyderef C))))
                                               (CONS '|:|
                                                (CONS
                                                 (CONS 'list (CONS 'wff NIL))
                                                 NIL)))
                                              (CONS
                                               (CONS
                                                (mult_subst (lazyderef Vs&&)
                                                 (lazyderef Vs)
                                                 (walk_cons_form
                                                  (snd (lazyderef C))))
                                                (CONS '|:| (CONS 'wff NIL)))
                                               (lazyderef V2853)))
                                             #'(LAMBDA NIL
                                                (bind S*
                                                 (mult_subst (lazyderef Vs&&)
                                                  (lazyderef Vs) (lazyderef S))
                                                 #'(LAMBDA NIL
                                                    (checksides S* NewerHyps
                                                     NewestHyps
                                                     #'(LAMBDA NIL
                                                        (bind P*
                                                         (mult_subst
                                                          (lazyderef Vs&&)
                                                          (lazyderef Vs)
                                                          (lazyderef P))
                                                         #'(LAMBDA NIL
                                                            (checkpremisses P*
                                                             NewestHyps
                                                             #'(LAMBDA NIL
                                                                (FUNCALL
                                                                 Continuation))))))))))))))))))))))))))))))))
             NIL)))
          NIL)))
       NIL)))
    NIL))))

(DEFUN datatypes_driver (V408 V410 V411 Continuation)
 (BLOCK failure
  (OR
   (LET ((X412 (lazyderef V411)))
    (IF (CONSP X412)
     (LET ((D (CAR X412)))
      (PROG2 (+infs)
       (call (CONS D (CONS V408 (CONS V410 NIL)))
        #'(LAMBDA NIL (FUNCALL Continuation)))))
     NIL))
   (LET ((X413 (lazyderef V411)))
    (IF (CONSP X413)
     (LET ((Ds (CDR X413)))
      (PROG2 (+infs)
       (datatypes_driver V408 V410 Ds #'(LAMBDA NIL (FUNCALL Continuation)))))
     NIL)))))

(DEFUN split_@p (V380 V381 Continuation)
 (BLOCK failure
  (OR
   (LET ((X382 (lazyderef V380)))
    (IF (CONSP X382)
     (LET ((X383 (lazyderef (CAR X382))))
      (IF (CONSP X383)
       (LET ((X384 (lazyderef (CAR X383))))
        (IF (CONSP X384)
         (LET ((X385 (lazyderef (CAR X384))))
          (IF (EQ '@p X385)
           (LET ((X386 (lazyderef (CDR X384))))
            (IF (CONSP X386)
             (LET ((X (CAR X386)))
              (LET ((X387 (lazyderef (CDR X386))))
               (IF (CONSP X387)
                (LET ((Y (CAR X387)))
                 (LET ((X388 (lazyderef (CDR X387))))
                  (IF (NULL X388)
                   (LET ((X389 (lazyderef (CDR X383))))
                    (IF (CONSP X389)
                     (LET ((X390 (lazyderef (CAR X389))))
                      (IF (EQ '|:| X390)
                       (LET ((X391 (lazyderef (CDR X389))))
                        (IF (CONSP X391)
                         (LET ((X392 (lazyderef (CAR X391))))
                          (IF (CONSP X392)
                           (LET ((A (CAR X392)))
                            (LET ((X393 (lazyderef (CDR X392))))
                             (IF (CONSP X393)
                              (LET ((X394 (lazyderef (CAR X393))))
                               (IF (EQ '* X394)
                                (LET ((X395 (lazyderef (CDR X393))))
                                 (IF (CONSP X395)
                                  (LET ((B (CAR X395)))
                                   (LET ((X396 (lazyderef (CDR X395))))
                                    (IF (NULL X396)
                                     (LET ((X397 (lazyderef (CDR X391))))
                                      (IF (NULL X397)
                                       (LET ((Hyps (CDR X382)))
                                        (PROG2 (+infs)
                                         (bind V381
                                          (CONS
                                           (CONS X (CONS '|:| (CONS A NIL)))
                                           (CONS
                                            (CONS Y (CONS '|:| (CONS B NIL)))
                                            Hyps))
                                          #'(LAMBDA NIL
                                             (FUNCALL Continuation)))))
                                       (IF (var? X397)
                                        (PROGV (LIST X397) (LIST NIL)
                                         (LET ((Hyps (CDR X382)))
                                          (PROG2 (+infs)
                                           (bind V381
                                            (CONS
                                             (CONS X (CONS '|:| (CONS A NIL)))
                                             (CONS
                                              (CONS Y (CONS '|:| (CONS B NIL)))
                                              Hyps))
                                            #'(LAMBDA NIL
                                               (FUNCALL Continuation))))))
                                        NIL)))
                                     (IF (var? X396)
                                      (PROGV (LIST X396) (LIST NIL)
                                       (LET ((X398 (lazyderef (CDR X391))))
                                        (IF (NULL X398)
                                         (LET ((Hyps (CDR X382)))
                                          (PROG2 (+infs)
                                           (bind V381
                                            (CONS
                                             (CONS X (CONS '|:| (CONS A NIL)))
                                             (CONS
                                              (CONS Y (CONS '|:| (CONS B NIL)))
                                              Hyps))
                                            #'(LAMBDA NIL
                                               (FUNCALL Continuation)))))
                                         (IF (var? X398)
                                          (PROGV (LIST X398) (LIST NIL)
                                           (LET ((Hyps (CDR X382)))
                                            (PROG2 (+infs)
                                             (bind V381
                                              (CONS
                                               (CONS X
                                                (CONS '|:| (CONS A NIL)))
                                               (CONS
                                                (CONS Y
                                                 (CONS '|:| (CONS B NIL)))
                                                Hyps))
                                              #'(LAMBDA NIL
                                                 (FUNCALL Continuation))))))
                                          NIL))))
                                      NIL))))
                                  (IF (var? X395)
                                   (LET ((B (GENSYM "X")))
                                    (PROGV (LIST X395) (LIST (CONS B NIL))
                                     (LET ((X399 (lazyderef (CDR X391))))
                                      (IF (NULL X399)
                                       (LET ((Hyps (CDR X382)))
                                        (PROG2 (+infs)
                                         (bind V381
                                          (CONS
                                           (CONS X (CONS '|:| (CONS A NIL)))
                                           (CONS
                                            (CONS Y (CONS '|:| (CONS B NIL)))
                                            Hyps))
                                          #'(LAMBDA NIL
                                             (FUNCALL Continuation)))))
                                       (IF (var? X399)
                                        (PROGV (LIST X399) (LIST NIL)
                                         (LET ((Hyps (CDR X382)))
                                          (PROG2 (+infs)
                                           (bind V381
                                            (CONS
                                             (CONS X (CONS '|:| (CONS A NIL)))
                                             (CONS
                                              (CONS Y (CONS '|:| (CONS B NIL)))
                                              Hyps))
                                            #'(LAMBDA NIL
                                               (FUNCALL Continuation))))))
                                        NIL)))))
                                   NIL)))
                                (IF (var? X394)
                                 (PROGV (LIST X394) (LIST '*)
                                  (LET ((X400 (lazyderef (CDR X393))))
                                   (IF (CONSP X400)
                                    (LET ((B (CAR X400)))
                                     (LET ((X401 (lazyderef (CDR X400))))
                                      (IF (NULL X401)
                                       (LET ((X402 (lazyderef (CDR X391))))
                                        (IF (NULL X402)
                                         (LET ((Hyps (CDR X382)))
                                          (PROG2 (+infs)
                                           (bind V381
                                            (CONS
                                             (CONS X (CONS '|:| (CONS A NIL)))
                                             (CONS
                                              (CONS Y (CONS '|:| (CONS B NIL)))
                                              Hyps))
                                            #'(LAMBDA NIL
                                               (FUNCALL Continuation)))))
                                         (IF (var? X402)
                                          (PROGV (LIST X402) (LIST NIL)
                                           (LET ((Hyps (CDR X382)))
                                            (PROG2 (+infs)
                                             (bind V381
                                              (CONS
                                               (CONS X
                                                (CONS '|:| (CONS A NIL)))
                                               (CONS
                                                (CONS Y
                                                 (CONS '|:| (CONS B NIL)))
                                                Hyps))
                                              #'(LAMBDA NIL
                                                 (FUNCALL Continuation))))))
                                          NIL)))
                                       (IF (var? X401)
                                        (PROGV (LIST X401) (LIST NIL)
                                         (LET ((X403 (lazyderef (CDR X391))))
                                          (IF (NULL X403)
                                           (LET ((Hyps (CDR X382)))
                                            (PROG2 (+infs)
                                             (bind V381
                                              (CONS
                                               (CONS X
                                                (CONS '|:| (CONS A NIL)))
                                               (CONS
                                                (CONS Y
                                                 (CONS '|:| (CONS B NIL)))
                                                Hyps))
                                              #'(LAMBDA NIL
                                                 (FUNCALL Continuation)))))
                                           (IF (var? X403)
                                            (PROGV (LIST X403) (LIST NIL)
                                             (LET ((Hyps (CDR X382)))
                                              (PROG2 (+infs)
                                               (bind V381
                                                (CONS
                                                 (CONS X
                                                  (CONS '|:| (CONS A NIL)))
                                                 (CONS
                                                  (CONS Y
                                                   (CONS '|:| (CONS B NIL)))
                                                  Hyps))
                                                #'(LAMBDA NIL
                                                   (FUNCALL Continuation))))))
                                            NIL))))
                                        NIL))))
                                    (IF (var? X400)
                                     (LET ((B (GENSYM "X")))
                                      (PROGV (LIST X400) (LIST (CONS B NIL))
                                       (LET ((X404 (lazyderef (CDR X391))))
                                        (IF (NULL X404)
                                         (LET ((Hyps (CDR X382)))
                                          (PROG2 (+infs)
                                           (bind V381
                                            (CONS
                                             (CONS X (CONS '|:| (CONS A NIL)))
                                             (CONS
                                              (CONS Y (CONS '|:| (CONS B NIL)))
                                              Hyps))
                                            #'(LAMBDA NIL
                                               (FUNCALL Continuation)))))
                                         (IF (var? X404)
                                          (PROGV (LIST X404) (LIST NIL)
                                           (LET ((Hyps (CDR X382)))
                                            (PROG2 (+infs)
                                             (bind V381
                                              (CONS
                                               (CONS X
                                                (CONS '|:| (CONS A NIL)))
                                               (CONS
                                                (CONS Y
                                                 (CONS '|:| (CONS B NIL)))
                                                Hyps))
                                              #'(LAMBDA NIL
                                                 (FUNCALL Continuation))))))
                                          NIL)))))
                                     NIL))))
                                 NIL)))
                              (IF (var? X393)
                               (LET ((B (GENSYM "X")))
                                (PROGV (LIST X393)
                                 (LIST (CONS '* (CONS B NIL)))
                                 (LET ((X405 (lazyderef (CDR X391))))
                                  (IF (NULL X405)
                                   (LET ((Hyps (CDR X382)))
                                    (PROG2 (+infs)
                                     (bind V381
                                      (CONS (CONS X (CONS '|:| (CONS A NIL)))
                                       (CONS (CONS Y (CONS '|:| (CONS B NIL)))
                                        Hyps))
                                      #'(LAMBDA NIL (FUNCALL Continuation)))))
                                   (IF (var? X405)
                                    (PROGV (LIST X405) (LIST NIL)
                                     (LET ((Hyps (CDR X382)))
                                      (PROG2 (+infs)
                                       (bind V381
                                        (CONS (CONS X (CONS '|:| (CONS A NIL)))
                                         (CONS
                                          (CONS Y (CONS '|:| (CONS B NIL)))
                                          Hyps))
                                        #'(LAMBDA NIL
                                           (FUNCALL Continuation))))))
                                    NIL)))))
                               NIL))))
                           (IF (var? X392)
                            (LET ((A (GENSYM "X")))
                             (LET ((B (GENSYM "X")))
                              (PROGV (LIST X392)
                               (LIST (CONS A (CONS '* (CONS B NIL))))
                               (LET ((X406 (lazyderef (CDR X391))))
                                (IF (NULL X406)
                                 (LET ((Hyps (CDR X382)))
                                  (PROG2 (+infs)
                                   (bind V381
                                    (CONS (CONS X (CONS '|:| (CONS A NIL)))
                                     (CONS (CONS Y (CONS '|:| (CONS B NIL)))
                                      Hyps))
                                    #'(LAMBDA NIL (FUNCALL Continuation)))))
                                 (IF (var? X406)
                                  (PROGV (LIST X406) (LIST NIL)
                                   (LET ((Hyps (CDR X382)))
                                    (PROG2 (+infs)
                                     (bind V381
                                      (CONS (CONS X (CONS '|:| (CONS A NIL)))
                                       (CONS (CONS Y (CONS '|:| (CONS B NIL)))
                                        Hyps))
                                      #'(LAMBDA NIL (FUNCALL Continuation))))))
                                  NIL))))))
                            NIL)))
                         NIL))
                       NIL))
                     NIL))
                   NIL)))
                NIL)))
             NIL))
           NIL))
         NIL))
       NIL))
     NIL))
   (LET ((X407 (lazyderef V380)))
    (IF (CONSP X407)
     (LET ((Hyp (CAR X407)))
      (LET ((Hyps (CDR X407)))
       (LET ((New (GENSYM "X")))
        (PROG2 (+infs)
         (bind V381 (CONS Hyp New)
          #'(LAMBDA NIL
             (split_@p Hyps New #'(LAMBDA NIL (FUNCALL Continuation)))))))))
     NIL)))))

(DEFUN split_cons (V354 V355 Continuation)
 (BLOCK failure
  (OR
   (LET ((X356 (lazyderef V354)))
    (IF (CONSP X356)
     (LET ((X357 (lazyderef (CAR X356))))
      (IF (CONSP X357)
       (LET ((X358 (lazyderef (CAR X357))))
        (IF (CONSP X358)
         (LET ((X359 (lazyderef (CAR X358))))
          (IF (EQ 'cons X359)
           (LET ((X360 (lazyderef (CDR X358))))
            (IF (CONSP X360)
             (LET ((X (CAR X360)))
              (LET ((X361 (lazyderef (CDR X360))))
               (IF (CONSP X361)
                (LET ((Y (CAR X361)))
                 (LET ((X362 (lazyderef (CDR X361))))
                  (IF (NULL X362)
                   (LET ((X363 (lazyderef (CDR X357))))
                    (IF (CONSP X363)
                     (LET ((X364 (lazyderef (CAR X363))))
                      (IF (EQ '|:| X364)
                       (LET ((X365 (lazyderef (CDR X363))))
                        (IF (CONSP X365)
                         (LET ((X366 (lazyderef (CAR X365))))
                          (IF (CONSP X366)
                           (LET ((X367 (lazyderef (CAR X366))))
                            (IF (EQ 'list X367)
                             (LET ((X368 (lazyderef (CDR X366))))
                              (IF (CONSP X368)
                               (LET ((A (CAR X368)))
                                (LET ((X369 (lazyderef (CDR X368))))
                                 (IF (NULL X369)
                                  (LET ((X370 (lazyderef (CDR X365))))
                                   (IF (NULL X370)
                                    (LET ((Hyps (CDR X356)))
                                     (PROG2 (+infs)
                                      (bind V355
                                       (CONS (CONS X (CONS '|:| (CONS A NIL)))
                                        (CONS
                                         (CONS Y
                                          (CONS '|:|
                                           (CONS (CONS 'list (CONS A NIL))
                                            NIL)))
                                         Hyps))
                                       #'(LAMBDA NIL (FUNCALL Continuation)))))
                                    (IF (var? X370)
                                     (PROGV (LIST X370) (LIST NIL)
                                      (LET ((Hyps (CDR X356)))
                                       (PROG2 (+infs)
                                        (bind V355
                                         (CONS
                                          (CONS X (CONS '|:| (CONS A NIL)))
                                          (CONS
                                           (CONS Y
                                            (CONS '|:|
                                             (CONS (CONS 'list (CONS A NIL))
                                              NIL)))
                                           Hyps))
                                         #'(LAMBDA NIL
                                            (FUNCALL Continuation))))))
                                     NIL)))
                                  (IF (var? X369)
                                   (PROGV (LIST X369) (LIST NIL)
                                    (LET ((X371 (lazyderef (CDR X365))))
                                     (IF (NULL X371)
                                      (LET ((Hyps (CDR X356)))
                                       (PROG2 (+infs)
                                        (bind V355
                                         (CONS
                                          (CONS X (CONS '|:| (CONS A NIL)))
                                          (CONS
                                           (CONS Y
                                            (CONS '|:|
                                             (CONS (CONS 'list (CONS A NIL))
                                              NIL)))
                                           Hyps))
                                         #'(LAMBDA NIL
                                            (FUNCALL Continuation)))))
                                      (IF (var? X371)
                                       (PROGV (LIST X371) (LIST NIL)
                                        (LET ((Hyps (CDR X356)))
                                         (PROG2 (+infs)
                                          (bind V355
                                           (CONS
                                            (CONS X (CONS '|:| (CONS A NIL)))
                                            (CONS
                                             (CONS Y
                                              (CONS '|:|
                                               (CONS (CONS 'list (CONS A NIL))
                                                NIL)))
                                             Hyps))
                                           #'(LAMBDA NIL
                                              (FUNCALL Continuation))))))
                                       NIL))))
                                   NIL))))
                               (IF (var? X368)
                                (LET ((A (GENSYM "X")))
                                 (PROGV (LIST X368) (LIST (CONS A NIL))
                                  (LET ((X372 (lazyderef (CDR X365))))
                                   (IF (NULL X372)
                                    (LET ((Hyps (CDR X356)))
                                     (PROG2 (+infs)
                                      (bind V355
                                       (CONS (CONS X (CONS '|:| (CONS A NIL)))
                                        (CONS
                                         (CONS Y
                                          (CONS '|:|
                                           (CONS (CONS 'list (CONS A NIL))
                                            NIL)))
                                         Hyps))
                                       #'(LAMBDA NIL (FUNCALL Continuation)))))
                                    (IF (var? X372)
                                     (PROGV (LIST X372) (LIST NIL)
                                      (LET ((Hyps (CDR X356)))
                                       (PROG2 (+infs)
                                        (bind V355
                                         (CONS
                                          (CONS X (CONS '|:| (CONS A NIL)))
                                          (CONS
                                           (CONS Y
                                            (CONS '|:|
                                             (CONS (CONS 'list (CONS A NIL))
                                              NIL)))
                                           Hyps))
                                         #'(LAMBDA NIL
                                            (FUNCALL Continuation))))))
                                     NIL)))))
                                NIL)))
                             (IF (var? X367)
                              (PROGV (LIST X367) (LIST 'list)
                               (LET ((X373 (lazyderef (CDR X366))))
                                (IF (CONSP X373)
                                 (LET ((A (CAR X373)))
                                  (LET ((X374 (lazyderef (CDR X373))))
                                   (IF (NULL X374)
                                    (LET ((X375 (lazyderef (CDR X365))))
                                     (IF (NULL X375)
                                      (LET ((Hyps (CDR X356)))
                                       (PROG2 (+infs)
                                        (bind V355
                                         (CONS
                                          (CONS X (CONS '|:| (CONS A NIL)))
                                          (CONS
                                           (CONS Y
                                            (CONS '|:|
                                             (CONS (CONS 'list (CONS A NIL))
                                              NIL)))
                                           Hyps))
                                         #'(LAMBDA NIL
                                            (FUNCALL Continuation)))))
                                      (IF (var? X375)
                                       (PROGV (LIST X375) (LIST NIL)
                                        (LET ((Hyps (CDR X356)))
                                         (PROG2 (+infs)
                                          (bind V355
                                           (CONS
                                            (CONS X (CONS '|:| (CONS A NIL)))
                                            (CONS
                                             (CONS Y
                                              (CONS '|:|
                                               (CONS (CONS 'list (CONS A NIL))
                                                NIL)))
                                             Hyps))
                                           #'(LAMBDA NIL
                                              (FUNCALL Continuation))))))
                                       NIL)))
                                    (IF (var? X374)
                                     (PROGV (LIST X374) (LIST NIL)
                                      (LET ((X376 (lazyderef (CDR X365))))
                                       (IF (NULL X376)
                                        (LET ((Hyps (CDR X356)))
                                         (PROG2 (+infs)
                                          (bind V355
                                           (CONS
                                            (CONS X (CONS '|:| (CONS A NIL)))
                                            (CONS
                                             (CONS Y
                                              (CONS '|:|
                                               (CONS (CONS 'list (CONS A NIL))
                                                NIL)))
                                             Hyps))
                                           #'(LAMBDA NIL
                                              (FUNCALL Continuation)))))
                                        (IF (var? X376)
                                         (PROGV (LIST X376) (LIST NIL)
                                          (LET ((Hyps (CDR X356)))
                                           (PROG2 (+infs)
                                            (bind V355
                                             (CONS
                                              (CONS X (CONS '|:| (CONS A NIL)))
                                              (CONS
                                               (CONS Y
                                                (CONS '|:|
                                                 (CONS
                                                  (CONS 'list (CONS A NIL))
                                                  NIL)))
                                               Hyps))
                                             #'(LAMBDA NIL
                                                (FUNCALL Continuation))))))
                                         NIL))))
                                     NIL))))
                                 (IF (var? X373)
                                  (LET ((A (GENSYM "X")))
                                   (PROGV (LIST X373) (LIST (CONS A NIL))
                                    (LET ((X377 (lazyderef (CDR X365))))
                                     (IF (NULL X377)
                                      (LET ((Hyps (CDR X356)))
                                       (PROG2 (+infs)
                                        (bind V355
                                         (CONS
                                          (CONS X (CONS '|:| (CONS A NIL)))
                                          (CONS
                                           (CONS Y
                                            (CONS '|:|
                                             (CONS (CONS 'list (CONS A NIL))
                                              NIL)))
                                           Hyps))
                                         #'(LAMBDA NIL
                                            (FUNCALL Continuation)))))
                                      (IF (var? X377)
                                       (PROGV (LIST X377) (LIST NIL)
                                        (LET ((Hyps (CDR X356)))
                                         (PROG2 (+infs)
                                          (bind V355
                                           (CONS
                                            (CONS X (CONS '|:| (CONS A NIL)))
                                            (CONS
                                             (CONS Y
                                              (CONS '|:|
                                               (CONS (CONS 'list (CONS A NIL))
                                                NIL)))
                                             Hyps))
                                           #'(LAMBDA NIL
                                              (FUNCALL Continuation))))))
                                       NIL)))))
                                  NIL))))
                              NIL)))
                           (IF (var? X366)
                            (LET ((A (GENSYM "X")))
                             (PROGV (LIST X366)
                              (LIST (CONS 'list (CONS A NIL)))
                              (LET ((X378 (lazyderef (CDR X365))))
                               (IF (NULL X378)
                                (LET ((Hyps (CDR X356)))
                                 (PROG2 (+infs)
                                  (bind V355
                                   (CONS (CONS X (CONS '|:| (CONS A NIL)))
                                    (CONS
                                     (CONS Y
                                      (CONS '|:|
                                       (CONS (CONS 'list (CONS A NIL)) NIL)))
                                     Hyps))
                                   #'(LAMBDA NIL (FUNCALL Continuation)))))
                                (IF (var? X378)
                                 (PROGV (LIST X378) (LIST NIL)
                                  (LET ((Hyps (CDR X356)))
                                   (PROG2 (+infs)
                                    (bind V355
                                     (CONS (CONS X (CONS '|:| (CONS A NIL)))
                                      (CONS
                                       (CONS Y
                                        (CONS '|:|
                                         (CONS (CONS 'list (CONS A NIL)) NIL)))
                                       Hyps))
                                     #'(LAMBDA NIL (FUNCALL Continuation))))))
                                 NIL)))))
                            NIL)))
                         NIL))
                       NIL))
                     NIL))
                   NIL)))
                NIL)))
             NIL))
           NIL))
         NIL))
       NIL))
     NIL))
   (LET ((X379 (lazyderef V354)))
    (IF (CONSP X379)
     (LET ((Hyp (CAR X379)))
      (LET ((Hyps (CDR X379)))
       (LET ((New (GENSYM "X")))
        (PROG2 (+infs)
         (bind V355 (CONS Hyp New)
          #'(LAMBDA NIL
             (split_cons Hyps New #'(LAMBDA NIL (FUNCALL Continuation)))))))))
     NIL)))))

(DEFUN by_hypothesis (V344 V345 V346 Continuation)
 (BLOCK failure
  (OR
   (LET ((X347 (lazyderef V346)))
    (IF (CONSP X347)
     (LET ((X348 (lazyderef (CAR X347))))
      (IF (CONSP X348)
       (LET ((Y (CAR X348)))
        (LET ((X349 (lazyderef (CDR X348))))
         (IF (CONSP X349)
          (LET ((X350 (lazyderef (CAR X349))))
           (IF (EQ '|:| X350)
            (LET ((X351 (lazyderef (CDR X349))))
             (IF (CONSP X351)
              (LET ((B (CAR X351)))
               (LET ((X352 (lazyderef (CDR X351))))
                (IF (NULL X352)
                 (PROG2 (+infs)
                  (identical V344 Y
                   #'(LAMBDA NIL
                      (unify! V345 B #'(LAMBDA NIL (FUNCALL Continuation))))))
                 NIL)))
              NIL))
            NIL))
          NIL)))
       NIL))
     NIL))
   (LET ((X353 (lazyderef V346)))
    (IF (CONSP X353)
     (LET ((Hyps (CDR X353)))
      (PROG2 (+infs)
       (by_hypothesis V344 V345 Hyps #'(LAMBDA NIL (FUNCALL Continuation)))))
     NIL)))))

(DEFUN t*-integrity (V334 V335 V336 Continuation)
 (BLOCK failure
  (OR
   (LET ((X337 (lazyderef V334))) (IF (NULL X337) (FUNCALL Continuation) NIL))
   (LET ((X338 (lazyderef V334)))
    (IF (CONSP X338)
     (LET ((P (CAR X338)))
      (LET ((Ps (CDR X338)))
       (LET ((X339 (lazyderef V335)))
        (IF (CONSP X339)
         (LET ((A (CAR X339)))
          (LET ((X340 (lazyderef (CDR X339))))
           (IF (CONSP X340)
            (LET ((X341 (lazyderef (CAR X340))))
             (IF (EQ '--> X341)
              (LET ((X342 (lazyderef (CDR X340))))
               (IF (CONSP X342)
                (LET ((B (CAR X342)))
                 (LET ((X343 (lazyderef (CDR X342))))
                  (IF (NULL X343)
                   (PROG2 (+infs)
                    (t* (CONS P (CONS '|:| (CONS A NIL))) V336
                     #'(LAMBDA NIL
                        (t*-integrity Ps B V336
                         #'(LAMBDA NIL (FUNCALL Continuation))))))
                   NIL)))
                NIL))
              NIL))
            NIL)))
         NIL))))
     NIL)))))

(DEFUN t*-rule (V330 V331 V332 V333 Continuation)
 (BLOCK failure
  (LET ((SkHyps (GENSYM "X")))
   (LET ((SkVars (GENSYM "X")))
    (LET ((Vars (GENSYM "X")))
     (LET ((SkPatterns (GENSYM "X")))
      (LET ((NewResult (GENSYM "X")))
       (LET ((B (GENSYM "X")))
        (LET ((Hyps+ (GENSYM "X")))
         (PROG2 (+infs)
          (bind Vars (extract-vars (lazyderef V330))
           #'(LAMBDA NIL
              (bind SkVars (MAPCAR 'sk (lazyderef Vars))
               #'(LAMBDA NIL
                  (bind SkHyps
                   (APPEND (MAPCAR 'skhyp (lazyderef SkVars)) (lazyderef V333))
                   #'(LAMBDA NIL
                      (bind SkPatterns
                       (mult_subst (lazyderef SkVars) (lazyderef Vars)
                        (lazyderef V330))
                       #'(LAMBDA NIL
                          (OR
                           (t*-integrity SkPatterns V332 SkHyps
                            #'(LAMBDA NIL
                               (bind NewResult
                                (curry
                                 (mult_subst (lazyderef SkVars)
                                  (lazyderef Vars) (lazyderef V331)))
                                #'(LAMBDA NIL
                                   (bind Hyps+
                                    (patthyps (lazyderef SkPatterns)
                                     (lazyderef V332) (lazyderef V333))
                                    #'(LAMBDA NIL
                                       (bind B
                                        (result-type (lazyderef SkPatterns)
                                         (lazyderef V332))
                                        #'(LAMBDA NIL
                                           (OR
                                            (t*
                                             (CONS NewResult
                                              (CONS '|:| (CONS B NIL)))
                                             Hyps+
                                             #'(LAMBDA NIL
                                                (FUNCALL Continuation)))
                                            (RETURN-FROM failure NIL))))))))))
                           (RETURN-FROM failure NIL))))))))))))))))))))

(DEFUN tfun (V320 V321 V322 V323 V324 Continuation)
 (BLOCK failure
  (OR
   (LET ((X325 (lazyderef V320))) (IF (NULL X325) (FUNCALL Continuation) NIL))
   (LET ((X326 (lazyderef V320)))
    (IF (CONSP X326)
     (LET ((X327 (lazyderef (CAR X326))))
      (IF (CONSP X327)
       (LET ((Patterns (CAR X327)))
        (LET ((X328 (lazyderef (CDR X327))))
         (IF (CONSP X328)
          (LET ((Result (CAR X328)))
           (LET ((X329 (lazyderef (CDR X328))))
            (IF (NULL X329)
             (LET ((Rules (CDR X326)))
              (LET ((M (GENSYM "X")))
               (PROG2 (+infs)
                (t*-rule Patterns Result V321 V322
                 #'(LAMBDA NIL
                    (is M (1+ (deref V323))
                     #'(LAMBDA NIL
                        (tfun Rules V321 V322 M V324
                         #'(LAMBDA NIL (FUNCALL Continuation))))))))))
             NIL)))
          NIL)))
       NIL))
     NIL))
   (LET ((Error (GENSYM "X")))
    (PROG2 (+infs)
     (is Error (type-error (deref V323) (deref V324))
      #'(LAMBDA NIL (FUNCALL Continuation))))))))

(DEFUN fundeclare (V318 V319 Continuation)
 (BLOCK failure
  (LET ((FS (GENSYM "X")))
   (PROG2 (+infs)
    (is FS (declare (deref V318) (deref V319))
     #'(LAMBDA NIL (FUNCALL Continuation)))))))

(DEFUN base (V303 V304 Continuation)
 (BLOCK failure
  (OR
   (LET ((X305 (lazyderef V304)))
    (IF (EQ 'number X305)
     (PROG2 (+infs)
      (fwhen (number? (lazyderef V303)) #'(LAMBDA NIL (FUNCALL Continuation))))
     (IF (var? X305)
      (PROGV (LIST X305) (LIST 'number)
       (PROG2 (+infs)
        (fwhen (number? (lazyderef V303))
         #'(LAMBDA NIL (FUNCALL Continuation)))))
      NIL)))
   (LET ((X306 (lazyderef V304)))
    (IF (EQ 'boolean X306)
     (PROG2 (+infs)
      (fwhen (boolean? (lazyderef V303))
       #'(LAMBDA NIL (FUNCALL Continuation))))
     (IF (var? X306)
      (PROGV (LIST X306) (LIST 'boolean)
       (PROG2 (+infs)
        (fwhen (boolean? (lazyderef V303))
         #'(LAMBDA NIL (FUNCALL Continuation)))))
      NIL)))
   (LET ((X307 (lazyderef V304)))
    (IF (EQ 'variable X307)
     (PROG2 (+infs)
      (fwhen (variable? (lazyderef V303))
       #'(LAMBDA NIL (FUNCALL Continuation))))
     (IF (var? X307)
      (PROGV (LIST X307) (LIST 'variable)
       (PROG2 (+infs)
        (fwhen (variable? (lazyderef V303))
         #'(LAMBDA NIL (FUNCALL Continuation)))))
      NIL)))
   (LET ((X308 (lazyderef V304)))
    (IF (EQ 'character X308)
     (PROG2 (+infs)
      (fwhen (character? (lazyderef V303))
       #'(LAMBDA NIL (FUNCALL Continuation))))
     (IF (var? X308)
      (PROGV (LIST X308) (LIST 'character)
       (PROG2 (+infs)
        (fwhen (character? (lazyderef V303))
         #'(LAMBDA NIL (FUNCALL Continuation)))))
      NIL)))
   (LET ((X309 (lazyderef V304)))
    (IF (EQ 'string X309)
     (PROG2 (+infs)
      (fwhen (string? (lazyderef V303)) #'(LAMBDA NIL (FUNCALL Continuation))))
     (IF (var? X309)
      (PROGV (LIST X309) (LIST 'string)
       (PROG2 (+infs)
        (fwhen (string? (lazyderef V303))
         #'(LAMBDA NIL (FUNCALL Continuation)))))
      NIL)))
   (LET ((S (GENSYM "X")))
    (PROG2 (+infs)
     (fwhen (symbol? (lazyderef V303))
      #'(LAMBDA NIL
         (bind S (signature (lazyderef V303))
          #'(LAMBDA NIL
             (fwhen (cons? (lazyderef S))
              #'(LAMBDA NIL
                 (unify! V304 S #'(LAMBDA NIL (FUNCALL Continuation)))))))))))
   (LET ((X310 (lazyderef V304)))
    (IF (EQ 'symbol X310)
     (PROG2 (+infs)
      (fwhen (symbol? (lazyderef V303)) #'(LAMBDA NIL (FUNCALL Continuation))))
     (IF (var? X310)
      (PROGV (LIST X310) (LIST 'symbol)
       (PROG2 (+infs)
        (fwhen (symbol? (lazyderef V303))
         #'(LAMBDA NIL (FUNCALL Continuation)))))
      NIL)))
   (LET ((X311 (lazyderef V303)))
    (IF (NULL X311)
     (LET ((X312 (lazyderef V304)))
      (IF (CONSP X312)
       (LET ((X313 (lazyderef (CAR X312))))
        (IF (EQ 'list X313)
         (LET ((X314 (lazyderef (CDR X312))))
          (IF (CONSP X314)
           (LET ((A (CAR X314)))
            (LET ((X315 (lazyderef (CDR X314))))
             (IF (NULL X315) (FUNCALL Continuation)
              (IF (var? X315)
               (PROGV (LIST X315) (LIST NIL) (FUNCALL Continuation)) NIL))))
           (IF (var? X314)
            (LET ((A (GENSYM "X")))
             (PROGV (LIST X314) (LIST (CONS A NIL)) (FUNCALL Continuation)))
            NIL)))
         (IF (var? X313)
          (PROGV (LIST X313) (LIST 'list)
           (LET ((X316 (lazyderef (CDR X312))))
            (IF (CONSP X316)
             (LET ((A (CAR X316)))
              (LET ((X317 (lazyderef (CDR X316))))
               (IF (NULL X317) (FUNCALL Continuation)
                (IF (var? X317)
                 (PROGV (LIST X317) (LIST NIL) (FUNCALL Continuation)) NIL))))
             (IF (var? X316)
              (LET ((A (GENSYM "X")))
               (PROGV (LIST X316) (LIST (CONS A NIL)) (FUNCALL Continuation)))
              NIL))))
          NIL)))
       (IF (var? X312)
        (LET ((A (GENSYM "X")))
         (PROGV (LIST X312) (LIST (CONS 'list (CONS A NIL)))
          (FUNCALL Continuation)))
        NIL)))
     NIL)))))

(DEFUN t* (V946 V947 Continuation)
 (BLOCK failure
  (OR
   (LET ((Error (GENSYM "X")))
    (PROG2 (+infs)
     (fwhen (maxinferences-exceeded?)
      #'(LAMBDA NIL
         (is Error (maxinference-error)
          #'(LAMBDA NIL (FUNCALL Continuation)))))))
   (LET ((Show (GENSYM "X")))
    (PROG2 (+infs)
     (fwhen (track-proof?)
      #'(LAMBDA NIL
         (is Show (show (deref V947) (deref V946))
          #'(LAMBDA NIL
             (identical Show 'f
              #'(LAMBDA NIL
                 (OR (fwhen 'false #'(LAMBDA NIL (FUNCALL Continuation)))
                  (RETURN-FROM failure NIL))))))))))
   (LET ((X948 (lazyderef V946)))
    (IF (CONSP X948)
     (LET ((X (CAR X948)))
      (LET ((X949 (lazyderef (CDR X948))))
       (IF (CONSP X949)
        (LET ((X950 (lazyderef (CAR X949))))
         (IF (EQ '|:| X950)
          (LET ((X951 (lazyderef (CDR X949))))
           (IF (CONSP X951)
            (LET ((A (CAR X951)))
             (LET ((X952 (lazyderef (CDR X951))))
              (IF (NULL X952)
               (PROG2 (+infs)
                (base X A #'(LAMBDA NIL (FUNCALL Continuation))))
               NIL)))
            NIL))
          NIL))
        NIL)))
     NIL))
   (LET ((X953 (lazyderef V946)))
    (IF (CONSP X953)
     (LET ((X (CAR X953)))
      (LET ((X954 (lazyderef (CDR X953))))
       (IF (CONSP X954)
        (LET ((X955 (lazyderef (CAR X954))))
         (IF (EQ '|:| X955)
          (LET ((X956 (lazyderef (CDR X954))))
           (IF (CONSP X956)
            (LET ((A (CAR X956)))
             (LET ((X957 (lazyderef (CDR X956))))
              (IF (NULL X957)
               (PROG2 (+infs)
                (by_hypothesis X A V947
                 #'(LAMBDA NIL (FUNCALL Continuation))))
               NIL)))
            NIL))
          NIL))
        NIL)))
     NIL))
   (LET ((X958 (lazyderef V946)))
    (IF (CONSP X958)
     (LET ((X959 (lazyderef (CAR X958))))
      (IF (CONSP X959)
       (LET ((X (CAR X959)))
        (LET ((X960 (lazyderef (CDR X959))))
         (IF (CONSP X960)
          (LET ((Y (CAR X960)))
           (LET ((X961 (lazyderef (CDR X960))))
            (IF (NULL X961)
             (LET ((X962 (lazyderef (CDR X958))))
              (IF (CONSP X962)
               (LET ((X963 (lazyderef (CAR X962))))
                (IF (EQ '|:| X963)
                 (LET ((X964 (lazyderef (CDR X962))))
                  (IF (CONSP X964)
                   (LET ((B (CAR X964)))
                    (LET ((X965 (lazyderef (CDR X964))))
                     (IF (NULL X965)
                      (LET ((A (GENSYM "X")))
                       (PROG2 (+infs)
                        (t*
                         (CONS X
                          (CONS '|:|
                           (CONS (CONS A (CONS '--> (CONS B NIL))) NIL)))
                         V947
                         #'(LAMBDA NIL
                            (t* (CONS Y (CONS '|:| (CONS A NIL))) V947
                             #'(LAMBDA NIL (FUNCALL Continuation)))))))
                      NIL)))
                   NIL))
                 NIL))
               NIL))
             NIL)))
          NIL)))
       NIL))
     NIL))
   (LET ((X966 (lazyderef V946)))
    (IF (CONSP X966)
     (LET ((X967 (lazyderef (CAR X966))))
      (IF (CONSP X967)
       (LET ((X968 (lazyderef (CAR X967))))
        (IF (EQ 'cons X968)
         (LET ((X969 (lazyderef (CDR X967))))
          (IF (CONSP X969)
           (LET ((X (CAR X969)))
            (LET ((X970 (lazyderef (CDR X969))))
             (IF (CONSP X970)
              (LET ((Y (CAR X970)))
               (LET ((X971 (lazyderef (CDR X970))))
                (IF (NULL X971)
                 (LET ((X972 (lazyderef (CDR X966))))
                  (IF (CONSP X972)
                   (LET ((X973 (lazyderef (CAR X972))))
                    (IF (EQ '|:| X973)
                     (LET ((X974 (lazyderef (CDR X972))))
                      (IF (CONSP X974)
                       (LET ((X975 (lazyderef (CAR X974))))
                        (IF (CONSP X975)
                         (LET ((X976 (lazyderef (CAR X975))))
                          (IF (EQ 'list X976)
                           (LET ((X977 (lazyderef (CDR X975))))
                            (IF (CONSP X977)
                             (LET ((A (CAR X977)))
                              (LET ((X978 (lazyderef (CDR X977))))
                               (IF (NULL X978)
                                (LET ((X979 (lazyderef (CDR X974))))
                                 (IF (NULL X979)
                                  (PROG2 (+infs)
                                   (t* (CONS X (CONS '|:| (CONS A NIL))) V947
                                    #'(LAMBDA NIL
                                       (t*
                                        (CONS Y
                                         (CONS '|:|
                                          (CONS (CONS 'list (CONS A NIL))
                                           NIL)))
                                        V947
                                        #'(LAMBDA NIL
                                           (FUNCALL Continuation))))))
                                  (IF (var? X979)
                                   (PROGV (LIST X979) (LIST NIL)
                                    (PROG2 (+infs)
                                     (t* (CONS X (CONS '|:| (CONS A NIL))) V947
                                      #'(LAMBDA NIL
                                         (t*
                                          (CONS Y
                                           (CONS '|:|
                                            (CONS (CONS 'list (CONS A NIL))
                                             NIL)))
                                          V947
                                          #'(LAMBDA NIL
                                             (FUNCALL Continuation)))))))
                                   NIL)))
                                (IF (var? X978)
                                 (PROGV (LIST X978) (LIST NIL)
                                  (LET ((X980 (lazyderef (CDR X974))))
                                   (IF (NULL X980)
                                    (PROG2 (+infs)
                                     (t* (CONS X (CONS '|:| (CONS A NIL))) V947
                                      #'(LAMBDA NIL
                                         (t*
                                          (CONS Y
                                           (CONS '|:|
                                            (CONS (CONS 'list (CONS A NIL))
                                             NIL)))
                                          V947
                                          #'(LAMBDA NIL
                                             (FUNCALL Continuation))))))
                                    (IF (var? X980)
                                     (PROGV (LIST X980) (LIST NIL)
                                      (PROG2 (+infs)
                                       (t* (CONS X (CONS '|:| (CONS A NIL)))
                                        V947
                                        #'(LAMBDA NIL
                                           (t*
                                            (CONS Y
                                             (CONS '|:|
                                              (CONS (CONS 'list (CONS A NIL))
                                               NIL)))
                                            V947
                                            #'(LAMBDA NIL
                                               (FUNCALL Continuation)))))))
                                     NIL))))
                                 NIL))))
                             (IF (var? X977)
                              (LET ((A (GENSYM "X")))
                               (PROGV (LIST X977) (LIST (cons A NIL))
                                (LET ((X981 (lazyderef (CDR X974))))
                                 (IF (NULL X981)
                                  (PROG2 (+infs)
                                   (t* (CONS X (CONS '|:| (CONS A NIL))) V947
                                    #'(LAMBDA NIL
                                       (t*
                                        (CONS Y
                                         (CONS '|:|
                                          (CONS (CONS 'list (CONS A NIL))
                                           NIL)))
                                        V947
                                        #'(LAMBDA NIL
                                           (FUNCALL Continuation))))))
                                  (IF (var? X981)
                                   (PROGV (LIST X981) (LIST NIL)
                                    (PROG2 (+infs)
                                     (t* (CONS X (CONS '|:| (CONS A NIL))) V947
                                      #'(LAMBDA NIL
                                         (t*
                                          (CONS Y
                                           (CONS '|:|
                                            (CONS (CONS 'list (CONS A NIL))
                                             NIL)))
                                          V947
                                          #'(LAMBDA NIL
                                             (FUNCALL Continuation)))))))
                                   NIL)))))
                              NIL)))
                           (IF (var? X976)
                            (PROGV (LIST X976) (LIST 'list)
                             (LET ((X982 (lazyderef (CDR X975))))
                              (IF (CONSP X982)
                               (LET ((A (CAR X982)))
                                (LET ((X983 (lazyderef (CDR X982))))
                                 (IF (NULL X983)
                                  (LET ((X984 (lazyderef (CDR X974))))
                                   (IF (NULL X984)
                                    (PROG2 (+infs)
                                     (t* (CONS X (CONS '|:| (CONS A NIL))) V947
                                      #'(LAMBDA NIL
                                         (t*
                                          (CONS Y
                                           (CONS '|:|
                                            (CONS (CONS 'list (CONS A NIL))
                                             NIL)))
                                          V947
                                          #'(LAMBDA NIL
                                             (FUNCALL Continuation))))))
                                    (IF (var? X984)
                                     (PROGV (LIST X984) (LIST NIL)
                                      (PROG2 (+infs)
                                       (t* (CONS X (CONS '|:| (CONS A NIL)))
                                        V947
                                        #'(LAMBDA NIL
                                           (t*
                                            (CONS Y
                                             (CONS '|:|
                                              (CONS (CONS 'list (CONS A NIL))
                                               NIL)))
                                            V947
                                            #'(LAMBDA NIL
                                               (FUNCALL Continuation)))))))
                                     NIL)))
                                  (IF (var? X983)
                                   (PROGV (LIST X983) (LIST NIL)
                                    (LET ((X985 (lazyderef (CDR X974))))
                                     (IF (NULL X985)
                                      (PROG2 (+infs)
                                       (t* (CONS X (CONS '|:| (CONS A NIL)))
                                        V947
                                        #'(LAMBDA NIL
                                           (t*
                                            (CONS Y
                                             (CONS '|:|
                                              (CONS (CONS 'list (CONS A NIL))
                                               NIL)))
                                            V947
                                            #'(LAMBDA NIL
                                               (FUNCALL Continuation))))))
                                      (IF (var? X985)
                                       (PROGV (LIST X985) (LIST NIL)
                                        (PROG2 (+infs)
                                         (t* (CONS X (CONS '|:| (CONS A NIL)))
                                          V947
                                          #'(LAMBDA NIL
                                             (t*
                                              (CONS Y
                                               (CONS '|:|
                                                (CONS (CONS 'list (CONS A NIL))
                                                 NIL)))
                                              V947
                                              #'(LAMBDA NIL
                                                 (FUNCALL
                                                  Continuation)))))))
                                       NIL))))
                                   NIL))))
                               (IF (var? X982)
                                (LET ((A (GENSYM "X")))
                                 (PROGV (LIST X982) (LIST (cons A NIL))
                                  (LET ((X986 (lazyderef (CDR X974))))
                                   (IF (NULL X986)
                                    (PROG2 (+infs)
                                     (t* (CONS X (CONS '|:| (CONS A NIL))) V947
                                      #'(LAMBDA NIL
                                         (t*
                                          (CONS Y
                                           (CONS '|:|
                                            (CONS (CONS 'list (CONS A NIL))
                                             NIL)))
                                          V947
                                          #'(LAMBDA NIL
                                             (FUNCALL Continuation))))))
                                    (IF (var? X986)
                                     (PROGV (LIST X986) (LIST NIL)
                                      (PROG2 (+infs)
                                       (t* (CONS X (CONS '|:| (CONS A NIL)))
                                        V947
                                        #'(LAMBDA NIL
                                           (t*
                                            (CONS Y
                                             (CONS '|:|
                                              (CONS (CONS 'list (CONS A NIL))
                                               NIL)))
                                            V947
                                            #'(LAMBDA NIL
                                               (FUNCALL Continuation)))))))
                                     NIL)))))
                                NIL))))
                            NIL)))
                         (IF (var? X975)
                          (LET ((A (GENSYM "X")))
                           (PROGV (LIST X975) (LIST (cons 'list (cons A NIL)))
                            (LET ((X987 (lazyderef (CDR X974))))
                             (IF (NULL X987)
                              (PROG2 (+infs)
                               (t* (CONS X (CONS '|:| (CONS A NIL))) V947
                                #'(LAMBDA NIL
                                   (t*
                                    (CONS Y
                                     (CONS '|:|
                                      (CONS (CONS 'list (CONS A NIL)) NIL)))
                                    V947
                                    #'(LAMBDA NIL
                                       (FUNCALL Continuation))))))
                              (IF (var? X987)
                               (PROGV (LIST X987) (LIST NIL)
                                (PROG2 (+infs)
                                 (t* (CONS X (CONS '|:| (CONS A NIL))) V947
                                  #'(LAMBDA NIL
                                     (t*
                                      (CONS Y
                                       (CONS '|:|
                                        (CONS (CONS 'list (CONS A NIL)) NIL)))
                                      V947
                                      #'(LAMBDA NIL
                                         (FUNCALL Continuation)))))))
                               NIL)))))
                          NIL)))
                       NIL))
                     NIL))
                   NIL))
                 NIL)))
              NIL)))
           NIL))
         NIL))
       NIL))
     NIL))
   (LET ((New (GENSYM "X")))
    (PROG2 (+infs)
     (split_cons V947 New
      #'(LAMBDA NIL (t* V946 New #'(LAMBDA NIL (FUNCALL Continuation)))))))
   (LET ((X988 (lazyderef V946)))
    (IF (CONSP X988)
     (LET ((X989 (lazyderef (CAR X988))))
      (IF (CONSP X989)
       (LET ((X990 (lazyderef (CAR X989))))
        (IF (EQ '@p X990)
         (LET ((X991 (lazyderef (CDR X989))))
          (IF (CONSP X991)
           (LET ((X (CAR X991)))
            (LET ((X992 (lazyderef (CDR X991))))
             (IF (CONSP X992)
              (LET ((Y (CAR X992)))
               (LET ((X993 (lazyderef (CDR X992))))
                (IF (NULL X993)
                 (LET ((X994 (lazyderef (CDR X988))))
                  (IF (CONSP X994)
                   (LET ((X995 (lazyderef (CAR X994))))
                    (IF (EQ '|:| X995)
                     (LET ((X996 (lazyderef (CDR X994))))
                      (IF (CONSP X996)
                       (LET ((X997 (lazyderef (CAR X996))))
                        (IF (CONSP X997)
                         (LET ((A (CAR X997)))
                          (LET ((X998 (lazyderef (CDR X997))))
                           (IF (CONSP X998)
                            (LET ((X999 (lazyderef (CAR X998))))
                             (IF (EQ '* X999)
                              (LET ((X1000 (lazyderef (CDR X998))))
                               (IF (CONSP X1000)
                                (LET ((B (CAR X1000)))
                                 (LET ((X1001 (lazyderef (CDR X1000))))
                                  (IF (NULL X1001)
                                   (LET ((X1002 (lazyderef (CDR X996))))
                                    (IF (NULL X1002)
                                     (PROG2 (+infs)
                                      (t* (CONS X (CONS '|:| (CONS A NIL)))
                                       V947
                                       #'(LAMBDA NIL
                                          (t* (CONS Y (CONS '|:| (CONS B NIL)))
                                           V947
                                           #'(LAMBDA NIL
                                              (FUNCALL Continuation))))))
                                     (IF (var? X1002)
                                      (PROGV (LIST X1002) (LIST NIL)
                                       (PROG2 (+infs)
                                        (t* (CONS X (CONS '|:| (CONS A NIL)))
                                         V947
                                         #'(LAMBDA NIL
                                            (t*
                                             (CONS Y (CONS '|:| (CONS B NIL)))
                                             V947
                                             #'(LAMBDA NIL
                                                (FUNCALL
                                                 Continuation)))))))
                                      NIL)))
                                   (IF (var? X1001)
                                    (PROGV (LIST X1001) (LIST NIL)
                                     (LET ((X1003 (lazyderef (CDR X996))))
                                      (IF (NULL X1003)
                                       (PROG2 (+infs)
                                        (t* (CONS X (CONS '|:| (CONS A NIL)))
                                         V947
                                         #'(LAMBDA NIL
                                            (t*
                                             (CONS Y (CONS '|:| (CONS B NIL)))
                                             V947
                                             #'(LAMBDA NIL
                                                (FUNCALL Continuation))))))
                                       (IF (var? X1003)
                                        (PROGV (LIST X1003) (LIST NIL)
                                         (PROG2 (+infs)
                                          (t* (CONS X (CONS '|:| (CONS A NIL)))
                                           V947
                                           #'(LAMBDA NIL
                                              (t*
                                               (CONS Y
                                                (CONS '|:| (CONS B NIL)))
                                               V947
                                               #'(LAMBDA NIL
                                                  (FUNCALL
                                                   Continuation)))))))
                                        NIL))))
                                    NIL))))
                                (IF (var? X1000)
                                 (LET ((B (GENSYM "X")))
                                  (PROGV (LIST X1000) (LIST (cons B NIL))
                                   (LET ((X1004 (lazyderef (CDR X996))))
                                    (IF (NULL X1004)
                                     (PROG2 (+infs)
                                      (t* (CONS X (CONS '|:| (CONS A NIL)))
                                       V947
                                       #'(LAMBDA NIL
                                          (t* (CONS Y (CONS '|:| (CONS B NIL)))
                                           V947
                                           #'(LAMBDA NIL
                                              (FUNCALL Continuation))))))
                                     (IF (var? X1004)
                                      (PROGV (LIST X1004) (LIST NIL)
                                       (PROG2 (+infs)
                                        (t* (CONS X (CONS '|:| (CONS A NIL)))
                                         V947
                                         #'(LAMBDA NIL
                                            (t*
                                             (CONS Y (CONS '|:| (CONS B NIL)))
                                             V947
                                             #'(LAMBDA NIL
                                                (FUNCALL
                                                 Continuation)))))))
                                      NIL)))))
                                 NIL)))
                              (IF (var? X999)
                               (PROGV (LIST X999) (LIST '*)
                                (LET ((X1005 (lazyderef (CDR X998))))
                                 (IF (CONSP X1005)
                                  (LET ((B (CAR X1005)))
                                   (LET ((X1006 (lazyderef (CDR X1005))))
                                    (IF (NULL X1006)
                                     (LET ((X1007 (lazyderef (CDR X996))))
                                      (IF (NULL X1007)
                                       (PROG2 (+infs)
                                        (t* (CONS X (CONS '|:| (CONS A NIL)))
                                         V947
                                         #'(LAMBDA NIL
                                            (t*
                                             (CONS Y (CONS '|:| (CONS B NIL)))
                                             V947
                                             #'(LAMBDA NIL
                                                (FUNCALL Continuation))))))
                                       (IF (var? X1007)
                                        (PROGV (LIST X1007) (LIST NIL)
                                         (PROG2 (+infs)
                                          (t* (CONS X (CONS '|:| (CONS A NIL)))
                                           V947
                                           #'(LAMBDA NIL
                                              (t*
                                               (CONS Y
                                                (CONS '|:| (CONS B NIL)))
                                               V947
                                               #'(LAMBDA NIL
                                                  (FUNCALL
                                                   Continuation)))))))
                                        NIL)))
                                     (IF (var? X1006)
                                      (PROGV (LIST X1006) (LIST NIL)
                                       (LET
                                        ((X1008 (lazyderef (CDR X996))))
                                        (IF (NULL X1008)
                                         (PROG2 (+infs)
                                          (t* (CONS X (CONS '|:| (CONS A NIL)))
                                           V947
                                           #'(LAMBDA NIL
                                              (t*
                                               (CONS Y
                                                (CONS '|:| (CONS B NIL)))
                                               V947
                                               #'(LAMBDA NIL
                                                  (FUNCALL
                                                   Continuation))))))
                                         (IF (var? X1008)
                                          (PROGV (LIST X1008) (LIST NIL)
                                           (PROG2 (+infs)
                                            (t*
                                             (CONS X (CONS '|:| (CONS A NIL)))
                                             V947
                                             #'(LAMBDA NIL
                                                (t*
                                                 (CONS Y
                                                  (CONS '|:| (CONS B NIL)))
                                                 V947
                                                 #'(LAMBDA NIL
                                                    (FUNCALL
                                                     Continuation)))))))
                                          NIL))))
                                      NIL))))
                                  (IF (var? X1005)
                                   (LET ((B (GENSYM "X")))
                                    (PROGV (LIST X1005) (LIST (cons B NIL))
                                     (LET ((X1009 (lazyderef (CDR X996))))
                                      (IF (NULL X1009)
                                       (PROG2 (+infs)
                                        (t* (CONS X (CONS '|:| (CONS A NIL)))
                                         V947
                                         #'(LAMBDA NIL
                                            (t*
                                             (CONS Y (CONS '|:| (CONS B NIL)))
                                             V947
                                             #'(LAMBDA NIL
                                                (FUNCALL Continuation))))))
                                       (IF (var? X1009)
                                        (PROGV (LIST X1009) (LIST NIL)
                                         (PROG2 (+infs)
                                          (t* (CONS X (CONS '|:| (CONS A NIL)))
                                           V947
                                           #'(LAMBDA NIL
                                              (t*
                                               (CONS Y
                                                (CONS '|:| (CONS B NIL)))
                                               V947
                                               #'(LAMBDA NIL
                                                  (FUNCALL
                                                   Continuation)))))))
                                        NIL)))))
                                   NIL))))
                               NIL)))
                            (IF (var? X998)
                             (LET ((B (GENSYM "X")))
                              (PROGV (LIST X998) (LIST (cons '* (cons B NIL)))
                               (LET ((X1010 (lazyderef (CDR X996))))
                                (IF (NULL X1010)
                                 (PROG2 (+infs)
                                  (t* (CONS X (CONS '|:| (CONS A NIL))) V947
                                   #'(LAMBDA NIL
                                      (t* (CONS Y (CONS '|:| (CONS B NIL)))
                                       V947
                                       #'(LAMBDA NIL
                                          (FUNCALL Continuation))))))
                                 (IF (var? X1010)
                                  (PROGV (LIST X1010) (LIST NIL)
                                   (PROG2 (+infs)
                                    (t* (CONS X (CONS '|:| (CONS A NIL))) V947
                                     #'(LAMBDA NIL
                                        (t* (CONS Y (CONS '|:| (CONS B NIL)))
                                         V947
                                         #'(LAMBDA NIL
                                            (FUNCALL Continuation)))))))
                                  NIL)))))
                             NIL))))
                         (IF (var? X997)
                          (LET ((A (GENSYM "X")))
                           (LET ((B (GENSYM "X")))
                            (PROGV (LIST X997)
                             (LIST (cons A (cons '* (cons B NIL))))
                             (LET ((X1011 (lazyderef (CDR X996))))
                              (IF (NULL X1011)
                               (PROG2 (+infs)
                                (t* (CONS X (CONS '|:| (CONS A NIL))) V947
                                 #'(LAMBDA NIL
                                    (t* (CONS Y (CONS '|:| (CONS B NIL))) V947
                                     #'(LAMBDA NIL
                                        (FUNCALL Continuation))))))
                               (IF (var? X1011)
                                (PROGV (LIST X1011) (LIST NIL)
                                 (PROG2 (+infs)
                                  (t* (CONS X (CONS '|:| (CONS A NIL))) V947
                                   #'(LAMBDA NIL
                                      (t* (CONS Y (CONS '|:| (CONS B NIL)))
                                       V947
                                       #'(LAMBDA NIL
                                          (FUNCALL Continuation)))))))
                                NIL))))))
                          NIL)))
                       NIL))
                     NIL))
                   NIL))
                 NIL)))
              NIL)))
           NIL))
         NIL))
       NIL))
     NIL))
   (LET ((New (GENSYM "X")))
    (PROG2 (+infs)
     (split_@p V947 New
      #'(LAMBDA NIL (t* V946 New #'(LAMBDA NIL (FUNCALL Continuation)))))))
   (LET ((X1012 (lazyderef V946)))
    (IF (CONSP X1012)
     (LET ((X1013 (lazyderef (CAR X1012))))
      (IF (CONSP X1013)
       (LET ((X1014 (lazyderef (CAR X1013))))
        (IF (EQ 'let X1014)
         (LET ((X1015 (lazyderef (CDR X1013))))
          (IF (CONSP X1015)
           (LET ((X (CAR X1015)))
            (LET ((X1016 (lazyderef (CDR X1015))))
             (IF (CONSP X1016)
              (LET ((Y (CAR X1016)))
               (LET ((X1017 (lazyderef (CDR X1016))))
                (IF (CONSP X1017)
                 (LET ((Z (CAR X1017)))
                  (LET ((X1018 (lazyderef (CDR X1017))))
                   (IF (NULL X1018)
                    (LET ((X1019 (lazyderef (CDR X1012))))
                     (IF (CONSP X1019)
                      (LET ((X1020 (lazyderef (CAR X1019))))
                       (IF (EQ '|:| X1020)
                        (LET ((X1021 (lazyderef (CDR X1019))))
                         (IF (CONSP X1021)
                          (LET ((A (CAR X1021)))
                           (LET ((X1022 (lazyderef (CDR X1021))))
                            (IF (NULL X1022)
                             (LET ((Z& (GENSYM "X")))
                              (LET ((X& (GENSYM "X")))
                               (LET ((B (GENSYM "X")))
                                (PROG2 (+infs)
                                 (OR
                                  (fwhen (variable? (lazyderef X))
                                   #'(LAMBDA NIL
                                      (t* (CONS Y (CONS '|:| (CONS B NIL)))
                                       V947
                                       #'(LAMBDA NIL
                                          (bind X& (arbterm)
                                           #'(LAMBDA NIL
                                              (bind Z&
                                               (beta-reduce (lazyderef X&)
                                                (lazyderef X) (lazyderef Z))
                                               #'(LAMBDA NIL
                                                  (t*
                                                   (CONS Z&
                                                    (CONS '|:| (CONS A NIL)))
                                                   (CONS
                                                    (CONS X&
                                                     (CONS '|:| (CONS B NIL)))
                                                    V947)
                                                   #'(LAMBDA NIL
                                                      (FUNCALL
                                                       Continuation)))))))))))
                                  (RETURN-FROM failure NIL))))))
                             NIL)))
                          NIL))
                        NIL))
                      NIL))
                    NIL)))
                 NIL)))
              NIL)))
           NIL))
         NIL))
       NIL))
     NIL))
   (LET ((X1023 (lazyderef V946)))
    (IF (CONSP X1023)
     (LET ((X1024 (lazyderef (CAR X1023))))
      (IF (CONSP X1024)
       (LET ((X1025 (lazyderef (CAR X1024))))
        (IF (EQ '/. X1025)
         (LET ((X1026 (lazyderef (CDR X1024))))
          (IF (CONSP X1026)
           (LET ((X (CAR X1026)))
            (LET ((X1027 (lazyderef (CDR X1026))))
             (IF (CONSP X1027)
              (LET ((Y (CAR X1027)))
               (LET ((X1028 (lazyderef (CDR X1027))))
                (IF (NULL X1028)
                 (LET ((X1029 (lazyderef (CDR X1023))))
                  (IF (CONSP X1029)
                   (LET ((X1030 (lazyderef (CAR X1029))))
                    (IF (EQ '|:| X1030)
                     (LET ((X1031 (lazyderef (CDR X1029))))
                      (IF (CONSP X1031)
                       (LET ((X1032 (lazyderef (CAR X1031))))
                        (IF (CONSP X1032)
                         (LET ((A (CAR X1032)))
                          (LET ((X1033 (lazyderef (CDR X1032))))
                           (IF (CONSP X1033)
                            (LET ((X1034 (lazyderef (CAR X1033))))
                             (IF (EQ '--> X1034)
                              (LET ((X1035 (lazyderef (CDR X1033))))
                               (IF (CONSP X1035)
                                (LET ((B (CAR X1035)))
                                 (LET ((X1036 (lazyderef (CDR X1035))))
                                  (IF (NULL X1036)
                                   (LET ((X1037 (lazyderef (CDR X1031))))
                                    (IF (NULL X1037)
                                     (LET ((Y& (GENSYM "X")))
                                      (LET ((X& (GENSYM "X")))
                                       (PROG2 (+infs)
                                        (OR
                                         (fwhen (variable? (lazyderef X))
                                          #'(LAMBDA NIL
                                             (bind X& (arbterm)
                                              #'(LAMBDA NIL
                                                 (bind Y&
                                                  (beta-reduce (lazyderef X&)
                                                   (lazyderef X) (lazyderef Y))
                                                  #'(LAMBDA NIL
                                                     (t*
                                                      (CONS Y&
                                                       (CONS '|:|
                                                        (CONS B NIL)))
                                                      (CONS
                                                       (CONS X&
                                                        (CONS '|:|
                                                         (CONS A NIL)))
                                                       V947)
                                                      #'(LAMBDA NIL
                                                         (FUNCALL
                                                          Continuation)))))))))
                                         (RETURN-FROM failure NIL)))))
                                     (IF (var? X1037)
                                      (PROGV (LIST X1037) (LIST NIL)
                                       (LET ((Y& (GENSYM "X")))
                                        (LET ((X& (GENSYM "X")))
                                         (PROG2 (+infs)
                                          (OR
                                           (fwhen (variable? (lazyderef X))
                                            #'(LAMBDA NIL
                                               (bind X& (arbterm)
                                                #'(LAMBDA NIL
                                                   (bind Y&
                                                    (beta-reduce (lazyderef X&)
                                                     (lazyderef X)
                                                     (lazyderef Y))
                                                    #'(LAMBDA NIL
                                                       (t*
                                                        (CONS Y&
                                                         (CONS '|:|
                                                          (CONS B NIL)))
                                                        (CONS
                                                         (CONS X&
                                                          (CONS '|:|
                                                           (CONS A NIL)))
                                                         V947)
                                                        #'(LAMBDA NIL
                                                           (FUNCALL
                                                            Continuation)))))))))
                                           (RETURN-FROM failure NIL))))))
                                      NIL)))
                                   (IF (var? X1036)
                                    (PROGV (LIST X1036) (LIST NIL)
                                     (LET ((X1038 (lazyderef (CDR X1031))))
                                      (IF (NULL X1038)
                                       (LET ((Y& (GENSYM "X")))
                                        (LET ((X& (GENSYM "X")))
                                         (PROG2 (+infs)
                                          (OR
                                           (fwhen (variable? (lazyderef X))
                                            #'(LAMBDA NIL
                                               (bind X& (arbterm)
                                                #'(LAMBDA NIL
                                                   (bind Y&
                                                    (beta-reduce (lazyderef X&)
                                                     (lazyderef X)
                                                     (lazyderef Y))
                                                    #'(LAMBDA NIL
                                                       (t*
                                                        (CONS Y&
                                                         (CONS '|:|
                                                          (CONS B NIL)))
                                                        (CONS
                                                         (CONS X&
                                                          (CONS '|:|
                                                           (CONS A NIL)))
                                                         V947)
                                                        #'(LAMBDA NIL
                                                           (FUNCALL
                                                            Continuation)))))))))
                                           (RETURN-FROM failure NIL)))))
                                       (IF (var? X1038)
                                        (PROGV (LIST X1038) (LIST NIL)
                                         (LET ((Y& (GENSYM "X")))
                                          (LET ((X& (GENSYM "X")))
                                           (PROG2 (+infs)
                                            (OR
                                             (fwhen (variable? (lazyderef X))
                                              #'(LAMBDA NIL
                                                 (bind X& (arbterm)
                                                  #'(LAMBDA NIL
                                                     (bind Y&
                                                      (beta-reduce
                                                       (lazyderef X&)
                                                       (lazyderef X)
                                                       (lazyderef Y))
                                                      #'(LAMBDA NIL
                                                         (t*
                                                          (CONS Y&
                                                           (CONS '|:|
                                                            (CONS B NIL)))
                                                          (CONS
                                                           (CONS X&
                                                            (CONS '|:|
                                                             (CONS A NIL)))
                                                           V947)
                                                          #'(LAMBDA NIL
                                                             (FUNCALL
                                                              Continuation)))))))))
                                             (RETURN-FROM failure NIL))))))
                                        NIL))))
                                    NIL))))
                                (IF (var? X1035)
                                 (LET ((B (GENSYM "X")))
                                  (PROGV (LIST X1035) (LIST (cons B NIL))
                                   (LET ((X1039 (lazyderef (CDR X1031))))
                                    (IF (NULL X1039)
                                     (LET ((Y& (GENSYM "X")))
                                      (LET ((X& (GENSYM "X")))
                                       (PROG2 (+infs)
                                        (OR
                                         (fwhen (variable? (lazyderef X))
                                          #'(LAMBDA NIL
                                             (bind X& (arbterm)
                                              #'(LAMBDA NIL
                                                 (bind Y&
                                                  (beta-reduce (lazyderef X&)
                                                   (lazyderef X) (lazyderef Y))
                                                  #'(LAMBDA NIL
                                                     (t*
                                                      (CONS Y&
                                                       (CONS '|:|
                                                        (CONS B NIL)))
                                                      (CONS
                                                       (CONS X&
                                                        (CONS '|:|
                                                         (CONS A NIL)))
                                                       V947)
                                                      #'(LAMBDA NIL
                                                         (FUNCALL
                                                          Continuation)))))))))
                                         (RETURN-FROM failure NIL)))))
                                     (IF (var? X1039)
                                      (PROGV (LIST X1039) (LIST NIL)
                                       (LET ((Y& (GENSYM "X")))
                                        (LET ((X& (GENSYM "X")))
                                         (PROG2 (+infs)
                                          (OR
                                           (fwhen (variable? (lazyderef X))
                                            #'(LAMBDA NIL
                                               (bind X& (arbterm)
                                                #'(LAMBDA NIL
                                                   (bind Y&
                                                    (beta-reduce (lazyderef X&)
                                                     (lazyderef X)
                                                     (lazyderef Y))
                                                    #'(LAMBDA NIL
                                                       (t*
                                                        (CONS Y&
                                                         (CONS '|:|
                                                          (CONS B NIL)))
                                                        (CONS
                                                         (CONS X&
                                                          (CONS '|:|
                                                           (CONS A NIL)))
                                                         V947)
                                                        #'(LAMBDA NIL
                                                           (FUNCALL
                                                            Continuation)))))))))
                                           (RETURN-FROM failure NIL))))))
                                      NIL)))))
                                 NIL)))
                              (IF (var? X1034)
                               (PROGV (LIST X1034) (LIST '-->)
                                (LET ((X1040 (lazyderef (CDR X1033))))
                                 (IF (CONSP X1040)
                                  (LET ((B (CAR X1040)))
                                   (LET ((X1041 (lazyderef (CDR X1040))))
                                    (IF (NULL X1041)
                                     (LET ((X1042 (lazyderef (CDR X1031))))
                                      (IF (NULL X1042)
                                       (LET ((Y& (GENSYM "X")))
                                        (LET ((X& (GENSYM "X")))
                                         (PROG2 (+infs)
                                          (OR
                                           (fwhen (variable? (lazyderef X))
                                            #'(LAMBDA NIL
                                               (bind X& (arbterm)
                                                #'(LAMBDA NIL
                                                   (bind Y&
                                                    (beta-reduce (lazyderef X&)
                                                     (lazyderef X)
                                                     (lazyderef Y))
                                                    #'(LAMBDA NIL
                                                       (t*
                                                        (CONS Y&
                                                         (CONS '|:|
                                                          (CONS B NIL)))
                                                        (CONS
                                                         (CONS X&
                                                          (CONS '|:|
                                                           (CONS A NIL)))
                                                         V947)
                                                        #'(LAMBDA NIL
                                                           (FUNCALL
                                                            Continuation)))))))))
                                           (RETURN-FROM failure NIL)))))
                                       (IF (var? X1042)
                                        (PROGV (LIST X1042) (LIST NIL)
                                         (LET ((Y& (GENSYM "X")))
                                          (LET ((X& (GENSYM "X")))
                                           (PROG2 (+infs)
                                            (OR
                                             (fwhen (variable? (lazyderef X))
                                              #'(LAMBDA NIL
                                                 (bind X& (arbterm)
                                                  #'(LAMBDA NIL
                                                     (bind Y&
                                                      (beta-reduce
                                                       (lazyderef X&)
                                                       (lazyderef X)
                                                       (lazyderef Y))
                                                      #'(LAMBDA NIL
                                                         (t*
                                                          (CONS Y&
                                                           (CONS '|:|
                                                            (CONS B NIL)))
                                                          (CONS
                                                           (CONS X&
                                                            (CONS '|:|
                                                             (CONS A NIL)))
                                                           V947)
                                                          #'(LAMBDA NIL
                                                             (FUNCALL
                                                              Continuation)))))))))
                                             (RETURN-FROM failure NIL))))))
                                        NIL)))
                                     (IF (var? X1041)
                                      (PROGV (LIST X1041) (LIST NIL)
                                       (LET
                                        ((X1043 (lazyderef (CDR X1031))))
                                        (IF (NULL X1043)
                                         (LET ((Y& (GENSYM "X")))
                                          (LET ((X& (GENSYM "X")))
                                           (PROG2 (+infs)
                                            (OR
                                             (fwhen (variable? (lazyderef X))
                                              #'(LAMBDA NIL
                                                 (bind X& (arbterm)
                                                  #'(LAMBDA NIL
                                                     (bind Y&
                                                      (beta-reduce
                                                       (lazyderef X&)
                                                       (lazyderef X)
                                                       (lazyderef Y))
                                                      #'(LAMBDA NIL
                                                         (t*
                                                          (CONS Y&
                                                           (CONS '|:|
                                                            (CONS B NIL)))
                                                          (CONS
                                                           (CONS X&
                                                            (CONS '|:|
                                                             (CONS A NIL)))
                                                           V947)
                                                          #'(LAMBDA NIL
                                                             (FUNCALL
                                                              Continuation)))))))))
                                             (RETURN-FROM failure NIL)))))
                                         (IF (var? X1043)
                                          (PROGV (LIST X1043) (LIST NIL)
                                           (LET ((Y& (GENSYM "X")))
                                            (LET ((X& (GENSYM "X")))
                                             (PROG2 (+infs)
                                              (OR
                                               (fwhen (variable? (lazyderef X))
                                                #'(LAMBDA NIL
                                                   (bind X& (arbterm)
                                                    #'(LAMBDA NIL
                                                       (bind Y&
                                                        (beta-reduce
                                                         (lazyderef X&)
                                                         (lazyderef X)
                                                         (lazyderef Y))
                                                        #'(LAMBDA NIL
                                                           (t*
                                                            (CONS Y&
                                                             (CONS '|:|
                                                              (CONS B NIL)))
                                                            (CONS
                                                             (CONS X&
                                                              (CONS '|:|
                                                               (CONS A NIL)))
                                                             V947)
                                                            #'(LAMBDA NIL
                                                               (FUNCALL
                                                                Continuation)))))))))
                                               (RETURN-FROM failure
                                                NIL))))))
                                          NIL))))
                                      NIL))))
                                  (IF (var? X1040)
                                   (LET ((B (GENSYM "X")))
                                    (PROGV (LIST X1040) (LIST (cons B NIL))
                                     (LET ((X1044 (lazyderef (CDR X1031))))
                                      (IF (NULL X1044)
                                       (LET ((Y& (GENSYM "X")))
                                        (LET ((X& (GENSYM "X")))
                                         (PROG2 (+infs)
                                          (OR
                                           (fwhen (variable? (lazyderef X))
                                            #'(LAMBDA NIL
                                               (bind X& (arbterm)
                                                #'(LAMBDA NIL
                                                   (bind Y&
                                                    (beta-reduce (lazyderef X&)
                                                     (lazyderef X)
                                                     (lazyderef Y))
                                                    #'(LAMBDA NIL
                                                       (t*
                                                        (CONS Y&
                                                         (CONS '|:|
                                                          (CONS B NIL)))
                                                        (CONS
                                                         (CONS X&
                                                          (CONS '|:|
                                                           (CONS A NIL)))
                                                         V947)
                                                        #'(LAMBDA NIL
                                                           (FUNCALL
                                                            Continuation)))))))))
                                           (RETURN-FROM failure NIL)))))
                                       (IF (var? X1044)
                                        (PROGV (LIST X1044) (LIST NIL)
                                         (LET ((Y& (GENSYM "X")))
                                          (LET ((X& (GENSYM "X")))
                                           (PROG2 (+infs)
                                            (OR
                                             (fwhen (variable? (lazyderef X))
                                              #'(LAMBDA NIL
                                                 (bind X& (arbterm)
                                                  #'(LAMBDA NIL
                                                     (bind Y&
                                                      (beta-reduce
                                                       (lazyderef X&)
                                                       (lazyderef X)
                                                       (lazyderef Y))
                                                      #'(LAMBDA NIL
                                                         (t*
                                                          (CONS Y&
                                                           (CONS '|:|
                                                            (CONS B NIL)))
                                                          (CONS
                                                           (CONS X&
                                                            (CONS '|:|
                                                             (CONS A NIL)))
                                                           V947)
                                                          #'(LAMBDA NIL
                                                             (FUNCALL
                                                              Continuation)))))))))
                                             (RETURN-FROM failure NIL))))))
                                        NIL)))))
                                   NIL))))
                               NIL)))
                            (IF (var? X1033)
                             (LET ((B (GENSYM "X")))
                              (PROGV (LIST X1033)
                               (LIST (cons '--> (cons B NIL)))
                               (LET ((X1045 (lazyderef (CDR X1031))))
                                (IF (NULL X1045)
                                 (LET ((Y& (GENSYM "X")))
                                  (LET ((X& (GENSYM "X")))
                                   (PROG2 (+infs)
                                    (OR
                                     (fwhen (variable? (lazyderef X))
                                      #'(LAMBDA NIL
                                         (bind X& (arbterm)
                                          #'(LAMBDA NIL
                                             (bind Y&
                                              (beta-reduce (lazyderef X&)
                                               (lazyderef X) (lazyderef Y))
                                              #'(LAMBDA NIL
                                                 (t*
                                                  (CONS Y&
                                                   (CONS '|:| (CONS B NIL)))
                                                  (CONS
                                                   (CONS X&
                                                    (CONS '|:| (CONS A NIL)))
                                                   V947)
                                                  #'(LAMBDA NIL
                                                     (FUNCALL
                                                      Continuation)))))))))
                                     (RETURN-FROM failure NIL)))))
                                 (IF (var? X1045)
                                  (PROGV (LIST X1045) (LIST NIL)
                                   (LET ((Y& (GENSYM "X")))
                                    (LET ((X& (GENSYM "X")))
                                     (PROG2 (+infs)
                                      (OR
                                       (fwhen (variable? (lazyderef X))
                                        #'(LAMBDA NIL
                                           (bind X& (arbterm)
                                            #'(LAMBDA NIL
                                               (bind Y&
                                                (beta-reduce (lazyderef X&)
                                                 (lazyderef X) (lazyderef Y))
                                                #'(LAMBDA NIL
                                                   (t*
                                                    (CONS Y&
                                                     (CONS '|:| (CONS B NIL)))
                                                    (CONS
                                                     (CONS X&
                                                      (CONS '|:| (CONS A NIL)))
                                                     V947)
                                                    #'(LAMBDA NIL
                                                       (FUNCALL
                                                        Continuation)))))))))
                                       (RETURN-FROM failure NIL))))))
                                  NIL)))))
                             NIL))))
                         (IF (var? X1032)
                          (LET ((A (GENSYM "X")))
                           (LET ((B (GENSYM "X")))
                            (PROGV (LIST X1032)
                             (LIST (cons A (cons '--> (cons B NIL))))
                             (LET ((X1046 (lazyderef (CDR X1031))))
                              (IF (NULL X1046)
                               (LET ((Y& (GENSYM "X")))
                                (LET ((X& (GENSYM "X")))
                                 (PROG2 (+infs)
                                  (OR
                                   (fwhen (variable? (lazyderef X))
                                    #'(LAMBDA NIL
                                       (bind X& (arbterm)
                                        #'(LAMBDA NIL
                                           (bind Y&
                                            (beta-reduce (lazyderef X&)
                                             (lazyderef X) (lazyderef Y))
                                            #'(LAMBDA NIL
                                               (t*
                                                (CONS Y&
                                                 (CONS '|:| (CONS B NIL)))
                                                (CONS
                                                 (CONS X&
                                                  (CONS '|:| (CONS A NIL)))
                                                 V947)
                                                #'(LAMBDA NIL
                                                   (FUNCALL
                                                    Continuation)))))))))
                                   (RETURN-FROM failure NIL)))))
                               (IF (var? X1046)
                                (PROGV (LIST X1046) (LIST NIL)
                                 (LET ((Y& (GENSYM "X")))
                                  (LET ((X& (GENSYM "X")))
                                   (PROG2 (+infs)
                                    (OR
                                     (fwhen (variable? (lazyderef X))
                                      #'(LAMBDA NIL
                                         (bind X& (arbterm)
                                          #'(LAMBDA NIL
                                             (bind Y&
                                              (beta-reduce (lazyderef X&)
                                               (lazyderef X) (lazyderef Y))
                                              #'(LAMBDA NIL
                                                 (t*
                                                  (CONS Y&
                                                   (CONS '|:| (CONS B NIL)))
                                                  (CONS
                                                   (CONS X&
                                                    (CONS '|:| (CONS A NIL)))
                                                   V947)
                                                  #'(LAMBDA NIL
                                                     (FUNCALL
                                                      Continuation)))))))))
                                     (RETURN-FROM failure NIL))))))
                                NIL))))))
                          NIL)))
                       NIL))
                     NIL))
                   NIL))
                 NIL)))
              NIL)))
           NIL))
         NIL))
       NIL))
     NIL))
   (LET ((X1047 (lazyderef V946)))
    (IF (CONSP X1047)
     (LET ((X1048 (lazyderef (CAR X1047))))
      (IF (CONSP X1048)
       (LET ((F (CAR X1048)))
        (LET ((X1049 (lazyderef (CDR X1048))))
         (IF (CONSP X1049)
          (LET ((X (CAR X1049)))
           (LET ((X1050 (lazyderef (CDR X1049))))
            (IF (NULL X1050)
             (LET ((X1051 (lazyderef (CDR X1047))))
              (IF (CONSP X1051)
               (LET ((X1052 (lazyderef (CAR X1051))))
                (IF (EQ '|:| X1052)
                 (LET ((X1053 (lazyderef (CDR X1051))))
                  (IF (CONSP X1053)
                   (LET ((X1054 (lazyderef (CAR X1053))))
                    (IF (EQ 'string X1054)
                     (LET ((X1055 (lazyderef (CDR X1053))))
                      (IF (NULL X1055)
                       (PROG2 (+infs)
                        (fwhen
                         (element? (lazyderef F)
                          (CONS 'output (CONS 'make-string NIL)))
                         #'(LAMBDA NIL
                            (OR
                             (t* (CONS X (CONS '|:| (CONS 'string NIL))) V947
                              #'(LAMBDA NIL (FUNCALL Continuation)))
                             (RETURN-FROM failure NIL)))))
                       (IF (var? X1055)
                        (PROGV (LIST X1055) (LIST NIL)
                         (PROG2 (+infs)
                          (fwhen
                           (element? (lazyderef F)
                            (CONS 'output (CONS 'make-string NIL)))
                           #'(LAMBDA NIL
                              (OR
                               (t* (CONS X (CONS '|:| (CONS 'string NIL))) V947
                                #'(LAMBDA NIL (FUNCALL Continuation)))
                               (RETURN-FROM failure NIL))))))
                        NIL)))
                     (IF (var? X1054)
                      (PROGV (LIST X1054) (LIST 'string)
                       (LET ((X1056 (lazyderef (CDR X1053))))
                        (IF (NULL X1056)
                         (PROG2 (+infs)
                          (fwhen
                           (element? (lazyderef F)
                            (CONS 'output (CONS 'make-string NIL)))
                           #'(LAMBDA NIL
                              (OR
                               (t* (CONS X (CONS '|:| (CONS 'string NIL))) V947
                                #'(LAMBDA NIL (FUNCALL Continuation)))
                               (RETURN-FROM failure NIL)))))
                         (IF (var? X1056)
                          (PROGV (LIST X1056) (LIST NIL)
                           (PROG2 (+infs)
                            (fwhen
                             (element? (lazyderef F)
                              (CONS 'output (CONS 'make-string NIL)))
                             #'(LAMBDA NIL
                                (OR
                                 (t* (CONS X (CONS '|:| (CONS 'string NIL)))
                                  V947
                                  #'(LAMBDA NIL (FUNCALL Continuation)))
                                 (RETURN-FROM failure NIL))))))
                          NIL))))
                      NIL)))
                   NIL))
                 NIL))
               NIL))
             NIL)))
          NIL)))
       NIL))
     NIL))
   (LET ((X1057 (lazyderef V946)))
    (IF (CONSP X1057)
     (LET ((X1058 (lazyderef (CAR X1057))))
      (IF (CONSP X1058)
       (LET ((F (CAR X1058)))
        (LET ((X1059 (lazyderef (CDR X1058))))
         (IF (CONSP X1059)
          (LET ((X (CAR X1059)))
           (LET ((X1060 (lazyderef (CDR X1059))))
            (IF (CONSP X1060)
             (LET ((Y (CAR X1060)))
              (LET ((Z (CDR X1060)))
               (LET ((X1061 (lazyderef (CDR X1057))))
                (IF (CONSP X1061)
                 (LET ((X1062 (lazyderef (CAR X1061))))
                  (IF (EQ '|:| X1062)
                   (LET ((X1063 (lazyderef (CDR X1061))))
                    (IF (CONSP X1063)
                     (LET ((X1064 (lazyderef (CAR X1063))))
                      (IF (EQ 'string X1064)
                       (LET ((X1065 (lazyderef (CDR X1063))))
                        (IF (NULL X1065)
                         (LET ((A (GENSYM "X")))
                          (PROG2 (+infs)
                           (fwhen
                            (element? (lazyderef F)
                             (CONS 'output (CONS 'make-string NIL)))
                            #'(LAMBDA NIL
                               (OR
                                (t* (CONS Y (CONS '|:| (CONS A NIL))) V947
                                 #'(LAMBDA NIL
                                    (t*
                                     (CONS (CONS F (CONS X Z))
                                      (CONS '|:| (CONS 'string NIL)))
                                     V947
                                     #'(LAMBDA NIL
                                        (FUNCALL Continuation)))))
                                (RETURN-FROM failure NIL))))))
                         (IF (var? X1065)
                          (PROGV (LIST X1065) (LIST NIL)
                           (LET ((A (GENSYM "X")))
                            (PROG2 (+infs)
                             (fwhen
                              (element? (lazyderef F)
                               (CONS 'output (CONS 'make-string NIL)))
                              #'(LAMBDA NIL
                                 (OR
                                  (t* (CONS Y (CONS '|:| (CONS A NIL))) V947
                                   #'(LAMBDA NIL
                                      (t*
                                       (CONS (CONS F (CONS X Z))
                                        (CONS '|:| (CONS 'string NIL)))
                                       V947
                                       #'(LAMBDA NIL
                                          (FUNCALL Continuation)))))
                                  (RETURN-FROM failure NIL)))))))
                          NIL)))
                       (IF (var? X1064)
                        (PROGV (LIST X1064) (LIST 'string)
                         (LET ((X1066 (lazyderef (CDR X1063))))
                          (IF (NULL X1066)
                           (LET ((A (GENSYM "X")))
                            (PROG2 (+infs)
                             (fwhen
                              (element? (lazyderef F)
                               (CONS 'output (CONS 'make-string NIL)))
                              #'(LAMBDA NIL
                                 (OR
                                  (t* (CONS Y (CONS '|:| (CONS A NIL))) V947
                                   #'(LAMBDA NIL
                                      (t*
                                       (CONS (CONS F (CONS X Z))
                                        (CONS '|:| (CONS 'string NIL)))
                                       V947
                                       #'(LAMBDA NIL
                                          (FUNCALL Continuation)))))
                                  (RETURN-FROM failure NIL))))))
                           (IF (var? X1066)
                            (PROGV (LIST X1066) (LIST NIL)
                             (LET ((A (GENSYM "X")))
                              (PROG2 (+infs)
                               (fwhen
                                (element? (lazyderef F)
                                 (CONS 'output (CONS 'make-string NIL)))
                                #'(LAMBDA NIL
                                   (OR
                                    (t* (CONS Y (CONS '|:| (CONS A NIL))) V947
                                     #'(LAMBDA NIL
                                        (t*
                                         (CONS (CONS F (CONS X Z))
                                          (CONS '|:| (CONS 'string NIL)))
                                         V947
                                         #'(LAMBDA NIL
                                            (FUNCALL Continuation)))))
                                    (RETURN-FROM failure NIL)))))))
                            NIL))))
                        NIL)))
                     NIL))
                   NIL))
                 NIL))))
             NIL)))
          NIL)))
       NIL))
     NIL))
   (LET ((X1067 (lazyderef V946)))
    (IF (CONSP X1067)
     (LET ((X1068 (lazyderef (CAR X1067))))
      (IF (CONSP X1068)
       (LET ((X1069 (lazyderef (CAR X1068))))
        (IF (EQ 'error X1069)
         (LET ((X1070 (lazyderef (CDR X1068))))
          (IF (CONSP X1070)
           (LET ((X (CAR X1070)))
            (LET ((X1071 (lazyderef (CDR X1070))))
             (IF (NULL X1071)
              (LET ((X1072 (lazyderef (CDR X1067))))
               (IF (CONSP X1072)
                (LET ((X1073 (lazyderef (CAR X1072))))
                 (IF (EQ '|:| X1073)
                  (LET ((X1074 (lazyderef (CDR X1072))))
                   (IF (CONSP X1074)
                    (LET ((X1075 (lazyderef (CDR X1074))))
                     (IF (NULL X1075)
                      (PROG2 (+infs)
                       (OR
                        (t* (CONS X (CONS '|:| (CONS 'string NIL))) V947
                         #'(LAMBDA NIL (FUNCALL Continuation)))
                        (RETURN-FROM failure NIL)))
                      NIL))
                    NIL))
                  NIL))
                NIL))
              NIL)))
           NIL))
         NIL))
       NIL))
     NIL))
   (LET ((X1076 (lazyderef V946)))
    (IF (CONSP X1076)
     (LET ((X1077 (lazyderef (CAR X1076))))
      (IF (CONSP X1077)
       (LET ((X1078 (lazyderef (CAR X1077))))
        (IF (EQ 'error X1078)
         (LET ((X1079 (lazyderef (CDR X1077))))
          (IF (CONSP X1079)
           (LET ((X (CAR X1079)))
            (LET ((X1080 (lazyderef (CDR X1079))))
             (IF (CONSP X1080)
              (LET ((Y (CAR X1080)))
               (LET ((Z (CDR X1080)))
                (LET ((X1081 (lazyderef (CDR X1076))))
                 (IF (CONSP X1081)
                  (LET ((X1082 (lazyderef (CAR X1081))))
                   (IF (EQ '|:| X1082)
                    (LET ((X1083 (lazyderef (CDR X1081))))
                     (IF (CONSP X1083)
                      (LET ((A (CAR X1083)))
                       (LET ((X1084 (lazyderef (CDR X1083))))
                        (IF (NULL X1084)
                         (LET ((B (GENSYM "X")))
                          (PROG2 (+infs)
                           (OR
                            (t* (CONS Y (CONS '|:| (CONS B NIL))) V947
                             #'(LAMBDA NIL
                                (t*
                                 (CONS (CONS 'error (CONS X Z))
                                  (CONS '|:| (CONS A NIL)))
                                 V947
                                 #'(LAMBDA NIL (FUNCALL Continuation)))))
                            (RETURN-FROM failure NIL))))
                         NIL)))
                      NIL))
                    NIL))
                  NIL))))
              NIL)))
           NIL))
         NIL))
       NIL))
     NIL))
   (LET ((X1085 (lazyderef V946)))
    (IF (CONSP X1085)
     (LET ((X1086 (lazyderef (CAR X1085))))
      (IF (CONSP X1086)
       (LET ((X1087 (lazyderef (CAR X1086))))
        (IF (EQ 'do X1087)
         (LET ((X1088 (lazyderef (CDR X1086))))
          (IF (CONSP X1088)
           (LET ((X (CAR X1088)))
            (LET ((X1089 (lazyderef (CDR X1088))))
             (IF (NULL X1089)
              (LET ((X1090 (lazyderef (CDR X1085))))
               (IF (CONSP X1090)
                (LET ((X1091 (lazyderef (CAR X1090))))
                 (IF (EQ '|:| X1091)
                  (LET ((X1092 (lazyderef (CDR X1090))))
                   (IF (CONSP X1092)
                    (LET ((A (CAR X1092)))
                     (LET ((X1093 (lazyderef (CDR X1092))))
                      (IF (NULL X1093)
                       (PROG2 (+infs)
                        (OR
                         (t* (CONS X (CONS '|:| (CONS A NIL))) V947
                          #'(LAMBDA NIL (FUNCALL Continuation)))
                         (RETURN-FROM failure NIL)))
                       NIL)))
                    NIL))
                  NIL))
                NIL))
              NIL)))
           NIL))
         NIL))
       NIL))
     NIL))
   (LET ((X1094 (lazyderef V946)))
    (IF (CONSP X1094)
     (LET ((X1095 (lazyderef (CAR X1094))))
      (IF (CONSP X1095)
       (LET ((X1096 (lazyderef (CAR X1095))))
        (IF (EQ 'do X1096)
         (LET ((X1097 (lazyderef (CDR X1095))))
          (IF (CONSP X1097)
           (LET ((X (CAR X1097)))
            (LET ((X1098 (lazyderef (CDR X1097))))
             (IF (CONSP X1098)
              (LET ((Y (CAR X1098)))
               (LET ((Z (CDR X1098)))
                (LET ((X1099 (lazyderef (CDR X1094))))
                 (IF (CONSP X1099)
                  (LET ((X1100 (lazyderef (CAR X1099))))
                   (IF (EQ '|:| X1100)
                    (LET ((X1101 (lazyderef (CDR X1099))))
                     (IF (CONSP X1101)
                      (LET ((A (CAR X1101)))
                       (LET ((X1102 (lazyderef (CDR X1101))))
                        (IF (NULL X1102)
                         (LET ((B (GENSYM "X")))
                          (PROG2 (+infs)
                           (OR
                            (t* (CONS X (CONS '|:| (CONS B NIL))) V947
                             #'(LAMBDA NIL
                                (t*
                                 (CONS (CONS 'do (CONS Y Z))
                                  (CONS '|:| (CONS A NIL)))
                                 V947
                                 #'(LAMBDA NIL (FUNCALL Continuation)))))
                            (RETURN-FROM failure NIL))))
                         NIL)))
                      NIL))
                    NIL))
                  NIL))))
              NIL)))
           NIL))
         NIL))
       NIL))
     NIL))
   (LET ((X1103 (lazyderef V946)))
    (IF (CONSP X1103)
     (LET ((X1104 (lazyderef (CAR X1103))))
      (IF (CONSP X1104)
       (LET ((X1105 (lazyderef (CAR X1104))))
        (IF (EQ 'set X1105)
         (LET ((X1106 (lazyderef (CDR X1104))))
          (IF (CONSP X1106)
           (LET ((S (CAR X1106)))
            (LET ((X1107 (lazyderef (CDR X1106))))
             (IF (CONSP X1107)
              (LET ((V (CAR X1107)))
               (LET ((X1108 (lazyderef (CDR X1107))))
                (IF (NULL X1108)
                 (LET ((X1109 (lazyderef (CDR X1103))))
                  (IF (CONSP X1109)
                   (LET ((X1110 (lazyderef (CAR X1109))))
                    (IF (EQ '|:| X1110)
                     (LET ((X1111 (lazyderef (CDR X1109))))
                      (IF (CONSP X1111)
                       (LET ((A (CAR X1111)))
                        (LET ((X1112 (lazyderef (CDR X1111))))
                         (IF (NULL X1112)
                          (PROG2 (+infs)
                           (OR
                            (t*
                             (CONS (CONS 'value (CONS S NIL))
                              (CONS '|:| (CONS A NIL)))
                             V947
                             #'(LAMBDA NIL
                                (t* (CONS V (CONS '|:| (CONS A NIL))) V947
                                 #'(LAMBDA NIL (FUNCALL Continuation)))))
                            (RETURN-FROM failure NIL)))
                          NIL)))
                       NIL))
                     NIL))
                   NIL))
                 NIL)))
              NIL)))
           NIL))
         NIL))
       NIL))
     NIL))
   (LET ((X1113 (lazyderef V946)))
    (IF (CONSP X1113)
     (LET ((X1114 (lazyderef (CAR X1113))))
      (IF (CONSP X1114)
       (LET ((X1115 (lazyderef (CAR X1114))))
        (IF (EQ 'where X1115)
         (LET ((X1116 (lazyderef (CDR X1114))))
          (IF (CONSP X1116)
           (LET ((P (CAR X1116)))
            (LET ((X1117 (lazyderef (CDR X1116))))
             (IF (CONSP X1117)
              (LET ((X (CAR X1117)))
               (LET ((X1118 (lazyderef (CDR X1117))))
                (IF (NULL X1118)
                 (LET ((X1119 (lazyderef (CDR X1113))))
                  (IF (CONSP X1119)
                   (LET ((X1120 (lazyderef (CAR X1119))))
                    (IF (EQ '|:| X1120)
                     (LET ((X1121 (lazyderef (CDR X1119))))
                      (IF (CONSP X1121)
                       (LET ((A (CAR X1121)))
                        (LET ((X1122 (lazyderef (CDR X1121))))
                         (IF (NULL X1122)
                          (PROG2 (+infs)
                           (t* (CONS P (CONS '|:| (CONS 'boolean NIL))) V947
                            #'(LAMBDA NIL
                               (t* (CONS X (CONS '|:| (CONS A NIL)))
                                (CONS (CONS P (CONS '|:| (CONS 'verified NIL)))
                                 V947)
                                #'(LAMBDA NIL (FUNCALL Continuation))))))
                          NIL)))
                       NIL))
                     NIL))
                   NIL))
                 NIL)))
              NIL)))
           NIL))
         NIL))
       NIL))
     NIL))
   (LET ((X1123 (lazyderef V946)))
    (IF (CONSP X1123)
     (LET ((X1124 (lazyderef (CAR X1123))))
      (IF (CONSP X1124)
       (LET ((X1125 (lazyderef (CAR X1124))))
        (IF (EQ 'define X1125)
         (LET ((X1126 (lazyderef (CDR X1124))))
          (IF (CONSP X1126)
           (LET ((F (CAR X1126)))
            (LET ((Def (CDR X1126)))
             (LET ((X1127 (lazyderef (CDR X1123))))
              (IF (CONSP X1127)
               (LET ((X1128 (lazyderef (CAR X1127))))
                (IF (EQ '|:| X1128)
                 (LET ((X1129 (lazyderef (CDR X1127))))
                  (IF (CONSP X1129)
                   (LET ((A (CAR X1129)))
                    (LET ((X1130 (lazyderef (CDR X1129))))
                     (IF (NULL X1130)
                      (LET ((S+Def (GENSYM "X")))
                       (LET ((Rules (GENSYM "X")))
                        (LET ((SS (GENSYM "X")))
                         (LET ((S (GENSYM "X")))
                          (PROG2 (+infs)
                           (OR
                            (fwhen (symbol? (lazyderef F))
                             #'(LAMBDA NIL
                                (bind S+Def
                                 (sigdef (lazyderef F) (lazyderef Def))
                                 #'(LAMBDA NIL
                                    (bind S
                                     (normalise-type
                                      (curry-type
                                       (head (tail (lazyderef S+Def)))))
                                     #'(LAMBDA NIL
                                        (bind SS
                                         (specialise-type (lazyderef S))
                                         #'(LAMBDA NIL
                                            (unify! A S
                                             #'(LAMBDA NIL
                                                (bind Rules
                                                 (rule+rules F
                                                  (elim-backtrack
                                                   (head (lazyderef S+Def))))
                                                 #'(LAMBDA NIL
                                                    (tfun Rules SS
                                                     (CONS
                                                      (CONS F
                                                       (CONS '|:|
                                                        (CONS SS NIL)))
                                                      NIL)
                                                     1 F
                                                     #'(LAMBDA NIL
                                                        (fundeclare F S
                                                         #'(LAMBDA NIL
                                                            (FUNCALL
                                                             Continuation)))))))))))))))))
                            (RETURN-FROM failure NIL)))))))
                      NIL)))
                   NIL))
                 NIL))
               NIL))))
           NIL))
         NIL))
       NIL))
     NIL))
   (LET ((X1131 (lazyderef V946)))
    (IF (CONSP X1131)
     (LET ((X1132 (lazyderef (CAR X1131))))
      (IF (CONSP X1132)
       (LET ((X1133 (lazyderef (CAR X1132))))
        (IF (EQ 'rule X1133)
         (LET ((Def (CDR X1132)))
          (LET ((X1134 (lazyderef (CDR X1131))))
           (IF (CONSP X1134)
            (LET ((X1135 (lazyderef (CAR X1134))))
             (IF (EQ '|:| X1135)
              (LET ((X1136 (lazyderef (CDR X1134))))
               (IF (CONSP X1136)
                (LET ((A (CAR X1136)))
                 (LET ((X1137 (lazyderef (CDR X1136))))
                  (IF (NULL X1137)
                   (LET ((Compile (GENSYM "X")))
                    (LET ((Rule (GENSYM "X")))
                     (PROG2 (+infs)
                      (OR
                       (unify A
                        (CONS
                         (CONS 'list
                          (CONS
                           (CONS (CONS 'list (CONS 'wff NIL))
                            (CONS '* (CONS 'wff NIL)))
                           NIL))
                         (CONS '-->
                          (CONS
                           (CONS 'list
                            (CONS
                             (CONS (CONS 'list (CONS 'wff NIL))
                              (CONS '* (CONS 'wff NIL)))
                             NIL))
                           NIL)))
                        #'(LAMBDA NIL
                           (bind Compile (compile '<abs-rule> (lazyderef Def))
                            #'(LAMBDA NIL
                               (fwhen (tuple? (lazyderef Compile))
                                #'(LAMBDA NIL
                                   (bind Rule (snd (lazyderef Compile))
                                    #'(LAMBDA NIL
                                       (checkrule Rule V947
                                        #'(LAMBDA NIL
                                           (FUNCALL Continuation)))))))))))
                       (RETURN-FROM failure NIL)))))
                   NIL)))
                NIL))
              NIL))
            NIL)))
         NIL))
       NIL))
     NIL))
   (LET ((X1138 (lazyderef V946)))
    (IF (CONSP X1138)
     (LET ((X1139 (lazyderef (CAR X1138))))
      (IF (CONSP X1139)
       (LET ((X1140 (lazyderef (CAR X1139))))
        (IF (EQ 'multi X1140)
         (LET ((Def (CDR X1139)))
          (LET ((X1141 (lazyderef (CDR X1138))))
           (IF (CONSP X1141)
            (LET ((X1142 (lazyderef (CAR X1141))))
             (IF (EQ '|:| X1142)
              (LET ((X1143 (lazyderef (CDR X1141))))
               (IF (CONSP X1143)
                (LET ((A (CAR X1143)))
                 (LET ((X1144 (lazyderef (CDR X1143))))
                  (IF (NULL X1144)
                   (LET ((Compile (GENSYM "X")))
                    (LET ((Rule (GENSYM "X")))
                     (PROG2 (+infs)
                      (OR
                       (unify A
                        (CONS
                         (CONS 'list
                          (CONS
                           (CONS (CONS 'list (CONS 'wff NIL))
                            (CONS '* (CONS 'wff NIL)))
                           NIL))
                         (CONS '-->
                          (CONS
                           (CONS 'list
                            (CONS
                             (CONS 'list
                              (CONS
                               (CONS (CONS 'list (CONS 'wff NIL))
                                (CONS '* (CONS 'wff NIL)))
                               NIL))
                             NIL))
                           NIL)))
                        #'(LAMBDA NIL
                           (bind Compile (compile '<abs-rule> (lazyderef Def))
                            #'(LAMBDA NIL
                               (fwhen (tuple? (lazyderef Compile))
                                #'(LAMBDA NIL
                                   (bind Rule (snd (lazyderef Compile))
                                    #'(LAMBDA NIL
                                       (checkrule Rule V947
                                        #'(LAMBDA NIL
                                           (FUNCALL Continuation)))))))))))
                       (RETURN-FROM failure NIL)))))
                   NIL)))
                NIL))
              NIL))
            NIL)))
         NIL))
       NIL))
     NIL))
   (LET ((X1145 (lazyderef V946)))
    (IF (CONSP X1145)
     (LET ((X1146 (lazyderef (CAR X1145))))
      (IF (CONSP X1146)
       (LET ((X1147 (lazyderef (CAR X1146))))
        (IF (EQ 'datatype X1147)
         (LET ((X1148 (lazyderef (CDR X1145))))
          (IF (CONSP X1148)
           (LET ((X1149 (lazyderef (CAR X1148))))
            (IF (EQ '|:| X1149)
             (LET ((X1150 (lazyderef (CDR X1148))))
              (IF (CONSP X1150)
               (LET ((X1151 (lazyderef (CAR X1150))))
                (IF (EQ 'symbol X1151)
                 (LET ((X1152 (lazyderef (CDR X1150))))
                  (IF (NULL X1152) (FUNCALL Continuation)
                   (IF (var? X1152)
                    (PROGV (LIST X1152) (LIST NIL) (FUNCALL Continuation))
                    NIL)))
                 (IF (var? X1151)
                  (PROGV (LIST X1151) (LIST 'symbol)
                   (LET ((X1153 (lazyderef (CDR X1150))))
                    (IF (NULL X1153) (FUNCALL Continuation)
                     (IF (var? X1153)
                      (PROGV (LIST X1153) (LIST NIL)
                       (FUNCALL Continuation))
                      NIL))))
                  NIL)))
               NIL))
             NIL))
           NIL))
         NIL))
       NIL))
     NIL))
   (LET ((X1154 (lazyderef V946)))
    (IF (CONSP X1154)
     (LET ((X1155 (lazyderef (CAR X1154))))
      (IF (CONSP X1155)
       (LET ((X1156 (lazyderef (CAR X1155))))
        (IF (EQ 'synonyms X1156)
         (LET ((X1157 (lazyderef (CDR X1154))))
          (IF (CONSP X1157)
           (LET ((X1158 (lazyderef (CAR X1157))))
            (IF (EQ '|:| X1158)
             (LET ((X1159 (lazyderef (CDR X1157))))
              (IF (CONSP X1159)
               (LET ((X1160 (lazyderef (CAR X1159))))
                (IF (EQ 'symbol X1160)
                 (LET ((X1161 (lazyderef (CDR X1159))))
                  (IF (NULL X1161) (FUNCALL Continuation)
                   (IF (var? X1161)
                    (PROGV (LIST X1161) (LIST NIL) (FUNCALL Continuation))
                    NIL)))
                 (IF (var? X1160)
                  (PROGV (LIST X1160) (LIST 'symbol)
                   (LET ((X1162 (lazyderef (CDR X1159))))
                    (IF (NULL X1162) (FUNCALL Continuation)
                     (IF (var? X1162)
                      (PROGV (LIST X1162) (LIST NIL)
                       (FUNCALL Continuation))
                      NIL))))
                  NIL)))
               NIL))
             NIL))
           NIL))
         NIL))
       NIL))
     NIL))
   (LET ((X1163 (lazyderef V946)))
    (IF (CONSP X1163)
     (LET ((X1164 (lazyderef (CAR X1163))))
      (IF (CONSP X1164)
       (LET ((X1165 (lazyderef (CAR X1164))))
        (IF (EQ 'input+ X1165)
         (LET ((X1166 (lazyderef (CDR X1164))))
          (IF (CONSP X1166)
           (LET ((X1167 (lazyderef (CAR X1166))))
            (IF (EQ '|:| X1167)
             (LET ((X1168 (lazyderef (CDR X1166))))
              (IF (CONSP X1168)
               (LET ((A (CAR X1168)))
                (LET ((X1169 (lazyderef (CDR X1168))))
                 (IF (NULL X1169)
                  (LET ((X1170 (lazyderef (CDR X1163))))
                   (IF (CONSP X1170)
                    (LET ((X1171 (lazyderef (CAR X1170))))
                     (IF (EQ '|:| X1171)
                      (LET ((X1172 (lazyderef (CDR X1170))))
                       (IF (CONSP X1172)
                        (LET ((B (CAR X1172)))
                         (LET ((X1173 (lazyderef (CDR X1172))))
                          (IF (NULL X1173)
                           (LET ((C (GENSYM "X")))
                            (PROG2 (+infs)
                             (OR
                              (bind C
                               (normalise-type (curry-type (lazyderef A)))
                               #'(LAMBDA NIL
                                  (unify B C
                                   #'(LAMBDA NIL (FUNCALL Continuation)))))
                              (RETURN-FROM failure NIL))))
                           NIL)))
                        NIL))
                      NIL))
                    NIL))
                  NIL)))
               NIL))
             NIL))
           NIL))
         NIL))
       NIL))
     NIL))
   (LET ((X1174 (lazyderef V946)))
    (IF (CONSP X1174)
     (LET ((X1175 (lazyderef (CAR X1174))))
      (IF (CONSP X1175)
       (LET ((X1176 (lazyderef (CAR X1175))))
        (IF (EQ 'save X1176)
         (LET ((X1177 (lazyderef (CDR X1175))))
          (IF (NULL X1177)
           (LET ((X1178 (lazyderef (CDR X1174))))
            (IF (CONSP X1178)
             (LET ((X1179 (lazyderef (CAR X1178))))
              (IF (EQ '|:| X1179)
               (LET ((X1180 (lazyderef (CDR X1178))))
                (IF (CONSP X1180)
                 (LET ((X1181 (lazyderef (CAR X1180))))
                  (IF (EQ 'number X1181)
                   (LET ((X1182 (lazyderef (CDR X1180))))
                    (IF (NULL X1182) (FUNCALL Continuation)
                     (IF (var? X1182)
                      (PROGV (LIST X1182) (LIST NIL)
                       (FUNCALL Continuation))
                      NIL)))
                   (IF (var? X1181)
                    (PROGV (LIST X1181) (LIST 'number)
                     (LET ((X1183 (lazyderef (CDR X1180))))
                      (IF (NULL X1183) (FUNCALL Continuation)
                       (IF (var? X1183)
                        (PROGV (LIST X1183) (LIST NIL)
                         (FUNCALL Continuation))
                        NIL))))
                    NIL)))
                 NIL))
               NIL))
             NIL))
           NIL))
         NIL))
       NIL))
     NIL))
   (LET ((X1184 (lazyderef V946)))
    (IF (CONSP X1184)
     (LET ((X1185 (lazyderef (CAR X1184))))
      (IF (CONSP X1185)
       (LET ((X1186 (lazyderef (CAR X1185))))
        (IF (EQ 'quit X1186)
         (LET ((X1187 (lazyderef (CDR X1185))))
          (IF (NULL X1187)
           (LET ((X1188 (lazyderef (CDR X1184))))
            (IF (CONSP X1188)
             (LET ((X1189 (lazyderef (CAR X1188))))
              (IF (EQ '|:| X1189)
               (LET ((X1190 (lazyderef (CDR X1188))))
                (IF (CONSP X1190)
                 (LET ((X1191 (lazyderef (CDR X1190))))
                  (IF (NULL X1191) (FUNCALL Continuation) NIL))
                 NIL))
               NIL))
             NIL))
           NIL))
         NIL))
       NIL))
     NIL))
   (LET ((DataTypes (GENSYM "X")))
    (PROG2 (+infs)
     (bind DataTypes (datatypes)
      #'(LAMBDA NIL
         (datatypes_driver V946 V947 DataTypes
          #'(LAMBDA NIL (FUNCALL Continuation))))))))))

(DEFUN statictypecheck (V67 V68 V74)
 (prolog?
  (t* (CONS (curry V68) (CONS '|:| (CONS (normalise-type V74) NIL))) V67)
  (return V74)))