/*
 * Name: OGRegularExpressionEnumeratorPrivate.m
 * Project: OgreKit
 *
 * Creation Date: Sep 03 2003
 * Author: Isao Sonobe <sonoisa@gmail.com>
 * Copyright: Copyright (c) 2003-2018 Isao Sonobe, All rights reserved.
 * License: OgreKit License
 *
 * Encoding: UTF8
 * Tabsize: 4
 */

#import <OgreKit/OGRegularExpression.h>
#import <OgreKit/OGRegularExpressionPrivate.h>
#import <OgreKit/OGRegularExpressionMatch.h>
#import <OgreKit/OGRegularExpressionMatchPrivate.h>
#import <OgreKit/OGRegularExpressionEnumerator.h>
#import <OgreKit/OGRegularExpressionEnumeratorPrivate.h>
#import <OgreKit/OGString.h>


@implementation OGRegularExpressionEnumerator (Private)

- (id) initWithOGString:(NSObject<OGStringProtocol>*)targetString 
	options:(unsigned)searchOptions 
	range:(NSRange)searchRange 
	regularExpression:(OGRegularExpression*)regex
{
#ifdef DEBUG_OGRE
	NSLog(@"-initWithOGString: of %@", [self className]);
#endif
	self = [super init];
	if (self) {
		// Ώەێ
		// target stringUTF16ɕϊB
		_targetString = [targetString copy];
		NSString	*targetPlainString = [_targetString string];
        _lengthOfTargetString = [_targetString length];
        
        _UTF16TargetString = (unichar*)NSZoneMalloc([self zone], sizeof(unichar) * (_lengthOfTargetString + 4));	// +4onigurumamemory access violationւ̑ΏÖ@
        if (_UTF16TargetString == NULL) {
            // mۂłȂꍇAO𔭐B
            [self release];
            [NSException raise:NSMallocException format:@"fail to allocate a memory"];
        }
        [targetPlainString getCharacters:_UTF16TargetString range:NSMakeRange(0, _lengthOfTargetString)];
            
        /* DEBUG 
        {
            NSLog(@"TargetString: '%@'", _targetString);
            int     i, count = _lengthOfTargetString;
            unichar *utf16Chars = _UTF16TargetString;
            for (i = 0; i < count; i++) {
                NSLog(@"UTF16: %04x", *(utf16Chars + i));
            }
        }*/
        
		// ͈
		_searchRange = searchRange;
		
		// K\IuWFNgێ
		_regex = [regex retain];
		
		// IvV
		_searchOptions = searchOptions;
		
		/* lݒ */
		// ŌɃ}b`̏I[ʒu
		// l 0
		// l >=  0 I[ʒu
		// l == -1 }b`I
		_terminalOfLastMatch = 0;
		
		// }b`Jnʒu
		_startLocation = 0;
	
		// Õ}b`󕶎񂾂ǂ
		_isLastMatchEmpty = NO;
		
		// }b`
		_numberOfMatches = 0;
	}
	
	return self;
}

- (void)dealloc
{
#ifdef DEBUG_OGRE
	NSLog(@"-dealloc of %@", [self className]);
#endif
	[_regex release];
	NSZoneFree([self zone], _UTF16TargetString);
	[_targetString release];
	
	[super dealloc];
}

/* accessors */
// private
- (void)_setTerminalOfLastMatch:(NSInteger)location
{
	_terminalOfLastMatch = location;
}

- (void)_setIsLastMatchEmpty:(BOOL)yesOrNo
{
	_isLastMatchEmpty = yesOrNo;
}

- (void)_setStartLocation:(NSUInteger)location
{
	_startLocation = location;
}

- (void)_setNumberOfMatches:(NSUInteger)aNumber
{
	_numberOfMatches = aNumber;
}

- (OGRegularExpression*)regularExpression
{
	return _regex;
}

- (void)setRegularExpression:(OGRegularExpression*)regularExpression
{
	[regularExpression retain];
	[_regex release];
	_regex = regularExpression;
}

// public?
- (NSObject<OGStringProtocol>*)targetString
{
	return _targetString;
}

- (unichar*)UTF16TargetString
{
	return _UTF16TargetString;
}

- (NSRange)searchRange
{
	return _searchRange;
}


@end
