/*
 * Name: OGRegularExpressionEnumerator.h
 * Project: OgreKit
 *
 * Creation Date: Sep 03 2003
 * Author: Isao Sonobe <sonoisa@gmail.com>
 * Copyright: Copyright (c) 2003-2020 Isao Sonobe, All rights reserved.
 * License: OgreKit License
 *
 * Encoding: UTF8
 * Tabsize: 4
 */

#import <Foundation/Foundation.h>

@class OGRegularExpression;

// Exception
extern NSString	* const OgreEnumeratorException;

@interface OGRegularExpressionEnumerator : NSEnumerator <NSCopying, NSCoding>
{
	OGRegularExpression	*_regex;				// K\IuWFNg
	NSObject<OGStringProtocol>			*_targetString;			// Ώە
	unichar             *_UTF16TargetString;	// UTF16ł̌Ώە
    NSUInteger			_lengthOfTargetString;	// [_targetString length]
	NSRange				_searchRange;			// ͈
	unsigned			_searchOptions;			// IvV
	NSInteger			_terminalOfLastMatch;	// OɃ}b`̏I[ʒu  (_region->end[0] / sizeof(unichar))
    NSUInteger			_startLocation;			// }b`Jnʒu
	BOOL				_isLastMatchEmpty;		// Õ}b`󕶎񂾂ǂ
	
	unsigned			_numberOfMatches;		// }b`
}

// S}b`ʂzŕԂB
- (NSArray*)allObjects;
// ̃}b`ʂԂB
- (id)nextObject;

// description
- (NSString*)description;

@end
