#ifndef CREDITS_H
#define CREDITS_H

#include <SDL.h>

namespace Credits {

/* Translators list; lines prefaced with a space aren't translatable */
static const char* translators[] = {
    "Arabic",
    " Eternal Dream Arabization",
    " Montassar Ghanmi",
    " Mohammed Seif Eddine Chaib",
    "Catalan",
    " Eduard Ereza Martínez",
    "Welsh",
    " Morgan Roberts",
    "German",
    " Thomas Faust",
    "Esperanto",
    " Reese Rivers",
    "Spanish (ES)",
    " Felipe Mercader",
    " Sara Marín",
    "Spanish (LATAM)",
    " LocQuest",
    " Guido Di Carlo",
    "Spanish (ARG.)",
    " LocQuest",
    " Guido Di Carlo",
    "French",
    " Words of Magic",
    "Irish",
    " Úna-Minh Kavanagh",
    " Seaghán Ó Modhráin",
    " Davis Sandefur",
    "Italian",
    " gloc.team",
    " Alain Dellepiane",
    " Matteo Scarabelli",
    " Lorenzo Bertolucci",
    " Fabio Bortolotti",
    "Japanese",
    " Nicalis, Inc.",
    " KabanFriends",
    "Korean",
    " Bada Im",
    " Hyungseok Cho",
    "Dutch",
    " Dav999",
    "Polish",
    " Kuba Kallus",
    "Brazilian Portuguese",
    ">Translators",
    "   Lucas Araujo",
    "   Thiago Araujo",
    ">Editing and LQA",
    "   Ivan Lopes",
    "   Lucas Nunes",
    "European Portuguese",
    " Locsmiths",
    "Russian",
    " TheMysticSword",
    "Silesian",
    " Kuba Kallus",
    "Turkish",
    " Engin İlkiz",
    "Ukrainian",
    " Olya Sushytska",
    "Chinese (Simplified)",
    " Sound of Mystery",
    "Chinese (Traditional)",
    " Sound of Mystery / craft",
};

/* Hardcoded pagesizes for the translator credits. Simplifies paging backwards and forwards */
static const int translator_pagesize[] = { 6, 6, 9, 12, 10, 11, 10 };

/* Terry's Patrons... */
static const char* superpatrons[] = {
    "Anders Ekermo",
    "Andreas Kämper",
    "Anthony Burch",
    "Bennett Foddy",
    "Brendan O'Sullivan",
    "Christopher Armstrong",
    "Daniel Benmergui",
    "David Pittman",
    "Ian Bogost",
    "Ian Poma",
    "Jaz McDougall",
    "John Faulkenbury",
    "Jonathan Whiting",
    "Kyle Pulver",
    "Markus Persson",
    "Nathan Ostgard",
    "Nick Easler",
    "Stephen Lavelle",
};

static const char* patrons[] = {
    "Adam Wendt",
    "Andreas Jörgensen",
    "Ángel Louzao Penalva",
    "Ashley Burton",
    "Aubrey Hesselgren",
    "Bradley Rose",
    "Brendan Urquhart",
    "Chris Ayotte",
    "Christopher Zamanillo",
    "Daniel Schuller",
    "Hybrid Mind Studios",
    "Emilie McGinley",
    "Francisco Solares",
    "Hal Helms",
    "Hayden Scott-Baron",
    "Hermit Games",
    "Ido Yehieli",
    "Jade Vault Games",
    "James Andrews",
    "James Riley",
    "James Hsieh",
    "Jasper Byrne",
    "Jedediah Baker",
    "Jens Bergensten",
    "Jeremy J. Penner",
    "Jeremy Peterson",
    "Jim McGinley",
    "Jonathan Cartwright",
    "John Nesky",
    "Jos Yule",
    "Jose Flores",
    "Josh Bizeau",
    "Joshua Buergel",
    "Joshua Hochner",
    "Kurt Ostfeld",
    "Magnus Pålsson",
    "Mark Neschadimenko",
    "Matt Antonellis",
    "Matthew Reppert",
    "Michael Falkensteiner",
    "Michael Vendittelli",
    "Mike Kasprzak",
    "Mitchel Stein",
    "Sean Murray",
    "Simon Michael",
    "Simon Schmid",
    "Stephen Maxwell",
    "Swing Swing Submarine",
    "Tam Toucan",
    "Terry Dooher",
    "Tim W.",
    "Timothy Bragan",
};

/* CONTRIBUTORS.txt, again listed alphabetically (according to `sort`) by first name
 * Misa is special; she gets to be listed in C++ credits alongside Ethan */
static const char* githubfriends[] = {
    "Alexandra Fox",
    "AlexApps99",
    "Allison Fleischer",
    "Brian Callahan",
    "Charlie Bruce",
    "Christoph Böhmwalder",
    "Daniel Lee",
    "Dav999",
    "Elijah Stone",
    "Elliott Saltar",
    "Emmanuel Vadot",
    "fraZ0R",
    "Fredrik Ljungdahl",
    "iliana etaoin",
    "Jules de Sartiges",
    "Keith Stellyes",
    "KyoZM",
    "leo60228",
    "MAO3J1m0Op",
    "Malte Grimm",
    "Marvin Scholz",
    "Matt Penny",
    "mothbeanie",
    "Nichole Mattera",
    "Pierre-Alain TORET",
    "Reese Rivers",
    "Rémi Verschelde",
    "SnDream",
    "Space-G",
    "Thomas Sänger",
    "Tynan Richards",
    "Wouter",
    "viri",
    "Vittorio Romeo",
    "Yussur Mustafa Oraji",
};

/* Calculate credits length, finally. */
static const int creditmaxposition = 1348 + (10 * (
    SDL_arraysize(superpatrons) + SDL_arraysize(patrons) + SDL_arraysize(githubfriends)
)) + (12 * SDL_arraysize(translators));

} /* namespace Credits */

#endif /* CREDITS_H */
