/*
 * Copyright (C) 2014-2025 Muhammad Tayyab Akram
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef _SB_INTERNAL_PARAGRAPH_H
#define _SB_INTERNAL_PARAGRAPH_H

#include <SheenBidi/SBAlgorithm.h>
#include <SheenBidi/SBBase.h>
#include <SheenBidi/SBConfig.h>
#include <SheenBidi/SBParagraph.h>

#include "Object.h"

typedef struct _SBParagraph {
    Object _object;
    SBAlgorithmRef algorithm;
    const SBBidiType *refTypes;
    SBLevel *fixedLevels;
    SBUInteger offset;
    SBUInteger length;
    SBLevel baseLevel;
    SBUInteger retainCount;
} SBParagraph;

SB_INTERNAL SBParagraphRef SBParagraphCreate(SBAlgorithmRef algorithm,
    SBUInteger paragraphOffset, SBUInteger suggestedLength, SBLevel baseLevel);

#endif
