/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.ddms;

import com.android.annotations.NonNull;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.DdmPreferences;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.Log;
import com.android.ddmuilib.DdmUiPreferences;
import com.android.ddmuilib.DevicePanel;
import com.android.ddmuilib.StackTracePanel;
import com.android.ddmuilib.console.DdmConsole;
import com.android.ddmuilib.console.IDdmConsole;
import com.android.ide.eclipse.ddms.IClientAction;
import com.android.ide.eclipse.ddms.IDebuggerConnector;
import com.android.ide.eclipse.ddms.IToolsLocator;
import com.android.ide.eclipse.ddms.ITraceviewLauncher;
import com.android.ide.eclipse.ddms.JavaSourceRevealer;
import com.android.ide.eclipse.ddms.LogCatMonitor;
import com.android.ide.eclipse.ddms.i18n.Messages;
import com.android.ide.eclipse.ddms.preferences.PreferenceInitializer;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public final class DdmsPlugin
extends AbstractUIPlugin
implements AndroidDebugBridge.IDeviceChangeListener,
DevicePanel.IUiSelectionListener,
StackTracePanel.ISourceRevealer {
    public static final String PLUGIN_ID = "com.android.ide.eclipse.ddms";
    private static DdmsPlugin sPlugin;
    private static String sAdbLocation;
    private static String sToolsFolder;
    private static String sHprofConverter;
    private boolean mHasDebuggerConnectors;
    private IDebuggerConnector[] mDebuggerConnectors;
    private ITraceviewLauncher[] mTraceviewLaunchers;
    private List<IClientAction> mClientSpecificActions = null;
    private MessageConsole mDdmsConsole;
    private IDevice mCurrentDevice;
    private Client mCurrentClient;
    private boolean mListeningToUiSelection = false;
    private final ArrayList<ISelectionListener> mListeners = new ArrayList();
    private Color mRed;
    private LogCatMonitor mLogCatMonitor;

    public DdmsPlugin() {
        sPlugin = this;
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        final Display display = DdmsPlugin.getDisplay();
        final IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
        DdmUiPreferences.setStore((IPreferenceStore)iPreferenceStore);
        this.mDdmsConsole = new MessageConsole("DDMS", null);
        ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{this.mDdmsConsole});
        final MessageConsoleStream messageConsoleStream = this.mDdmsConsole.newMessageStream();
        final MessageConsoleStream messageConsoleStream2 = this.mDdmsConsole.newMessageStream();
        this.mRed = new Color((Device)display, 255, 0, 0);
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                messageConsoleStream2.setColor(DdmsPlugin.this.mRed);
            }
        });
        Log.setLogOutput((Log.ILogOutput)new Log.ILogOutput(){

            public void printLog(Log.LogLevel logLevel, String string, String string2) {
                if (logLevel.getPriority() >= Log.LogLevel.ERROR.getPriority()) {
                    DdmsPlugin.printToStream(messageConsoleStream2, string, string2);
                    DdmsPlugin.this.showConsoleView(DdmsPlugin.this.mDdmsConsole);
                } else {
                    DdmsPlugin.printToStream(messageConsoleStream, string, string2);
                }
            }

            public void printAndPromptLog(final Log.LogLevel logLevel, final String string, final String string2) {
                this.printLog(logLevel, string, string2);
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Shell shell = display.getActiveShell();
                        if (logLevel == Log.LogLevel.ERROR) {
                            MessageDialog.openError((Shell)shell, (String)string, (String)string2);
                        } else {
                            MessageDialog.openWarning((Shell)shell, (String)string, (String)string2);
                        }
                    }
                });
            }
        });
        DdmConsole.setConsole((IDdmConsole)new IDdmConsole(){

            public void printErrorToConsole(String string) {
                DdmsPlugin.printToStream(messageConsoleStream2, null, string);
                DdmsPlugin.this.showConsoleView(DdmsPlugin.this.mDdmsConsole);
            }

            public void printErrorToConsole(String[] stringArray) {
                String[] stringArray2 = stringArray;
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray2[n2];
                    DdmsPlugin.printToStream(messageConsoleStream2, null, string);
                    ++n2;
                }
                DdmsPlugin.this.showConsoleView(DdmsPlugin.this.mDdmsConsole);
            }

            public void printToConsole(String string) {
                DdmsPlugin.printToStream(messageConsoleStream, null, string);
            }

            public void printToConsole(String[] stringArray) {
                String[] stringArray2 = stringArray;
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray2[n2];
                    DdmsPlugin.printToStream(messageConsoleStream, null, string);
                    ++n2;
                }
            }
        });
        iPreferenceStore.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getProperty();
                if ("com.android.ide.eclipse.ddms.adbDebugBasePort".equals(string)) {
                    DdmPreferences.setDebugPortBase((int)iPreferenceStore.getInt("com.android.ide.eclipse.ddms.adbDebugBasePort"));
                } else if ("com.android.ide.eclipse.ddms.debugSelectedPort".equals(string)) {
                    DdmPreferences.setSelectedDebugPort((int)iPreferenceStore.getInt("com.android.ide.eclipse.ddms.debugSelectedPort"));
                } else if ("com.android.ide.eclipse.ddms.threadStatusInterval".equals(string)) {
                    DdmUiPreferences.setThreadRefreshInterval((int)iPreferenceStore.getInt("com.android.ide.eclipse.ddms.threadStatusInterval"));
                } else if ("com.android.ide.eclipse.ddms.logLevel".equals(string)) {
                    DdmPreferences.setLogLevel((String)iPreferenceStore.getString("com.android.ide.eclipse.ddms.logLevel"));
                } else if ("com.android.ide.eclipse.ddms.timeOut".equals(string)) {
                    DdmPreferences.setTimeOut((int)iPreferenceStore.getInt("com.android.ide.eclipse.ddms.timeOut"));
                } else if ("com.android.ide.eclipse.ddms.useAdbHost".equals(string)) {
                    DdmPreferences.setUseAdbHost((boolean)iPreferenceStore.getBoolean("com.android.ide.eclipse.ddms.useAdbHost"));
                } else if ("com.android.ide.eclipse.ddms.adbHostValue".equals(string)) {
                    DdmPreferences.setAdbHostValue((String)iPreferenceStore.getString("com.android.ide.eclipse.ddms.adbHostValue"));
                }
            }
        });
        PreferenceInitializer.setupPreferences();
        StackTracePanel.setSourceRevealer((StackTracePanel.ISourceRevealer)this);
        final IConfigurationElement[] iConfigurationElementArray = this.findConfigElements("com.android.ide.eclipse.ddms.debuggerConnector");
        this.mHasDebuggerConnectors = iConfigurationElementArray.length > 0;
        new Job(Messages.DdmsPlugin_DDMS_Post_Create_Init){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                try {
                    IToolsLocator[] iToolsLocatorArray;
                    AndroidDebugBridge.init((boolean)true);
                    IConfigurationElement[] iConfigurationElementArray2 = DdmsPlugin.this.findConfigElements("com.android.ide.eclipse.ddms.toolsLocator");
                    IToolsLocator[] iToolsLocatorArray2 = iToolsLocatorArray = DdmsPlugin.this.instantiateToolsLocators(iConfigurationElementArray2);
                    int n = iToolsLocatorArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IToolsLocator iToolsLocator = iToolsLocatorArray2[n2];
                        try {
                            String string = iToolsLocator.getAdbLocation();
                            String string2 = iToolsLocator.getTraceViewLocation();
                            String string3 = iToolsLocator.getHprofConvLocation();
                            if (string != null && string2 != null && string3 != null && DdmsPlugin.setToolsLocation(string, string3, string2)) {
                                AndroidDebugBridge.createBridge((String)sAdbLocation, (boolean)true);
                                break;
                            }
                        }
                        catch (Throwable throwable) {}
                        ++n2;
                    }
                    DdmsPlugin.this.mDebuggerConnectors = DdmsPlugin.this.instantiateDebuggerConnectors(iConfigurationElementArray);
                    iConfigurationElementArray2 = DdmsPlugin.this.findConfigElements("com.android.ide.eclipse.ddms.traceviewLauncher");
                    DdmsPlugin.this.mTraceviewLaunchers = DdmsPlugin.this.instantiateTraceviewLauncher(iConfigurationElementArray2);
                    return Status.OK_STATUS;
                }
                catch (CoreException coreException) {
                    return coreException.getStatus();
                }
            }
        }.schedule();
    }

    private void showConsoleView(MessageConsole messageConsole) {
        ConsolePlugin.getDefault().getConsoleManager().showConsoleView((IConsole)messageConsole);
    }

    IConfigurationElement[] findConfigElements(String string) {
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint iExtensionPoint = iExtensionRegistry.getExtensionPoint(string);
        if (iExtensionPoint != null) {
            return iExtensionPoint.getConfigurationElements();
        }
        return new IConfigurationElement[0];
    }

    private IToolsLocator[] instantiateToolsLocators(IConfigurationElement[] iConfigurationElementArray) throws CoreException {
        IConfigurationElement iConfigurationElement;
        Object object;
        ArrayList<IToolsLocator> arrayList = new ArrayList<IToolsLocator>();
        if (iConfigurationElementArray.length > 0 && (object = (iConfigurationElement = iConfigurationElementArray[0]).createExecutableExtension("class")) instanceof IToolsLocator) {
            arrayList.add((IToolsLocator)object);
        }
        return arrayList.toArray(new IToolsLocator[arrayList.size()]);
    }

    private IDebuggerConnector[] instantiateDebuggerConnectors(IConfigurationElement[] iConfigurationElementArray) throws CoreException {
        IConfigurationElement iConfigurationElement;
        Object object;
        ArrayList<IDebuggerConnector> arrayList = new ArrayList<IDebuggerConnector>();
        if (iConfigurationElementArray.length > 0 && (object = (iConfigurationElement = iConfigurationElementArray[0]).createExecutableExtension("class")) instanceof IDebuggerConnector) {
            arrayList.add((IDebuggerConnector)object);
        }
        return arrayList.toArray(new IDebuggerConnector[arrayList.size()]);
    }

    private ITraceviewLauncher[] instantiateTraceviewLauncher(IConfigurationElement[] iConfigurationElementArray) throws CoreException {
        IConfigurationElement iConfigurationElement;
        Object object;
        ArrayList<ITraceviewLauncher> arrayList = new ArrayList<ITraceviewLauncher>();
        if (iConfigurationElementArray.length > 0 && (object = (iConfigurationElement = iConfigurationElementArray[0]).createExecutableExtension("class")) instanceof ITraceviewLauncher) {
            arrayList.add((ITraceviewLauncher)object);
        }
        return arrayList.toArray(new ITraceviewLauncher[arrayList.size()]);
    }

    private List<IClientAction> instantiateClientSpecificActions(IConfigurationElement[] iConfigurationElementArray) throws CoreException {
        if (iConfigurationElementArray == null || iConfigurationElementArray.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<IClientAction> arrayList = new ArrayList<IClientAction>(1);
        IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray;
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray2[n2];
            Object object = iConfigurationElement.createExecutableExtension("class");
            if (object instanceof IClientAction) {
                arrayList.add((IClientAction)object);
            }
            ++n2;
        }
        return arrayList;
    }

    public static Display getDisplay() {
        IWorkbench iWorkbench = sPlugin.getWorkbench();
        if (iWorkbench != null) {
            return iWorkbench.getDisplay();
        }
        return null;
    }

    public void stop(BundleContext bundleContext) throws Exception {
        AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
        AndroidDebugBridge.terminate();
        this.mRed.dispose();
        sPlugin = null;
        super.stop(bundleContext);
    }

    public static DdmsPlugin getDefault() {
        return sPlugin;
    }

    public static String getAdb() {
        return sAdbLocation;
    }

    public static File getPlatformToolsFolder() {
        return new File(sAdbLocation).getParentFile();
    }

    public static String getToolsFolder() {
        return sToolsFolder;
    }

    public static String getHprofConverter() {
        return sHprofConverter;
    }

    private static boolean setToolsLocation(String string, String string2, String string3) {
        File file = new File(string);
        File file2 = new File(string2);
        File file3 = new File(string3);
        String string4 = "";
        if (!file.isFile()) {
            string4 = String.valueOf(string4) + file.getAbsolutePath() + " ";
        }
        if (!file2.isFile()) {
            string4 = String.valueOf(string4) + file2.getAbsolutePath() + " ";
        }
        if (!file3.isFile()) {
            string4 = String.valueOf(string4) + file3.getAbsolutePath() + " ";
        }
        if (string4.length() > 0) {
            String string5 = String.format("DDMS files not found: %1$s", string4);
            Log.e((String)"DDMS", (String)string5);
            Status status = new Status(4, PLUGIN_ID, string5, null);
            DdmsPlugin.getDefault().getLog().log((IStatus)status);
            return false;
        }
        sAdbLocation = string;
        sHprofConverter = file2.getAbsolutePath();
        DdmUiPreferences.setTraceviewLocation((String)file3.getAbsolutePath());
        sToolsFolder = file3.getParent();
        return true;
    }

    public static void setToolsLocation(String string, boolean bl, String string2, String string3) {
        if (DdmsPlugin.setToolsLocation(string, string2, string3) && bl) {
            new Thread(){

                @Override
                public void run() {
                    try {
                        AndroidDebugBridge.createBridge((String)sAdbLocation, (boolean)false);
                    }
                    catch (Throwable throwable) {
                        Status status = new Status(4, DdmsPlugin.PLUGIN_ID, "Failed to create AndroidDebugBridge", throwable);
                        DdmsPlugin.getDefault().getLog().log((IStatus)status);
                    }
                }
            }.start();
        }
    }

    public boolean hasDebuggerConnectors() {
        return this.mHasDebuggerConnectors;
    }

    public IDebuggerConnector[] getDebuggerConnectors() {
        return this.mDebuggerConnectors;
    }

    public synchronized void addSelectionListener(ISelectionListener iSelectionListener) {
        this.mListeners.add(iSelectionListener);
        iSelectionListener.selectionChanged(this.mCurrentDevice);
        iSelectionListener.selectionChanged(this.mCurrentClient);
    }

    public synchronized void removeSelectionListener(ISelectionListener iSelectionListener) {
        this.mListeners.remove(iSelectionListener);
    }

    public synchronized void setListeningState(boolean bl) {
        this.mListeningToUiSelection = bl;
    }

    public void deviceConnected(IDevice iDevice) {
        if (!this.mListeningToUiSelection && this.mCurrentDevice == null) {
            this.handleDefaultSelection(iDevice);
        }
    }

    public void deviceDisconnected(IDevice iDevice) {
        if (!this.mListeningToUiSelection && this.mCurrentDevice == iDevice) {
            AndroidDebugBridge androidDebugBridge = AndroidDebugBridge.getBridge();
            if (androidDebugBridge != null) {
                IDevice[] iDeviceArray = androidDebugBridge.getDevices();
                if (iDeviceArray.length == 0) {
                    this.handleDefaultSelection((IDevice)null);
                } else {
                    this.handleDefaultSelection(iDeviceArray[0]);
                }
            } else {
                this.handleDefaultSelection((IDevice)null);
            }
        }
    }

    public void deviceChanged(IDevice iDevice, int n) {
        if (!this.mListeningToUiSelection && iDevice == this.mCurrentDevice) {
            if (this.mCurrentClient == null) {
                this.handleDefaultSelection(iDevice);
            } else {
                Client[] clientArray = iDevice.getClients();
                boolean bl = false;
                Client[] clientArray2 = clientArray;
                int n2 = clientArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    Client client = clientArray2[n3];
                    if (client == this.mCurrentClient) {
                        bl = true;
                        break;
                    }
                    ++n3;
                }
                if (!bl) {
                    this.mCurrentClient = null;
                    this.handleDefaultSelection(iDevice);
                }
            }
        }
    }

    public synchronized void selectionChanged(IDevice iDevice, Client client) {
        if (this.mCurrentDevice != iDevice) {
            this.mCurrentDevice = iDevice;
            for (ISelectionListener iSelectionListener : this.mListeners) {
                iSelectionListener.selectionChanged(this.mCurrentDevice);
            }
        }
        if (this.mCurrentClient != client) {
            this.mCurrentClient = client;
            for (ISelectionListener iSelectionListener : this.mListeners) {
                iSelectionListener.selectionChanged(this.mCurrentClient);
            }
        }
    }

    private void handleDefaultSelection(final IDevice iDevice) {
        try {
            Display display = DdmsPlugin.getDisplay();
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    boolean bl = false;
                    if (DdmsPlugin.this.mCurrentDevice != iDevice) {
                        DdmsPlugin.this.mCurrentDevice = iDevice;
                        bl = true;
                        for (Object object : DdmsPlugin.this.mListeners) {
                            object.selectionChanged(DdmsPlugin.this.mCurrentDevice);
                        }
                    }
                    if (iDevice != null) {
                        if (bl || DdmsPlugin.this.mCurrentClient == null) {
                            Object object;
                            object = iDevice.getClients();
                            if (((Client[])object).length > 0) {
                                DdmsPlugin.this.handleDefaultSelection(object[0]);
                            } else {
                                DdmsPlugin.this.handleDefaultSelection(null);
                            }
                        }
                    } else {
                        DdmsPlugin.this.handleDefaultSelection(null);
                    }
                }
            });
        }
        catch (SWTException sWTException) {}
    }

    private void handleDefaultSelection(Client client) {
        this.mCurrentClient = client;
        for (ISelectionListener iSelectionListener : this.mListeners) {
            iSelectionListener.selectionChanged(this.mCurrentClient);
        }
    }

    private static synchronized void printToStream(MessageConsoleStream messageConsoleStream, String string, String string2) {
        String string3 = DdmsPlugin.getMessageTag(string);
        messageConsoleStream.print(string3);
        if (!string3.endsWith(" ")) {
            messageConsoleStream.print(" ");
        }
        messageConsoleStream.println(string2);
    }

    private static String getMessageTag(String string) {
        Calendar calendar = Calendar.getInstance();
        if (string == null) {
            return String.format(Messages.DdmsPlugin_Message_Tag_Mask_1, calendar);
        }
        return String.format(Messages.DdmsPlugin_Message_Tag_Mask_2, calendar, string);
    }

    public void reveal(String string, String string2, int n) {
        JavaSourceRevealer.reveal(string, string2, n);
    }

    public boolean launchTraceview(String string) {
        if (this.mTraceviewLaunchers != null) {
            ITraceviewLauncher[] iTraceviewLauncherArray = this.mTraceviewLaunchers;
            int n = this.mTraceviewLaunchers.length;
            int n2 = 0;
            while (n2 < n) {
                ITraceviewLauncher iTraceviewLauncher = iTraceviewLauncherArray[n2];
                try {
                    if (iTraceviewLauncher.openFile(string)) {
                        return true;
                    }
                }
                catch (Throwable throwable) {}
                ++n2;
            }
        }
        return false;
    }

    @NonNull
    public synchronized List<IClientAction> getClientSpecificActions() {
        if (this.mClientSpecificActions == null) {
            IConfigurationElement[] iConfigurationElementArray = this.findConfigElements("com.android.ide.eclipse.ddms.clientAction");
            try {
                this.mClientSpecificActions = this.instantiateClientSpecificActions(iConfigurationElementArray);
            }
            catch (CoreException coreException) {
                this.mClientSpecificActions = Collections.emptyList();
            }
        }
        return this.mClientSpecificActions;
    }

    public void startLogCatMonitor(IDevice iDevice) {
        if (this.mLogCatMonitor == null) {
            this.mLogCatMonitor = new LogCatMonitor(this.getDebuggerConnectors(), this.getPreferenceStore());
        }
        this.mLogCatMonitor.monitorDevice(iDevice);
    }

    public static ImageDescriptor getImageDescriptor(String string) {
        return DdmsPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)string);
    }

    public static interface ISelectionListener {
        public void selectionChanged(Client var1);

        public void selectionChanged(IDevice var1);
    }
}

