/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.gltrace.state.transforms;

import com.android.ide.eclipse.gltrace.state.GLIntegerProperty;
import com.android.ide.eclipse.gltrace.state.GLStateType;
import com.android.ide.eclipse.gltrace.state.IGLProperty;
import com.android.ide.eclipse.gltrace.state.transforms.GLPropertyAccessor;
import com.android.ide.eclipse.gltrace.state.transforms.IGLPropertyAccessor;
import com.android.ide.eclipse.gltrace.state.transforms.TextureUnitPropertyAccessor;

public class TexturePropertyAccessor
implements IGLPropertyAccessor {
    private final int mContextId;
    private final GLStateType mTargetUnitType;
    private final int mMipmapLevel;
    private final GLStateType mTextureType;
    private TextureUnitPropertyAccessor mTextureUnitPropertyAccessor;

    public TexturePropertyAccessor(int n, GLStateType gLStateType, int n2, GLStateType gLStateType2) {
        this.mContextId = n;
        this.mTargetUnitType = gLStateType;
        this.mMipmapLevel = n2;
        this.mTextureType = gLStateType2;
        this.mTextureUnitPropertyAccessor = new TextureUnitPropertyAccessor(this.mContextId, this.mTargetUnitType);
    }

    public TexturePropertyAccessor(int n, GLStateType gLStateType, GLStateType gLStateType2) {
        this(n, gLStateType, -1, gLStateType2);
    }

    @Override
    public IGLProperty getProperty(IGLProperty iGLProperty) {
        IGLProperty iGLProperty2 = this.mTextureUnitPropertyAccessor.getProperty(iGLProperty);
        if (!(iGLProperty2 instanceof GLIntegerProperty)) {
            return null;
        }
        Integer n = (Integer)iGLProperty2.getValue();
        IGLPropertyAccessor iGLPropertyAccessor = this.mMipmapLevel >= 0 ? GLPropertyAccessor.makeAccessor(this.mContextId, new Object[]{GLStateType.TEXTURE_STATE, GLStateType.TEXTURES, n, GLStateType.TEXTURE_MIPMAPS, this.mMipmapLevel, this.mTextureType}) : GLPropertyAccessor.makeAccessor(this.mContextId, new Object[]{GLStateType.TEXTURE_STATE, GLStateType.TEXTURES, n, this.mTextureType});
        return iGLPropertyAccessor.getProperty(iGLProperty);
    }

    @Override
    public String getPath() {
        return String.format("TEXTURE_STATE/TEXTURES/${activeTexture}/%s", new Object[]{this.mTextureType});
    }
}

