/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkmanager;

import com.android.SdkConstants;
import com.android.annotations.NonNull;
import com.android.io.FileWrapper;
import com.android.io.IAbstractFile;
import com.android.prefs.AndroidLocation;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.SdkManager;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.sdklib.internal.avd.HardwareProperties;
import com.android.sdklib.internal.project.ProjectCreator;
import com.android.sdklib.internal.project.ProjectProperties;
import com.android.sdklib.internal.project.ProjectPropertiesWorkingCopy;
import com.android.sdklib.internal.repository.DownloadCache;
import com.android.sdklib.internal.repository.updater.SdkUpdaterNoWindow;
import com.android.sdklib.repository.SdkAddonConstants;
import com.android.sdklib.repository.SdkRepoConstants;
import com.android.sdkmanager.SdkCommandLine;
import com.android.sdkuilib.internal.widgets.MessageBoxLog;
import com.android.sdkuilib.repository.AvdManagerWindow;
import com.android.sdkuilib.repository.SdkUpdaterWindow;
import com.android.utils.ILogger;
import com.android.utils.IReaderLogger;
import com.android.utils.Pair;
import com.android.xml.AndroidXPathFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.swt.widgets.Display;
import org.xml.sax.InputSource;

public class Main {
    public static final String TOOLSDIR = "com.android.sdkmanager.toolsdir";
    private static final String WORKDIR = "com.android.sdkmanager.workdir";
    private static final int INVALID_TARGET_ID = 0;
    private static final String[] BOOLEAN_YES_REPLIES = new String[]{"yes", "y"};
    private static final String[] BOOLEAN_NO_REPLIES = new String[]{"no", "n"};
    private String mOsSdkFolder;
    private ILogger mSdkLog;
    private SdkManager mSdkManager;
    private SdkCommandLine mSdkCommandLine;
    private File mWorkDir;

    public static void main(String[] args) {
        new Main().run(args);
    }

    void setSdkManager(SdkManager sdkManager) {
        this.mSdkManager = sdkManager;
    }

    private void run(String[] args) {
        this.createLogger();
        this.init();
        this.mSdkCommandLine.parseArgs(args);
        this.parseSdk();
        this.doAction();
    }

    private void createLogger() {
        this.mSdkLog = new IReaderLogger(){

            @Override
            public void error(Throwable t, String errorFormat, Object ... args) {
                if (errorFormat != null) {
                    System.err.printf("Error: " + errorFormat, args);
                    if (!errorFormat.endsWith("\n")) {
                        System.err.printf("\n", new Object[0]);
                    }
                }
                if (t != null) {
                    System.err.printf("Error: %s\n", t.getMessage());
                }
            }

            @Override
            public void warning(@NonNull String warningFormat, Object ... args) {
                if (Main.this.mSdkCommandLine.isVerbose()) {
                    System.out.printf("Warning: " + warningFormat, args);
                    if (!warningFormat.endsWith("\n")) {
                        System.out.printf("\n", new Object[0]);
                    }
                }
            }

            @Override
            public void info(@NonNull String msgFormat, Object ... args) {
                System.out.printf(msgFormat, args);
            }

            @Override
            public void verbose(@NonNull String msgFormat, Object ... args) {
                System.out.printf(msgFormat, args);
            }

            @Override
            public int readLine(byte[] inputBuffer) throws IOException {
                return System.in.read(inputBuffer);
            }
        };
    }

    public void setLogger(ILogger logger) {
        this.mSdkLog = logger;
    }

    private void init() {
        String workDirProp;
        this.mSdkCommandLine = new SdkCommandLine(this.mSdkLog);
        String toolsDirProp = System.getProperty(TOOLSDIR);
        if (toolsDirProp == null) {
            toolsDirProp = System.getenv(TOOLSDIR);
        }
        if (toolsDirProp != null) {
            File tools;
            if (toolsDirProp.length() > 0) {
                tools = new File(toolsDirProp);
                this.mOsSdkFolder = tools.getParent();
            } else {
                try {
                    tools = new File(".").getCanonicalFile();
                    this.mOsSdkFolder = tools.getParent();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        if (this.mOsSdkFolder == null) {
            this.errorAndExit("The tools directory property is not set, please make sure you are executing %1$s", SdkConstants.androidCmdName());
        }
        if ((workDirProp = System.getProperty(WORKDIR)) == null) {
            workDirProp = System.getenv(WORKDIR);
        }
        if (workDirProp != null) {
            this.mWorkDir = new File(workDirProp);
            try {
                this.mWorkDir = this.mWorkDir.getCanonicalFile().getAbsoluteFile();
            }
            catch (IOException e) {
                this.mWorkDir = null;
            }
            if (this.mWorkDir == null || !this.mWorkDir.isDirectory()) {
                this.errorAndExit("The working directory does not seem to be valid: '%1$s", workDirProp);
            }
        }
    }

    private void parseSdk() {
        this.mSdkManager = SdkManager.createManager((String)this.mOsSdkFolder, (ILogger)this.mSdkLog);
        if (this.mSdkManager == null) {
            this.errorAndExit("Unable to parse SDK content.", new Object[0]);
        }
    }

    private void doAction() {
        if (this.mSdkCommandLine.hasClearCache()) {
            DownloadCache d = new DownloadCache(DownloadCache.Strategy.SERVE_CACHE);
            d.clearCache();
            this.mSdkLog.info("SDK Manager repository: manifest cache cleared.\n", new Object[0]);
        }
        String verb = this.mSdkCommandLine.getVerb();
        String directObject = this.mSdkCommandLine.getDirectObject();
        if ("list".equals(verb)) {
            if ("target".equals(directObject)) {
                this.displayTargetList();
            } else if ("avd".equals(directObject)) {
                this.displayAvdList();
            } else if ("sdk".equals(directObject)) {
                this.displayRemoteSdkListNoUI();
            } else {
                this.displayTargetList();
                this.displayAvdList();
            }
        } else if ("create".equals(verb)) {
            if ("avd".equals(directObject)) {
                this.createAvd();
            } else if ("project".equals(directObject)) {
                this.createProject(false);
            } else if ("test-project".equals(directObject)) {
                this.createTestProject();
            } else if ("lib-project".equals(directObject)) {
                this.createProject(true);
            } else if ("uitest-project".equals(directObject)) {
                this.createUiTestProject();
            }
        } else if ("update".equals(verb)) {
            if ("avd".equals(directObject)) {
                this.updateAvd();
            } else if ("project".equals(directObject)) {
                this.updateProject(false);
            } else if ("test-project".equals(directObject)) {
                this.updateTestProject();
            } else if ("lib-project".equals(directObject)) {
                this.updateProject(true);
            } else if ("sdk".equals(directObject)) {
                if (this.mSdkCommandLine.getFlagNoUI(verb)) {
                    this.updateSdkNoUI();
                } else {
                    this.showSdkManagerWindow();
                }
            } else if ("adb".equals(directObject)) {
                this.updateAdb();
            }
        } else if ("sdk".equals(verb)) {
            this.showSdkManagerWindow();
        } else if ("avd".equals(verb)) {
            this.showAvdManagerWindow();
        } else if ("delete".equals(verb) && "avd".equals(directObject)) {
            this.deleteAvd();
        } else if ("move".equals(verb) && "avd".equals(directObject)) {
            this.moveAvd();
        } else if (verb == null && directObject == null) {
            this.showSdkManagerWindow();
        } else {
            this.mSdkCommandLine.printHelpAndExit(null, new Object[0]);
        }
    }

    private void showSdkManagerWindow() {
        try {
            MessageBoxLog errorLogger = new MessageBoxLog("SDK Manager", Display.getCurrent(), true);
            SdkUpdaterWindow window = new SdkUpdaterWindow(null, errorLogger, this.mOsSdkFolder, SdkUpdaterWindow.SdkInvocationContext.STANDALONE);
            window.open();
            errorLogger.displayResult(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void showAvdManagerWindow() {
        try {
            MessageBoxLog errorLogger = new MessageBoxLog("AVD Manager", Display.getCurrent(), true);
            AvdManagerWindow window = new AvdManagerWindow(null, errorLogger, this.mOsSdkFolder, AvdManagerWindow.AvdInvocationContext.STANDALONE);
            window.open();
            errorLogger.displayResult(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void displayRemoteSdkListNoUI() {
        boolean force = this.mSdkCommandLine.getFlagForce();
        boolean useHttp = this.mSdkCommandLine.getFlagNoHttps();
        boolean all = this.mSdkCommandLine.getFlagAll();
        boolean extended = this.mSdkCommandLine.getFlagExtended();
        String proxyHost = this.mSdkCommandLine.getParamProxyHost();
        String proxyPort = this.mSdkCommandLine.getParamProxyPort();
        boolean obsolete = this.mSdkCommandLine.getFlagObsolete();
        SdkUpdaterNoWindow upd = new SdkUpdaterNoWindow(this.mOsSdkFolder, this.mSdkManager, this.mSdkLog, force, useHttp, proxyHost, proxyPort);
        upd.listRemotePackages(all |= obsolete, extended);
        if (obsolete) {
            this.mSdkLog.info("Note: Flag --obsolete is deprecated and will be removed in the next version.\n      Please use --all instead.\n", new Object[0]);
        }
    }

    private void updateSdkNoUI() {
        boolean force = this.mSdkCommandLine.getFlagForce();
        boolean useHttp = this.mSdkCommandLine.getFlagNoHttps();
        boolean dryMode = this.mSdkCommandLine.getFlagDryMode();
        boolean all = this.mSdkCommandLine.getFlagAll();
        String proxyHost = this.mSdkCommandLine.getParamProxyHost();
        String proxyPort = this.mSdkCommandLine.getParamProxyPort();
        String acceptLicense = null;
        boolean obsolete = this.mSdkCommandLine.getFlagObsolete();
        all |= obsolete;
        Pair<String, ArrayList<String>> filterResult = this.checkFilterValues(this.mSdkCommandLine.getParamFilter());
        if (filterResult.getFirst() != null) {
            this.errorAndExit(filterResult.getFirst(), new Object[0]);
        }
        SdkUpdaterNoWindow upd = new SdkUpdaterNoWindow(this.mOsSdkFolder, this.mSdkManager, this.mSdkLog, force, useHttp, proxyHost, proxyPort);
        upd.updateAll(filterResult.getSecond(), all, dryMode, acceptLicense);
        if (obsolete) {
            this.mSdkLog.info("Note: Flag --obsolete is deprecated and will be removed in the next version.\n      Please use --all instead.\n", new Object[0]);
        }
    }

    Pair<String, ArrayList<String>> checkFilterValues(String filter) {
        ArrayList<String> pkgFilter = new ArrayList<String>();
        if (filter != null && filter.length() > 0) {
            TreeSet<String> filterTypes = new TreeSet<String>();
            filterTypes.addAll(Arrays.asList(SdkRepoConstants.NODES));
            filterTypes.addAll(Arrays.asList(SdkAddonConstants.NODES));
            for (String t : filter.split(",")) {
                if (t == null || (t = t.trim()).length() <= 0) continue;
                if (t.indexOf(45) > 0 || t.equals("tools") || t.equals("platform-tools")) {
                    pkgFilter.add(t);
                    continue;
                }
                if (t.replaceAll("[0-9]+", "").length() == 0) {
                    pkgFilter.add(t);
                    continue;
                }
                if (filterTypes.contains(t)) {
                    pkgFilter.add(t);
                    continue;
                }
                return Pair.of(String.format("Unknown package filter type '%1$s'.\nAccepted values are: %2$s", t, Arrays.toString(filterTypes.toArray())), null);
            }
        }
        return Pair.of(null, pkgFilter);
    }

    private ProjectCreator getProjectCreator() {
        ProjectCreator creator = new ProjectCreator(this.mSdkManager, this.mOsSdkFolder, this.mSdkCommandLine.isVerbose() ? ProjectCreator.OutputLevel.VERBOSE : (this.mSdkCommandLine.isSilent() ? ProjectCreator.OutputLevel.SILENT : ProjectCreator.OutputLevel.NORMAL), this.mSdkLog);
        return creator;
    }

    private void createProject(boolean library) {
        String directObject = library ? "lib-project" : "project";
        int targetId = this.resolveTargetName(this.mSdkCommandLine.getParamTargetId());
        IAndroidTarget[] targets = this.mSdkManager.getTargets();
        if (targetId == 0 || targetId > targets.length) {
            this.errorAndExit("Target id is not valid. Use '%s list targets' to get the target ids.", SdkConstants.androidCmdName());
        }
        IAndroidTarget target = targets[targetId - 1];
        ProjectCreator creator = this.getProjectCreator();
        String projectDir = this.getProjectLocation(this.mSdkCommandLine.getParamLocationPath());
        String projectName = this.mSdkCommandLine.getParamName();
        String packageName = this.mSdkCommandLine.getParamProjectPackage(directObject);
        String activityName = null;
        if (!library) {
            activityName = this.mSdkCommandLine.getParamProjectActivity();
        }
        if (projectName != null && !ProjectCreator.RE_PROJECT_NAME.matcher(projectName).matches()) {
            this.errorAndExit("Project name '%1$s' contains invalid characters.\nAllowed characters are: %2$s", projectName, "a-z A-Z 0-9 _");
            return;
        }
        if (activityName != null && !ProjectCreator.RE_ACTIVITY_NAME.matcher(activityName).matches()) {
            this.errorAndExit("Activity name '%1$s' contains invalid characters.\nAllowed characters are: %2$s", activityName, "a-z A-Z 0-9 _");
            return;
        }
        if (packageName != null && !ProjectCreator.RE_PACKAGE_NAME.matcher(packageName).matches()) {
            this.errorAndExit("Package name '%1$s' contains invalid characters.\nA package name must be constitued of two Java identifiers.\nEach identifier allowed characters are: %2$s", packageName, "a-z A-Z 0-9 _");
            return;
        }
        if (this.mSdkCommandLine.getParamGradle()) {
            String gradleVersion = this.mSdkCommandLine.getParamGradleVersion();
            if (gradleVersion == null) {
                this.errorAndExit("Using the gradle template requires specifying the Gradle Android plugin version.", new Object[0]);
                return;
            }
            creator.createGradleProject(projectDir, projectName, packageName, activityName, target, library, gradleVersion);
        } else {
            creator.createProject(projectDir, projectName, packageName, activityName, target, library, null);
        }
    }

    private void createTestProject() {
        String activityName;
        String packageName;
        String projectDir = this.getProjectLocation(this.mSdkCommandLine.getParamLocationPath());
        String pathToMainProject = this.mSdkCommandLine.getParamTestProjectMain();
        File parentProject = new File(pathToMainProject);
        if (!parentProject.isAbsolute()) {
            try {
                parentProject = new File(projectDir, pathToMainProject).getCanonicalFile();
            }
            catch (IOException e) {
                this.errorAndExit("Unable to resolve Main project's directory: %1$s", pathToMainProject);
                return;
            }
        }
        if (!parentProject.isDirectory()) {
            this.errorAndExit("Main project's directory does not exist: %1$s", pathToMainProject);
            return;
        }
        File manifest = new File(parentProject, "AndroidManifest.xml");
        if (!manifest.isFile()) {
            this.errorAndExit("No AndroidManifest.xml file found in the main project directory: %1$s", parentProject.getAbsolutePath());
            return;
        }
        XPath xpath = AndroidXPathFactory.newXPath();
        try {
            packageName = xpath.evaluate("/manifest/@package", new InputSource(new FileInputStream(manifest)));
            this.mSdkLog.info("Found main project package: %1$s\n", packageName);
            activityName = xpath.evaluate("/manifest/application/activity[1]/@android:name", new InputSource(new FileInputStream(manifest)));
            if (activityName == null || activityName.length() == 0) {
                activityName = null;
            } else {
                this.mSdkLog.info("Found main project activity: %1$s\n", activityName);
            }
        }
        catch (FileNotFoundException e) {
            this.errorAndExit("No AndroidManifest.xml file found in main project.", new Object[0]);
            return;
        }
        catch (XPathExpressionException e) {
            this.errorAndExit("Unable to parse main project manifest to get information.", new Object[0]);
            return;
        }
        ProjectProperties p = ProjectProperties.load((String)parentProject.getAbsolutePath(), (ProjectProperties.PropertyType)ProjectProperties.PropertyType.PROJECT);
        if (p == null) {
            this.errorAndExit("Unable to load the main project's %1$s", ProjectProperties.PropertyType.PROJECT.getFilename());
            return;
        }
        String targetHash = p.getProperty("target");
        if (targetHash == null) {
            this.errorAndExit("Couldn't find the main project target", new Object[0]);
            return;
        }
        IAndroidTarget target = this.mSdkManager.getTargetFromHashString(targetHash);
        if (target == null) {
            this.errorAndExit("Unable to resolve main project target '%1$s'. You may want to install the platform in your SDK.", targetHash);
            return;
        }
        this.mSdkLog.info("Found main project target: %1$s\n", target.getFullName());
        ProjectCreator creator = this.getProjectCreator();
        String projectName = this.mSdkCommandLine.getParamName();
        if (projectName != null && !ProjectCreator.RE_PROJECT_NAME.matcher(projectName).matches()) {
            this.errorAndExit("Project name '%1$s' contains invalid characters.\nAllowed characters are: %2$s", projectName, "a-z A-Z 0-9 _");
            return;
        }
        creator.createProject(projectDir, projectName, packageName, activityName, target, false, pathToMainProject);
    }

    private void createUiTestProject() {
        String projectName;
        IAndroidTarget target;
        String projectDir = this.getProjectLocation(this.mSdkCommandLine.getParamLocationPath());
        int targetId = this.resolveTargetName(this.mSdkCommandLine.getParamTargetId());
        IAndroidTarget[] targets = this.mSdkManager.getTargets();
        if (targetId == 0 || targetId > targets.length) {
            this.errorAndExit("Target id is not valid. Use '%s list targets' to get the target ids.", SdkConstants.androidCmdName());
        }
        if ((target = targets[targetId - 1]).getVersion().getApiLevel() < 16) {
            this.errorAndExit("UI test projects can only target API 16 and above", new Object[0]);
        }
        if ((projectName = this.mSdkCommandLine.getParamName()) == null) {
            File f = new File(projectDir);
            projectName = f.getName();
        }
        try {
            File srcFolder = new File(projectDir, "src");
            srcFolder.mkdir();
            ProjectPropertiesWorkingCopy localProperties = ProjectProperties.create((String)projectDir, (ProjectProperties.PropertyType)ProjectProperties.PropertyType.LOCAL);
            localProperties.setProperty("sdk.dir", this.mOsSdkFolder);
            localProperties.save();
            ProjectPropertiesWorkingCopy projectProperties = ProjectProperties.create((String)projectDir, (ProjectProperties.PropertyType)ProjectProperties.PropertyType.PROJECT);
            projectProperties.setProperty("target", target.hashString());
            projectProperties.save();
            HashMap<String, String> keywords = new HashMap<String, String>();
            keywords.put("PROJECT_NAME", projectName);
            ProjectCreator creator = this.getProjectCreator();
            creator.installTemplate("uibuild.template", new File(projectDir, "build.xml"), keywords);
        }
        catch (Exception e) {
            this.mSdkLog.error(e, null, new Object[0]);
        }
    }

    private void updateProject(boolean library) {
        IAndroidTarget target = null;
        String targetStr = this.mSdkCommandLine.getParamTargetId();
        if (targetStr != null) {
            IAndroidTarget[] targets = this.mSdkManager.getTargets();
            int targetId = this.resolveTargetName(targetStr);
            if (targetId == 0 || targetId > targets.length) {
                this.errorAndExit("Target id '%1$s' is not valid. Use '%2$s list targets' to get the target ids.", targetStr, SdkConstants.androidCmdName());
            }
            target = targets[targetId - 1];
        }
        ProjectCreator creator = this.getProjectCreator();
        String projectDir = this.getProjectLocation(this.mSdkCommandLine.getParamLocationPath());
        String libraryPath = library ? null : this.mSdkCommandLine.getParamProjectLibrary("project");
        creator.updateProject(projectDir, target, this.mSdkCommandLine.getParamName(), libraryPath);
        if (!library) {
            boolean doSubProjects = this.mSdkCommandLine.getParamSubProject();
            boolean couldHaveDone = false;
            File[] files = new File(projectDir).listFiles();
            if (files != null) {
                for (File dir : files) {
                    if (!dir.isDirectory() || !new File(dir, "AndroidManifest.xml").isFile()) continue;
                    if (doSubProjects) {
                        creator.updateProject(dir.getPath(), target, this.mSdkCommandLine.getParamName(), null);
                        continue;
                    }
                    couldHaveDone = true;
                }
            }
            if (couldHaveDone) {
                this.mSdkLog.info("It seems that there are sub-projects. If you want to update them\nplease use the --%1$s parameter.\n", "subprojects");
            }
        }
    }

    private void updateTestProject() {
        ProjectCreator creator = this.getProjectCreator();
        String projectDir = this.getProjectLocation(this.mSdkCommandLine.getParamLocationPath());
        creator.updateTestProject(projectDir, this.mSdkCommandLine.getParamTestProjectMain(), this.mSdkManager);
    }

    private String getProjectLocation(String newProjectLocation) {
        File projectDir = new File(newProjectLocation);
        if (projectDir.isAbsolute()) {
            return newProjectLocation;
        }
        if (this.mWorkDir == null) {
            return newProjectLocation;
        }
        try {
            projectDir = new File(this.mWorkDir, newProjectLocation).getCanonicalFile();
            return projectDir.getPath();
        }
        catch (IOException e) {
            this.errorAndExit("Failed to combine working directory '%1$s' with project location '%2$s': %3$s", this.mWorkDir.getPath(), newProjectLocation, e.getMessage());
            return null;
        }
    }

    void displayTargetList() {
        if (this.mSdkCommandLine != null && this.mSdkCommandLine.getFlagCompact()) {
            char eol = this.mSdkCommandLine.getFlagEolNull() ? (char)'\u0000' : '\n';
            for (IAndroidTarget target : this.mSdkManager.getTargets()) {
                this.mSdkLog.info("%1$s%2$c", target.hashString(), Character.valueOf(eol));
            }
            return;
        }
        this.mSdkLog.info("Available Android targets:\n", new Object[0]);
        int index = 1;
        for (IAndroidTarget target : this.mSdkManager.getTargets()) {
            this.mSdkLog.info("----------\n", new Object[0]);
            this.mSdkLog.info("id: %1$d or \"%2$s\"\n", index, target.hashString());
            this.mSdkLog.info("     Name: %s\n", target.getName());
            if (target.isPlatform()) {
                this.mSdkLog.info("     Type: Platform\n", new Object[0]);
                this.mSdkLog.info("     API level: %s\n", target.getVersion().getApiString());
                this.mSdkLog.info("     Revision: %d\n", target.getRevision());
            } else {
                this.mSdkLog.info("     Type: Add-On\n", new Object[0]);
                this.mSdkLog.info("     Vendor: %s\n", target.getVendor());
                this.mSdkLog.info("     Revision: %d\n", target.getRevision());
                if (target.getDescription() != null) {
                    this.mSdkLog.info("     Description: %s\n", target.getDescription());
                }
                this.mSdkLog.info("     Based on Android %s (API level %s)\n", target.getVersionName(), target.getVersion().getApiString());
                IAndroidTarget.IOptionalLibrary[] libraries = target.getOptionalLibraries();
                if (libraries != null) {
                    this.mSdkLog.info("     Libraries:\n", new Object[0]);
                    for (IAndroidTarget.IOptionalLibrary library : libraries) {
                        this.mSdkLog.info("      * %1$s (%2$s)\n", library.getName(), library.getJarName());
                        this.mSdkLog.info("          %1$s\n", library.getDescription());
                    }
                }
            }
            this.displaySkinList(target, "     Skins: ");
            this.displayAbiList(target, "     ABIs : ");
            if (target.getUsbVendorId() != 0) {
                this.mSdkLog.info("     Adds USB support for devices (Vendor: 0x%04X)\n", target.getUsbVendorId());
            }
            ++index;
        }
    }

    void displaySkinList(IAndroidTarget target, String message) {
        String[] skins = target.getSkins();
        String defaultSkin = target.getDefaultSkin();
        this.mSdkLog.info(message, new Object[0]);
        if (skins != null) {
            boolean first = true;
            for (String skin : skins) {
                if (!first) {
                    this.mSdkLog.info(", ", new Object[0]);
                } else {
                    first = false;
                }
                this.mSdkLog.info(skin, new Object[0]);
                if (!skin.equals(defaultSkin)) continue;
                this.mSdkLog.info(" (default)", new Object[0]);
            }
            this.mSdkLog.info("\n", new Object[0]);
        } else {
            this.mSdkLog.info("no skins.\n", new Object[0]);
        }
    }

    void displayAbiList(IAndroidTarget target, String message) {
        ISystemImage[] systemImages = target.getSystemImages();
        this.mSdkLog.info(message, new Object[0]);
        if (systemImages.length > 0) {
            boolean first = true;
            for (ISystemImage si : systemImages) {
                if (!first) {
                    this.mSdkLog.info(", ", new Object[0]);
                } else {
                    first = false;
                }
                this.mSdkLog.info(si.getAbiType(), new Object[0]);
            }
            this.mSdkLog.info("\n", new Object[0]);
        } else {
            this.mSdkLog.info("no ABIs.\n", new Object[0]);
        }
    }

    void displayAvdList(AvdManager avdManager) {
        AvdInfo[] avds = avdManager.getValidAvds();
        if (this.mSdkCommandLine != null && this.mSdkCommandLine.getFlagCompact()) {
            char eol = this.mSdkCommandLine.getFlagEolNull() ? (char)'\u0000' : '\n';
            for (int index = 0; index < avds.length; ++index) {
                AvdInfo info = avds[index];
                this.mSdkLog.info("%1$s%2$c", info.getName(), Character.valueOf(eol));
            }
            return;
        }
        this.mSdkLog.info("Available Android Virtual Devices:\n", new Object[0]);
        for (int index = 0; index < avds.length; ++index) {
            String snapshot;
            String sdcard;
            AvdInfo info = avds[index];
            if (index > 0) {
                this.mSdkLog.info("---------\n", new Object[0]);
            }
            this.mSdkLog.info("    Name: %s\n", info.getName());
            this.mSdkLog.info("    Path: %s\n", info.getDataFolderPath());
            IAndroidTarget target = info.getTarget();
            if (target.isPlatform()) {
                this.mSdkLog.info("  Target: %s (API level %s)\n", target.getName(), target.getVersion().getApiString());
            } else {
                this.mSdkLog.info("  Target: %s (%s)\n", target.getName(), target.getVendor());
                this.mSdkLog.info("          Based on Android %s (API level %s)\n", target.getVersionName(), target.getVersion().getApiString());
            }
            this.mSdkLog.info("     ABI: %s\n", info.getAbiType());
            Map properties = info.getProperties();
            if (properties == null) continue;
            String skin = (String)properties.get("skin.name");
            if (skin != null) {
                this.mSdkLog.info("    Skin: %s\n", skin);
            }
            if ((sdcard = (String)properties.get("sdcard.size")) == null) {
                sdcard = (String)properties.get("sdcard.path");
            }
            if (sdcard != null) {
                this.mSdkLog.info("  Sdcard: %s\n", sdcard);
            }
            if ((snapshot = (String)properties.get("snapshot.present")) == null) continue;
            this.mSdkLog.info("Snapshot: %s\n", snapshot);
        }
        AvdInfo[] badAvds = avdManager.getBrokenAvds();
        if (badAvds.length == 0) {
            return;
        }
        this.mSdkLog.info("\nThe following Android Virtual Devices could not be loaded:\n", new Object[0]);
        boolean needSeparator = false;
        for (AvdInfo info : badAvds) {
            if (needSeparator) {
                this.mSdkLog.info("---------\n", new Object[0]);
            }
            this.mSdkLog.info("    Name: %s\n", info.getName() == null ? "--" : info.getName());
            this.mSdkLog.info("    Path: %s\n", info.getDataFolderPath() == null ? "--" : info.getDataFolderPath());
            String error = info.getErrorMessage();
            this.mSdkLog.info("   Error: %s\n", error == null ? "Uknown error" : error);
            needSeparator = true;
        }
    }

    private void displayAvdList() {
        try {
            AvdManager avdManager = AvdManager.getInstance((SdkManager)this.mSdkManager, (ILogger)this.mSdkLog);
            this.displayAvdList(avdManager);
        }
        catch (AndroidLocation.AndroidLocationException e) {
            this.errorAndExit(e.getMessage(), new Object[0]);
        }
    }

    private void createAvd() {
        int targetId = this.resolveTargetName(this.mSdkCommandLine.getParamTargetId());
        IAndroidTarget[] targets = this.mSdkManager.getTargets();
        if (targetId == 0 || targetId > targets.length) {
            this.errorAndExit("Target id is not valid. Use '%s list targets' to get the target ids.", SdkConstants.androidCmdName());
        }
        IAndroidTarget target = targets[targetId - 1];
        try {
            boolean removePrevious = this.mSdkCommandLine.getFlagForce();
            AvdManager avdManager = AvdManager.getInstance((SdkManager)this.mSdkManager, (ILogger)this.mSdkLog);
            String avdName = this.mSdkCommandLine.getParamName();
            if (!AvdManager.RE_AVD_NAME.matcher(avdName).matches()) {
                this.errorAndExit("AVD name '%1$s' contains invalid characters.\nAllowed characters are: %2$s", avdName, "a-z A-Z 0-9 . _ -");
                return;
            }
            AvdInfo info = avdManager.getAvd(avdName, false);
            if (info != null) {
                if (removePrevious) {
                    this.mSdkLog.warning("Android Virtual Device '%s' already exists and will be replaced.", avdName);
                } else {
                    this.errorAndExit("Android Virtual Device '%s' already exists.\nUse --force if you want to replace it.", avdName);
                    return;
                }
            }
            String paramFolderPath = this.mSdkCommandLine.getParamLocationPath();
            File avdFolder = null;
            avdFolder = paramFolderPath != null ? new File(paramFolderPath) : AvdInfo.getDefaultAvdFolder((AvdManager)avdManager, (String)avdName);
            Map skinHardwareConfig = null;
            String skin = this.mSdkCommandLine.getParamSkin();
            if (skin != null && skin.length() == 0) {
                skin = null;
            }
            if (skin != null && target != null) {
                boolean valid = false;
                for (String s : target.getSkins()) {
                    if (!skin.equalsIgnoreCase(s)) continue;
                    skin = s;
                    valid = true;
                    File skinFolder = avdManager.getSkinPath(skin, target);
                    FileWrapper skinHardwareFile = new FileWrapper(skinFolder, "hardware.ini");
                    if (!skinHardwareFile.isFile()) break;
                    skinHardwareConfig = ProjectProperties.parsePropertyFile((IAbstractFile)skinHardwareFile, (ILogger)this.mSdkLog);
                    break;
                }
                if (!valid) {
                    valid = AvdManager.NUMERIC_SKIN_SIZE.matcher(skin).matches();
                }
                if (!valid) {
                    this.displaySkinList(target, "Valid skins: ");
                    this.errorAndExit("'%s' is not a valid skin name or size (NNNxMMM)", skin);
                    return;
                }
            }
            String abiType = this.mSdkCommandLine.getParamAbi();
            if (target != null && (abiType == null || abiType.length() == 0)) {
                ISystemImage[] systemImages = target.getSystemImages();
                if (systemImages != null && systemImages.length == 1) {
                    abiType = systemImages[0].getAbiType();
                    this.mSdkLog.info("Auto-selecting single ABI %1$s\n", abiType);
                } else {
                    this.displayAbiList(target, "Valid ABIs: ");
                    this.errorAndExit("This platform has more than one ABI. Please specify one using --%1$s.", "abi");
                }
            }
            Map<String, String> hardwareConfig = null;
            if (target != null && target.isPlatform()) {
                try {
                    hardwareConfig = this.promptForHardware(target, skinHardwareConfig);
                }
                catch (IOException e) {
                    this.errorAndExit(e.getMessage(), new Object[0]);
                }
            }
            AvdInfo oldAvdInfo = null;
            if (removePrevious) {
                oldAvdInfo = avdManager.getAvd(avdName, false);
            }
            AvdInfo newAvdInfo = avdManager.createAvd(avdFolder, avdName, target, abiType, skin, this.mSdkCommandLine.getParamSdCard(), hardwareConfig, this.mSdkCommandLine.getFlagSnapshot(), removePrevious, false, this.mSdkLog);
        }
        catch (AndroidLocation.AndroidLocationException e) {
            this.errorAndExit(e.getMessage(), new Object[0]);
        }
    }

    private void deleteAvd() {
        try {
            String avdName = this.mSdkCommandLine.getParamName();
            AvdManager avdManager = AvdManager.getInstance((SdkManager)this.mSdkManager, (ILogger)this.mSdkLog);
            AvdInfo info = avdManager.getAvd(avdName, false);
            if (info == null) {
                this.errorAndExit("There is no Android Virtual Device named '%s'.", avdName);
                return;
            }
            avdManager.deleteAvd(info, this.mSdkLog);
        }
        catch (AndroidLocation.AndroidLocationException e) {
            this.errorAndExit(e.getMessage(), new Object[0]);
        }
    }

    private void moveAvd() {
        try {
            String paramFolderPath;
            String avdName = this.mSdkCommandLine.getParamName();
            AvdManager avdManager = AvdManager.getInstance((SdkManager)this.mSdkManager, (ILogger)this.mSdkLog);
            AvdInfo info = avdManager.getAvd(avdName, true);
            if (info == null) {
                this.errorAndExit("There is no valid Android Virtual Device named '%s'.", avdName);
                return;
            }
            String newName = this.mSdkCommandLine.getParamMoveNewName();
            if (newName != null && newName.equals(info.getName())) {
                newName = null;
            }
            if ((paramFolderPath = this.mSdkCommandLine.getParamLocationPath()) != null) {
                try {
                    File f1 = new File(paramFolderPath).getCanonicalFile();
                    File f2 = new File(info.getDataFolderPath()).getCanonicalFile();
                    if (f1.equals(f2)) {
                        paramFolderPath = null;
                    }
                }
                catch (IOException e) {
                    this.errorAndExit(e.getMessage(), new Object[0]);
                    return;
                }
            }
            if (newName == null && paramFolderPath == null) {
                this.mSdkLog.warning("Move operation aborted: same AVD name, same canonical data path", new Object[0]);
                return;
            }
            if (newName != null && paramFolderPath == null) {
                File originalFolder = new File(AndroidLocation.getFolder() + "avd", info.getName() + ".avd");
                if (info.getDataFolderPath() != null && originalFolder.equals(new File(info.getDataFolderPath()))) {
                    try {
                        File f = new File(AndroidLocation.getFolder() + "avd", newName + ".avd");
                        paramFolderPath = f.getCanonicalPath();
                    }
                    catch (IOException e) {
                        this.errorAndExit(e.getMessage(), new Object[0]);
                    }
                }
            }
            if (newName != null) {
                if (avdManager.getAvd(newName, false) != null) {
                    this.errorAndExit("There is already an AVD named '%s'.", newName);
                    return;
                }
                File ini = info.getIniFile();
                if (ini.equals(AvdInfo.getDefaultIniFile((AvdManager)avdManager, (String)newName))) {
                    this.errorAndExit("The AVD file '%s' is in the way.", ini.getCanonicalPath());
                    return;
                }
            }
            if (paramFolderPath != null && new File(paramFolderPath).exists()) {
                this.errorAndExit("There is already a file or directory at '%s'.\nUse --path to specify a different data folder.", paramFolderPath);
            }
            avdManager.moveAvd(info, newName, paramFolderPath, this.mSdkLog);
        }
        catch (AndroidLocation.AndroidLocationException e) {
            this.errorAndExit(e.getMessage(), new Object[0]);
        }
        catch (IOException e) {
            this.errorAndExit(e.getMessage(), new Object[0]);
        }
    }

    private void updateAvd() {
        try {
            String avdName = this.mSdkCommandLine.getParamName();
            AvdManager avdManager = AvdManager.getInstance((SdkManager)this.mSdkManager, (ILogger)this.mSdkLog);
            avdManager.updateAvd(avdName, this.mSdkLog);
        }
        catch (AndroidLocation.AndroidLocationException e) {
            this.errorAndExit(e.getMessage(), new Object[0]);
        }
        catch (IOException e) {
            this.errorAndExit(e.getMessage(), new Object[0]);
        }
    }

    private void updateAdb() {
        try {
            this.mSdkManager.updateAdb();
            this.mSdkLog.info("adb has been updated. You must restart adb with the following commands\n\tadb kill-server\n\tadb start-server\n", new Object[0]);
        }
        catch (AndroidLocation.AndroidLocationException e) {
            this.errorAndExit(e.getMessage(), new Object[0]);
        }
        catch (IOException e) {
            this.errorAndExit(e.getMessage(), new Object[0]);
        }
    }

    private Map<String, String> promptForHardware(IAndroidTarget createTarget, Map<String, String> skinHardwareConfig) throws IOException {
        byte[] readLineBuffer = new byte[256];
        String defaultAnswer = "no";
        this.mSdkLog.info("%s is a basic Android platform.\n", createTarget.getName());
        this.mSdkLog.info("Do you wish to create a custom hardware profile [%s]", defaultAnswer);
        String result = this.readLine(readLineBuffer).trim();
        if (result.length() == 0) {
            result = defaultAnswer;
        }
        if (!this.getBooleanReply(result)) {
            return skinHardwareConfig;
        }
        this.mSdkLog.info("\n", new Object[0]);
        File hardwareDefs = new File(this.mOsSdkFolder + File.separator + SdkConstants.OS_SDK_TOOLS_LIB_FOLDER, "hardware-properties.ini");
        Map hwMap = HardwareProperties.parseHardwareDefinitions((File)hardwareDefs, null);
        HashMap<String, String> map = new HashMap<String, String>();
        HardwareProperties.HardwareProperty[] hwProperties = hwMap.values().toArray(new HardwareProperties.HardwareProperty[hwMap.size()]);
        int i = 0;
        while (i < hwProperties.length) {
            String defaultFromSkin;
            HardwareProperties.HardwareProperty property = hwProperties[i];
            String description = property.getDescription();
            if (description != null) {
                this.mSdkLog.info("%s: %s\n", property.getAbstract(), description);
            } else {
                this.mSdkLog.info("%s\n", property.getAbstract());
            }
            String defaultValue = property.getDefault();
            String string = defaultFromSkin = skinHardwareConfig != null ? skinHardwareConfig.get(property.getName()) : null;
            if (defaultFromSkin != null) {
                this.mSdkLog.info("%s [%s (from skin)]:", property.getName(), defaultFromSkin);
            } else if (defaultValue != null) {
                this.mSdkLog.info("%s [%s]:", property.getName(), defaultValue);
            } else {
                this.mSdkLog.info("%s (%s):", property.getName(), property.getType());
            }
            result = this.readLine(readLineBuffer);
            if (result.length() == 0) {
                if (defaultFromSkin == null && defaultValue == null) continue;
                if (defaultFromSkin != null) {
                    map.put(property.getName(), defaultFromSkin);
                }
                this.mSdkLog.info("\n", new Object[0]);
                ++i;
                continue;
            }
            switch (property.getType()) {
                case BOOLEAN: {
                    try {
                        if (this.getBooleanReply(result)) {
                            map.put(property.getName(), "yes");
                            ++i;
                            break;
                        }
                        map.put(property.getName(), "no");
                        ++i;
                    }
                    catch (IOException e) {
                        this.mSdkLog.info("\n%s\n", e.getMessage());
                    }
                    break;
                }
                case INTEGER: {
                    try {
                        Integer.parseInt(result);
                        map.put(property.getName(), result);
                        ++i;
                    }
                    catch (NumberFormatException e) {
                        this.mSdkLog.info("\n%s\n", e.getMessage());
                    }
                    break;
                }
                case DISKSIZE: {
                    map.put(property.getName(), result);
                    ++i;
                }
            }
            this.mSdkLog.info("\n", new Object[0]);
        }
        return map;
    }

    private String readLine(byte[] buffer) throws IOException {
        int count = System.in.read(buffer);
        if (count == buffer.length && buffer[count - 1] != 10) {
            byte[] tempBuffer = new byte[256];
            String secondHalf = this.readLine(tempBuffer);
            return new String(buffer, 0, count) + secondHalf;
        }
        while (count > 0 && (buffer[count - 1] == 13 || buffer[count - 1] == 10)) {
            --count;
        }
        return new String(buffer, 0, count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String promptPassword(String prompt) throws IOException {
        final AtomicBoolean keepErasing = new AtomicBoolean(true);
        Thread eraser = new Thread(new Runnable(){

            @Override
            public void run() {
                while (keepErasing.get()) {
                    System.err.print("\b ");
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }, "eraser");
        try {
            System.err.print(prompt);
            eraser.start();
            byte[] buffer = new byte[256];
            String string = this.readLine(buffer);
            return string;
        }
        finally {
            keepErasing.set(false);
            try {
                eraser.join();
            }
            catch (InterruptedException e) {}
        }
    }

    private boolean getBooleanReply(String reply) throws IOException {
        for (String valid : BOOLEAN_YES_REPLIES) {
            if (!valid.equalsIgnoreCase(reply)) continue;
            return true;
        }
        for (String valid : BOOLEAN_NO_REPLIES) {
            if (!valid.equalsIgnoreCase(reply)) continue;
            return false;
        }
        throw new IOException(String.format("%s is not a valid reply", reply));
    }

    private void errorAndExit(String format, Object ... args) {
        this.mSdkLog.error(null, format, args);
        System.exit(1);
    }

    private int resolveTargetName(String targetName) {
        if (targetName == null) {
            return 0;
        }
        if ((targetName = targetName.trim()).matches("[0-9]*")) {
            try {
                int n = Integer.parseInt(targetName);
                return n < 1 ? 0 : n;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        IAndroidTarget[] targets = this.mSdkManager.getTargets();
        for (int i = 0; i < targets.length; ++i) {
            if (!targetName.equals(targets[i].hashString())) continue;
            return i + 1;
        }
        return 0;
    }
}

