/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.filter;

import com.vladium.util.WCMatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public interface IInclExclFilter {
    public static final char INCLUSION_PREFIX = '+';
    public static final String INCLUSION_PREFIX_STRING = "+";
    public static final char EXCLUSION_PREFIX = '-';
    public static final String EXCLUSION_PREFIX_STRING = "-";

    public boolean included(String var1);

    public static abstract class Factory {
        public static IInclExclFilter create(String string, String string2, String[] stringArray) {
            if (string == null || string.trim().length() == 0) {
                return Factory.create(stringArray);
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    arrayList.add(stringArray[i]);
                }
            }
            String[] stringArray2 = new StringTokenizer(string, string2);
            while (stringArray2.hasMoreTokens()) {
                arrayList.add(stringArray2.nextToken());
            }
            stringArray2 = new String[arrayList.size()];
            arrayList.toArray(stringArray2);
            return Factory.create(stringArray2);
        }

        public static IInclExclFilter create(String[] stringArray) {
            if (stringArray == null || stringArray.length == 0) {
                return new WCInclExclFilter((String[])null, (String[])null);
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (String string : stringArray) {
                if (string.length() <= 0) continue;
                if (string.charAt(0) == '-') {
                    arrayList2.add(string.substring(1));
                    continue;
                }
                if (string.charAt(0) == '+') {
                    arrayList.add(string.substring(1));
                    continue;
                }
                arrayList.add(string);
            }
            return new WCInclExclFilter(arrayList, arrayList2);
        }

        public static IInclExclFilter create(String[] stringArray, String[] stringArray2) {
            return new WCInclExclFilter(stringArray, stringArray2);
        }

        public static IInclExclFilter create(List list, List list2) {
            return new WCInclExclFilter(list, list2);
        }

        private static final class WCInclExclFilter
        implements IInclExclFilter {
            private final WCMatcher[] m_inclusions;
            private final WCMatcher[] m_exclusions;

            public boolean included(String string) {
                int n;
                int n2;
                if (string == null) {
                    return false;
                }
                char[] cArray = string.toCharArray();
                WCMatcher[] wCMatcherArray = this.m_inclusions;
                WCMatcher[] wCMatcherArray2 = this.m_exclusions;
                if (wCMatcherArray != null) {
                    n2 = 0;
                    int n3 = wCMatcherArray.length;
                    for (n = 0; n < n3; ++n) {
                        if (!wCMatcherArray[n].matches(cArray)) continue;
                        n2 = 1;
                        break;
                    }
                    if (n2 == 0) {
                        return false;
                    }
                }
                if (wCMatcherArray2 != null) {
                    n = wCMatcherArray2.length;
                    for (n2 = 0; n2 < n; ++n2) {
                        if (!wCMatcherArray2[n2].matches(cArray)) continue;
                        return false;
                    }
                }
                return true;
            }

            WCInclExclFilter(String[] stringArray, String[] stringArray2) {
                int n;
                if (stringArray == null || stringArray.length == 0) {
                    this.m_inclusions = null;
                } else {
                    this.m_inclusions = new WCMatcher[stringArray.length];
                    for (n = 0; n < stringArray.length; ++n) {
                        this.m_inclusions[n] = WCMatcher.compile(stringArray[n]);
                    }
                }
                if (stringArray2 == null || stringArray2.length == 0) {
                    this.m_exclusions = null;
                } else {
                    this.m_exclusions = new WCMatcher[stringArray2.length];
                    for (n = 0; n < stringArray2.length; ++n) {
                        this.m_exclusions[n] = WCMatcher.compile(stringArray2[n]);
                    }
                }
            }

            WCInclExclFilter(List list, List list2) {
                int n;
                if (list == null || list.isEmpty()) {
                    this.m_inclusions = null;
                } else {
                    this.m_inclusions = new WCMatcher[list.size()];
                    n = 0;
                    for (String string : list) {
                        this.m_inclusions[n] = WCMatcher.compile(string);
                        ++n;
                    }
                }
                if (list2 == null || list2.isEmpty()) {
                    this.m_exclusions = null;
                } else {
                    this.m_exclusions = new WCMatcher[list2.size()];
                    n = 0;
                    for (String string : list2) {
                        this.m_exclusions[n] = WCMatcher.compile(string);
                        ++n;
                    }
                }
            }
        }
    }
}

