/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast;

import java.util.ArrayList;
import java.util.List;
import lombok.ast.AbstractNode;
import lombok.ast.AstException;
import lombok.ast.AstVisitor;
import lombok.ast.Block;
import lombok.ast.BreakTemplate;
import lombok.ast.Identifier;
import lombok.ast.Node;
import lombok.ast.Statement;

public class Break
extends AbstractNode
implements Statement {
    private AbstractNode label = null;

    @Override
    public Block upToBlock() {
        if (!(this.getParent() instanceof Block)) {
            return null;
        }
        Block out = (Block)this.getParent();
        if (!out.rawContents().contains(this)) {
            return null;
        }
        return out;
    }

    public Identifier astLabel() {
        if (!(this.label instanceof Identifier)) {
            return null;
        }
        return (Identifier)this.label;
    }

    public Break astLabel(Identifier label) {
        return this.rawLabel(label);
    }

    private Break rawLabel(Node label) {
        if (label == this.label) {
            return this;
        }
        if (label != null) {
            this.adopt((AbstractNode)label);
        }
        if (this.label != null) {
            this.disown(this.label);
        }
        this.label = (AbstractNode)label;
        return this;
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        if (this.label != null) {
            result.add(this.label);
        }
        return result;
    }

    @Override
    public boolean replaceChild(Node original, Node replacement) throws AstException {
        if (this.label == original) {
            if (replacement instanceof Identifier) {
                this.astLabel((Identifier)replacement);
                return true;
            }
            throw new AstException(this, String.format("Cannot replace node: replacement must be of type %s but is of type %s", "Identifier", replacement == null ? "null" : replacement.getClass().getName()));
        }
        return false;
    }

    @Override
    public boolean detach(Node child) {
        if (this.label == child) {
            this.disown((AbstractNode)child);
            this.label = null;
            return true;
        }
        return false;
    }

    @Override
    public void accept(AstVisitor visitor) {
        if (visitor.visitBreak(this)) {
            return;
        }
        if (this.label != null) {
            this.label.accept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public Break copy() {
        Break result = new Break();
        if (this.label != null) {
            result.rawLabel(this.label.copy());
        }
        return result;
    }

    public boolean hasLabel() {
        return BreakTemplate.hasLabel(this);
    }
}

