/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.importexport.internal.wizard;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.p2.importexport.IUDetail;
import org.eclipse.equinox.internal.p2.importexport.VersionIncompatibleException;
import org.eclipse.equinox.internal.p2.importexport.internal.Messages;
import org.eclipse.equinox.internal.p2.importexport.internal.wizard.AbstractImportPage;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.dialogs.ISelectableIUsPage;
import org.eclipse.equinox.internal.p2.ui.dialogs.ProvisioningOperationWizard;
import org.eclipse.equinox.internal.p2.ui.viewers.IUColumnConfig;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.query.CompoundQueryable;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.IRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PatternFilter;

public class ImportPage
extends AbstractImportPage
implements ISelectableIUsPage {
    private List<IUDetail> features;
    private final List<URI> loadRepos = new ArrayList<URI>();
    private final Map<IUDetail, IUDetail[]> newProposedFeature = new HashMap<IUDetail, IUDetail[]>();
    private Button contactAll;
    private Button installLatest;
    private String oldDestination;
    static /* synthetic */ Class class$0;

    public ImportPage(ProvisioningUI ui, ProvisioningOperationWizard wizard) {
        super("importpage", ui, wizard);
        this.setTitle(Messages.ImportPage_TITLE);
        this.setDescription(Messages.ImportPage_DESCRIPTION);
    }

    protected void createContents(Composite composite) {
        this.createDestinationGroup(composite);
        this.createInstallationTable(composite);
        this.createAdditionOptions(composite);
    }

    private void createAdditionOptions(Composite parent) {
        Composite composite = new Composite(parent, 2048);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.contactAll = new Button(composite, 32);
        this.contactAll.setText(ProvUIMessages.AvailableIUsPage_ResolveAllCheckbox);
        this.installLatest = new Button(composite, 32);
        this.installLatest.setText(Messages.ImportPage_InstallLatestVersion);
        this.installLatest.setSelection(true);
    }

    protected ITreeContentProvider getContentProvider() {
        return new InstallationContentProvider();
    }

    protected ITableLabelProvider getLabelProvider() {
        return new InstallationLabelProvider();
    }

    protected int getBrowseDialogStyle() {
        return 4096;
    }

    protected String getDestinationLabel() {
        return Messages.ImportPage_DESTINATION_LABEL;
    }

    protected String getDialogTitle() {
        return Messages.ImportPage_FILEDIALOG_TITLE;
    }

    protected IUDetail[] getInput() {
        return new IUDetail[0];
    }

    protected String getInvalidDestinationMessage() {
        return Messages.ImportPage_DEST_ERROR;
    }

    protected void giveFocusToDestination() {
        this.destinationNameField.setFocus();
    }

    protected void updatePageCompletion() {
        super.updatePageCompletion();
        if (this.isPageComplete()) {
            this.getProvisioningWizard().operationSelectionsChanged((ISelectableIUsPage)this);
        }
    }

    protected void handleDestinationChanged(String newDestination) {
        if (this.validateDestinationGroup()) {
            if (!newDestination.equals(this.oldDestination)) {
                this.loadRepos.clear();
                this.newProposedFeature.clear();
            }
            BufferedInputStream input = null;
            try {
                input = new BufferedInputStream(new FileInputStream(this.getDestinationValue()));
                this.features = this.importexportService.importP2F(input);
                this.viewer.setInput((Object)this.features.toArray(new IUDetail[this.features.size()]));
                ((InputStream)input).close();
            }
            catch (VersionIncompatibleException e) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.ImportPage_TITLE, (String)e.getMessage());
            }
            catch (FileNotFoundException fileNotFoundException) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.ImportPage_TITLE, (String)Messages.ImportPage_FILENOTFOUND);
            }
            catch (IOException e) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.ImportPage_TITLE, (String)e.getLocalizedMessage());
            }
        } else {
            this.viewer.setInput(null);
        }
    }

    protected void setDestinationValue(String selectedFileName) {
        this.oldDestination = this.getDestinationValue();
        super.setDestinationValue(selectedFileName);
    }

    protected boolean validDestination() {
        File target = new File(this.getDestinationValue());
        return super.validDestination() && target.exists() && target.canRead();
    }

    public Object[] getCheckedIUElements() {
        Object[] checked = this.viewer.getCheckedElements();
        ArrayList<IUDetail> checkedFeatures = new ArrayList<IUDetail>(checked.length);
        int i = 0;
        while (i < checked.length) {
            IUDetail feature = (IUDetail)checked[i];
            IUDetail[] existingFeatures = this.newProposedFeature.get(feature);
            if (existingFeatures == null) {
                checkedFeatures.add(feature);
            } else {
                IUDetail matchPolicy = null;
                IUDetail[] iUDetailArray = existingFeatures;
                int n = existingFeatures.length;
                int n2 = 0;
                while (n2 < n) {
                    IUDetail f = iUDetailArray[n2];
                    if (matchPolicy == null) {
                        matchPolicy = f;
                    } else if (matchPolicy.getIU().getVersion().compareTo((Object)f.getIU().getVersion()) < 0) {
                        if (this.installLatest.getSelection()) {
                            matchPolicy = f;
                        }
                    } else {
                        matchPolicy = f;
                    }
                    ++n2;
                }
                if (matchPolicy != null) {
                    checkedFeatures.add(matchPolicy);
                }
            }
            ++i;
        }
        return checkedFeatures.toArray(new IUDetail[checkedFeatures.size()]);
    }

    public Object[] getSelectedIUElements() {
        return null;
    }

    public void setCheckedElements(Object[] elements) {
        new UnsupportedOperationException();
    }

    public ProvisioningContext getProvisioningContext() {
        if (agent != null) {
            Object[] checked = this.viewer.getCheckedElements();
            ArrayList<URI> referredRepos = new ArrayList<URI>(checked.length);
            Object[] objectArray = checked;
            int n = checked.length;
            int n2 = 0;
            while (n2 < n) {
                Object checkItem = objectArray[n2];
                IUDetail feature = (IUDetail)checkItem;
                Iterator<URI> iterator = feature.getReferencedRepositories().iterator();
                while (iterator.hasNext()) {
                    URI uri = iterator.next();
                    referredRepos.add(uri);
                }
                ++n2;
            }
            ProvisioningContext context = new ProvisioningContext(agent);
            if (!this.contactAll.getSelection()) {
                context.setArtifactRepositories(referredRepos.toArray(new URI[referredRepos.size()]));
                context.setMetadataRepositories(referredRepos.toArray(new URI[referredRepos.size()]));
            }
            return context;
        }
        return null;
    }

    public boolean hasUnloadedRepo() {
        Object[] objectArray = this.viewer.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object checked = objectArray[n2];
            IUDetail feature = (IUDetail)checked;
            Iterator<URI> iterator = feature.getReferencedRepositories().iterator();
            while (iterator.hasNext()) {
                URI uri = iterator.next();
                if (this.loadRepos.contains(uri)) continue;
                return true;
            }
            ++n2;
        }
        return false;
    }

    public Object[] getChecked() {
        if (Display.findDisplay((Thread)Thread.currentThread()) != null) {
            return this.viewer.getCheckedElements();
        }
        GetCheckedElement get = new GetCheckedElement();
        Display.getDefault().syncExec((Runnable)get);
        return get.checkedElements;
    }

    public void recompute(IProgressMonitor monitor) throws InterruptedException {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ImportPage_QueryFeaturesJob, (int)1000);
        if (agent != null) {
            IMetadataRepositoryManager metaManager = (IMetadataRepositoryManager)agent.getService(IMetadataRepositoryManager.SERVICE_NAME);
            IArtifactRepositoryManager artifactManager = (IArtifactRepositoryManager)agent.getService(IArtifactRepositoryManager.SERVICE_NAME);
            Object[] checked = this.getChecked();
            sub.setWorkRemaining(100 * checked.length);
            Object[] objectArray = checked;
            int n = checked.length;
            int n2 = 0;
            while (n2 < n) {
                Object item = objectArray[n2];
                IUDetail feature = (IUDetail)item;
                if (!this.newProposedFeature.containsKey(feature)) {
                    if (sub.isCanceled()) {
                        throw new InterruptedException();
                    }
                    SubMonitor sub2 = sub.newChild(100, 7);
                    sub2.setWorkRemaining(feature.getReferencedRepositories().size() * 500 + 100);
                    ArrayList<IMetadataRepository> repos = new ArrayList<IMetadataRepository>();
                    Iterator<URI> iterator = feature.getReferencedRepositories().iterator();
                    while (iterator.hasNext()) {
                        URI uri = iterator.next();
                        if (!metaManager.contains(uri)) {
                            metaManager.addRepository(uri);
                        }
                        metaManager.setEnabled(uri, true);
                        try {
                            repos.add(metaManager.loadRepository(uri, (IProgressMonitor)sub2.newChild(500)));
                        }
                        catch (ProvisionException e) {
                            e.printStackTrace();
                        }
                        catch (OperationCanceledException e) {
                            throw new InterruptedException(e.getLocalizedMessage());
                        }
                        if (!artifactManager.contains(uri)) {
                            artifactManager.addRepository(uri);
                        }
                        artifactManager.setEnabled(uri, true);
                    }
                    if (sub2.isCanceled()) {
                        throw new InterruptedException();
                    }
                    Set result = new CompoundQueryable((IQueryable[])repos.toArray(new IRepository[repos.size()])).query(QueryUtil.createIUQuery((String)feature.getIU().getId(), (VersionRange)new VersionRange(feature.getIU().getVersion(), true, null, false)), (IProgressMonitor)sub2.newChild(100)).toSet();
                    ArrayList<IUDetail> existingFeatures = new ArrayList<IUDetail>(result.size());
                    Iterator iterator2 = result.iterator();
                    while (iterator2.hasNext()) {
                        IInstallableUnit iu = (IInstallableUnit)iterator2.next();
                        existingFeatures.add(new IUDetail(iu, feature.getReferencedRepositories()));
                    }
                    this.newProposedFeature.put(feature, existingFeatures.toArray(new IUDetail[existingFeatures.size()]));
                } else {
                    if (sub.isCanceled()) {
                        throw new InterruptedException();
                    }
                    sub.worked(100);
                }
                ++n2;
            }
        }
    }

    protected PatternFilter getPatternFilter() {
        return new P2ImportIUPatternFilter(this.getColumnConfig());
    }

    class GetCheckedElement
    implements Runnable {
        Object[] checkedElements = null;

        GetCheckedElement() {
        }

        public void run() {
            this.checkedElements = ImportPage.this.viewer.getCheckedElements();
        }
    }

    class InstallationContentProvider
    implements ITreeContentProvider {
        InstallationContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            return (Object[])inputElement;
        }

        public void inputChanged(Viewer viewer1, Object oldInput, Object newInput) {
        }

        public Object[] getChildren(Object parentElement) {
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }
    }

    class InstallationLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    IColorProvider {
        InstallationLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            IInstallableUnit iu = ((IUDetail)element).getIU();
            switch (columnIndex) {
                case 0: {
                    return ImportPage.this.getIUNameWithDetail(iu);
                }
                case 1: {
                    return iu.getVersion().toString();
                }
                case 2: {
                    return iu.getId();
                }
            }
            throw new RuntimeException("Should not happen");
        }

        public Color getForeground(Object element) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.equinox.p2.metadata.IInstallableUnit");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (ImportPage.this.hasInstalled((IInstallableUnit)ProvUI.getAdapter((Object)element, (Class)clazz))) {
                return Display.getDefault().getSystemColor(15);
            }
            return null;
        }

        public Color getBackground(Object element) {
            return null;
        }
    }

    class P2ImportIUPatternFilter
    extends PatternFilter {
        boolean checkName;
        boolean checkVersion;
        boolean checkId = false;
        String patternString;

        public P2ImportIUPatternFilter(IUColumnConfig[] columnConfig) {
            int i = 0;
            while (i < columnConfig.length) {
                int field = columnConfig[i].getColumnType();
                if (field == 0) {
                    this.checkId = true;
                } else if (field == 1) {
                    this.checkName = true;
                } else if (field == 2) {
                    this.checkVersion = true;
                }
                ++i;
            }
        }

        public boolean isElementSelectable(Object element) {
            return element instanceof IUDetail;
        }

        public void setPattern(String patternString) {
            super.setPattern(patternString);
            this.patternString = patternString;
        }

        protected boolean isParentMatch(Viewer viewer1, Object element) {
            if (this.patternString == null || this.patternString.length() == 0) {
                return true;
            }
            return super.isParentMatch(viewer1, element);
        }

        protected boolean isLeafMatch(Viewer viewer1, Object element) {
            String text = null;
            if (element instanceof IUDetail) {
                IInstallableUnit iu = ((IUDetail)element).getIU();
                if (this.checkName && (text = iu.getProperty("org.eclipse.equinox.p2.name", null)) != null && this.wordMatches(text)) {
                    return true;
                }
                if ((this.checkId || this.checkName && text == null) && this.wordMatches(text = iu.getId())) {
                    return true;
                }
                if (this.checkVersion && this.wordMatches(text = iu.getVersion().toString())) {
                    return true;
                }
            }
            return false;
        }
    }
}

