/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.resources.ResourceType;

public class ResourceUrl {
    @NonNull
    public final ResourceType type;
    @NonNull
    public final String name;
    public final boolean framework;
    public final boolean create;
    public boolean theme;

    private ResourceUrl(@NonNull ResourceType type, @NonNull String name, boolean framework, boolean create) {
        this.type = type;
        this.name = name;
        this.framework = framework;
        this.create = create;
    }

    public static ResourceUrl create(@NonNull ResourceType type, @NonNull String name, boolean framework, boolean create) {
        return new ResourceUrl(type, name, framework, create);
    }

    @Nullable
    public static ResourceUrl parse(@NonNull String url) {
        String typeName;
        ResourceType type;
        if (url.startsWith("?")) {
            String remainder = url.substring("?".length());
            if (url.startsWith("?attr/")) {
                url = "@" + url.substring("?".length());
                return ResourceUrl.setTheme(ResourceUrl.parse(url));
            }
            int colon = url.indexOf(58);
            if (colon != -1) {
                if (remainder.indexOf(47, colon) == -1) {
                    remainder = remainder.substring(0, colon) + "attr" + '/' + remainder.substring(colon);
                }
                url = "@" + remainder;
                return ResourceUrl.setTheme(ResourceUrl.parse(url));
            }
            int slash = url.indexOf(47);
            if (slash == -1) {
                url = "@attr/" + remainder;
                return ResourceUrl.setTheme(ResourceUrl.parse(url));
            }
        }
        if (!url.startsWith("@") || url.equals("@null")) {
            return null;
        }
        int typeEnd = url.indexOf(47, 1);
        if (typeEnd == -1) {
            return null;
        }
        int nameBegin = typeEnd + 1;
        boolean create = url.startsWith("@+");
        int typeBegin = create ? 2 : 1;
        int colon = url.lastIndexOf(58, typeEnd);
        boolean framework = false;
        if (colon != -1) {
            if (url.startsWith("android", typeBegin)) {
                framework = true;
            }
            typeBegin = colon + 1;
        }
        if ((type = ResourceType.getEnum(typeName = url.substring(typeBegin, typeEnd))) == null) {
            return null;
        }
        String name = url.substring(nameBegin);
        return new ResourceUrl(type, name, framework, create);
    }

    @Nullable
    private static ResourceUrl setTheme(@Nullable ResourceUrl url) {
        if (url != null) {
            url.theme = true;
        }
        return url;
    }

    public boolean hasValidName() {
        if (this.name.isEmpty()) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(this.name.charAt(0))) {
            return false;
        }
        int n = this.name.length();
        for (int i = 1; i < n; ++i) {
            char c = this.name.charAt(i);
            if (Character.isJavaIdentifierPart(c) || c == '.') continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.theme ? "?" : "@");
        if (this.create) {
            sb.append('+');
        }
        if (this.framework) {
            sb.append("android");
            sb.append(':');
        }
        sb.append(this.type.getName());
        sb.append('/');
        sb.append(this.name);
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceUrl that = (ResourceUrl)o;
        if (this.create != that.create) {
            return false;
        }
        if (this.framework != that.framework) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        return this.type == that.type;
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + (this.framework ? 1 : 0);
        result = 31 * result + (this.create ? 1 : 0);
        return result;
    }
}

