/*
 * Decompiled with CFR 0.152.
 */
package com.android.manifmerger;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.manifmerger.IMergerLog;
import com.android.utils.ILogger;

public abstract class MergerLog {
    public static IMergerLog wrapSdkLog(final @NonNull ILogger sdkLog) {
        return new IMergerLog(){

            @Override
            public void error(@NonNull IMergerLog.Severity severity, @NonNull IMergerLog.FileAndLine location, @NonNull String message, Object ... msgParams) {
                switch (severity) {
                    case INFO: {
                        sdkLog.info("[%1$s] %2$s", location, String.format(message, msgParams));
                        break;
                    }
                    case WARNING: {
                        sdkLog.warning("[%1$s] %2$s", location, String.format(message, msgParams));
                        break;
                    }
                    case ERROR: {
                        sdkLog.error(null, "[%1$s] %2$s", location, String.format(message, msgParams));
                    }
                }
            }

            @Override
            public void conflict(@NonNull IMergerLog.Severity severity, @NonNull IMergerLog.FileAndLine location1, @NonNull IMergerLog.FileAndLine location2, @NonNull String message, Object ... msgParams) {
                switch (severity) {
                    case INFO: {
                        sdkLog.info("[%1$s, %2$s] %3$s", location1, location2, String.format(message, msgParams));
                        break;
                    }
                    case WARNING: {
                        sdkLog.warning("[%1$s, %2$s] %3$s", location1, location2, String.format(message, msgParams));
                        break;
                    }
                    case ERROR: {
                        sdkLog.error(null, "[%1$s, %2$s] %3$s", location1, location2, String.format(message, msgParams));
                    }
                }
            }
        };
    }

    public static IMergerLog mergerLogOverrideLocation(final @NonNull IMergerLog parentLog, final @Nullable String filePath1, final String ... filePath2) {
        return new IMergerLog(){

            @Override
            public void error(@NonNull IMergerLog.Severity severity, @NonNull IMergerLog.FileAndLine location, @NonNull String message, Object ... msgParams) {
                if (filePath1 != null) {
                    location = new IMergerLog.FileAndLine(filePath1, location.getLine());
                }
                parentLog.error(severity, location, message, msgParams);
            }

            @Override
            public void conflict(@NonNull IMergerLog.Severity severity, @NonNull IMergerLog.FileAndLine location1, @NonNull IMergerLog.FileAndLine location2, @NonNull String message, Object ... msgParams) {
                if (filePath1 != null) {
                    location1 = new IMergerLog.FileAndLine(filePath1, location1.getLine());
                }
                if (filePath2 != null && filePath2.length > 0) {
                    location2 = new IMergerLog.FileAndLine(filePath2[0], location2.getLine());
                }
                parentLog.conflict(severity, location1, location2, message, msgParams);
            }
        };
    }
}

