/*
 * Decompiled with CFR 0.152.
 */
package com.android.draw9patch.ui;

import com.android.draw9patch.graphics.GraphicsUtilities;
import com.android.draw9patch.ui.Pair;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;

public class PatchInfo {
    public static final int BLACK_TICK = -16777216;
    public static final int RED_TICK = -65536;
    public final List<Rectangle> patches;
    public final List<Rectangle> fixed;
    public final List<Rectangle> horizontalPatches;
    public final List<Rectangle> verticalPatches;
    public final List<Pair<Integer>> horizontalPatchMarkers;
    public final List<Pair<Integer>> horizontalPaddingMarkers;
    public final List<Pair<Integer>> verticalPatchMarkers;
    public final List<Pair<Integer>> verticalPaddingMarkers;
    public final boolean verticalStartWithPatch;
    public final boolean horizontalStartWithPatch;
    public final Pair<Integer> horizontalPadding;
    public final Pair<Integer> verticalPadding;
    private BufferedImage image;

    public PatchInfo(BufferedImage image) {
        this.image = image;
        int width = image.getWidth();
        int height = image.getHeight();
        int[] row = GraphicsUtilities.getPixels(image, 0, 0, width, 1, null);
        int[] column = GraphicsUtilities.getPixels(image, 0, 0, 1, height, null);
        P left = PatchInfo.getPatches(column);
        this.verticalStartWithPatch = left.startsWithPatch;
        this.verticalPatchMarkers = left.patches;
        P top = PatchInfo.getPatches(row);
        this.horizontalStartWithPatch = top.startsWithPatch;
        this.horizontalPatchMarkers = top.patches;
        this.fixed = this.getRectangles(left.fixed, top.fixed);
        this.patches = this.getRectangles(left.patches, top.patches);
        if (!this.fixed.isEmpty()) {
            this.horizontalPatches = this.getRectangles(left.fixed, top.patches);
            this.verticalPatches = this.getRectangles(left.patches, top.fixed);
        } else if (!top.fixed.isEmpty()) {
            this.horizontalPatches = new ArrayList<Rectangle>(0);
            this.verticalPatches = this.getVerticalRectangles(top.fixed);
        } else if (!left.fixed.isEmpty()) {
            this.horizontalPatches = this.getHorizontalRectangles(left.fixed);
            this.verticalPatches = new ArrayList<Rectangle>(0);
        } else {
            this.verticalPatches = new ArrayList<Rectangle>(0);
            this.horizontalPatches = this.verticalPatches;
        }
        row = GraphicsUtilities.getPixels(image, 0, height - 1, width, 1, row);
        column = GraphicsUtilities.getPixels(image, width - 1, 0, 1, height, column);
        top = PatchInfo.getPatches(row);
        this.horizontalPaddingMarkers = top.patches;
        this.horizontalPadding = this.getPadding(top.fixed);
        left = PatchInfo.getPatches(column);
        this.verticalPaddingMarkers = left.patches;
        this.verticalPadding = this.getPadding(left.fixed);
    }

    private List<Rectangle> getVerticalRectangles(List<Pair<Integer>> topPairs) {
        ArrayList<Rectangle> rectangles = new ArrayList<Rectangle>();
        for (Pair<Integer> top : topPairs) {
            int x = (Integer)top.first;
            int width = (Integer)top.second - (Integer)top.first;
            rectangles.add(new Rectangle(x, 1, width, this.image.getHeight() - 2));
        }
        return rectangles;
    }

    private List<Rectangle> getHorizontalRectangles(List<Pair<Integer>> leftPairs) {
        ArrayList<Rectangle> rectangles = new ArrayList<Rectangle>();
        for (Pair<Integer> left : leftPairs) {
            int y = (Integer)left.first;
            int height = (Integer)left.second - (Integer)left.first;
            rectangles.add(new Rectangle(1, y, this.image.getWidth() - 2, height));
        }
        return rectangles;
    }

    private Pair<Integer> getPadding(List<Pair<Integer>> pairs) {
        if (pairs.size() == 0) {
            return new Pair<Integer>(0, 0);
        }
        if (pairs.size() == 1) {
            if ((Integer)pairs.get((int)0).first == 1) {
                return new Pair<Integer>((Integer)pairs.get((int)0).second - (Integer)pairs.get((int)0).first, 0);
            }
            return new Pair<Integer>(0, (Integer)pairs.get((int)0).second - (Integer)pairs.get((int)0).first);
        }
        int index = pairs.size() - 1;
        return new Pair<Integer>((Integer)pairs.get((int)0).second - (Integer)pairs.get((int)0).first, (Integer)pairs.get((int)index).second - (Integer)pairs.get((int)index).first);
    }

    private List<Rectangle> getRectangles(List<Pair<Integer>> leftPairs, List<Pair<Integer>> topPairs) {
        ArrayList<Rectangle> rectangles = new ArrayList<Rectangle>();
        for (Pair<Integer> left : leftPairs) {
            int y = (Integer)left.first;
            int height = (Integer)left.second - (Integer)left.first;
            for (Pair<Integer> top : topPairs) {
                int x = (Integer)top.first;
                int width = (Integer)top.second - (Integer)top.first;
                rectangles.add(new Rectangle(x, y, width, height));
            }
        }
        return rectangles;
    }

    private static P getPatches(int[] pixels) {
        int lastIndex = 1;
        boolean first = true;
        boolean startWithPatch = false;
        ArrayList<Pair<Integer>> fixed = new ArrayList<Pair<Integer>>();
        ArrayList<Pair<Integer>> patches = new ArrayList<Pair<Integer>>();
        assert (pixels.length > 2) : "Invalid 9-patch, cannot be less than 3 pixels in a dimension";
        int lastPixel = pixels[1] != -65536 ? pixels[1] : 0;
        for (int i = 1; i < pixels.length - 1; ++i) {
            int pixel;
            int n = pixel = pixels[i] != -65536 ? pixels[i] : 0;
            if (pixel == lastPixel) continue;
            if (lastPixel == -16777216) {
                if (first) {
                    startWithPatch = true;
                }
                patches.add(new Pair<Integer>(lastIndex, i));
            } else {
                fixed.add(new Pair<Integer>(lastIndex, i));
            }
            first = false;
            lastIndex = i;
            lastPixel = pixel;
        }
        if (lastPixel == -16777216) {
            if (first) {
                startWithPatch = true;
            }
            patches.add(new Pair<Integer>(lastIndex, pixels.length - 1));
        } else {
            fixed.add(new Pair<Integer>(lastIndex, pixels.length - 1));
        }
        if (patches.isEmpty()) {
            patches.add(new Pair<Integer>(1, pixels.length - 1));
            startWithPatch = true;
            fixed.clear();
        }
        return new P(fixed, patches, startWithPatch);
    }

    private static class P {
        public final List<Pair<Integer>> fixed;
        public final List<Pair<Integer>> patches;
        public final boolean startsWithPatch;

        private P(List<Pair<Integer>> f, List<Pair<Integer>> p, boolean s) {
            this.fixed = f;
            this.patches = p;
            this.startsWithPatch = s;
        }
    }
}

