/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib;

import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmuilib.TablePanel;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class InfoPanel
extends TablePanel {
    private Table mTable;
    private TableColumn mCol2;
    private static final String[] mLabels = new String[]{"DDM-aware?", "App description:", "VM version:", "Process ID:", "Supports Profiling Control:", "Supports HPROF Control:", "ABI Flavor:", "JVM Flags:"};
    private static final int ENT_DDM_AWARE = 0;
    private static final int ENT_APP_DESCR = 1;
    private static final int ENT_VM_VERSION = 2;
    private static final int ENT_PROCESS_ID = 3;
    private static final int ENT_SUPPORTS_PROFILING = 4;
    private static final int ENT_SUPPORTS_HPROF = 5;
    private static final int ENT_ABI_FLAVOR = 6;
    private static final int ENT_JVM_FLAGS = 7;

    @Override
    protected Control createControl(Composite parent) {
        this.mTable = new Table(parent, 65538);
        this.mTable.setHeaderVisible(false);
        this.mTable.setLinesVisible(false);
        TableColumn col1 = new TableColumn(this.mTable, 131072);
        col1.setText("name");
        this.mCol2 = new TableColumn(this.mTable, 16384);
        this.mCol2.setText("PlaceHolderContentForWidth");
        for (int i = 0; i < mLabels.length; ++i) {
            TableItem item = new TableItem(this.mTable, 0);
            item.setText(0, mLabels[i]);
            item.setText(1, "-");
        }
        col1.pack();
        this.mCol2.pack();
        return this.mTable;
    }

    @Override
    public void setFocus() {
        this.mTable.setFocus();
    }

    @Override
    public void clientChanged(Client client, int changeMask) {
        if (client == this.getCurrentClient() && (changeMask & 7) == 7) {
            if (this.mTable.isDisposed()) {
                return;
            }
            this.mTable.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    InfoPanel.this.clientSelected();
                }
            });
        }
    }

    @Override
    public void deviceSelected() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clientSelected() {
        if (this.mTable.isDisposed()) {
            return;
        }
        Client client = this.getCurrentClient();
        if (client == null) {
            for (int i = 0; i < mLabels.length; ++i) {
                TableItem item = this.mTable.getItem(i);
                item.setText(1, "-");
            }
        } else {
            String pid;
            String isDdmAware;
            String vmIdentifier;
            String clientDescription;
            ClientData cd;
            ClientData clientData = cd = client.getClientData();
            synchronized (clientData) {
                clientDescription = cd.getClientDescription() != null ? cd.getClientDescription() : "?";
                vmIdentifier = cd.getVmIdentifier() != null ? cd.getVmIdentifier() : "?";
                isDdmAware = cd.isDdmAware() ? "yes" : "no";
                pid = cd.getPid() != 0 ? String.valueOf(cd.getPid()) : "?";
            }
            TableItem item = this.mTable.getItem(1);
            item.setText(1, clientDescription);
            item = this.mTable.getItem(2);
            item.setText(1, vmIdentifier);
            item = this.mTable.getItem(0);
            item.setText(1, isDdmAware);
            item = this.mTable.getItem(3);
            item.setText(1, pid);
            item = this.mTable.getItem(4);
            if (cd.hasFeature("method-trace-profiling-streaming")) {
                item.setText(1, "Yes");
            } else if (cd.hasFeature("method-trace-profiling")) {
                item.setText(1, "Yes (Application must be able to write on the SD Card)");
            } else {
                item.setText(1, "No");
            }
            item = this.mTable.getItem(5);
            if (cd.hasFeature("hprof-heap-dump-streaming")) {
                item.setText(1, "Yes");
            } else if (cd.hasFeature("hprof-heap-dump")) {
                item.setText(1, "Yes (Application must be able to write on the SD Card)");
            } else {
                item.setText(1, "No");
            }
            item = this.mTable.getItem(6);
            String abi = cd.getAbi();
            item.setText(1, abi == null ? "" : abi);
            item = this.mTable.getItem(7);
            String jvmFlags = cd.getJvmFlags();
            item.setText(1, jvmFlags == null ? "" : jvmFlags);
        }
        this.mCol2.pack();
    }

    @Override
    protected void setTableFocusListener() {
        this.addTableToFocusListener(this.mTable);
    }
}

