/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib.heap;

import com.android.ddmlib.NativeStackCallInfo;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class NativeStackLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    @Override
    public Image getColumnImage(Object arg0, int arg1) {
        return null;
    }

    @Override
    public String getColumnText(Object element, int index) {
        if (element instanceof NativeStackCallInfo) {
            return this.getResolvedStackTraceColumnText((NativeStackCallInfo)element, index);
        }
        if (element instanceof Long) {
            return this.getStackAddressColumnText((Long)element, index);
        }
        return null;
    }

    public String getResolvedStackTraceColumnText(NativeStackCallInfo info, int index) {
        switch (index) {
            case 0: {
                return String.format("0x%08x", info.getAddress());
            }
            case 1: {
                return info.getLibraryName();
            }
            case 2: {
                return info.getMethodName();
            }
            case 3: {
                return info.getSourceFile();
            }
            case 4: {
                int l = info.getLineNumber();
                return l == -1 ? "" : Integer.toString(l);
            }
        }
        return null;
    }

    private String getStackAddressColumnText(Long address, int index) {
        if (index == 0) {
            return String.format("0x%08x", address);
        }
        return null;
    }
}

