/*
 * Decompiled with CFR 0.152.
 */
package cz.startnet.utils.pgdiff;

import cz.startnet.utils.pgdiff.PgDiffUtils;
import cz.startnet.utils.pgdiff.SearchPathHelper;
import cz.startnet.utils.pgdiff.schema.PgSchema;
import cz.startnet.utils.pgdiff.schema.PgView;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PgDiffViews {
    public static void createViews(PrintWriter writer, PgSchema oldSchema, PgSchema newSchema, SearchPathHelper searchPathHelper) {
        for (PgView newView : newSchema.getViews()) {
            if (oldSchema != null && oldSchema.containsView(newView.getName()) && !PgDiffViews.isViewModified(oldSchema.getView(newView.getName()), newView)) continue;
            searchPathHelper.outputSearchPath(writer);
            writer.println();
            writer.println(newView.getCreationSQL());
        }
    }

    public static void dropViews(PrintWriter writer, PgSchema oldSchema, PgSchema newSchema, SearchPathHelper searchPathHelper) {
        if (oldSchema == null) {
            return;
        }
        for (PgView oldView : oldSchema.getViews()) {
            PgView newView = newSchema.getView(oldView.getName());
            if (newView != null && !PgDiffViews.isViewModified(oldView, newView)) continue;
            searchPathHelper.outputSearchPath(writer);
            writer.println();
            writer.println(oldView.getDropSQL());
        }
    }

    private static boolean isViewModified(PgView oldView, PgView newView) {
        Object[] oldViewColumnNames = oldView.getColumnNames() == null || oldView.getColumnNames().isEmpty() ? null : oldView.getColumnNames().toArray(new String[oldView.getColumnNames().size()]);
        String[] newViewColumnNames = newView.getColumnNames() == null || newView.getColumnNames().isEmpty() ? null : newView.getColumnNames().toArray(new String[newView.getColumnNames().size()]);
        if (oldViewColumnNames == null && newViewColumnNames == null) {
            return !oldView.getQuery().trim().equals(newView.getQuery().trim());
        }
        return !Arrays.equals(oldViewColumnNames, newViewColumnNames);
    }

    public static void alterViews(PrintWriter writer, PgSchema oldSchema, PgSchema newSchema, SearchPathHelper searchPathHelper) {
        if (oldSchema == null) {
            return;
        }
        for (PgView oldView : oldSchema.getViews()) {
            PgView newView = newSchema.getView(oldView.getName());
            if (newView == null) continue;
            PgDiffViews.diffDefaultValues(writer, oldView, newView, searchPathHelper);
            if (oldView.getComment() == null && newView.getComment() != null || oldView.getComment() != null && newView.getComment() != null && !oldView.getComment().equals(newView.getComment())) {
                searchPathHelper.outputSearchPath(writer);
                writer.println();
                writer.print("COMMENT ON VIEW ");
                writer.print(PgDiffUtils.getQuotedName(newView.getName()));
                writer.print(" IS ");
                writer.print(newView.getComment());
                writer.println(';');
            } else if (oldView.getComment() != null && newView.getComment() == null) {
                searchPathHelper.outputSearchPath(writer);
                writer.println();
                writer.print("COMMENT ON VIEW ");
                writer.print(PgDiffUtils.getQuotedName(newView.getName()));
                writer.println(" IS NULL;");
            }
            ArrayList<String> columnNames = new ArrayList<String>(newView.getColumnComments().size());
            for (PgView.ColumnComment columnComment : newView.getColumnComments()) {
                columnNames.add(columnComment.getColumnName());
            }
            for (PgView.ColumnComment columnComment : oldView.getColumnComments()) {
                if (columnNames.contains(columnComment.getColumnName())) continue;
                columnNames.add(columnComment.getColumnName());
            }
            for (String columnName : columnNames) {
                PgView.ColumnComment oldColumnComment = null;
                PgView.ColumnComment newColumnComment = null;
                for (PgView.ColumnComment columnComment : oldView.getColumnComments()) {
                    if (!columnName.equals(columnComment.getColumnName())) continue;
                    oldColumnComment = columnComment;
                    break;
                }
                for (PgView.ColumnComment columnComment : newView.getColumnComments()) {
                    if (!columnName.equals(columnComment.getColumnName())) continue;
                    newColumnComment = columnComment;
                    break;
                }
                if (oldColumnComment == null && newColumnComment != null || oldColumnComment != null && newColumnComment != null && !oldColumnComment.getComment().equals(newColumnComment.getComment())) {
                    searchPathHelper.outputSearchPath(writer);
                    writer.println();
                    writer.print("COMMENT ON COLUMN ");
                    writer.print(PgDiffUtils.getQuotedName(newView.getName()));
                    writer.print('.');
                    writer.print(PgDiffUtils.getQuotedName(newColumnComment.getColumnName()));
                    writer.print(" IS ");
                    writer.print(newColumnComment.getComment());
                    writer.println(';');
                    continue;
                }
                if (oldColumnComment == null || newColumnComment != null) continue;
                searchPathHelper.outputSearchPath(writer);
                writer.println();
                writer.print("COMMENT ON COLUMN ");
                writer.print(PgDiffUtils.getQuotedName(newView.getName()));
                writer.print('.');
                writer.print(PgDiffUtils.getQuotedName(oldColumnComment.getColumnName()));
                writer.println(" IS NULL;");
            }
        }
    }

    private static void diffDefaultValues(PrintWriter writer, PgView oldView, PgView newView, SearchPathHelper searchPathHelper) {
        boolean found;
        List<PgView.DefaultValue> oldValues = oldView.getDefaultValues();
        List<PgView.DefaultValue> newValues = newView.getDefaultValues();
        for (PgView.DefaultValue oldValue : oldValues) {
            found = false;
            for (PgView.DefaultValue newValue : newValues) {
                if (!oldValue.getColumnName().equals(newValue.getColumnName())) continue;
                found = true;
                if (oldValue.getDefaultValue().equals(newValue.getDefaultValue())) break;
                searchPathHelper.outputSearchPath(writer);
                writer.println();
                writer.print("ALTER TABLE ");
                writer.print(PgDiffUtils.getQuotedName(newView.getName()));
                writer.print(" ALTER COLUMN ");
                writer.print(PgDiffUtils.getQuotedName(newValue.getColumnName()));
                writer.print(" SET DEFAULT ");
                writer.print(newValue.getDefaultValue());
                writer.println(';');
                break;
            }
            if (found) continue;
            searchPathHelper.outputSearchPath(writer);
            writer.println();
            writer.print("ALTER TABLE ");
            writer.print(PgDiffUtils.getQuotedName(newView.getName()));
            writer.print(" ALTER COLUMN ");
            writer.print(PgDiffUtils.getQuotedName(oldValue.getColumnName()));
            writer.println(" DROP DEFAULT;");
        }
        for (PgView.DefaultValue newValue : newValues) {
            found = false;
            for (PgView.DefaultValue oldValue : oldValues) {
                if (!newValue.getColumnName().equals(oldValue.getColumnName())) continue;
                found = true;
                break;
            }
            if (found) continue;
            searchPathHelper.outputSearchPath(writer);
            writer.println();
            writer.print("ALTER TABLE ");
            writer.print(PgDiffUtils.getQuotedName(newView.getName()));
            writer.print(" ALTER COLUMN ");
            writer.print(PgDiffUtils.getQuotedName(newValue.getColumnName()));
            writer.print(" SET DEFAULT ");
            writer.print(newValue.getDefaultValue());
            writer.println(';');
        }
    }

    private PgDiffViews() {
    }
}

