/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.tool;

import com.google.cloud.sql.tool.Log;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class KeepAlive {
    private final ScheduledExecutorService executor;
    private final Connection connection;
    private final int numMinutes;
    private final int intervalSeconds;
    private ScheduledFuture<?> keepAliveTask;
    long keepAliveStopTimeMillis;

    KeepAlive(ScheduledExecutorService executor, Connection connection, int numMinutes, int intervalSeconds) {
        this.executor = executor;
        this.connection = connection;
        this.numMinutes = numMinutes;
        this.intervalSeconds = intervalSeconds;
        this.keepAliveStopTimeMillis = System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(numMinutes);
    }

    void disable() {
        if (this.keepAliveTask != null) {
            this.keepAliveTask.cancel(false);
            this.keepAliveTask = null;
        }
    }

    void enable() {
        if (System.currentTimeMillis() <= this.keepAliveStopTimeMillis) {
            this.keepAliveTask = this.executor.scheduleWithFixedDelay(new KeepAliveRunnable(), this.intervalSeconds, this.intervalSeconds, TimeUnit.SECONDS);
            this.keepAliveStopTimeMillis = System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(this.numMinutes);
        }
    }

    private class KeepAliveRunnable
    implements Runnable {
        private KeepAliveRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (System.currentTimeMillis() > KeepAlive.this.keepAliveStopTimeMillis) {
                    throw new RuntimeException("Stop KeepAlive.");
                }
                Log.vlog("Executing keep alive statement.", new Object[0]);
                Connection connection = KeepAlive.this.connection;
                synchronized (connection) {
                    KeepAlive.this.connection.isValid(0);
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

