/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import java.io.Serializable;

class AppIdNamespace
implements Serializable,
Comparable<AppIdNamespace> {
    private final String appId;
    private final String namespace;
    private static final String BAD_APP_ID_MESSAGE = "appId or namespace cannot contain '!'";

    public AppIdNamespace(String appId, String namespace) {
        if (appId == null || namespace == null) {
            throw new IllegalArgumentException("appId or namespace may not be null");
        }
        if (appId.indexOf(33) != -1 || namespace.indexOf(33) != -1) {
            throw new IllegalArgumentException(BAD_APP_ID_MESSAGE);
        }
        this.appId = appId;
        this.namespace = namespace;
    }

    public static AppIdNamespace parseEncodedAppIdNamespace(String encodedAppIdNamespace) {
        if (encodedAppIdNamespace == null) {
            throw new IllegalArgumentException("appIdNamespaceString may not be null");
        }
        int index = encodedAppIdNamespace.indexOf(33);
        if (index == -1) {
            return new AppIdNamespace(encodedAppIdNamespace, "");
        }
        String appId = encodedAppIdNamespace.substring(0, index);
        String namespace = encodedAppIdNamespace.substring(index + 1);
        if (namespace.length() == 0) {
            throw new IllegalArgumentException("encodedAppIdNamespace with empty namespace may not contain a '!'");
        }
        return new AppIdNamespace(appId, namespace);
    }

    @Override
    public int compareTo(AppIdNamespace other) {
        int appidCompare = this.appId.compareTo(other.appId);
        if (appidCompare == 0) {
            return this.namespace.compareTo(other.namespace);
        }
        return appidCompare;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String toEncodedString() {
        if (this.namespace.equals("")) {
            return this.appId;
        }
        return this.appId + '!' + this.namespace;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.appId == null ? 0 : this.appId.hashCode());
        result = 31 * result + (this.namespace == null ? 0 : this.namespace.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AppIdNamespace other = (AppIdNamespace)obj;
        if (this.appId == null ? other.appId != null : !this.appId.equals(other.appId)) {
            return false;
        }
        return !(this.namespace == null ? other.namespace != null : !this.namespace.equals(other.namespace));
    }

    public String toString() {
        return this.toEncodedString();
    }
}

