/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search.checkers;

import java.util.Formatter;

public final class Preconditions {
    private Preconditions() {
    }

    public static void checkArgument(boolean expression, Object errorMessage) {
        if (!expression) {
            throw new IllegalArgumentException(String.valueOf(errorMessage));
        }
    }

    public static void checkArgument(boolean expression, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (!expression) {
            throw new IllegalArgumentException(Preconditions.format(errorMessageTemplate, errorMessageArgs));
        }
    }

    public static <T> T checkNotNull(T reference, Object errorMessage) {
        if (reference == null) {
            throw new NullPointerException(String.valueOf(errorMessage));
        }
        return reference;
    }

    static String format(String template, Object ... args) {
        if (template == null) {
            return "";
        }
        return new Formatter().format(template, args).toString();
    }
}

