/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search;

import com.google.appengine.api.search.SearchServicePb;
import com.google.appengine.api.search.Util;
import com.google.appengine.api.search.checkers.FieldChecker;
import com.google.appengine.api.search.checkers.Preconditions;

public final class SortExpression {
    private final SortDirection direction;
    private final String expression;
    private final String defaultValue;
    private final Double defaultValueNumeric;

    private SortExpression(Builder builder) {
        this.expression = builder.expression;
        this.direction = Util.defaultIfNull(builder.direction, SortDirection.DESCENDING);
        this.defaultValue = builder.defaultValue;
        this.defaultValueNumeric = builder.defaultValueNumeric;
        this.checkValid();
    }

    public String getExpression() {
        return this.expression;
    }

    public SortDirection getDirection() {
        return this.direction;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public Double getDefaultValueNumeric() {
        return this.defaultValueNumeric;
    }

    private SortExpression checkValid() {
        Preconditions.checkNotNull(this.expression, "expression cannot be null");
        Preconditions.checkArgument(this.defaultValue != null || this.defaultValueNumeric != null, "A default value must be specified for the SortExpression");
        if (this.defaultValue != null) {
            FieldChecker.checkText(this.defaultValue);
        }
        return this;
    }

    SearchServicePb.SortSpec copyToProtocolBuffer() {
        SearchServicePb.SortSpec.Builder builder = SearchServicePb.SortSpec.newBuilder();
        if (SortDirection.ASCENDING.equals((Object)this.getDirection())) {
            builder.setSortDescending(false);
        }
        builder.setSortExpression(this.getExpression());
        if (this.getDefaultValue() != null) {
            builder.setDefaultValueText(this.getDefaultValue());
        }
        if (this.getDefaultValueNumeric() != null) {
            builder.setDefaultValueNumeric(this.getDefaultValueNumeric());
        }
        return builder.build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String toString() {
        return String.format("SortExpression(direction=%s%s%s%s)", new Object[]{this.direction, Util.fieldToString("expression", this.expression), Util.fieldToString("defaultValue", this.defaultValue), Util.fieldToString("defaultValueNumeric", this.defaultValueNumeric)});
    }

    public static final class Builder {
        private String expression;
        private SortDirection direction;
        private String defaultValue;
        private Double defaultValueNumeric;

        private Builder() {
        }

        public Builder setExpression(String expression) {
            this.expression = FieldChecker.checkExpression(expression);
            return this;
        }

        public Builder setDirection(SortDirection direction) {
            this.direction = direction;
            return this;
        }

        public Builder setDefaultValue(String defaultValue) {
            this.defaultValue = FieldChecker.checkText(defaultValue);
            return this;
        }

        public Builder setDefaultValueNumeric(double defaultValue) {
            this.defaultValueNumeric = defaultValue;
            return this;
        }

        public SortExpression build() {
            return new SortExpression(this);
        }
    }

    public static enum SortDirection {
        ASCENDING,
        DESCENDING;

    }
}

