/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.repackaged.com.google.common.base.Pair;
import com.google.appengine.repackaged.com.google.common.collect.Sets;
import com.google.apphosting.api.DatastorePb;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CompositeIndexManager {
    private static final String DATASTORE_INDEX_WITH_PROPERTIES_XML_FORMAT = "    <datastore-index kind=\"%s\" ancestor=\"%s\" source=\"%s\">\n%s    </datastore-index>\n\n";
    private static final String DATASTORE_INDEX_NO_PROPERTIES_XML_FORMAT = "    <datastore-index kind=\"%s\" ancestor=\"%s\" source=\"%s\"/>\n\n";
    private static final String PROPERTY_XML_FORMAT = "        <property name=\"%s\" direction=\"%s\"/>\n";
    private static final Comparator<OnestoreEntity.Index.Property> PROPERTY_NAME_COMPARATOR = new Comparator<OnestoreEntity.Index.Property>(){

        @Override
        public int compare(OnestoreEntity.Index.Property o1, OnestoreEntity.Index.Property o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };

    protected String generateXmlForIndex(OnestoreEntity.Index index, IndexSource source) {
        boolean isAncestor = index.isAncestor();
        if (index.propertySize() == 0) {
            return String.format(DATASTORE_INDEX_NO_PROPERTIES_XML_FORMAT, new Object[]{index.getEntityType(), isAncestor, source});
        }
        StringBuilder sb = new StringBuilder();
        for (OnestoreEntity.Index.Property prop : index.propertys()) {
            String dir = prop.getDirectionEnum() == OnestoreEntity.Index.Property.Direction.ASCENDING ? "asc" : "desc";
            sb.append(String.format(PROPERTY_XML_FORMAT, prop.getName(), dir));
        }
        return String.format(DATASTORE_INDEX_WITH_PROPERTIES_XML_FORMAT, new Object[]{index.getEntityType(), isAncestor, source, sb.toString()});
    }

    protected OnestoreEntity.Index compositeIndexForQuery(IndexComponentsOnlyQuery indexOnlyQuery) {
        DatastorePb.Query query = indexOnlyQuery.getQuery();
        boolean hasKind = query.hasKind();
        boolean isAncestor = query.hasAncestor();
        List<DatastorePb.Query.Filter> filters = query.filters();
        List<DatastorePb.Query.Order> orders = query.orders();
        if (filters.isEmpty() && orders.isEmpty()) {
            return null;
        }
        Set<String> eqProps = indexOnlyQuery.getEqualityProps();
        List<OnestoreEntity.Index.Property> indexProperties = this.getRecommendedIndexProps(indexOnlyQuery);
        if (hasKind && !eqProps.isEmpty() && eqProps.size() == filters.size() && !indexOnlyQuery.hasKeyProperty() && orders.isEmpty()) {
            return null;
        }
        if (!(!hasKind || isAncestor || indexProperties.size() > 1 || indexOnlyQuery.hasKeyProperty() && indexProperties.get(0).getDirectionEnum() != OnestoreEntity.Index.Property.Direction.ASCENDING)) {
            return null;
        }
        OnestoreEntity.Index index = new OnestoreEntity.Index();
        index.setEntityType(query.getKind());
        index.setAncestor(isAncestor);
        index.mutablePropertys().addAll(indexProperties);
        return index;
    }

    private static OnestoreEntity.Index.Property newIndexProperty(String name, OnestoreEntity.Index.Property.Direction direction) {
        OnestoreEntity.Index.Property indexProperty = new OnestoreEntity.Index.Property();
        indexProperty.setName(name);
        indexProperty.setDirection(direction);
        return indexProperty;
    }

    private List<OnestoreEntity.Index.Property> getRecommendedIndexProps(IndexComponentsOnlyQuery query) {
        ArrayList<OnestoreEntity.Index.Property> indexProps = new ArrayList<OnestoreEntity.Index.Property>(query.getEqualityProps().size() + query.getOrderProps().size() + query.getExistsProps().size());
        for (String name : query.getEqualityProps()) {
            indexProps.add(CompositeIndexManager.newIndexProperty(name, OnestoreEntity.Index.Property.Direction.ASCENDING));
        }
        Collections.sort(indexProps, PROPERTY_NAME_COMPARATOR);
        for (OnestoreEntity.Index.Property orderProp : query.getOrderProps()) {
            if (!orderProp.hasDirection()) {
                orderProp = (OnestoreEntity.Index.Property)orderProp.clone();
                orderProp.setDirection(OnestoreEntity.Index.Property.Direction.ASCENDING);
            }
            indexProps.add(orderProp);
        }
        ArrayList<String> sortedExists = new ArrayList<String>(query.getExistsProps());
        Collections.sort(sortedExists);
        for (String name : sortedExists) {
            indexProps.add(CompositeIndexManager.newIndexProperty(name, OnestoreEntity.Index.Property.Direction.ASCENDING));
        }
        return indexProps;
    }

    protected OnestoreEntity.Index minimumCompositeIndexForQuery(IndexComponentsOnlyQuery indexOnlyQuery, Collection<OnestoreEntity.Index> indexes) {
        OnestoreEntity.Index suggestedIndex = this.compositeIndexForQuery(indexOnlyQuery);
        if (suggestedIndex == null) {
            return null;
        }
        HashMap<List<OnestoreEntity.Index.Property>, Pair<Set<String>, Boolean>> remainingMap = new HashMap<List<OnestoreEntity.Index.Property>, Pair<Set<String>, Boolean>>();
        block0: for (OnestoreEntity.Index index : indexes) {
            boolean remainingAncestor;
            Set<String> remainingEqProps;
            int postfixStart;
            int postfixSplit;
            if (!indexOnlyQuery.getQuery().getKind().equals(index.getEntityType()) || !indexOnlyQuery.getQuery().hasAncestor() && index.isAncestor()) continue;
            HashSet<String> indexExistsSet = Sets.newHashSetWithExpectedSize(indexOnlyQuery.getExistsProps().size());
            for (postfixSplit = index.propertySize() - 1; postfixSplit >= 0; --postfixSplit) {
                String name = index.getProperty(postfixSplit).getName();
                if (!indexOnlyQuery.getExistsProps().contains(name)) break;
                indexExistsSet.add(name);
            }
            if (!((Object)indexExistsSet).equals(indexOnlyQuery.getExistsProps()) || (postfixStart = ++postfixSplit - indexOnlyQuery.getOrderProps().size()) <= 0) continue;
            List<OnestoreEntity.Index.Property> indexOrderProps = index.propertys().subList(postfixStart, postfixSplit);
            Iterator<OnestoreEntity.Index.Property> indexItr = indexOrderProps.iterator();
            for (OnestoreEntity.Index.Property prop : indexOnlyQuery.getOrderProps()) {
                OnestoreEntity.Index.Property indexProp = indexItr.next();
                if (indexProp.getName().equals(prop.getName()) && (!prop.hasDirection() || prop.getDirection() == indexProp.getDirection())) continue;
                continue block0;
            }
            HashSet<String> indexEqProps = Sets.newHashSetWithExpectedSize(postfixStart);
            for (OnestoreEntity.Index.Property prop : index.propertys().subList(0, postfixStart)) {
                indexEqProps.add(prop.getName());
            }
            if (!indexOnlyQuery.getEqualityProps().containsAll(indexEqProps)) continue;
            List<OnestoreEntity.Index.Property> indexPostfix = index.propertys().subList(postfixStart, index.propertySize());
            Pair remaining = (Pair)remainingMap.get(indexPostfix);
            if (remaining == null) {
                remainingEqProps = Sets.newHashSet(indexOnlyQuery.getEqualityProps());
                remainingAncestor = indexOnlyQuery.getQuery().hasAncestor();
            } else {
                remainingEqProps = (Set)remaining.first;
                remainingAncestor = (Boolean)remaining.second;
            }
            boolean modified = remainingEqProps.removeAll(indexEqProps);
            if (remainingAncestor && index.isAncestor()) {
                modified = true;
                remainingAncestor = false;
            }
            if (!modified) continue;
            if (remainingEqProps.isEmpty() && !remainingAncestor) {
                return null;
            }
            remainingMap.put(indexPostfix, Pair.of(remainingEqProps, remainingAncestor));
        }
        if (remainingMap.isEmpty()) {
            return suggestedIndex;
        }
        int minimumCost = Integer.MAX_VALUE;
        List minimumPostfix = null;
        Pair minimumRemaining = null;
        for (Map.Entry entry : remainingMap.entrySet()) {
            int cost = ((Set)((Pair)entry.getValue()).first).size();
            if (((Boolean)((Pair)entry.getValue()).second).booleanValue()) {
                cost += 2;
            }
            if (cost >= minimumCost) continue;
            minimumCost = cost;
            minimumPostfix = (List)entry.getKey();
            minimumRemaining = (Pair)entry.getValue();
        }
        suggestedIndex.clearProperty();
        suggestedIndex.setAncestor((Boolean)minimumRemaining.second);
        for (String name : (Set)minimumRemaining.first) {
            suggestedIndex.addProperty().setName(name).setDirection(OnestoreEntity.Index.Property.Direction.ASCENDING);
        }
        Collections.sort(suggestedIndex.mutablePropertys(), PROPERTY_NAME_COMPARATOR);
        suggestedIndex.mutablePropertys().addAll(minimumPostfix);
        return suggestedIndex;
    }

    protected static class KeyTranslator
    extends com.google.appengine.api.datastore.KeyTranslator {
        protected KeyTranslator() {
        }
    }

    protected static class ValidatedQuery
    extends com.google.appengine.api.datastore.ValidatedQuery {
        public ValidatedQuery(DatastorePb.Query query) {
            super(query);
        }
    }

    protected static class IndexComponentsOnlyQuery
    extends com.google.appengine.api.datastore.IndexComponentsOnlyQuery {
        public IndexComponentsOnlyQuery(DatastorePb.Query query) {
            super(query);
        }
    }

    protected static enum IndexSource {
        auto,
        manual;

    }
}

