/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.query;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.datanucleus.FetchPlan;
import org.datanucleus.ObjectManager;
import org.datanucleus.ObjectManagerFactoryImpl;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.exceptions.TransactionNotActiveException;
import org.datanucleus.exceptions.TransactionNotReadableException;
import org.datanucleus.management.runtime.QueryRuntime;
import org.datanucleus.metadata.QueryResultMetaData;
import org.datanucleus.query.JDOQLQueryHelper;
import org.datanucleus.query.QueryUtils;
import org.datanucleus.query.compiler.QueryCompilation;
import org.datanucleus.query.expression.ParameterExpression;
import org.datanucleus.query.symbol.Symbol;
import org.datanucleus.query.symbol.SymbolTable;
import org.datanucleus.store.Extent;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.query.NoQueryResultsException;
import org.datanucleus.store.query.QueryInterruptedException;
import org.datanucleus.store.query.QueryInvalidParametersException;
import org.datanucleus.store.query.QueryNotUniqueException;
import org.datanucleus.store.query.QueryResult;
import org.datanucleus.store.query.QueryTimeoutException;
import org.datanucleus.util.Imports;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Query
implements Serializable {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ObjectManagerFactoryImpl.class.getClassLoader());
    protected final transient ObjectManager om;
    public static final short SELECT = 0;
    public static final short BULK_UPDATE = 1;
    public static final short BULK_DELETE = 2;
    protected short type = 0;
    protected Class candidateClass;
    protected String candidateClassName;
    protected boolean subclasses = true;
    protected boolean unique = false;
    protected transient String from = null;
    protected transient String update = null;
    protected String result = null;
    protected boolean resultDistinct = false;
    protected Class resultClass = null;
    protected String resultClassName = null;
    protected String filter;
    protected String imports;
    protected String explicitVariables;
    protected String explicitParameters;
    protected String ordering;
    protected String grouping;
    protected String having;
    protected String range;
    protected long fromInclNo = 0L;
    protected long toExclNo = Long.MAX_VALUE;
    protected boolean unmodifiable = false;
    protected boolean ignoreCache = false;
    private FetchPlan fetchPlan;
    private Boolean serializeRead = null;
    private Integer timeoutMillis = null;
    protected Map<String, Object> extensions = null;
    protected Map<String, SubqueryDefinition> subqueries = null;
    protected transient HashMap implicitParameters = null;
    protected transient Imports parsedImports = null;
    protected transient String[] parameterNames = null;
    protected transient QueryCompilation compilation = null;
    protected transient HashSet<QueryResult> queryResults = new HashSet();
    protected transient HashSet<FutureTask> tasks = new HashSet();
    Map inputParameters;

    public Query(ObjectManager om) {
        this.om = om;
        if (om == null) {
            throw new NucleusUserException(LOCALISER.msg("021012"));
        }
        this.ignoreCache = om.getIgnoreCache();
        this.timeoutMillis = om.getQueryTimeoutMillis();
    }

    protected void discardCompiled() {
        this.parsedImports = null;
        this.parameterNames = null;
        this.compilation = null;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Query)) {
            return false;
        }
        Query q = (Query)obj;
        if (this.candidateClass == null ? q.candidateClass != null : !this.candidateClass.equals(q.candidateClass)) {
            return false;
        }
        if (this.filter == null ? q.filter != null : !this.filter.equals(q.filter)) {
            return false;
        }
        if (this.imports == null ? q.imports != null : !this.imports.equals(q.imports)) {
            return false;
        }
        if (this.explicitParameters == null ? q.explicitParameters != null : !this.explicitParameters.equals(q.explicitParameters)) {
            return false;
        }
        if (this.explicitVariables == null ? q.explicitVariables != null : !this.explicitVariables.equals(q.explicitVariables)) {
            return false;
        }
        if (this.unique != q.unique) {
            return false;
        }
        if (this.unmodifiable != q.unmodifiable) {
            return false;
        }
        if (this.resultClass != q.resultClass) {
            return false;
        }
        if (this.grouping == null ? q.grouping != null : !this.grouping.equals(q.grouping)) {
            return false;
        }
        return !(this.ordering == null ? q.ordering != null : !this.ordering.equals(q.ordering));
    }

    public int hashCode() {
        return (this.candidateClass == null ? 0 : this.candidateClass.hashCode()) ^ (this.result == null ? 0 : this.result.hashCode()) ^ (this.filter == null ? 0 : this.filter.hashCode()) ^ (this.imports == null ? 0 : this.imports.hashCode()) ^ (this.explicitParameters == null ? 0 : this.explicitParameters.hashCode()) ^ (this.explicitVariables == null ? 0 : this.explicitVariables.hashCode()) ^ (this.resultClass == null ? 0 : this.resultClass.hashCode()) ^ (this.grouping == null ? 0 : this.grouping.hashCode()) ^ (this.having == null ? 0 : this.having.hashCode()) ^ (this.ordering == null ? 0 : this.ordering.hashCode()) ^ (this.range == null ? 0 : this.range.hashCode());
    }

    public short getType() {
        return this.type;
    }

    public void setType(short type) {
        if (type != 0 && type != 1 && type != 2) {
            throw new NucleusUserException("Query only supports types of SELECT, BULK_UPDATE, BULK_DELETE : unknown value " + type);
        }
        this.type = type;
    }

    public StoreManager getStoreManager() {
        return this.om.getStoreManager();
    }

    public ObjectManager getObjectManager() {
        return this.om;
    }

    public void addExtension(String key, Object value) {
        if (this.extensions == null) {
            this.extensions = new HashMap<String, Object>();
        }
        this.extensions.put(key, value);
    }

    public void setExtensions(Map extensions) {
        this.extensions = new HashMap<String, Object>(extensions);
    }

    public Object getExtension(String key) {
        return this.extensions != null ? this.extensions.get(key) : null;
    }

    public Map<String, Object> getExtensions() {
        return this.extensions;
    }

    public boolean getBooleanExtensionProperty(String name, boolean resultIfNotSet) {
        if (this.extensions != null && this.extensions.containsKey(name)) {
            return Boolean.valueOf((String)this.extensions.get(name));
        }
        return this.om.getOMFContext().getPersistenceConfiguration().getBooleanProperty(name, resultIfNotSet);
    }

    public Set<String> getSupportedExtensions() {
        HashSet<String> supported = new HashSet<String>();
        supported.add("datanucleus.query.flushBeforeExecution");
        supported.add("datanucleus.query.useFetchPlan");
        supported.add("datanucleus.query.timeout");
        supported.add("datanucleus.query.resultSizeMethod");
        supported.add("datanucleus.query.loadResultsAtCommit");
        supported.add("datanucleus.query.resultCacheType");
        return supported;
    }

    public FetchPlan getFetchPlan() {
        if (this.fetchPlan == null) {
            this.fetchPlan = this.om.getFetchPlan().getCopy();
        }
        return this.fetchPlan;
    }

    public void setFetchPlan(FetchPlan fp) {
        this.fetchPlan = fp;
    }

    public void setUpdate(String update) {
        this.discardCompiled();
        this.assertIsModifiable();
        this.update = update;
    }

    public String getUpdate() {
        return this.update;
    }

    public Class getCandidateClass() {
        return this.candidateClass;
    }

    public void setClass(Class candidateClass) {
        this.discardCompiled();
        this.assertIsModifiable();
        this.candidateClassName = candidateClass != null ? candidateClass.getName() : null;
        this.candidateClass = candidateClass;
    }

    public void setCandidateClassName(String candidateClassName) {
        this.candidateClassName = candidateClassName != null ? candidateClassName.trim() : null;
    }

    public String getCandidateClassName() {
        return this.candidateClassName;
    }

    public void setFrom(String from) {
        this.discardCompiled();
        this.assertIsModifiable();
        this.from = from;
    }

    public String getFrom() {
        return this.from;
    }

    public abstract void setCandidates(Extent var1);

    public abstract void setCandidates(Collection var1);

    public void setFilter(String filter) {
        this.discardCompiled();
        this.assertIsModifiable();
        this.filter = filter != null ? filter.trim() : null;
    }

    public String getFilter() {
        return this.filter;
    }

    public void declareImports(String imports) {
        this.discardCompiled();
        this.assertIsModifiable();
        this.imports = imports != null ? imports.trim() : null;
    }

    public String getImports() {
        return this.imports;
    }

    public void declareExplicitParameters(String parameters) {
        this.discardCompiled();
        this.assertIsModifiable();
        this.explicitParameters = StringUtils.isWhitespace(parameters) ? null : parameters.trim();
    }

    public String getExplicitParameters() {
        return this.explicitParameters;
    }

    public void setImplicitParameter(String name, Object value) {
        if (this.implicitParameters == null) {
            this.implicitParameters = new HashMap();
        }
        this.implicitParameters.put(name, value);
        if (this.compilation == null) {
            this.discardCompiled();
            this.compileInternal(false, this.implicitParameters);
        }
        this.applyImplicitParameterValueToCompilation(name, value);
    }

    public void setImplicitParameter(int position, Object value) {
        if (this.implicitParameters == null) {
            this.implicitParameters = new HashMap();
        }
        this.implicitParameters.put(new Integer(position), value);
        if (this.compilation == null) {
            this.discardCompiled();
            this.compileInternal(false, this.implicitParameters);
        }
        this.applyImplicitParameterValueToCompilation("" + position, value);
    }

    protected void applyImplicitParameterValueToCompilation(String name, Object value) {
        if (this.compilation != null) {
            Symbol sym = this.compilation.getSymbolTable().getSymbol(name);
            if (sym == null) {
                throw new QueryInvalidParametersException(LOCALISER.msg("021116", (Object)name));
            }
            if (sym.getValueType() == null && value != null) {
                sym.setValueType(value.getClass());
            } else if (sym.getValueType() != null && value != null && !QueryUtils.queryParameterTypesAreCompatible(sym.getValueType(), value.getClass())) {
                throw new QueryInvalidParametersException("Parameter " + name + " needs to be assignable from " + sym.getValueType().getName() + " yet the value is of type " + value.getClass().getName());
            }
        }
    }

    public Map getImplicitParameters() {
        return this.implicitParameters;
    }

    public void declareExplicitVariables(String variables) {
        this.discardCompiled();
        this.assertIsModifiable();
        this.explicitVariables = StringUtils.isWhitespace(variables) ? null : variables.trim();
    }

    public String getExplicitVariables() {
        return this.explicitVariables;
    }

    public void setOrdering(String ordering) {
        this.discardCompiled();
        this.assertIsModifiable();
        this.ordering = ordering != null ? ordering.trim() : null;
    }

    public String getOrdering() {
        return this.ordering;
    }

    public void setGrouping(String grouping) {
        this.discardCompiled();
        this.assertIsModifiable();
        this.grouping = grouping != null ? grouping.trim() : null;
    }

    public String getGrouping() {
        return this.grouping;
    }

    public void setHaving(String having) {
        this.discardCompiled();
        this.assertIsModifiable();
        this.having = having != null ? having.trim() : null;
    }

    public String getHaving() {
        return this.having;
    }

    public void setUnique(boolean unique) {
        this.discardCompiled();
        this.assertIsModifiable();
        this.unique = unique;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public void setRange(long fromIncl, long toExcl) {
        this.discardCompiled();
        this.range = null;
        this.fromInclNo = fromIncl;
        this.toExclNo = toExcl;
    }

    public void setRange(String range) {
        this.discardCompiled();
        this.range = range != null ? range.trim() : null;
        this.fromInclNo = 0L;
        this.toExclNo = Long.MAX_VALUE;
    }

    public String getRange() {
        return this.range;
    }

    public long getRangeFromIncl() {
        return this.fromInclNo;
    }

    public long getRangeToExcl() {
        return this.toExclNo;
    }

    public void setResult(String result) {
        this.discardCompiled();
        this.assertIsModifiable();
        this.result = result != null ? result.trim() : null;
    }

    public String getResult() {
        return this.result;
    }

    public void setResultDistinct(boolean distinct) {
        this.resultDistinct = distinct;
    }

    public boolean getResultDistinct() {
        return this.resultDistinct;
    }

    public void setResultClass(Class result_cls) {
        this.discardCompiled();
        this.resultClassName = result_cls != null ? result_cls.getName() : null;
        this.resultClass = result_cls;
    }

    public Class getResultClass() {
        return this.resultClass;
    }

    public void setResultClassName(String resultClassName) {
        this.resultClassName = resultClassName;
    }

    public String getResultClassName() {
        return this.resultClassName;
    }

    public void setResultMetaData(QueryResultMetaData qrmd) {
        throw new NucleusException("This query doesn't support the use of setResultMetaData()");
    }

    public void setIgnoreCache(boolean ignoreCache) {
        this.discardCompiled();
        this.ignoreCache = ignoreCache;
    }

    public boolean getIgnoreCache() {
        return this.ignoreCache;
    }

    public boolean isSubclasses() {
        return this.subclasses;
    }

    public void setSubclasses(boolean subclasses) {
        this.discardCompiled();
        this.assertIsModifiable();
        this.subclasses = subclasses;
    }

    public Boolean getSerializeRead() {
        return this.serializeRead;
    }

    public void setSerializeRead(Boolean serialize) {
        this.serializeRead = serialize;
    }

    public boolean isUnmodifiable() {
        return this.unmodifiable;
    }

    protected void assertIsModifiable() {
        if (this.unmodifiable) {
            throw new NucleusUserException(LOCALISER.msg("021014"));
        }
    }

    public void setUnmodifiable() {
        this.unmodifiable = true;
    }

    public void addSubquery(Query sub, String variableDecl, String candidateExpr, Map paramMap) {
        if (StringUtils.isWhitespace(variableDecl)) {
            throw new NucleusUserException(LOCALISER.msg("021115"));
        }
        if (sub == null) {
            this.explicitVariables = this.explicitVariables == null ? variableDecl : this.explicitVariables + ";" + variableDecl;
        } else {
            if (this.subqueries == null) {
                this.subqueries = new HashMap<String, SubqueryDefinition>();
            }
            String subqueryVariableName = variableDecl.trim();
            int sepPos = subqueryVariableName.indexOf(32);
            subqueryVariableName = subqueryVariableName.substring(sepPos + 1);
            this.subqueries.put(subqueryVariableName, new SubqueryDefinition(sub, StringUtils.isWhitespace(candidateExpr) ? null : candidateExpr, variableDecl, paramMap));
        }
    }

    public SubqueryDefinition getSubqueryForVariable(String variableName) {
        if (this.subqueries == null) {
            return null;
        }
        return this.subqueries.get(variableName);
    }

    public boolean hasSubqueryForVariable(String variableName) {
        return this.subqueries == null ? false : this.subqueries.containsKey(variableName);
    }

    protected void prepareDatastore() {
        boolean flush = false;
        flush = !this.ignoreCache && !this.om.isDelayDatastoreOperationsEnabled() ? true : this.getBooleanExtensionProperty("datanucleus.query.flushBeforeExecution", false);
        if (flush) {
            this.om.flushInternal(false);
        }
    }

    public QueryCompilation getCompilation() {
        return this.compilation;
    }

    protected boolean isCompiled() {
        return this.compilation != null;
    }

    public void compile() {
        if (this.isCompiled()) {
            return;
        }
        this.compileInternal(false, null);
    }

    protected abstract void compileInternal(boolean var1, Map var2);

    public Imports getParsedImports() {
        if (this.parsedImports == null) {
            this.parsedImports = new Imports();
            if (this.candidateClassName != null) {
                this.parsedImports.importPackage(this.candidateClassName);
            }
            if (this.imports != null) {
                this.parsedImports.parseImports(this.imports);
            }
        }
        return this.parsedImports;
    }

    public Class resolveClassDeclaration(String classDecl) {
        try {
            return this.getParsedImports().resolveClassDeclaration(classDecl, this.om.getClassLoaderResolver(), this.candidateClass == null ? null : this.candidateClass.getClassLoader());
        }
        catch (ClassNotResolvedException e) {
            throw new NucleusUserException(LOCALISER.msg("021015", (Object)classDecl));
        }
    }

    public Object execute() {
        return this.executeWithArray(new Object[0]);
    }

    public Object executeWithArray(Object[] parameterValues) {
        if (this.om == null) {
            throw new NucleusUserException(LOCALISER.msg("021017"));
        }
        if (this.om.isClosed()) {
            throw new NucleusUserException(LOCALISER.msg("021013")).setFatal();
        }
        if (!this.om.getTransaction().isActive() && !this.om.getTransaction().getNontransactionalRead()) {
            throw new TransactionNotReadableException();
        }
        return this.executeQuery(this.getParameterMapForValues(parameterValues));
    }

    public Object executeWithMap(Map parameters) {
        if (this.om == null) {
            throw new NucleusUserException(LOCALISER.msg("021017"));
        }
        if (this.om.isClosed()) {
            throw new NucleusUserException(LOCALISER.msg("021013")).setFatal();
        }
        if (!this.om.getTransaction().isActive() && !this.om.getTransaction().getNontransactionalRead()) {
            throw new TransactionNotReadableException();
        }
        return this.executeQuery(parameters);
    }

    public Map getInputParameters() {
        return this.inputParameters;
    }

    public void setTimeoutMillis(Integer timeout) {
        this.timeoutMillis = timeout;
    }

    public Integer getTimeoutMillis() {
        return this.timeoutMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object executeQuery(Map parameters) {
        this.inputParameters = new HashMap();
        if (this.implicitParameters != null) {
            this.inputParameters.putAll(this.implicitParameters);
        }
        if (parameters != null) {
            this.inputParameters.putAll(parameters);
        }
        try {
            if (!this.isCompiled()) {
                this.compileInternal(true, this.inputParameters);
            }
            if (this.compilation != null) {
                this.candidateClass = this.compilation.getCandidateClass();
            }
        }
        finally {
            if (!this.isCompiled()) {
                this.discardCompiled();
            }
        }
        this.prepareDatastore();
        boolean failed = true;
        long start = 0L;
        QueryRuntime queryRuntime = this.om.getOMFContext().getQueryManager().getQueryRuntime();
        if (queryRuntime != null) {
            start = System.currentTimeMillis();
            queryRuntime.queryBegin();
        }
        try {
            Object result = this.performExecute(this.inputParameters);
            if (this.type == 2 || this.type == 1) {
                Object object = result;
                return object;
            }
            Collection qr = (Collection)result;
            failed = false;
            if (this.shouldReturnSingleRow()) {
                try {
                    if (qr == null) throw new NoQueryResultsException("No query results were returned");
                    if (qr.size() == 0) {
                        throw new NoQueryResultsException("No query results were returned");
                    }
                    if (this.applyRangeChecks() && this.toExclNo - this.fromInclNo <= 0L) {
                        throw new NoQueryResultsException("No query results were returned in the required range");
                    }
                    Iterator qrIter = qr.iterator();
                    Object firstRow = qrIter.next();
                    if (qrIter.hasNext()) {
                        failed = true;
                        throw new QueryNotUniqueException();
                    }
                    Object e = firstRow;
                    return e;
                }
                finally {
                    if (qr != null) {
                        this.close(qr);
                    }
                }
            }
            if (qr instanceof QueryResult) {
                this.queryResults.add((QueryResult)qr);
            }
            if (this.applyRangeChecks()) {
                int i = 0;
                Iterator qr_iter = qr.iterator();
                ArrayList res = new ArrayList();
                while (true) {
                    if (!qr_iter.hasNext()) {
                        ArrayList arrayList = res;
                        return arrayList;
                    }
                    Object obj = qr_iter.next();
                    if ((long)i >= this.fromInclNo && (long)i < this.toExclNo) {
                        res.add(obj);
                    }
                    ++i;
                }
            }
            Collection collection = qr;
            return collection;
        }
        finally {
            if (queryRuntime != null) {
                if (failed) {
                    queryRuntime.queryExecutedWithError();
                } else {
                    queryRuntime.queryExecuted(System.currentTimeMillis() - start);
                }
            }
        }
    }

    protected void assertSupportsCancel() {
        throw new UnsupportedOperationException("This query implementation doesn't support the cancel of executing queries");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        this.assertSupportsCancel();
        HashSet<FutureTask> hashSet = this.tasks;
        synchronized (hashSet) {
            for (FutureTask task : this.tasks) {
                task.cancel(true);
            }
            this.tasks.clear();
        }
    }

    public void cancel(Thread thread) {
        this.assertSupportsCancel();
        this.cancel();
    }

    protected Object performExecuteTask(final Object ... args) {
        Integer timeout = this.getTimeoutMillis();
        FutureTask<Object> theTask = null;
        final Object[] threadResults = new Object[1];
        try {
            theTask = new FutureTask<Object>(new Runnable(){

                public void run() {
                    threadResults[0] = Query.this.performExecuteInternal(args);
                }
            }, null);
            this.tasks.add(theTask);
            if (NucleusLogger.QUERY.isDebugEnabled()) {
                if (timeout != null && timeout > 0) {
                    NucleusLogger.QUERY.debug(LOCALISER.msg("021019", (Object)this.toString(), (Object)timeout));
                } else {
                    NucleusLogger.QUERY.debug(LOCALISER.msg("021022", (Object)this.toString()));
                }
            }
            new Thread(theTask).start();
            if (timeout != null && timeout > 0) {
                theTask.get(timeout.intValue(), TimeUnit.MILLISECONDS);
            } else {
                theTask.get();
            }
            this.tasks.remove(theTask);
        }
        catch (TimeoutException e) {
            this.tasks.remove(theTask);
            throw new QueryTimeoutException(LOCALISER.msg("021018", (Object)this.toString(), (Object)timeout));
        }
        catch (InterruptedException e) {
            this.tasks.remove(theTask);
            throw new QueryInterruptedException(LOCALISER.msg("021020", (Object)this.toString()));
        }
        catch (ExecutionException e) {
            NucleusLogger.QUERY.error(LOCALISER.msg("021021", (Object)this.toString()), e);
            throw (NucleusException)e.getCause();
        }
        return threadResults[0];
    }

    protected Object performExecuteInternal(Object ... args) {
        throw new UnsupportedOperationException("Should be implemented by query implementations");
    }

    protected abstract Object performExecute(Map var1);

    protected FutureTask getPerformExecuteTask(final Map parameters, final Object[] results) {
        FutureTask<Object> theTask = new FutureTask<Object>(new Runnable(){

            public void run() {
                results[0] = Query.this.performExecute(parameters);
            }
        }, null);
        return theTask;
    }

    protected boolean applyRangeChecks() {
        return false;
    }

    public long deletePersistentAll() {
        return this.deletePersistentAll(new Object[0]);
    }

    public long deletePersistentAll(Object[] parameterValues) {
        return this.deletePersistentAll(this.getParameterMapForValues(parameterValues));
    }

    public long deletePersistentAll(Map parameters) {
        if (this.om.isClosed()) {
            throw new NucleusUserException(LOCALISER.msg("021013")).setFatal();
        }
        if (!this.om.getTransaction().isActive() && !this.om.getTransaction().getNontransactionalWrite()) {
            throw new TransactionNotActiveException();
        }
        if (this.result != null) {
            throw new NucleusUserException(LOCALISER.msg("021029"));
        }
        if (this.resultClass != null) {
            throw new NucleusUserException(LOCALISER.msg("021030"));
        }
        if (this.resultClassName != null) {
            throw new NucleusUserException(LOCALISER.msg("021030"));
        }
        if (this.ordering != null) {
            throw new NucleusUserException(LOCALISER.msg("021027"));
        }
        if (this.grouping != null) {
            throw new NucleusUserException(LOCALISER.msg("021028"));
        }
        if (this.range != null) {
            throw new NucleusUserException(LOCALISER.msg("021031"));
        }
        if (this.fromInclNo >= 0L && this.toExclNo >= 0L && (this.fromInclNo != 0L || this.toExclNo != Long.MAX_VALUE)) {
            throw new NucleusUserException(LOCALISER.msg("021031"));
        }
        return this.performDeletePersistentAll(parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long performDeletePersistentAll(Map parameters) {
        boolean requiresUnique = this.unique;
        try {
            if (this.unique) {
                this.unique = false;
                this.discardCompiled();
            }
            this.compileInternal(true, parameters);
            Collection results = (Collection)this.performExecute(parameters);
            if (results == null) {
                long l = 0L;
                return l;
            }
            int number = results.size();
            if (requiresUnique && number > 1) {
                throw new NucleusUserException(LOCALISER.msg("021032"));
            }
            Iterator resultsIter = results.iterator();
            while (resultsIter.hasNext()) {
                this.om.findStateManager(resultsIter.next()).flush();
            }
            this.om.deleteObjects(results);
            if (results instanceof QueryResult) {
                ((QueryResult)results).close();
            }
            long l = number;
            return l;
        }
        finally {
            if (requiresUnique != this.unique) {
                this.unique = requiresUnique;
                this.discardCompiled();
            }
        }
    }

    public void close(Object queryResult) {
        if (queryResult != null && queryResult instanceof QueryResult) {
            this.queryResults.remove(queryResult);
            ((QueryResult)queryResult).close();
        }
    }

    public void closeAll() {
        QueryResult[] qrs = this.queryResults.toArray(new QueryResult[this.queryResults.size()]);
        for (int i = 0; i < qrs.length; ++i) {
            this.close(qrs[i]);
        }
    }

    protected boolean shouldReturnSingleRow() {
        return QueryUtils.queryReturnsSingleRow(this);
    }

    protected Map getParameterMapForValues(Object[] parameterValues) {
        HashMap<Object, Object> parameterMap = new HashMap<Object, Object>();
        int position = 0;
        if (this.explicitParameters != null) {
            StringTokenizer t1 = new StringTokenizer(this.explicitParameters, ",");
            while (t1.hasMoreTokens()) {
                StringTokenizer t2 = new StringTokenizer(t1.nextToken(), " ");
                if (t2.countTokens() != 2) {
                    throw new NucleusUserException(LOCALISER.msg("021101", (Object)this.explicitParameters));
                }
                t2.nextToken();
                String parameterName = t2.nextToken();
                if (!JDOQLQueryHelper.isValidJavaIdentifierForJDOQL(parameterName)) {
                    throw new NucleusUserException(LOCALISER.msg("021102", (Object)parameterName));
                }
                if (parameterMap.containsKey(parameterName)) {
                    throw new NucleusUserException(LOCALISER.msg("021103", (Object)parameterName));
                }
                if (parameterValues.length < position + 1) {
                    throw new NucleusUserException(LOCALISER.msg("021108", (Object)("" + position), (Object)("" + parameterValues.length)));
                }
                parameterMap.put(parameterName, parameterValues[position++]);
            }
            if (parameterMap.size() != parameterValues.length) {
                throw new NucleusUserException(LOCALISER.msg("021108", (Object)("" + parameterMap.size()), (Object)("" + parameterValues.length)));
            }
        } else {
            for (int i = 0; i < parameterValues.length; ++i) {
                parameterMap.put(new Integer(i), parameterValues[i]);
            }
        }
        return parameterMap;
    }

    protected boolean useFetchPlan() {
        boolean useFetchPlan = this.getBooleanExtensionProperty("datanucleus.query.useFetchPlan", true);
        if (this.type == 1 || this.type == 2) {
            useFetchPlan = false;
        }
        return useFetchPlan;
    }

    protected void checkParameterTypesAgainstCompilation(Map parameterValues) {
        if (this.compilation != null) {
            SymbolTable symtbl = this.compilation.getSymbolTable();
            if (parameterValues != null && parameterValues.size() > 0) {
                for (Map.Entry entry : parameterValues.entrySet()) {
                    Object paramKey = entry.getKey();
                    Symbol sym = null;
                    if (paramKey instanceof Integer) {
                        ParameterExpression expr = this.compilation.getParameterExpressionForPosition((Integer)paramKey);
                        if (expr != null) {
                            sym = expr.getSymbol();
                        }
                    } else {
                        String paramName = (String)paramKey;
                        sym = symtbl.getSymbol(paramName);
                    }
                    if (sym != null) {
                        Class expectedValueType = sym.getValueType();
                        if (entry.getValue() == null || expectedValueType == null || QueryUtils.queryParameterTypesAreCompatible(expectedValueType, entry.getValue().getClass())) continue;
                        throw new NucleusUserException("Parameter \"" + paramKey + "\" was specified as " + entry.getValue().getClass().getName() + " but should have been " + expectedValueType.getName());
                    }
                    if (!(paramKey instanceof String)) continue;
                    throw new QueryInvalidParametersException(LOCALISER.msg("021116", paramKey));
                }
            }
        }
    }

    public class SubqueryDefinition {
        Query query;
        String candidateExpression;
        String variableDecl;
        Map parameterMap;

        public SubqueryDefinition(Query q, String candidates, String variables, Map params) {
            this.query = q;
            this.candidateExpression = candidates;
            this.variableDecl = variables;
            this.parameterMap = params;
        }

        public Query getQuery() {
            return this.query;
        }

        public String getCandidateExpression() {
            return this.candidateExpression;
        }

        public String getVariableDeclaration() {
            return this.variableDecl;
        }

        public Map getParameterMap() {
            return this.parameterMap;
        }
    }
}

