/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.datanucleus.mapping;

import com.google.appengine.datanucleus.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.store.mapped.DatastoreField;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.MappingCallbacks;
import org.datanucleus.store.mapped.mapping.MappingConsumer;
import org.datanucleus.store.mapped.mapping.PersistableMapping;
import org.datanucleus.store.mapped.mapping.ReferenceMapping;

public class InsertMappingConsumer
implements MappingConsumer {
    private final List<MappingCallbacks> mc = new ArrayList<MappingCallbacks>();
    private final Map<Integer, AbstractMemberMetaData> fieldIndexToMemberMetaData = Utils.newHashMap();
    private final AbstractClassMetaData cmd;
    private int numFields = 0;

    public InsertMappingConsumer(AbstractClassMetaData cmd) {
        this.cmd = cmd;
    }

    public void preConsumeMapping(int highestFieldNumber) {
    }

    public void consumeMapping(JavaTypeMapping m, AbstractMemberMetaData fmd) {
        if (!fmd.getAbstractClassMetaData().isSameOrAncestorOf(this.cmd)) {
            return;
        }
        if (m.getNumberOfDatastoreMappings() != 0 || !(m instanceof PersistableMapping) && !(m instanceof ReferenceMapping)) {
            if (fmd.hasExtension("insertable") && fmd.getValueForExtension("insertable").equalsIgnoreCase("false")) {
                return;
            }
            ColumnMetaData[] colmds = fmd.getColumnMetaData();
            if (colmds != null && colmds.length > 0) {
                for (ColumnMetaData colmd : colmds) {
                    if (colmd.getInsertable()) continue;
                    return;
                }
            }
        }
        this.fieldIndexToMemberMetaData.put(this.numFields++, fmd);
        if (m instanceof MappingCallbacks) {
            this.mc.add((MappingCallbacks)m);
        }
    }

    public void consumeMapping(JavaTypeMapping m, int mappingType) {
    }

    public void consumeUnmappedDatastoreField(DatastoreField fld) {
    }

    public List<MappingCallbacks> getMappingCallbacks() {
        return this.mc;
    }

    public AbstractMemberMetaData getMemberMetaDataForIndex(int index) {
        return this.fieldIndexToMemberMetaData.get(index);
    }

    public Map<Integer, AbstractMemberMetaData> getFieldIndexToMemberMetaData() {
        return this.fieldIndexToMemberMetaData;
    }
}

