/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.clearcast;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sun.reflect.Reflection;

public class ClearCast {
    public static <S, T> Caster<S, T> compileCaster(Class<S> source, Class<T> target) {
        return ClearCast.compileCaster(source, target, ClearCast.maybeSetClassLoader(new Options()));
    }

    public static <S, T> Caster<S, T> compileCaster(Class<S> source, Class<T> target, Options options) {
        return new CasterImpl<S, T>(source, target, ClearCast.maybeSetClassLoader(options));
    }

    public static <S, T> T cast(S source, Class<T> targetClass, Options options) {
        Class<?> sourceClass = source.getClass();
        return ClearCast.compileCaster(sourceClass, targetClass, ClearCast.maybeSetClassLoader(options)).cast(source);
    }

    public static <S, T> T cast(S source, Class<T> targetClass) {
        return ClearCast.cast(source, targetClass, ClearCast.maybeSetClassLoader(new Options()));
    }

    public static <S, T> T staticCast(Class<S> sourceClass, Class<T> targetClass, Options options) {
        return ClearCast.compileCaster(sourceClass, targetClass, ClearCast.maybeSetClassLoader(options)).cast(null);
    }

    public static <S, T> T staticCast(Class<S> sourceClass, Class<T> targetClass) {
        return ClearCast.staticCast(sourceClass, targetClass, ClearCast.maybeSetClassLoader(new Options()));
    }

    public static <S, T> T privateCast(S source, Class<T> targetClass) {
        return ClearCast.privateCast(source, targetClass, ClearCast.maybeSetClassLoader(new Options()));
    }

    public static <S, T> T privateCast(S source, Class<T> targetClass, Options options) {
        return ClearCast.cast(source, targetClass, ClearCast.maybeSetClassLoader(options.addCoercions(Coercion.Private)));
    }

    private static Options maybeSetClassLoader(Options options) {
        if (!options.loaderIsSet) {
            options.setLoader(AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    Class callerClass = Reflection.getCallerClass((int)6);
                    return callerClass.getClassLoader();
                }
            }));
        }
        return options;
    }

    private static class CasterImpl<S, T>
    implements Caster<S, T> {
        private Class<S> sourceClass;
        private Class<T> targetClass;
        private Options options;
        private Constructor proxyCons;
        Map<Method, AccessibleObject> refMap;

        public CasterImpl(Class<S> sourceClass, Class<T> targetClass, Options options) {
            this.sourceClass = sourceClass;
            this.targetClass = targetClass;
            this.options = options;
            this.constructProxy();
        }

        private void constructProxy() {
            HashMap<String, List<Method>> classMethodsByName = new HashMap<String, List<Method>>();
            CasterImpl.addMethods(classMethodsByName, CasterImpl.getDeclaredMethods(this.sourceClass));
            CasterImpl.addMethods(classMethodsByName, this.sourceClass.getMethods());
            HashMap<String, Field> classFieldsByName = new HashMap<String, Field>();
            this.getDeclaredFields(classFieldsByName);
            Method[] interfaceMethods = this.targetClass.getDeclaredMethods();
            this.refMap = new HashMap<Method, AccessibleObject>(interfaceMethods.length);
            for (Method m : interfaceMethods) {
                AccessibleObject match = CasterImpl.findMatch(classMethodsByName, classFieldsByName, m);
                if (match != null && !Modifier.isPublic(CasterImpl.getModifiers(match))) {
                    if (!this.options.coercions.contains((Object)Coercion.Private)) {
                        match = null;
                    } else {
                        try {
                            CasterImpl.setAccessible(match);
                        }
                        catch (SecurityException e) {
                            match = null;
                        }
                    }
                }
                if (match == null && !this.options.coercions.contains((Object)Coercion.Incomplete)) {
                    throw new IllegalArgumentException("Could not find a match for " + this.targetClass.getName() + "." + m.getName() + " in " + this.sourceClass.getName());
                }
                this.refMap.put(m, match);
            }
            Class<?> proxyClass = Proxy.getProxyClass(this.options.getLoader(), this.targetClass);
            try {
                this.proxyCons = proxyClass.getConstructor(InvocationHandler.class);
            }
            catch (NoSuchMethodException e) {
            }
            catch (Exception e) {
                throw new RuntimeException("Unexpected exception while compiling cast.", e);
            }
        }

        private void getDeclaredFields(Map<String, Field> classFieldsByName) {
            Field[] fields;
            for (Field f : fields = AccessController.doPrivileged(new PrivilegedAction<Field[]>(){

                @Override
                public Field[] run() {
                    try {
                        return CasterImpl.this.sourceClass.getDeclaredFields();
                    }
                    catch (SecurityException e) {
                        return new Field[0];
                    }
                }
            })) {
                classFieldsByName.put(f.getName(), f);
            }
        }

        @Override
        public T cast(S source) {
            if (source != null && !this.sourceClass.isAssignableFrom(source.getClass())) {
                throw new RuntimeException("Cast target must be of type, " + this.sourceClass);
            }
            try {
                return this.targetClass.cast(this.proxyCons.newInstance(new ProxyHandler(source)));
            }
            catch (Exception e) {
                throw new RuntimeException("Unexpected exception during cast.", e);
            }
        }

        private static AccessibleObject findMatch(Map<String, List<Method>> classMethodsByName, Map<String, Field> classFieldsByName, Method request) {
            if (request.getAnnotation(FieldRef.class) != null) {
                return classFieldsByName.get(request.getName());
            }
            List<Method> possibleMatches = classMethodsByName.get(request.getName());
            if (possibleMatches == null) {
                return null;
            }
            Object[] requestTypes = request.getParameterTypes();
            for (Method m : possibleMatches) {
                if (!Arrays.equals(requestTypes, m.getParameterTypes())) continue;
                return m;
            }
            return null;
        }

        private static Method[] getDeclaredMethods(final Class<?> objectClass) {
            return AccessController.doPrivileged(new PrivilegedAction<Method[]>(){

                @Override
                public Method[] run() {
                    try {
                        return objectClass.getDeclaredMethods();
                    }
                    catch (SecurityException e) {
                        return new Method[0];
                    }
                }
            });
        }

        private static void addMethods(Map<String, List<Method>> classMethodsByName, Method[] classMethods) {
            for (Method m : classMethods) {
                String name = m.getName();
                List<Method> methods = classMethodsByName.get(name);
                if (methods == null) {
                    methods = new ArrayList<Method>();
                    classMethodsByName.put(name, methods);
                }
                methods.add(m);
            }
        }

        private static int getModifiers(AccessibleObject obj) {
            if (obj instanceof Field) {
                return ((Field)obj).getModifiers();
            }
            if (obj instanceof Method) {
                return ((Method)obj).getModifiers();
            }
            throw new RuntimeException("Unexpected object type: " + obj.getClass());
        }

        private static void setAccessible(final AccessibleObject object) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    object.setAccessible(true);
                    return null;
                }
            });
        }

        private class ProxyHandler
        implements InvocationHandler {
            Object source;

            public ProxyHandler(Object source) {
                this.source = source;
            }

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Object dispatch;
                AccessibleObject targetObj = CasterImpl.this.refMap.get(method);
                if (targetObj == null) {
                    if (method.getDeclaringClass().equals(Object.class)) {
                        targetObj = method;
                    } else {
                        throw new UnsupportedOperationException(CasterImpl.this.sourceClass.getName() + " does not support " + method);
                    }
                }
                Object object = dispatch = Modifier.isStatic(CasterImpl.getModifiers(targetObj)) ? null : this.source;
                if (targetObj instanceof Field) {
                    return ((Field)targetObj).get(dispatch);
                }
                return ((Method)targetObj).invoke(dispatch, args);
            }
        }
    }

    public static interface Caster<S, T> {
        public T cast(S var1);
    }

    public static class Options {
        private Set<Coercion> coercions = EnumSet.noneOf(Coercion.class);
        private ClassLoader loader;
        private boolean loaderIsSet;

        public Options setLoader(ClassLoader loader) {
            this.loader = loader;
            this.loaderIsSet = true;
            return this;
        }

        public ClassLoader getLoader() {
            return this.loader;
        }

        public Options addCoercions(Coercion ... coercions) {
            this.coercions.addAll(Arrays.asList(coercions));
            return this;
        }

        public Set<Coercion> getCoercions() {
            return Collections.unmodifiableSet(this.coercions);
        }
    }

    public static enum Coercion {
        Private,
        Incomplete;

    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface FieldRef {
    }
}

