/**********************************************************************
Copyright (c) 2002 Mike Martin (TJDO) and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License. 
 

Contributors:
2002 Kelly Grizzle (TJDO)
2003 Andy Jefferson - commented and localised.
    ...
**********************************************************************/
package org.datanucleus.jdo.exceptions;

import javax.jdo.JDOUserException;

import org.datanucleus.ObjectManagerFactoryImpl;
import org.datanucleus.util.Localiser;

/**
 * An <tt>ConnectionInUseException</tt> is thrown if an operation is attempted
 * that requires a new database connection (such as Transaction.begin()) and a
 * previously obtained database connection (such as for non-transactional read
 * or write) is still in-use.
 *
 * @version $Revision: 1.1 $
 */
public class ConnectionInUseException extends JDOUserException
{
    private static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation",
        ObjectManagerFactoryImpl.class.getClassLoader());

    /**
     * Constructor.
     */
    public ConnectionInUseException()
    {
        super(LOCALISER.msg("009003"));
    }
}
