/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.datanucleus;

import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.DatastoreServiceConfig;
import com.google.appengine.datanucleus.DatastoreManager;
import com.google.appengine.datanucleus.DatastoreServiceFactoryInternal;
import com.google.appengine.datanucleus.DatastoreXAResource;
import com.google.appengine.datanucleus.EmulatedXAResource;
import com.google.appengine.datanucleus.WrappedDatastoreService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.transaction.xa.XAResource;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.Transaction;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.AbstractConnectionFactory;
import org.datanucleus.store.connection.ConnectionFactory;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.connection.ManagedConnectionResourceListener;
import org.datanucleus.util.NucleusLogger;

public class DatastoreConnectionFactoryImpl
extends AbstractConnectionFactory {
    public static final String AUTO_CREATE_TXNS_PROPERTY = "datanucleus.appengine.autoCreateDatastoreTxns";
    private final boolean isAutoCreateTransaction;

    public DatastoreConnectionFactoryImpl(StoreManager storeMgr, String resourceType) {
        super(storeMgr, resourceType);
        PersistenceConfiguration conf = storeMgr.getNucleusContext().getPersistenceConfiguration();
        if (conf.getProperty(AUTO_CREATE_TXNS_PROPERTY) == null) {
            conf.setProperty(AUTO_CREATE_TXNS_PROPERTY, (Object)Boolean.TRUE.toString());
        }
        this.isAutoCreateTransaction = conf.getBooleanProperty(AUTO_CREATE_TXNS_PROPERTY);
    }

    public void close() {
    }

    public ManagedConnection getConnection(Object poolKey, Transaction txn, Map options) {
        return this.storeMgr.getConnectionManager().allocateConnection((ConnectionFactory)this, poolKey, txn, options);
    }

    public ManagedConnection createManagedConnection(Object poolKey, Map transactionOptions) {
        return new DatastoreManagedConnection(this.storeMgr, this.isAutoCreateTransaction());
    }

    boolean isAutoCreateTransaction() {
        return this.isAutoCreateTransaction;
    }

    static class DatastoreManagedConnection
    implements ManagedConnection {
        private boolean managed = false;
        private boolean locked = false;
        private final List<ManagedConnectionResourceListener> listeners = new ArrayList<ManagedConnectionResourceListener>();
        private final XAResource datastoreXAResource;

        DatastoreManagedConnection(StoreManager storeMgr, boolean autoCreateTransaction) {
            DatastoreManager datastoreManager = (DatastoreManager)storeMgr;
            DatastoreServiceConfig config = datastoreManager.getDefaultDatastoreServiceConfigForWrites();
            DatastoreService datastoreService = DatastoreServiceFactoryInternal.getDatastoreService(config);
            if (NucleusLogger.CONNECTION.isDebugEnabled()) {
                if (datastoreService instanceof WrappedDatastoreService) {
                    NucleusLogger.CONNECTION.debug((Object)("Created ManagedConnection using DatastoreService = " + ((WrappedDatastoreService)datastoreService).getDelegate()));
                } else {
                    NucleusLogger.CONNECTION.debug((Object)("Created ManagedConnection using DatastoreService = " + datastoreService));
                }
            }
            this.datastoreXAResource = autoCreateTransaction ? new DatastoreXAResource(datastoreService, datastoreManager.getDefaultDatastoreTransactionOptions()) : new EmulatedXAResource(datastoreService);
        }

        public Object getConnection() {
            return ((EmulatedXAResource)this.datastoreXAResource).getDatastoreService();
        }

        public XAResource getXAResource() {
            return this.datastoreXAResource;
        }

        public void release() {
            if (!this.managed) {
                this.close();
            }
        }

        public void close() {
            ArrayList<ManagedConnectionResourceListener> resourceListeners = new ArrayList<ManagedConnectionResourceListener>(this.listeners);
            for (ManagedConnectionResourceListener listener : resourceListeners) {
                listener.managedConnectionPreClose();
            }
            for (ManagedConnectionResourceListener listener : resourceListeners) {
                listener.managedConnectionPostClose();
            }
        }

        public void setManagedResource() {
            this.managed = true;
        }

        public boolean isLocked() {
            return this.locked;
        }

        public void lock() {
            this.locked = true;
        }

        public void unlock() {
            this.locked = false;
        }

        public void transactionFlushed() {
            for (ManagedConnectionResourceListener listener : this.listeners) {
                listener.transactionFlushed();
            }
        }

        public void transactionPreClose() {
            for (ManagedConnectionResourceListener listener : this.listeners) {
                listener.transactionPreClose();
            }
        }

        public void addListener(ManagedConnectionResourceListener listener) {
            this.listeners.add(listener);
        }

        public void removeListener(ManagedConnectionResourceListener listener) {
            this.listeners.remove(listener);
        }
    }
}

