/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.query.compiler;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Map;
import java.util.Stack;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.query.compiler.Lexer;
import org.datanucleus.query.compiler.Parser;
import org.datanucleus.query.node.Node;
import org.datanucleus.query.node.ParameterNode;
import org.datanucleus.store.query.QueryCompilerSyntaxException;
import org.datanucleus.store.query.QueryInvalidParametersException;

public class JPQLParser
implements Parser {
    private Lexer p;
    private Stack<Node> stack = new Stack();
    private static String paramPrefixes = ":?";
    private ParameterType paramType = null;
    int parameterPosition = 0;

    public JPQLParser(Map options) {
    }

    public Node parse(String expression) {
        this.p = new Lexer(expression, paramPrefixes);
        this.stack = new Stack();
        Node result = this.processExpression();
        if (this.p.ci.getIndex() != this.p.ci.getEndIndex()) {
            String unparsed = this.p.getInput().substring(this.p.ci.getIndex());
            throw new QueryCompilerSyntaxException("Portion of expression could not be parsed: " + unparsed);
        }
        return result;
    }

    public Node parseVariable(String expression) {
        this.p = new Lexer(expression, paramPrefixes);
        this.stack = new Stack();
        if (!this.processIdentifier()) {
            throw new QueryCompilerSyntaxException("expected identifier", this.p.getIndex(), this.p.getInput());
        }
        if (!this.processIdentifier()) {
            throw new QueryCompilerSyntaxException("expected identifier", this.p.getIndex(), this.p.getInput());
        }
        Node nodeVariable = this.stack.pop();
        Node nodeType = this.stack.pop();
        nodeType.appendChildNode(nodeVariable);
        return nodeType;
    }

    public Node[] parseFrom(String expression) {
        this.p = new Lexer(expression, paramPrefixes);
        this.stack = new Stack();
        return this.processFromExpression();
    }

    public Node[] parseUpdate(String expression) {
        this.p = new Lexer(expression, paramPrefixes);
        this.stack = new Stack();
        return this.parseTupple(expression);
    }

    public Node[] parseOrder(String expression) {
        this.p = new Lexer(expression, paramPrefixes);
        this.stack = new Stack();
        return this.processOrderExpression();
    }

    public Node[] parseTupple(String expression) {
        this.p = new Lexer(expression, paramPrefixes);
        this.stack = new Stack();
        ArrayList<Node> nodes = new ArrayList<Node>();
        do {
            this.processExpression();
            Node expr = this.stack.pop();
            nodes.add(expr);
        } while (this.p.parseString(","));
        return nodes.toArray(new Node[nodes.size()]);
    }

    public Node[][] parseVariables(String expression) {
        this.p = new Lexer(expression, paramPrefixes);
        ArrayList<Node[]> nodes = new ArrayList<Node[]>();
        do {
            this.processPrimary();
            if (this.stack.isEmpty()) {
                throw new QueryCompilerSyntaxException("expected identifier", this.p.getIndex(), this.p.getInput());
            }
            if (!this.processIdentifier()) {
                throw new QueryCompilerSyntaxException("expected identifier", this.p.getIndex(), this.p.getInput());
            }
            Node nodeVariable = this.stack.pop();
            Node nodeType = this.stack.pop();
            nodes.add(new Node[]{nodeType, nodeVariable});
        } while (this.p.parseString(";"));
        return (Node[][])nodes.toArray((T[])new Node[nodes.size()][2]);
    }

    public Node[][] parseParameters(String expression) {
        this.p = new Lexer(expression, paramPrefixes);
        ArrayList<Node[]> nodes = new ArrayList<Node[]>();
        do {
            this.processPrimary();
            if (this.stack.isEmpty()) {
                throw new QueryCompilerSyntaxException("expected identifier", this.p.getIndex(), this.p.getInput());
            }
            if (!this.processIdentifier()) {
                throw new QueryCompilerSyntaxException("expected identifier", this.p.getIndex(), this.p.getInput());
            }
            Node nodeVariable = this.stack.pop();
            Node nodeType = this.stack.pop();
            nodes.add(new Node[]{nodeType, nodeVariable});
        } while (this.p.parseString(","));
        return (Node[][])nodes.toArray((T[])new Node[nodes.size()][2]);
    }

    private Node[] processFromExpression() {
        String candidateClassName = null;
        String candidateAlias = null;
        ArrayList<Node> nodes = new ArrayList<Node>();
        do {
            if (this.p.peekStringIgnoreCase("IN(") || this.p.peekStringIgnoreCase("IN ")) {
                Node joinedNode;
                this.p.parseStringIgnoreCase("IN");
                if (!this.p.parseChar('(')) {
                    throw new QueryCompilerSyntaxException("Expected: '(' but got " + this.p.remaining(), this.p.getIndex(), this.p.getInput());
                }
                String name = this.p.parseIdentifier();
                Node parentNode = joinedNode = new Node(3, name);
                if (this.p.nextIsDot()) {
                    this.p.parseChar('.');
                    Node subNode = new Node(3, this.p.parseName());
                    parentNode.appendChildNode(subNode);
                    parentNode = subNode;
                }
                if (!this.p.parseChar(')')) {
                    throw new QueryCompilerSyntaxException("Expected: ')' but got " + this.p.remaining(), this.p.getIndex(), this.p.getInput());
                }
                this.p.parseStringIgnoreCase("AS");
                String alias = this.p.parseIdentifier();
                Node classNode = new Node(6, candidateClassName);
                Node classAliasNode = new Node(2, candidateAlias);
                classNode.insertChildNode(classAliasNode);
                this.stack.push(classNode);
                Node joinNode = new Node(4, "JOIN_INNER");
                joinNode.appendChildNode(joinedNode);
                Node joinAliasNode = new Node(2, alias);
                joinNode.appendChildNode(joinAliasNode);
                classNode.appendChildNode(joinNode);
                this.processFromJoinExpression();
                nodes.add(classNode);
                continue;
            }
            this.processExpression();
            Node id = this.stack.pop();
            String className = id.getNodeValue().toString();
            while (id.getChildNodes().size() > 0) {
                id = id.getFirstChild();
                className = className + "." + id.getNodeValue().toString();
            }
            String alias = this.p.parseIdentifier();
            if (alias != null && alias.equalsIgnoreCase("AS")) {
                alias = this.p.parseIdentifier();
            }
            if (candidateClassName == null) {
                candidateClassName = className;
                candidateAlias = alias;
            }
            Node classNode = new Node(6, className);
            Node aliasNode = new Node(2, alias);
            classNode.insertChildNode(aliasNode);
            this.stack.push(classNode);
            this.processFromJoinExpression();
            nodes.add(classNode);
        } while (this.p.parseString(","));
        return nodes.toArray(new Node[nodes.size()]);
    }

    private void processFromJoinExpression() {
        Node candidateNode = this.stack.pop();
        boolean moreJoins = true;
        while (moreJoins) {
            boolean leftJoin = false;
            boolean innerJoin = false;
            if (this.p.parseStringIgnoreCase("INNER ")) {
                innerJoin = true;
            } else if (this.p.parseStringIgnoreCase("LEFT ")) {
                this.p.parseStringIgnoreCase("OUTER");
                leftJoin = true;
            }
            if (this.p.parseStringIgnoreCase("JOIN ")) {
                Node joinedNode;
                if (!innerJoin && !leftJoin) {
                    innerJoin = true;
                }
                boolean fetch = false;
                if (this.p.parseStringIgnoreCase("FETCH")) {
                    fetch = true;
                }
                String id = this.p.parseIdentifier();
                Node parentNode = joinedNode = new Node(3, id);
                while (this.p.nextIsDot()) {
                    this.p.parseChar('.');
                    Node subNode = new Node(3, this.p.parseName());
                    parentNode.appendChildNode(subNode);
                    parentNode = subNode;
                }
                this.p.parseStringIgnoreCase("AS ");
                String alias = this.p.parseName();
                String joinType = "JOIN_INNER";
                if (innerJoin) {
                    joinType = fetch ? "JOIN_INNER_FETCH" : "JOIN_INNER";
                } else if (leftJoin) {
                    joinType = fetch ? "JOIN_OUTER_FETCH" : "JOIN_OUTER";
                }
                Node joinNode = new Node(4, joinType);
                joinNode.appendChildNode(joinedNode);
                Node joinedAliasNode = new Node(2, alias);
                joinNode.appendChildNode(joinedAliasNode);
                candidateNode.appendChildNode(joinNode);
                continue;
            }
            if (innerJoin || leftJoin) {
                throw new NucleusUserException("Expected JOIN after INNER/LEFT keyword at" + this.p.remaining());
            }
            moreJoins = false;
        }
        this.stack.push(candidateNode);
    }

    private Node[] processOrderExpression() {
        ArrayList<Node> nodes = new ArrayList<Node>();
        do {
            Node expr;
            this.processExpression();
            if (this.p.parseStringIgnoreCase("asc")) {
                expr = new Node(4, "ascending");
                this.stack.push(expr);
            } else if (this.p.parseStringIgnoreCase("desc")) {
                expr = new Node(4, "descending");
                this.stack.push(expr);
            }
            expr = new Node(4, "order");
            expr.insertChildNode(this.stack.pop());
            if (!this.stack.empty()) {
                expr.insertChildNode(this.stack.pop());
            }
            nodes.add(expr);
        } while (this.p.parseString(","));
        return nodes.toArray(new Node[nodes.size()]);
    }

    private Node processExpression() {
        this.processOrExpression();
        return this.stack.peek();
    }

    private void processOrExpression() {
        this.processAndExpression();
        while (this.p.parseStringIgnoreCase("OR ")) {
            this.processAndExpression();
            Node expr = new Node(4, "||");
            expr.insertChildNode(this.stack.pop());
            expr.insertChildNode(this.stack.pop());
            this.stack.push(expr);
        }
    }

    private void processAndExpression() {
        this.processRelationalExpression();
        while (this.p.parseStringIgnoreCase("AND ")) {
            this.processRelationalExpression();
            Node expr = new Node(4, "&&");
            expr.insertChildNode(this.stack.pop());
            expr.insertChildNode(this.stack.pop());
            this.stack.push(expr);
        }
    }

    private void processRelationalExpression() {
        this.processAdditiveExpression();
        while (true) {
            Node betweenNode;
            Node rightNode;
            Node leftNode;
            Node upperNode;
            Node inputNode;
            Node expr;
            if (this.p.parseString("=")) {
                this.processAdditiveExpression();
                expr = new Node(4, "==");
                expr.insertChildNode(this.stack.pop());
                expr.insertChildNode(this.stack.pop());
                this.stack.push(expr);
                continue;
            }
            if (this.p.parseString("<>")) {
                this.processAdditiveExpression();
                expr = new Node(4, "!=");
                expr.insertChildNode(this.stack.pop());
                expr.insertChildNode(this.stack.pop());
                this.stack.push(expr);
                continue;
            }
            if (this.p.parseStringIgnoreCase("NOT ")) {
                if (this.p.parseStringIgnoreCase("BETWEEN ")) {
                    inputNode = this.stack.pop();
                    this.processAdditiveExpression();
                    Node lowerNode = this.stack.pop();
                    if (this.p.parseStringIgnoreCase("AND ")) {
                        this.processAdditiveExpression();
                        upperNode = this.stack.pop();
                        leftNode = new Node(4, "<");
                        leftNode.appendChildNode(inputNode);
                        leftNode.appendChildNode(lowerNode);
                        rightNode = new Node(4, ">");
                        rightNode.appendChildNode(inputNode);
                        rightNode.appendChildNode(upperNode);
                        betweenNode = new Node(4, "||");
                        betweenNode.appendChildNode(leftNode);
                        betweenNode.appendChildNode(rightNode);
                        this.stack.push(betweenNode);
                        continue;
                    }
                    throw new NucleusUserException("Query has BETWEEN keyword with no AND clause");
                }
                if (this.p.parseStringIgnoreCase("LIKE ")) {
                    this.processLikeExpression();
                    Node notNode = new Node(4, "!");
                    notNode.insertChildNode(this.stack.pop());
                    this.stack.push(notNode);
                    continue;
                }
                if (this.p.parseStringIgnoreCase("IN")) {
                    this.processInExpression(true);
                    continue;
                }
                if (this.p.parseStringIgnoreCase("MEMBER ")) {
                    this.processMemberExpression(true);
                    continue;
                }
                throw new NucleusException("Unsupported query syntax NOT followed by unsupported keyword");
            }
            if (this.p.parseStringIgnoreCase("BETWEEN ")) {
                inputNode = this.stack.pop();
                this.processAdditiveExpression();
                Node lowerNode = this.stack.pop();
                if (this.p.parseStringIgnoreCase("AND ")) {
                    this.processAdditiveExpression();
                    upperNode = this.stack.pop();
                    leftNode = new Node(4, ">=");
                    leftNode.appendChildNode(inputNode);
                    leftNode.appendChildNode(lowerNode);
                    rightNode = new Node(4, "<=");
                    rightNode.appendChildNode(inputNode);
                    rightNode.appendChildNode(upperNode);
                    betweenNode = new Node(4, "&&");
                    betweenNode.appendChildNode(rightNode);
                    betweenNode.appendChildNode(leftNode);
                    this.stack.push(betweenNode);
                    continue;
                }
                throw new NucleusUserException("Query has BETWEEN keyword with no AND clause");
            }
            if (this.p.parseStringIgnoreCase("LIKE ")) {
                this.processLikeExpression();
                continue;
            }
            if (this.p.parseStringIgnoreCase("IN")) {
                this.processInExpression(false);
                continue;
            }
            if (this.p.parseStringIgnoreCase("MEMBER ")) {
                this.processMemberExpression(false);
                continue;
            }
            if (this.p.parseStringIgnoreCase("IS ")) {
                Node isNode;
                inputNode = this.stack.pop();
                boolean not = false;
                if (this.p.parseStringIgnoreCase("NOT ")) {
                    not = true;
                }
                if (this.p.parseStringIgnoreCase("NULL")) {
                    isNode = new Node(4, not ? "!=" : "==");
                    Node compareNode = new Node(0, null);
                    isNode.insertChildNode(compareNode);
                    isNode.insertChildNode(inputNode);
                    this.stack.push(isNode);
                    continue;
                }
                if (this.p.parseStringIgnoreCase("EMPTY")) {
                    isNode = new Node(1, "isEmpty");
                    inputNode.insertChildNode(isNode);
                    if (not) {
                        Node notExpr = new Node(4, "!");
                        notExpr.insertChildNode(inputNode);
                        this.stack.push(notExpr);
                        continue;
                    }
                    this.stack.push(inputNode);
                    continue;
                }
                throw new NucleusException("Encountered IS " + (not ? "NOT " : " ") + " that should be followed by NULL | EMPTY but isnt");
            }
            if (this.p.parseString("<=")) {
                this.processAdditiveExpression();
                expr = new Node(4, "<=");
                expr.insertChildNode(this.stack.pop());
                expr.insertChildNode(this.stack.pop());
                this.stack.push(expr);
                continue;
            }
            if (this.p.parseString(">=")) {
                this.processAdditiveExpression();
                expr = new Node(4, ">=");
                expr.insertChildNode(this.stack.pop());
                expr.insertChildNode(this.stack.pop());
                this.stack.push(expr);
                continue;
            }
            if (this.p.parseChar('<')) {
                this.processAdditiveExpression();
                expr = new Node(4, "<");
                expr.insertChildNode(this.stack.pop());
                expr.insertChildNode(this.stack.pop());
                this.stack.push(expr);
                continue;
            }
            if (!this.p.parseChar('>')) break;
            this.processAdditiveExpression();
            expr = new Node(4, ">");
            expr.insertChildNode(this.stack.pop());
            expr.insertChildNode(this.stack.pop());
            this.stack.push(expr);
        }
    }

    private void processLikeExpression() {
        Node primaryNode = this.stack.pop();
        if (primaryNode.getNodeType() == 3) {
            while (primaryNode.getFirstChild() != null) {
                primaryNode = primaryNode.getFirstChild();
            }
        }
        this.processAdditiveExpression();
        Node likeExprNode = this.stack.pop();
        if (this.p.parseStringIgnoreCase("ESCAPE")) {
            this.processAdditiveExpression();
            this.stack.pop();
            Node matchesNode = new Node(1, "matches");
            matchesNode.addProperty(likeExprNode);
            primaryNode.appendChildNode(matchesNode);
            this.stack.push(primaryNode);
        } else {
            Node matchesNode = new Node(1, "matches");
            matchesNode.addProperty(likeExprNode);
            primaryNode.appendChildNode(matchesNode);
            this.stack.push(primaryNode);
        }
    }

    private void processInExpression(boolean not) {
        Node inputNode = this.stack.pop();
        if (!this.p.parseChar('(')) {
            Node inNode = new Node(10, "IN");
            this.processExpression();
            Node subqueryNode = this.stack.pop();
            inNode.appendChildNode(subqueryNode);
            this.stack.push(inNode);
            return;
        }
        Node inNode = null;
        do {
            this.processPrimary();
            if (this.stack.peek() == null) {
                throw new QueryCompilerSyntaxException("Expected literal|parameter but got " + this.p.remaining(), this.p.getIndex(), this.p.getInput());
            }
            Node valueNode = this.stack.pop();
            Node compareNode = new Node(4, not ? "!=" : "==");
            compareNode.appendChildNode(inputNode);
            compareNode.appendChildNode(valueNode);
            if (inNode == null) {
                inNode = compareNode;
                continue;
            }
            Node newInNode = new Node(4, not ? "&&" : "||");
            newInNode.appendChildNode(inNode);
            newInNode.appendChildNode(compareNode);
            inNode = newInNode;
        } while (this.p.parseChar(','));
        if (!this.p.parseChar(')')) {
            throw new QueryCompilerSyntaxException("Expected: ')' but got " + this.p.remaining(), this.p.getIndex(), this.p.getInput());
        }
        this.stack.push(inNode);
    }

    private void processMemberExpression(boolean not) {
        Node inputNode = this.stack.pop();
        this.p.parseStringIgnoreCase("OF");
        this.processPrimary();
        Node containerNode = this.stack.peek();
        while (containerNode.getFirstChild() != null) {
            containerNode = containerNode.getFirstChild();
        }
        if (not) {
            Node notNode = new Node(4, "!");
            this.stack.pop();
            notNode.insertChildNode(containerNode);
            this.stack.push(notNode);
        }
        Node containsNode = new Node(1, "contains");
        containsNode.addProperty(inputNode);
        containerNode.appendChildNode(containsNode);
    }

    protected void processAdditiveExpression() {
        this.processMultiplicativeExpression();
        while (true) {
            Node expr;
            if (this.p.parseChar('+')) {
                this.processMultiplicativeExpression();
                expr = new Node(4, "+");
                expr.insertChildNode(this.stack.pop());
                expr.insertChildNode(this.stack.pop());
                this.stack.push(expr);
                continue;
            }
            if (!this.p.parseChar('-')) break;
            this.processMultiplicativeExpression();
            expr = new Node(4, "-");
            expr.insertChildNode(this.stack.pop());
            expr.insertChildNode(this.stack.pop());
            this.stack.push(expr);
        }
    }

    protected void processMultiplicativeExpression() {
        this.processUnaryExpression();
        while (true) {
            Node expr;
            if (this.p.parseChar('*')) {
                this.processMultiplicativeExpression();
                expr = new Node(4, "*");
                expr.insertChildNode(this.stack.pop());
                expr.insertChildNode(this.stack.pop());
                this.stack.push(expr);
                continue;
            }
            if (this.p.parseChar('/')) {
                this.processMultiplicativeExpression();
                expr = new Node(4, "/");
                expr.insertChildNode(this.stack.pop());
                expr.insertChildNode(this.stack.pop());
                this.stack.push(expr);
                continue;
            }
            if (!this.p.parseChar('%')) break;
            this.processMultiplicativeExpression();
            expr = new Node(4, "%");
            expr.insertChildNode(this.stack.pop());
            expr.insertChildNode(this.stack.pop());
            this.stack.push(expr);
        }
    }

    protected void processUnaryExpression() {
        if (this.p.parseString("++")) {
            throw new NucleusUserException("Unsupported operator '++'");
        }
        if (this.p.parseString("--")) {
            throw new NucleusUserException("Unsupported operator '--'");
        }
        if (this.p.parseChar('+')) {
            this.processUnaryExpression();
        } else if (this.p.parseChar('-')) {
            this.processUnaryExpression();
            Node expr = new Node(4, "-");
            expr.insertChildNode(this.stack.pop());
            this.stack.push(expr);
        } else if (this.p.parseStringIgnoreCase("NOT ")) {
            this.processUnaryExpression();
            Node expr = new Node(4, "!");
            expr.insertChildNode(this.stack.pop());
            this.stack.push(expr);
        } else {
            this.processPrimary();
        }
    }

    protected void processPrimary() {
        if (this.p.parseStringIgnoreCase("CURRENT_DATE")) {
            Node expr = new Node(1, "CURRENT_DATE");
            this.stack.push(expr);
            return;
        }
        if (this.p.parseStringIgnoreCase("CURRENT_TIMESTAMP")) {
            Node expr = new Node(1, "CURRENT_TIMESTAMP");
            this.stack.push(expr);
            return;
        }
        if (this.p.parseStringIgnoreCase("CURRENT_TIME")) {
            Node expr = new Node(1, "CURRENT_TIME");
            this.stack.push(expr);
            return;
        }
        if (this.p.parseStringIgnoreCase("DISTINCT ")) {
            Node distinctNode = new Node(4, "DISTINCT");
            this.processIdentifier();
            Node identifierNode = this.stack.pop();
            distinctNode.appendChildNode(identifierNode);
            this.stack.push(distinctNode);
            return;
        }
        if (this.processCreator() || this.processLiteral() || this.processMethod()) {
            return;
        }
        if (this.p.parseChar('(')) {
            this.processExpression();
            if (!this.p.parseChar(')')) {
                throw new QueryCompilerSyntaxException("expected ')'", this.p.getIndex(), this.p.getInput());
            }
            return;
        }
        if (!this.processIdentifier()) {
            throw new QueryCompilerSyntaxException("Identifier expected", this.p.getIndex(), this.p.getInput());
        }
        int size = this.stack.size();
        while (this.p.parseChar('.')) {
            if (this.processMethod() || this.processIdentifier()) continue;
            throw new QueryCompilerSyntaxException("Identifier expected", this.p.getIndex(), this.p.getInput());
        }
        while (this.stack.size() > size) {
            Node top = this.stack.pop();
            Node peek = this.stack.peek();
            peek.insertChildNode(top);
        }
    }

    private boolean processCreator() {
        if (this.p.parseStringIgnoreCase("NEW ")) {
            int size = this.stack.size();
            if (!this.processMethod()) {
                if (!this.processIdentifier()) {
                    throw new QueryCompilerSyntaxException("Identifier expected", this.p.getIndex(), this.p.getInput());
                }
                while (this.p.parseChar('.')) {
                    if (this.processMethod() || this.processIdentifier()) continue;
                    throw new QueryCompilerSyntaxException("Identifier expected", this.p.getIndex(), this.p.getInput());
                }
            }
            while (this.stack.size() - 1 > size) {
                Node top = this.stack.pop();
                Node peek = this.stack.peek();
                peek.insertChildNode(top);
            }
            Node expr = this.stack.pop();
            Node newExpr = new Node(5);
            newExpr.insertChildNode(expr);
            this.stack.push(newExpr);
            return true;
        }
        return false;
    }

    private boolean processMethod() {
        String method = this.p.parseMethod();
        if (method != null) {
            this.p.skipWS();
            this.p.parseChar('(');
            if (method.equals("Object")) {
                this.processExpression();
                if (!this.p.parseChar(')')) {
                    throw new QueryCompilerSyntaxException("')' expected", this.p.getIndex(), this.p.getInput());
                }
                return true;
            }
            if (method.equalsIgnoreCase("EXISTS")) {
                Node existsNode = new Node(10, "EXISTS");
                this.processExpression();
                Node subqueryNode = this.stack.pop();
                existsNode.appendChildNode(subqueryNode);
                this.stack.push(existsNode);
                if (!this.p.parseChar(')')) {
                    throw new QueryCompilerSyntaxException("')' expected", this.p.getIndex(), this.p.getInput());
                }
                return true;
            }
            if (method.equalsIgnoreCase("ANY")) {
                Node existsNode = new Node(10, "ANY");
                this.processExpression();
                Node subqueryNode = this.stack.pop();
                existsNode.appendChildNode(subqueryNode);
                this.stack.push(existsNode);
                if (!this.p.parseChar(')')) {
                    throw new QueryCompilerSyntaxException("')' expected", this.p.getIndex(), this.p.getInput());
                }
                return true;
            }
            if (method.equalsIgnoreCase("ALL")) {
                Node existsNode = new Node(10, "ALL");
                this.processExpression();
                Node subqueryNode = this.stack.pop();
                existsNode.appendChildNode(subqueryNode);
                this.stack.push(existsNode);
                if (!this.p.parseChar(')')) {
                    throw new QueryCompilerSyntaxException("')' expected", this.p.getIndex(), this.p.getInput());
                }
                return true;
            }
            if (method.equalsIgnoreCase("SOME")) {
                Node existsNode = new Node(10, "SOME");
                this.processExpression();
                Node subqueryNode = this.stack.pop();
                existsNode.appendChildNode(subqueryNode);
                this.stack.push(existsNode);
                if (!this.p.parseChar(')')) {
                    throw new QueryCompilerSyntaxException("')' expected", this.p.getIndex(), this.p.getInput());
                }
                return true;
            }
            if (method.equalsIgnoreCase("SUBSTRING")) {
                Node invokeNode = new Node(1, "substring");
                this.processExpression();
                Node primaryNode = this.stack.pop();
                if (!this.p.parseChar(',')) {
                    throw new QueryCompilerSyntaxException("',' expected", this.p.getIndex(), this.p.getInput());
                }
                this.processExpression();
                Node arg1 = this.stack.pop();
                Node oneNode = new Node(0, 1);
                Node arg1Node = new Node(4, "-");
                arg1Node.insertChildNode(arg1);
                arg1Node.appendChildNode(oneNode);
                if (this.p.parseChar(',')) {
                    this.processExpression();
                    Node arg2 = this.stack.pop();
                    Node arg2Node = new Node(4, "+");
                    arg2Node.appendChildNode(arg2);
                    arg2Node.appendChildNode(arg1Node);
                    if (!this.p.parseChar(')')) {
                        throw new QueryCompilerSyntaxException("')' expected", this.p.getIndex(), this.p.getInput());
                    }
                    primaryNode.appendChildNode(invokeNode);
                    invokeNode.addProperty(arg1Node);
                    invokeNode.addProperty(arg2Node);
                    this.stack.push(primaryNode);
                    return true;
                }
                if (this.p.parseChar(')')) {
                    primaryNode.appendChildNode(invokeNode);
                    invokeNode.addProperty(arg1Node);
                    this.stack.push(primaryNode);
                    return true;
                }
                throw new QueryCompilerSyntaxException("')' expected", this.p.getIndex(), this.p.getInput());
            }
            if (method.equalsIgnoreCase("UPPER")) {
                Node invokeNode = new Node(1, "toUpperCase");
                this.processExpression();
                Node primaryNode = this.stack.pop();
                if (!this.p.parseChar(')')) {
                    throw new QueryCompilerSyntaxException("',' expected", this.p.getIndex(), this.p.getInput());
                }
                primaryNode.appendChildNode(invokeNode);
                this.stack.push(primaryNode);
                return true;
            }
            if (method.equalsIgnoreCase("LOWER")) {
                Node invokeNode = new Node(1, "toLowerCase");
                this.processExpression();
                Node primaryNode = this.stack.pop();
                if (!this.p.parseChar(')')) {
                    throw new QueryCompilerSyntaxException("',' expected", this.p.getIndex(), this.p.getInput());
                }
                primaryNode.appendChildNode(invokeNode);
                this.stack.push(primaryNode);
                return true;
            }
            if (method.equalsIgnoreCase("LENGTH")) {
                Node invokeNode = new Node(1, "length");
                this.processExpression();
                Node primaryNode = this.stack.pop();
                if (!this.p.parseChar(')')) {
                    throw new QueryCompilerSyntaxException("',' expected", this.p.getIndex(), this.p.getInput());
                }
                primaryNode.appendChildNode(invokeNode);
                this.stack.push(primaryNode);
                return true;
            }
            if (method.equalsIgnoreCase("CONCAT")) {
                this.processExpression();
                Node prevNode = this.stack.pop();
                while (true) {
                    if (!this.p.parseChar(',')) {
                        throw new QueryCompilerSyntaxException("',' expected", this.p.getIndex(), this.p.getInput());
                    }
                    this.processExpression();
                    Node thisNode = this.stack.pop();
                    Node currentNode = new Node(4, "+");
                    currentNode.appendChildNode(prevNode);
                    currentNode.appendChildNode(thisNode);
                    if (this.p.parseChar(')')) {
                        this.stack.push(currentNode);
                        return true;
                    }
                    prevNode = currentNode;
                    currentNode = null;
                }
            }
            if (method.equalsIgnoreCase("LOCATE")) {
                this.processExpression();
                Node searchNode = this.stack.pop();
                if (!this.p.parseChar(',')) {
                    throw new QueryCompilerSyntaxException("',' expected", this.p.getIndex(), this.p.getInput());
                }
                this.processExpression();
                Node primaryNode = this.stack.pop();
                Node invokeNode = new Node(1, "indexOf");
                invokeNode.addProperty(searchNode);
                Node oneNode = new Node(0, 1);
                if (this.p.parseChar(',')) {
                    this.processExpression();
                    Node fromPosNode = this.stack.pop();
                    Node positionNode = new Node(4, "-");
                    positionNode.appendChildNode(fromPosNode);
                    positionNode.appendChildNode(oneNode);
                    invokeNode.addProperty(positionNode);
                }
                if (!this.p.parseChar(')')) {
                    throw new QueryCompilerSyntaxException("')' expected", this.p.getIndex(), this.p.getInput());
                }
                primaryNode.appendChildNode(invokeNode);
                Node locateNode = new Node(4, "+");
                locateNode.appendChildNode(primaryNode);
                locateNode.appendChildNode(oneNode);
                this.stack.push(locateNode);
                return true;
            }
            if (method.equalsIgnoreCase("TRIM")) {
                String methodName = "trim";
                if (this.p.parseStringIgnoreCase("LEADING")) {
                    methodName = "trimLeft";
                } else if (this.p.parseStringIgnoreCase("TRAILING")) {
                    methodName = "trimRight";
                } else if (this.p.parseStringIgnoreCase("BOTH")) {
                    // empty if block
                }
                Node invokeNode = new Node(1, methodName);
                Node trimCharNode = null;
                this.processExpression();
                Node next = this.stack.pop();
                if (this.p.parseChar(')')) {
                    next.appendChildNode(invokeNode);
                    this.stack.push(next);
                    return true;
                }
                if (next.getNodeType() == 3) {
                    Object litValue = next.getNodeValue();
                    if (litValue instanceof String && ((String)litValue).equals("FROM")) {
                        this.processExpression();
                        next = this.stack.pop();
                    } else {
                        trimCharNode = next;
                        if (this.p.parseStringIgnoreCase("FROM ")) {
                            // empty if block
                        }
                        this.processExpression();
                        next = this.stack.pop();
                    }
                }
                if (!this.p.parseChar(')')) {
                    throw new QueryCompilerSyntaxException("')' expected", this.p.getIndex(), this.p.getInput());
                }
                next.appendChildNode(invokeNode);
                if (trimCharNode != null) {
                    invokeNode.addProperty(trimCharNode);
                }
                this.stack.push(next);
                return true;
            }
            if (method.equalsIgnoreCase("SIZE")) {
                Node invokeNode = new Node(1, "size");
                this.processExpression();
                Node primaryNode = this.stack.pop();
                if (!this.p.parseChar(')')) {
                    throw new QueryCompilerSyntaxException("',' expected", this.p.getIndex(), this.p.getInput());
                }
                primaryNode.appendChildNode(invokeNode);
                this.stack.push(primaryNode);
                return true;
            }
            if (method.equalsIgnoreCase("KEY")) {
                Node invokeNode = new Node(1, "mapKey");
                this.processExpression();
                Node primaryNode = this.stack.pop();
                if (!this.p.parseChar(')')) {
                    throw new QueryCompilerSyntaxException("',' expected", this.p.getIndex(), this.p.getInput());
                }
                primaryNode.appendChildNode(invokeNode);
                this.stack.push(primaryNode);
                return true;
            }
            if (method.equalsIgnoreCase("VALUE")) {
                Node invokeNode = new Node(1, "mapValue");
                this.processExpression();
                Node primaryNode = this.stack.pop();
                if (!this.p.parseChar(')')) {
                    throw new QueryCompilerSyntaxException("',' expected", this.p.getIndex(), this.p.getInput());
                }
                primaryNode.appendChildNode(invokeNode);
                this.stack.push(primaryNode);
                return true;
            }
            if (method.equalsIgnoreCase("ENTRY")) {
                Node invokeNode = new Node(1, "mapEntry");
                this.processExpression();
                Node primaryNode = this.stack.pop();
                if (!this.p.parseChar(')')) {
                    throw new QueryCompilerSyntaxException("',' expected", this.p.getIndex(), this.p.getInput());
                }
                primaryNode.appendChildNode(invokeNode);
                this.stack.push(primaryNode);
                return true;
            }
            Node expr = new Node(1, method);
            if (!this.p.parseChar(')')) {
                do {
                    this.processExpression();
                    expr.addProperty(this.stack.pop());
                } while (this.p.parseChar(','));
                if (!this.p.parseChar(')')) {
                    throw new QueryCompilerSyntaxException("')' expected", this.p.getIndex(), this.p.getInput());
                }
            }
            this.stack.push(expr);
            return true;
        }
        return false;
    }

    protected boolean processLiteral() {
        Object litValue = null;
        boolean single_quote_next = this.p.nextIsSingleQuote();
        String sLiteral = this.p.parseStringLiteral();
        if (sLiteral != null) {
            litValue = sLiteral.length() == 1 && single_quote_next ? new Character(sLiteral.charAt(0)) : sLiteral;
        } else {
            BigDecimal fLiteral = this.p.parseFloatingPointLiteral();
            if (fLiteral != null) {
                litValue = fLiteral;
            } else {
                BigInteger iLiteral = this.p.parseIntegerLiteral();
                if (iLiteral != null) {
                    litValue = new Long(iLiteral.longValue());
                } else {
                    Boolean bLiteral = this.p.parseBooleanLiteralIgnoreCase();
                    if (bLiteral != null) {
                        litValue = bLiteral;
                    } else if (this.p.parseNullLiteralIgnoreCase()) {
                        litValue = null;
                    } else {
                        return false;
                    }
                }
            }
        }
        this.stack.push(new Node(0, litValue));
        return true;
    }

    private boolean processIdentifier() {
        String id = this.p.parseIdentifier();
        if (id == null || id.length() == 0) {
            return false;
        }
        char first = id.charAt(0);
        if (first == '?') {
            if (this.paramType == null) {
                this.paramType = ParameterType.NUMBERED;
            } else if (this.paramType == ParameterType.NAMED) {
                throw new QueryInvalidParametersException("Query is using named parameters yet also has \"" + id + "\"");
            }
            String paramName = id.substring(1);
            try {
                ParameterNode expr = new ParameterNode(7, new Integer(paramName), this.parameterPosition);
                ++this.parameterPosition;
                this.stack.push(expr);
                return true;
            }
            catch (NumberFormatException nfe) {
                throw new NucleusUserException("Numbered parameter syntax starting ? but isnt followed by numeric!");
            }
        }
        if (first == ':') {
            if (this.paramType == null) {
                this.paramType = ParameterType.NAMED;
            } else if (this.paramType == ParameterType.NUMBERED) {
                throw new QueryInvalidParametersException("Query is using numbered parameters yet also has \"" + id + "\"");
            }
            ParameterNode expr = new ParameterNode(7, id.substring(1), this.parameterPosition);
            ++this.parameterPosition;
            this.stack.push(expr);
            return true;
        }
        Node expr = new Node(3, id);
        this.stack.push(expr);
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ParameterType {
        NUMBERED,
        NAMED;

    }
}

