/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.appengv3.converter;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.base.Strings;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.cloud.datastore.core.rep.IndexValue;
import com.google.cloud.datastore.core.rep.Value;
import com.google.cloud.datastore.core.rep.converter.ConverterHelper;
import com.google.storage.onestore.v3.OnestoreEntity;

public class AppEngV3IndexValueFromRepConverter {
    public static final AppEngV3IndexValueFromRepConverter INSTANCE = new AppEngV3IndexValueFromRepConverter();

    private AppEngV3IndexValueFromRepConverter() {
    }

    public OnestoreEntity.PropertyValue convertIndexValue(IndexValue indexValue) {
        Preconditions.checkArgument((!indexValue.isDeepTruncated() ? 1 : 0) != 0);
        OnestoreEntity.PropertyValue result = new OnestoreEntity.PropertyValue();
        switch (indexValue.type()) {
            case NULL: {
                break;
            }
            case BOOLEAN: {
                result.setBooleanValue(indexValue.asBoolean());
                break;
            }
            case NUMBER: {
                if (indexValue.isNumberDouble()) {
                    result.setDoubleValue(indexValue.asNumberDouble());
                    break;
                }
                result.setInt64Value(indexValue.asNumberLong());
                break;
            }
            case BYTES: {
                result.setStringValueAsBytes(indexValue.asBytes().toByteArray());
                break;
            }
            case ENTITY_REF: {
                result.setReferenceValue(this.convertReferenceValue(indexValue.asEntityRef()));
                break;
            }
            case GEO_POINT: {
                result.getMutablePointValue().setX(indexValue.asGeoPoint().getLatitude()).setY(indexValue.asGeoPoint().getLongitude());
                break;
            }
            case LEGACY_USER: {
                result.setUserValue(this.convertLegacyUserValue(indexValue.asLegacyUser()));
                break;
            }
            case STRING: 
            case TIMESTAMP: 
            case ABSENT_TYPE: 
            case ARRAY: 
            case MAP: {
                String string = String.valueOf((Object)indexValue.type());
                throw new IllegalArgumentException(new StringBuilder(40 + String.valueOf(string).length()).append("Invalid type for Datastore index value: ").append(string).toString());
            }
        }
        return result;
    }

    private OnestoreEntity.PropertyValue.ReferenceValue convertReferenceValue(IndexValue.EntityRef ref) {
        Preconditions.checkArgument((!ref.namespaceId().isDeepTruncated() ? 1 : 0) != 0);
        Preconditions.checkArgument((!ref.segments().isDeepTruncated() ? 1 : 0) != 0);
        OnestoreEntity.PropertyValue.ReferenceValue v3Ref = new OnestoreEntity.PropertyValue.ReferenceValue();
        v3Ref.setApp(ref.databaseRef().appId());
        if (!Strings.isNullOrEmpty((String)ref.databaseRef().databaseId())) {
            v3Ref.setDatabaseId(ref.databaseRef().databaseId());
        }
        if (!Strings.isNullOrEmpty((String)ref.namespaceId().asString())) {
            v3Ref.setNameSpace(ref.namespaceId().asString());
        }
        ImmutableList<IndexValue> segments = ref.segments().asArray();
        for (int i = 0; i < segments.size(); i += 2) {
            OnestoreEntity.PropertyValue.ReferenceValuePathElement element = v3Ref.addPathElement();
            element.setTypeAsBytes(ConverterHelper.convertStringToBytesUnchecked("kind", ((IndexValue)segments.get(i)).asString()));
            if (i + 1 >= segments.size()) continue;
            IndexValue resourceId = (IndexValue)segments.get(i + 1);
            if (resourceId.type() == IndexValue.Type.NUMBER) {
                element.setId(resourceId.asNumberLong());
                continue;
            }
            element.setNameAsBytes(ConverterHelper.convertStringToBytesUnchecked("resource id", resourceId.asString()));
        }
        return v3Ref;
    }

    private OnestoreEntity.PropertyValue.UserValue convertLegacyUserValue(Value.LegacyUser user) {
        OnestoreEntity.PropertyValue.UserValue v3User = new OnestoreEntity.PropertyValue.UserValue();
        v3User.setEmail(user.email());
        v3User.setAuthDomain(user.authDomain());
        v3User.setGaiaid(0L);
        if (!user.obfuscatedGaiaId().isEmpty()) {
            v3User.setObfuscatedGaiaid(user.obfuscatedGaiaId());
        }
        if (user.federatedIdentity() != null) {
            v3User.setFederatedIdentity(user.federatedIdentity());
        }
        if (user.federatedProvider() != null) {
            v3User.setFederatedProvider(user.federatedProvider());
        }
        return v3User;
    }
}

