/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.config.jsonwriter;

import com.google.api.server.spi.config.ApiConfig;
import com.google.api.server.spi.config.ResourceSchema;
import com.google.api.server.spi.config.ResourceTransformer;
import com.google.api.server.spi.config.Serializers;
import com.google.api.server.spi.config.Transformer;
import com.google.api.server.spi.config.jsonwriter.ResourceSchemaProvider;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;

abstract class AbstractResourceSchemaProvider
implements ResourceSchemaProvider {
    AbstractResourceSchemaProvider() {
    }

    @Override
    public @Nullable ResourceSchema getResourceSchema(Class<?> clazz, ApiConfig config) {
        return this.getResourceSchemaImpl(clazz, config);
    }

    private <T> @Nullable ResourceSchema getResourceSchemaImpl(Class<T> clazz, ApiConfig config) {
        List<Class<Transformer<?, ?>>> serializerClasses = Serializers.getSerializerClasses(clazz, config.getSerializationConfig());
        if (!serializerClasses.isEmpty() && ResourceTransformer.class.isAssignableFrom(serializerClasses.get(0))) {
            ResourceTransformer resourceSerializer = (ResourceTransformer)Serializers.instantiate(serializerClasses.get(0), clazz);
            return resourceSerializer.getResourceSchema();
        }
        return null;
    }
}

