/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.DatagramSocket;
import java.net.DatagramSocketImpl;
import java.net.DatagramSocketImplFactory;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketImpl;
import java.net.SocketImplFactory;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class DevSocketImplFactory
implements SocketImplFactory,
DatagramSocketImplFactory {
    private static final ThreadLocal<Boolean> nativeSocketMode = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return true;
        }
    };
    private static final Constructor<?> SOCKS_SOCKET_IMPL_CONSTRUCTOR;
    private static final Method CREATE_DATAGRAM_SOCKET_IMPL;
    private static final Constructor<?> DATAGRAM_SOCKET_IMPL_CONSTRUCTOR;
    private static SocketImplFactory appEngineSocketImplFactory;
    private static DatagramSocketImplFactory appEngineDatagramSocketImplFactory;
    private static boolean isInstalled;
    private static DevSocketImplFactory instance;
    private static boolean override;

    private DevSocketImplFactory() {
    }

    private static Method getDefaultCreateDatagramSocketImplMethod() {
        Method method;
        try {
            method = Class.forName("java.net.DefaultDatagramSocketImplFactory").getDeclaredMethod("createDatagramSocketImpl", Boolean.TYPE);
        }
        catch (SecurityException e) {
            throw new IllegalStateException(e);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        method.setAccessible(true);
        return method;
    }

    private static void setInstance(DevSocketImplFactory instance) {
        DevSocketImplFactory.instance = instance;
    }

    public static void install() {
        if (isInstalled) {
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                DevSocketImplFactory socketFactory = new DevSocketImplFactory();
                DevSocketImplFactory.setInstance(socketFactory);
                try {
                    Socket.setSocketImplFactory(socketFactory);
                }
                catch (IOException e) {
                    throw new IllegalStateException("setSocketImplFactory failed.", e);
                }
                try {
                    ServerSocket.setSocketFactory(socketFactory);
                }
                catch (IOException e) {
                    throw new IllegalStateException("setSocketFactory failed.", e);
                }
                try {
                    DatagramSocket.setDatagramSocketImplFactory(socketFactory);
                }
                catch (IOException e) {
                    throw new IllegalStateException("setDatagramSocketImplFactory failed.", e);
                }
                return null;
            }
        });
        isInstalled = true;
    }

    @Override
    public SocketImpl createSocketImpl() {
        if (appEngineSocketImplFactory == null || nativeSocketMode.get().booleanValue() || override) {
            return DevSocketImplFactory.createNativeSocketImpl();
        }
        return appEngineSocketImplFactory.createSocketImpl();
    }

    @Override
    public DatagramSocketImpl createDatagramSocketImpl() {
        if (appEngineDatagramSocketImplFactory == null || nativeSocketMode.get().booleanValue() || override) {
            return DevSocketImplFactory.createNativeDatagramSocketImpl();
        }
        return appEngineDatagramSocketImplFactory.createDatagramSocketImpl();
    }

    static DatagramSocketImpl createNativeDatagramSocketImpl() {
        if (CREATE_DATAGRAM_SOCKET_IMPL != null) {
            try {
                return (DatagramSocketImpl)CREATE_DATAGRAM_SOCKET_IMPL.invoke(null, false);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalStateException(e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
        }
        try {
            return (DatagramSocketImpl)DATAGRAM_SOCKET_IMPL_CONSTRUCTOR.newInstance(new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException(e);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    static SocketImpl createNativeSocketImpl() {
        try {
            return (SocketImpl)SOCKS_SOCKET_IMPL_CONSTRUCTOR.newInstance(new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException(e);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    public static void setAppEngineSocketImplFactory(SocketImplFactory appEngineSocketImplFactory) {
        if (appEngineSocketImplFactory == null) {
            throw new IllegalArgumentException("Parameter devAppserverSocketImplFactory may not be null.");
        }
        if (!isInstalled) {
            throw new IllegalStateException("Calling setCurrentSocketImplFactory is ineffective since DevSocketImplFactory is not installed.");
        }
        DevSocketImplFactory.appEngineSocketImplFactory = appEngineSocketImplFactory;
    }

    public static void setAppEngineDatagramSocketImplFactory(DatagramSocketImplFactory appEngineDatagramSocketImplFactory) {
        if (appEngineSocketImplFactory == null) {
            throw new IllegalArgumentException("Parameter devAppserverSocketImplFactory may not be null.");
        }
        if (!isInstalled) {
            throw new IllegalStateException("Calling setCurrentSocketImplFactory is ineffective since DevSocketImplFactory is not installed.");
        }
        DevSocketImplFactory.appEngineDatagramSocketImplFactory = appEngineDatagramSocketImplFactory;
    }

    public static boolean isNativeSocketMode() {
        return nativeSocketMode.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setSocketNativeMode(boolean nativeMode) {
        Class<DevSocketImplFactory> clazz = DevSocketImplFactory.class;
        synchronized (DevSocketImplFactory.class) {
            boolean lastMode = nativeSocketMode.get();
            nativeSocketMode.set(nativeMode);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return lastMode;
        }
    }

    public static DevSocketImplFactory getInstance() {
        return instance;
    }

    public static boolean setOverrideMode(boolean override) {
        boolean lastOverride = DevSocketImplFactory.override;
        DevSocketImplFactory.override = override;
        return lastOverride;
    }

    static {
        appEngineSocketImplFactory = null;
        appEngineDatagramSocketImplFactory = null;
        isInstalled = false;
        override = false;
        try {
            SOCKS_SOCKET_IMPL_CONSTRUCTOR = Class.forName("java.net.SocksSocketImpl").getDeclaredConstructor(new Class[0]);
        }
        catch (SecurityException e) {
            throw new IllegalStateException(e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
        SOCKS_SOCKET_IMPL_CONSTRUCTOR.setAccessible(true);
        CREATE_DATAGRAM_SOCKET_IMPL = DevSocketImplFactory.getDefaultCreateDatagramSocketImplMethod();
        if (CREATE_DATAGRAM_SOCKET_IMPL == null) {
            try {
                DATAGRAM_SOCKET_IMPL_CONSTRUCTOR = Class.forName("java.net.PlainDatagramSocketImpl").getDeclaredConstructor(new Class[0]);
            }
            catch (SecurityException e) {
                throw new IllegalStateException(e);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException(e);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
            DATAGRAM_SOCKET_IMPL_CONSTRUCTOR.setAccessible(true);
        } else {
            DATAGRAM_SOCKET_IMPL_CONSTRUCTOR = null;
        }
    }
}

