/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.tools.devserver;

import com.google.api.server.spi.EnvUtil;
import com.google.api.server.spi.IoUtil;
import com.google.api.server.spi.ObjectMapperUtil;
import com.google.api.server.spi.tools.devserver.Headers;
import com.google.appengine.repackaged.org.codehaus.jackson.map.ObjectMapper;
import com.google.appengine.repackaged.org.codehaus.jackson.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;

public class LilyClient {
    public static final String ERROR_MESSAGE = "error_message";
    public static final String ITEMS = "items";
    private final ObjectMapper mapper = ObjectMapperUtil.createStandardObjectMapper();

    public Response send(Request request) {
        try {
            return this.receiveResponse(this.sendRequest(request));
        }
        catch (IOException e) {
            return this.receiveError(e.getMessage());
        }
    }

    private HttpURLConnection sendRequest(Request request) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)new URL(request.spiEndpoint).openConnection();
        connection.setReadTimeout(0);
        for (Map.Entry header : request.headers.entrySet()) {
            connection.setRequestProperty((String)header.getKey(), (String)header.getValue());
        }
        if (EnvUtil.isRunningOnAppEngine()) {
            connection.setRequestProperty("X-Appengine-Peer", "apiserving");
        }
        connection.setDoOutput(true);
        OutputStreamWriter writer = new OutputStreamWriter(connection.getOutputStream());
        writer.write(request.body);
        writer.flush();
        writer.close();
        return connection;
    }

    private Response receiveResponse(HttpURLConnection connection) throws IOException {
        int responseStatus = connection.getResponseCode();
        Headers responseHeaders = new Headers();
        int i = 0;
        while (true) {
            String name = connection.getHeaderFieldKey(i);
            String value = connection.getHeaderField(i);
            if (name == null && value == null) break;
            if (name != null) {
                responseHeaders.put(name, value);
            }
            ++i;
        }
        String responseBody = IoUtil.readStream((InputStream)connection.getInputStream());
        return new Response(responseStatus, responseHeaders, responseBody);
    }

    private Response receiveError(String errorMessage) {
        Headers headers = new Headers();
        headers.put("Content-Type", "application/json");
        ObjectNode json = this.mapper.createObjectNode();
        json.put(ERROR_MESSAGE, errorMessage);
        return new Response(404, headers, json.toString());
    }

    public static class Response {
        public final int status;
        public final Headers headers;
        public final String body;

        public Response(int status, Headers headers, String body) {
            this.status = status;
            this.headers = headers;
            this.body = body;
        }
    }

    public static class Request {
        public final String spiEndpoint;
        public final Headers headers;
        public final String body;

        public Request(String spiEndpoint, Headers headers, String body) {
            this.spiEndpoint = spiEndpoint;
            this.headers = headers;
            this.body = body;
        }
    }
}

