/**********************************************************************
Copyright (c) 2007 Andy Jefferson and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Contributors:
    ...
**********************************************************************/
package org.datanucleus.enhancer.asm.method;

import javax.jdo.spi.StateManager;

import org.datanucleus.enhancer.ClassEnhancer;
import org.datanucleus.enhancer.asm.ASMClassMethod;
import org.datanucleus.enhancer.asm.ASMUtils;
import org.objectweb.asm.Label;
import org.objectweb.asm.Opcodes;

/**
 * Method to generate the method "jdoReplaceStateManager" using ASM.
 * <pre>
 * public final synchronized void jdoReplaceStateManager(StateManager stateManager)
 * {
 *     if (jdoStateManager != null)
 *     {
 *         jdoStateManager = jdoStateManager.replacingStateManager(this, stateManager);
 *     }
 *     else
 *     {
 *         JDOImplHelper.checkAuthorizedStateManager(sm);
 *         jdoStateManager = stateManager;
 *         jdoFlags = (byte) 1;
 *     }
 * }
 * </pre>
 */
public class JdoReplaceStateManager extends ASMClassMethod
{
    public static JdoReplaceStateManager getInstance(ClassEnhancer enhancer)
    {
        return new JdoReplaceStateManager(enhancer, ClassEnhancer.MN_JdoReplaceStateManager, 
            Opcodes.ACC_PUBLIC | Opcodes.ACC_FINAL | Opcodes.ACC_SYNCHRONIZED,
            null, new Class[] {StateManager.class}, new String[] {"sm"});
    }

    /**
     * Constructor.
     * @param enhancer ClassEnhancer
     * @param name Name of method
     * @param access Access type
     * @param returnType Return type
     * @param argTypes Argument types
     * @param argNames Argument names
     */
    public JdoReplaceStateManager(ClassEnhancer enhancer, String name, int access, 
        Object returnType, Object[] argTypes, String[] argNames)
    {
        super(enhancer, name, access, returnType, argTypes, argNames);
    }

    /**
     * Method to add the contents of the class method.
     */
    public void execute()
    {
        visitor.visitCode();

        Label startLabel = new Label();
        visitor.visitLabel(startLabel);

        visitor.visitVarInsn(Opcodes.ALOAD, 0);
        visitor.visitFieldInsn(Opcodes.GETFIELD, getClassEnhancer().getASMClassName(),
            ClassEnhancer.FN_StateManager, ASMUtils.CD_StateManager);
        Label l1 = new Label();
        visitor.visitJumpInsn(Opcodes.IFNULL, l1);

        visitor.visitVarInsn(Opcodes.ALOAD, 0);
        visitor.visitVarInsn(Opcodes.ALOAD, 0);
        visitor.visitFieldInsn(Opcodes.GETFIELD, getClassEnhancer().getASMClassName(),
            ClassEnhancer.FN_StateManager, ASMUtils.CD_StateManager);
        visitor.visitVarInsn(Opcodes.ALOAD, 0);
        visitor.visitVarInsn(Opcodes.ALOAD, 1);
        visitor.visitMethodInsn(Opcodes.INVOKEINTERFACE, ASMUtils.ACN_StateManager, "replacingStateManager",
            "(" + ASMUtils.CD_PersistenceCapable + ASMUtils.CD_StateManager + ")" + ASMUtils.CD_StateManager);
        visitor.visitFieldInsn(Opcodes.PUTFIELD, getClassEnhancer().getASMClassName(),
            ClassEnhancer.FN_StateManager, ASMUtils.CD_StateManager);
        Label l3 = new Label();
        visitor.visitJumpInsn(Opcodes.GOTO, l3);

        visitor.visitLabel(l1);
        visitor.visitVarInsn(Opcodes.ALOAD, 1);
        visitor.visitMethodInsn(Opcodes.INVOKESTATIC, "javax/jdo/spi/JDOImplHelper", 
            "checkAuthorizedStateManager", "(Ljavax/jdo/spi/StateManager;)V");
        visitor.visitVarInsn(Opcodes.ALOAD, 0);
        visitor.visitVarInsn(Opcodes.ALOAD, 1);
        visitor.visitFieldInsn(Opcodes.PUTFIELD, getClassEnhancer().getASMClassName(),
            ClassEnhancer.FN_StateManager, ASMUtils.CD_StateManager);
        visitor.visitVarInsn(Opcodes.ALOAD, 0);
        visitor.visitInsn(Opcodes.ICONST_1);
        visitor.visitFieldInsn(Opcodes.PUTFIELD, getClassEnhancer().getASMClassName(), "jdoFlags", "B");
        visitor.visitLabel(l3);
        visitor.visitInsn(Opcodes.RETURN);

        Label endLabel = new Label();
        visitor.visitLabel(endLabel);
        visitor.visitLocalVariable("this", getClassEnhancer().getClassDescriptor(), null, startLabel, endLabel, 0);
        visitor.visitLocalVariable(argNames[0], ASMUtils.CD_StateManager, null, startLabel, endLabel, 1);
        visitor.visitMaxs(4, 2);

        visitor.visitEnd();
    }
}