/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.operands;

import java.nio.charset.UnsupportedCharsetException;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.operands.ImmutableLiteral;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.OperandType;
import org.jruby.ir.operands.StringLiteral;
import org.jruby.ir.operands.Stringable;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.util.ByteList;

public class FrozenString
extends ImmutableLiteral<RubyString>
implements Stringable,
StringLiteral {
    public final ByteList bytelist;
    public final int coderange;
    public final String file;
    public final int line;
    public String string;

    public FrozenString(ByteList bytelist, int coderange, String file2, int line) {
        this.bytelist = bytelist;
        this.coderange = coderange;
        this.file = file2;
        this.line = line;
    }

    public FrozenString(RubySymbol symbol) {
        this(symbol.getBytes());
    }

    public FrozenString(String s2) {
        this(ByteList.create(s2));
    }

    private FrozenString(ByteList byteList) {
        this.bytelist = byteList;
        this.coderange = 16;
        this.file = "<dummy>";
        this.line = -1;
    }

    private static String internedStringFromByteList(ByteList val) {
        try {
            return Helpers.byteListToString(val).intern();
        }
        catch (UnsupportedCharsetException e) {
            return val.toString().intern();
        }
    }

    @Override
    public OperandType getOperandType() {
        return OperandType.FROZEN_STRING;
    }

    @Override
    public boolean hasKnownValue() {
        return true;
    }

    public int hashCode() {
        return this.bytelist.hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof FrozenString && this.bytelist.equals(((FrozenString)other).bytelist) && this.coderange == ((FrozenString)other).coderange;
    }

    public String toString() {
        return "frozen:\"" + this.bytelist + "\"";
    }

    @Override
    public Operand cloneForInlining(CloneInfo ii) {
        return this;
    }

    @Override
    public RubyString createCacheObject(ThreadContext context) {
        return IRRuntimeHelpers.newFrozenString(context, this.bytelist, this.coderange, this.file, this.line);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.FrozenString(this);
    }

    @Override
    public ByteList getByteList() {
        return this.bytelist;
    }

    @Override
    public String getString() {
        String cached = this.string;
        if (cached == null) {
            this.string = cached = FrozenString.internedStringFromByteList(this.bytelist);
        }
        return cached;
    }

    public String getFile() {
        return this.file;
    }

    public int getLine() {
        return this.line;
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.bytelist);
        e.encode(this.coderange);
        e.encode(this.file);
        e.encode(this.line);
    }

    public static FrozenString decode(IRReaderDecoder d) {
        return new FrozenString(d.decodeByteList(), d.decodeInt(), d.decodeString(), d.decodeInt());
    }

    @Override
    public int getCodeRange() {
        return this.coderange;
    }

    @Override
    public boolean isTruthyImmediate() {
        return true;
    }
}

