/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.jruby.ast.impl;

import java.util.AbstractList;
import java.util.Collection;
import java.util.List;
import org.asciidoctor.ast.Column;
import org.asciidoctor.ast.Row;
import org.asciidoctor.ast.Table;
import org.asciidoctor.jruby.ast.impl.RowImpl;
import org.asciidoctor.jruby.ast.impl.StructuralNodeImpl;
import org.asciidoctor.jruby.internal.RubyBlockListDecorator;
import org.asciidoctor.jruby.internal.RubyObjectWrapper;
import org.jruby.RubyArray;
import org.jruby.RubyNil;
import org.jruby.runtime.builtin.IRubyObject;

public class TableImpl
extends StructuralNodeImpl
implements Table {
    private static final String FRAME_ATTR = "frame";
    private static final String GRID_ATTR = "grid";
    private Rows rows = new Rows(this.getRubyProperty("rows", new Object[0]));

    public TableImpl(IRubyObject rubyObject) {
        super(rubyObject);
    }

    public boolean hasHeaderOption() {
        return this.getBoolean("has_header_option", new Object[0]);
    }

    public String getFrame() {
        return (String)this.getAttribute(FRAME_ATTR, "all");
    }

    public void setFrame(String frame) {
        this.setAttribute(FRAME_ATTR, frame, true);
    }

    public String getGrid() {
        return (String)this.getAttribute(GRID_ATTR, "all");
    }

    public void setGrid(String grid) {
        this.setAttribute(GRID_ATTR, grid, true);
    }

    public List<Column> getColumns() {
        RubyArray rubyBlocks = (RubyArray)this.getRubyProperty("columns", new Object[0]);
        return new RubyBlockListDecorator<Column>(rubyBlocks);
    }

    public List<Row> getFooter() {
        return this.rows.getFooter();
    }

    public List<Row> getBody() {
        return this.rows.getBody();
    }

    public List<Row> getHeader() {
        return this.rows.getHeader();
    }

    class RowList
    extends AbstractList<Row> {
        private final RubyArray rubyArray;

        private RowList(RubyArray rubyArray) {
            this.rubyArray = rubyArray;
        }

        @Override
        public int size() {
            return this.rubyArray.size();
        }

        @Override
        public boolean isEmpty() {
            return this.rubyArray.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            if (!RowImpl.class.isInstance(o)) {
                return false;
            }
            return this.rubyArray.contains((Object)((RowImpl)o).getRubyObject());
        }

        @Override
        public boolean add(Row row) {
            boolean changed = this.rubyArray.add((Object)((RowImpl)row).getRubyObject());
            TableImpl.this.setAttribute("rowcount", this.size(), true);
            return changed;
        }

        @Override
        public boolean remove(Object o) {
            if (!RowImpl.class.isInstance(o)) {
                return false;
            }
            boolean changed = this.rubyArray.remove((Object)((RowImpl)o).getRubyObject());
            TableImpl.this.setAttribute("rowcount", this.size(), true);
            return changed;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            this.rubyArray.clear();
            TableImpl.this.setAttribute("rowcount", this.size(), true);
        }

        @Override
        public Row get(int index) {
            IRubyObject o = this.rubyArray.at((IRubyObject)this.rubyArray.getRuntime().newFixnum(index));
            if (o == null || o instanceof RubyNil) {
                return null;
            }
            return new RowImpl(o);
        }

        @Override
        public Row set(int index, Row element) {
            Row oldRow = this.get(index);
            this.rubyArray.set(index, (Object)((RowImpl)element).getRubyObject());
            return oldRow;
        }

        @Override
        public void add(int index, Row element) {
            this.rubyArray.add(index, (Object)((RowImpl)element).getRubyObject());
            TableImpl.this.setAttribute("rowcount", this.size(), true);
        }

        @Override
        public Row remove(int index) {
            IRubyObject rubyObject = (IRubyObject)this.rubyArray.remove(index);
            TableImpl.this.setAttribute("rowcount", this.size(), true);
            return new RowImpl(rubyObject);
        }

        @Override
        public int indexOf(Object o) {
            if (!RowImpl.class.isInstance(o)) {
                return -1;
            }
            return this.rubyArray.indexOf((Object)((RowImpl)o).getRubyObject());
        }

        @Override
        public int lastIndexOf(Object o) {
            if (!RowImpl.class.isInstance(o)) {
                return -1;
            }
            return this.rubyArray.lastIndexOf((Object)((RowImpl)o).getRubyObject());
        }
    }

    private class Rows
    extends RubyObjectWrapper {
        public Rows(IRubyObject rubyNode) {
            super(rubyNode);
        }

        private RowList getHeader() {
            RubyArray headerRows = (RubyArray)this.getRubyProperty("head", new Object[0]);
            return new RowList(headerRows);
        }

        private RowList getBody() {
            RubyArray bodyRows = (RubyArray)this.getRubyProperty("body", new Object[0]);
            return new RowList(bodyRows);
        }

        private RowList getFooter() {
            RubyArray footerRows = (RubyArray)this.getRubyProperty("foot", new Object[0]);
            return new RowList(footerRows);
        }

        private void setFooterRow(Row row) {
            RubyArray newFooterRows = this.getRuntime().newArray((IRubyObject)((RowImpl)row).getRubyCells());
            this.getRubyObject().getInstanceVariables().setInstanceVariable("@foot", (IRubyObject)newFooterRows);
        }
    }
}

