/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.ArrayList;
import java.util.List;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.SymbolNode;
import org.jruby.ast.types.ILiteralNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.util.KeyValuePair;

public class HashNode
extends Node
implements ILiteralNode {
    private final List<KeyValuePair<Node, Node>> pairs = new ArrayList<KeyValuePair<Node, Node>>();
    private boolean hasOnlySymbolKeys = true;
    private boolean hasRestKwarg = false;

    public HashNode(int line) {
        super(line, false);
    }

    public HashNode(int line, KeyValuePair<Node, Node> pair) {
        this(line);
        this.add(pair);
    }

    public boolean hasOnlySymbolKeys() {
        return this.hasOnlySymbolKeys;
    }

    public boolean isMaybeKwargs() {
        return this.hasOnlySymbolKeys() || this.hasOnlyRestKwargs();
    }

    public boolean hasRestKwarg() {
        return this.hasRestKwarg;
    }

    public boolean hasOnlyRestKwargs() {
        if (!this.hasRestKwarg) {
            return false;
        }
        for (KeyValuePair<Node, Node> pair : this.pairs) {
            if (pair.getKey() == null) continue;
            return false;
        }
        return true;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.HASHNODE;
    }

    public HashNode add(KeyValuePair<Node, Node> pair) {
        Node key2 = pair.getKey();
        if (key2 != null && key2.containsVariableAssignment() || pair.getValue() != null && pair.getValue().containsVariableAssignment()) {
            this.containsVariableAssignment = true;
        }
        if (key2 == null) {
            this.hasRestKwarg = true;
            this.hasOnlySymbolKeys = false;
        } else if (!(pair.getKey() instanceof SymbolNode)) {
            this.hasOnlySymbolKeys = false;
        }
        this.pairs.add(pair);
        return this;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitHashNode(this);
    }

    public boolean isEmpty() {
        return this.pairs.isEmpty();
    }

    public List<KeyValuePair<Node, Node>> getPairs() {
        return this.pairs;
    }

    @Override
    public List<Node> childNodes() {
        ArrayList<Node> children2 = new ArrayList<Node>();
        for (KeyValuePair<Node, Node> pair : this.pairs) {
            children2.add(pair.getKey());
            children2.add(pair.getValue());
        }
        return children2;
    }
}

