/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.skyframe.serialization.autocodec;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.devtools.build.lib.skyframe.serialization.PolymorphicHelper;
import com.google.devtools.build.lib.skyframe.serialization.SerializationException;
import com.google.devtools.build.lib.skyframe.serialization.autocodec.AutoCodec;
import com.google.devtools.build.lib.skyframe.serialization.autocodec.AutoCodecUtil;
import com.google.devtools.build.lib.skyframe.serialization.autocodec.Marshallers;
import com.google.devtools.build.lib.skyframe.serialization.autocodec.SerializationCodeGenerator;
import com.google.devtools.build.lib.skyframe.serialization.autocodec.UnsafeProvider;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;

@AutoService(value=Processor.class)
public class AutoCodecProcessor
extends AbstractProcessor {
    private static final String PRINT_GENERATED_OPTION = "autocodec_print_generated";
    private ProcessingEnvironment env;
    private Marshallers marshallers;

    @Override
    public Set<String> getSupportedOptions() {
        return ImmutableSet.of((Object)PRINT_GENERATED_OPTION);
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return ImmutableSet.of((Object)AutoCodecUtil.ANNOTATION.getCanonicalName());
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.env = processingEnv;
        this.marshallers = new Marshallers(processingEnv);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getElementsAnnotatedWith(AutoCodecUtil.ANNOTATION)) {
            AutoCodec annotation = element.getAnnotation(AutoCodecUtil.ANNOTATION);
            TypeElement encodedType = (TypeElement)element;
            TypeElement dependencyType = this.getDependencyType(annotation);
            TypeSpec.Builder codecClassBuilder = null;
            switch (annotation.strategy()) {
                case INSTANTIATOR: {
                    codecClassBuilder = this.buildClassWithInstantiatorStrategy(encodedType, dependencyType);
                    break;
                }
                case PUBLIC_FIELDS: {
                    codecClassBuilder = this.buildClassWithPublicFieldsStrategy(encodedType, dependencyType);
                    break;
                }
                case POLYMORPHIC: {
                    codecClassBuilder = AutoCodecProcessor.buildClassWithPolymorphicStrategy(encodedType, dependencyType);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown strategy: " + annotation.strategy());
                }
            }
            codecClassBuilder.addMethod(AutoCodecUtil.initializeGetEncodedClassMethod(encodedType).addStatement("return $T.class", new Object[]{TypeName.get((TypeMirror)encodedType.asType())}).build());
            String packageName = this.env.getElementUtils().getPackageOf(encodedType).getQualifiedName().toString();
            try {
                JavaFile file = JavaFile.builder((String)packageName, (TypeSpec)codecClassBuilder.build()).build();
                file.writeTo(this.env.getFiler());
                if (!this.env.getOptions().containsKey(PRINT_GENERATED_OPTION)) continue;
                this.note("AutoCodec generated codec for " + encodedType + ":\n" + file);
            }
            catch (IOException e) {
                this.env.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to generate output file: " + e.getMessage());
            }
        }
        return true;
    }

    @Nullable
    private TypeElement getDependencyType(AutoCodec annotation) {
        try {
            annotation.dependency();
            throw new AssertionError((Object)"Expected MirroredTypeException!");
        }
        catch (MirroredTypeException e) {
            DeclaredType dependencyMirror = (DeclaredType)e.getTypeMirror();
            if (this.matchesType(dependencyMirror, Void.class)) {
                return null;
            }
            return (TypeElement)dependencyMirror.asElement();
        }
    }

    private TypeSpec.Builder buildClassWithInstantiatorStrategy(TypeElement encodedType, @Nullable TypeElement dependency) {
        ExecutableElement constructor = this.selectInstantiator(encodedType);
        PartitionedParameters parameters = AutoCodecProcessor.isolateDependency(constructor);
        if (dependency != null) {
            if (parameters.dependency != null) {
                throw new IllegalArgumentException(encodedType.getQualifiedName() + " has both a @Dependency annotated constructor parameter and a non-Void dependency element " + dependency.getQualifiedName());
            }
            parameters.dependency = dependency;
        }
        TypeSpec.Builder codecClassBuilder = AutoCodecUtil.initializeCodecClassBuilder(encodedType, parameters.dependency);
        this.initializeUnsafeOffsets(codecClassBuilder, encodedType, parameters.fields);
        codecClassBuilder.addMethod(this.buildSerializeMethodWithInstantiator(encodedType, parameters));
        MethodSpec.Builder deserializeBuilder = AutoCodecUtil.initializeDeserializeMethodBuilder(encodedType, parameters.dependency);
        this.buildDeserializeBody(deserializeBuilder, parameters.fields);
        AutoCodecProcessor.addReturnNew(deserializeBuilder, encodedType, constructor);
        codecClassBuilder.addMethod(deserializeBuilder.build());
        return codecClassBuilder;
    }

    private static PartitionedParameters isolateDependency(ExecutableElement constructor) {
        Map<Boolean, List<VariableElement>> splitParameters = constructor.getParameters().stream().collect(Collectors.partitioningBy(p -> p.getAnnotation(AutoCodec.Dependency.class) != null));
        PartitionedParameters result = new PartitionedParameters();
        result.fields = splitParameters.get(Boolean.FALSE);
        List<VariableElement> dependencies = splitParameters.get(Boolean.TRUE);
        if (dependencies.size() > 1) {
            throw new IllegalArgumentException(((TypeElement)constructor.getEnclosingElement()).getQualifiedName() + " constructor has multiple Dependency annotations.");
        }
        if (!dependencies.isEmpty()) {
            result.dependency = (TypeElement)((DeclaredType)dependencies.get(0).asType()).asElement();
        }
        return result;
    }

    private ExecutableElement selectInstantiator(TypeElement encodedType) {
        List<ExecutableElement> constructors = ElementFilter.constructorsIn(encodedType.getEnclosedElements());
        Stream<ExecutableElement> factoryMethods = ElementFilter.methodsIn(encodedType.getEnclosedElements()).stream().filter(AutoCodecProcessor::hasInstantiatorAnnotation).peek(m -> this.verifyFactoryMethod(encodedType, (ExecutableElement)m));
        ImmutableList markedInstantiators = (ImmutableList)Stream.concat(constructors.stream().filter(AutoCodecProcessor::hasInstantiatorAnnotation), factoryMethods).collect(ImmutableList.toImmutableList());
        if (markedInstantiators.isEmpty()) {
            if (constructors.size() > 1) {
                throw new IllegalArgumentException(encodedType.getQualifiedName() + " has multiple constructors but no Instantiator annotation.");
            }
            return constructors.get(0);
        }
        if (markedInstantiators.size() == 1) {
            return (ExecutableElement)markedInstantiators.get(0);
        }
        throw new IllegalArgumentException(encodedType.getQualifiedName() + " has multiple Instantiator annotations.");
    }

    private static boolean hasInstantiatorAnnotation(Element elt) {
        return elt.getAnnotation(AutoCodec.Instantiator.class) != null;
    }

    private void verifyFactoryMethod(TypeElement encodedType, ExecutableElement elt) {
        if (!elt.getModifiers().contains((Object)Modifier.STATIC) || !this.env.getTypeUtils().isSubtype(elt.getReturnType(), encodedType.asType())) {
            throw new IllegalArgumentException(encodedType.getQualifiedName() + " tags " + elt.getSimpleName() + " as an Instantiator, but it's not a valid factory method.");
        }
    }

    private MethodSpec buildSerializeMethodWithInstantiator(TypeElement encodedType, PartitionedParameters parameters) {
        MethodSpec.Builder serializeBuilder = AutoCodecUtil.initializeSerializeMethodBuilder(encodedType, parameters.dependency);
        block6: for (VariableElement parameter : parameters.fields) {
            VariableElement field = this.getFieldByName((TypeElement)encodedType, (String)parameter.getSimpleName().toString()).value;
            TypeKind typeKind = field.asType().getKind();
            switch (typeKind) {
                case BOOLEAN: {
                    serializeBuilder.addStatement("codedOut.writeBoolNoTag($T.getInstance().getBoolean(input, $L_offset))", new Object[]{UnsafeProvider.class, parameter.getSimpleName()});
                    continue block6;
                }
                case INT: {
                    serializeBuilder.addStatement("codedOut.writeInt32NoTag($T.getInstance().getInt(input, $L_offset))", new Object[]{UnsafeProvider.class, parameter.getSimpleName()});
                    continue block6;
                }
                case ARRAY: {
                    serializeBuilder.addStatement("$T unsafe_$L = ($T)$T.getInstance().getObject(input, $L_offset)", new Object[]{field.asType(), parameter.getSimpleName(), field.asType(), UnsafeProvider.class, parameter.getSimpleName()});
                    this.marshallers.writeSerializationCode(new SerializationCodeGenerator.Context(serializeBuilder, parameter.asType(), "unsafe_" + parameter.getSimpleName()));
                    continue block6;
                }
                case DECLARED: {
                    serializeBuilder.addStatement("$T unsafe_$L = ($T)$T.getInstance().getObject(input, $L_offset)", new Object[]{field.asType(), parameter.getSimpleName(), field.asType(), UnsafeProvider.class, parameter.getSimpleName()});
                    this.marshallers.writeSerializationCode(new SerializationCodeGenerator.Context(serializeBuilder, (DeclaredType)parameter.asType(), "unsafe_" + parameter.getSimpleName()));
                    continue block6;
                }
            }
            throw new UnsupportedOperationException("Unimplemented or invalid kind: " + (Object)((Object)typeKind));
        }
        return serializeBuilder.build();
    }

    private TypeSpec.Builder buildClassWithPublicFieldsStrategy(TypeElement encodedType, @Nullable TypeElement dependency) {
        TypeSpec.Builder codecClassBuilder = AutoCodecUtil.initializeCodecClassBuilder(encodedType, dependency);
        ImmutableList publicFields = (ImmutableList)ElementFilter.fieldsIn(this.env.getElementUtils().getAllMembers(encodedType)).stream().filter(this::isPublicField).collect(ImmutableList.toImmutableList());
        codecClassBuilder.addMethod(this.buildSerializeMethodWithPublicFields(encodedType, (List<? extends VariableElement>)publicFields, dependency));
        MethodSpec.Builder deserializeBuilder = AutoCodecUtil.initializeDeserializeMethodBuilder(encodedType, dependency);
        this.buildDeserializeBody(deserializeBuilder, (List<? extends VariableElement>)publicFields);
        AutoCodecProcessor.addInstantiatePopulateFieldsAndReturn(deserializeBuilder, encodedType, (List<? extends VariableElement>)publicFields);
        codecClassBuilder.addMethod(deserializeBuilder.build());
        return codecClassBuilder;
    }

    private boolean isPublicField(VariableElement element) {
        if (this.matchesType(element.asType(), Void.class)) {
            return false;
        }
        Set<Modifier> modifiers = element.getModifiers();
        return modifiers.contains((Object)Modifier.PUBLIC) && !modifiers.contains((Object)Modifier.STATIC);
    }

    private MethodSpec buildSerializeMethodWithPublicFields(TypeElement encodedType, List<? extends VariableElement> parameters, @Nullable TypeElement dependency) {
        MethodSpec.Builder serializeBuilder = AutoCodecUtil.initializeSerializeMethodBuilder(encodedType, dependency);
        block6: for (VariableElement variableElement : parameters) {
            String paramAccessor = "input." + variableElement.getSimpleName();
            TypeKind typeKind = variableElement.asType().getKind();
            switch (typeKind) {
                case BOOLEAN: {
                    serializeBuilder.addStatement("codedOut.writeBoolNoTag($L)", new Object[]{paramAccessor});
                    continue block6;
                }
                case INT: {
                    serializeBuilder.addStatement("codedOut.writeInt32NoTag($L)", new Object[]{paramAccessor});
                    continue block6;
                }
                case ARRAY: {
                    this.marshallers.writeSerializationCode(new SerializationCodeGenerator.Context(serializeBuilder, variableElement.asType(), paramAccessor));
                    continue block6;
                }
                case DECLARED: {
                    this.marshallers.writeSerializationCode(new SerializationCodeGenerator.Context(serializeBuilder, (DeclaredType)variableElement.asType(), paramAccessor));
                    continue block6;
                }
            }
            throw new UnsupportedOperationException("Unimplemented or invalid kind: " + (Object)((Object)typeKind));
        }
        return serializeBuilder.build();
    }

    private void buildDeserializeBody(MethodSpec.Builder builder, List<? extends VariableElement> parameters) {
        block6: for (VariableElement variableElement : parameters) {
            String paramName = variableElement.getSimpleName() + "_";
            TypeKind typeKind = variableElement.asType().getKind();
            switch (typeKind) {
                case BOOLEAN: {
                    builder.addStatement("boolean $L = codedIn.readBool()", new Object[]{paramName});
                    continue block6;
                }
                case INT: {
                    builder.addStatement("int $L = codedIn.readInt32()", new Object[]{paramName});
                    continue block6;
                }
                case ARRAY: {
                    this.marshallers.writeDeserializationCode(new SerializationCodeGenerator.Context(builder, variableElement.asType(), paramName));
                    continue block6;
                }
                case DECLARED: {
                    this.marshallers.writeDeserializationCode(new SerializationCodeGenerator.Context(builder, (DeclaredType)variableElement.asType(), paramName));
                    continue block6;
                }
            }
            throw new IllegalArgumentException("Unimplemented or invalid kind: " + (Object)((Object)typeKind));
        }
    }

    private static void addReturnNew(MethodSpec.Builder builder, TypeElement type, ExecutableElement instantiator) {
        List<? extends TypeMirror> allThrown = instantiator.getThrownTypes();
        if (!allThrown.isEmpty()) {
            builder.beginControlFlow("try", new Object[0]);
        }
        String parameters = instantiator.getParameters().stream().map(AutoCodecProcessor::handleFromParameter).collect(Collectors.joining(", "));
        if (instantiator.getKind().equals((Object)ElementKind.CONSTRUCTOR)) {
            builder.addStatement("return new $T($L)", new Object[]{TypeName.get((TypeMirror)type.asType()), parameters});
        } else {
            builder.addStatement("return $T.$L($L)", new Object[]{TypeName.get((TypeMirror)type.asType()), instantiator.getSimpleName(), parameters});
        }
        if (!allThrown.isEmpty()) {
            for (TypeMirror typeMirror : allThrown) {
                builder.nextControlFlow("catch ($T e)", new Object[]{TypeName.get((TypeMirror)typeMirror)});
                builder.addStatement("throw new $T(\"$L instantiator threw an exception\", e)", new Object[]{SerializationException.class, type.getQualifiedName()});
            }
            builder.endControlFlow();
        }
    }

    private static String handleFromParameter(VariableElement parameter) {
        return parameter.getAnnotation(AutoCodec.Dependency.class) != null ? "dependency" : parameter.getSimpleName() + "_";
    }

    private static void addInstantiatePopulateFieldsAndReturn(MethodSpec.Builder builder, TypeElement type, List<? extends VariableElement> fields) {
        builder.addStatement("$T deserializationResult = new $T()", new Object[]{TypeName.get((TypeMirror)type.asType()), TypeName.get((TypeMirror)type.asType())});
        for (VariableElement variableElement : fields) {
            String fieldName = variableElement.getSimpleName().toString();
            builder.addStatement("deserializationResult.$L = $L", new Object[]{fieldName, fieldName + "_"});
        }
        builder.addStatement("return deserializationResult", new Object[0]);
    }

    private void initializeUnsafeOffsets(TypeSpec.Builder builder, TypeElement encodedType, List<? extends VariableElement> parameters) {
        MethodSpec.Builder constructor = MethodSpec.constructorBuilder();
        for (VariableElement variableElement : parameters) {
            FieldValueAndClass field = this.getFieldByName(encodedType, variableElement.getSimpleName().toString());
            if (!this.env.getTypeUtils().isSameType(field.value.asType(), variableElement.asType())) {
                throw new IllegalArgumentException(encodedType.getQualifiedName() + " field " + field.value.getSimpleName() + " has mismatching type.");
            }
            builder.addField(TypeName.LONG, variableElement.getSimpleName() + "_offset", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
            constructor.beginControlFlow("try", new Object[0]);
            constructor.addStatement("this.$L_offset = $T.getInstance().objectFieldOffset($T.class.getDeclaredField(\"$L\"))", new Object[]{variableElement.getSimpleName(), UnsafeProvider.class, field.declaringClassType, variableElement.getSimpleName()});
            constructor.nextControlFlow("catch ($T e)", new Object[]{NoSuchFieldException.class});
            constructor.addStatement("throw new $T(e)", new Object[]{IllegalStateException.class});
            constructor.endControlFlow();
        }
        builder.addMethod(constructor.build());
    }

    private FieldValueAndClass getFieldByName(TypeElement type, String name) {
        return this.getFieldByNameRecursive(type, name).orElseThrow(() -> new IllegalArgumentException(type.getQualifiedName() + ": no field with name matching " + name));
    }

    private Optional<FieldValueAndClass> getFieldByNameRecursive(TypeElement type, String name) {
        Optional<VariableElement> field = ElementFilter.fieldsIn(type.getEnclosedElements()).stream().filter(f -> f.getSimpleName().contentEquals(name)).findAny();
        if (field.isPresent()) {
            return Optional.of(new FieldValueAndClass(field.get(), type));
        }
        if (type.getSuperclass().getKind() != TypeKind.NONE) {
            return this.getFieldByNameRecursive(this.env.getElementUtils().getTypeElement(type.getSuperclass().toString()), name);
        }
        return Optional.empty();
    }

    private static TypeSpec.Builder buildClassWithPolymorphicStrategy(TypeElement encodedType, @Nullable TypeElement dependency) {
        if (!encodedType.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            throw new IllegalArgumentException(encodedType + " is not abstract, but POLYMORPHIC was selected as the strategy.");
        }
        TypeSpec.Builder codecClassBuilder = AutoCodecUtil.initializeCodecClassBuilder(encodedType, dependency);
        codecClassBuilder.addMethod(AutoCodecProcessor.buildPolymorphicSerializeMethod(encodedType, dependency));
        codecClassBuilder.addMethod(AutoCodecProcessor.buildPolymorphicDeserializeMethod(encodedType, dependency));
        return codecClassBuilder;
    }

    private static MethodSpec buildPolymorphicSerializeMethod(TypeElement encodedType, @Nullable TypeElement dependency) {
        MethodSpec.Builder builder = AutoCodecUtil.initializeSerializeMethodBuilder(encodedType, dependency);
        if (dependency == null) {
            builder.addStatement("$T.serialize(input, codedOut, null)", new Object[]{PolymorphicHelper.class});
        } else {
            builder.addStatement("$T.serialize(input, codedOut, $T.ofNullable(dependency))", new Object[]{PolymorphicHelper.class, Optional.class});
        }
        return builder.build();
    }

    private static MethodSpec buildPolymorphicDeserializeMethod(TypeElement encodedType, @Nullable TypeElement dependency) {
        MethodSpec.Builder builder = AutoCodecUtil.initializeDeserializeMethodBuilder(encodedType, dependency);
        if (dependency == null) {
            builder.addStatement("return ($T) $T.deserialize(codedIn, null)", new Object[]{TypeName.get((TypeMirror)encodedType.asType()), PolymorphicHelper.class});
        } else {
            builder.addStatement("return ($T) $T.deserialize(codedIn, $T.ofNullable(dependency))", new Object[]{TypeName.get((TypeMirror)encodedType.asType()), PolymorphicHelper.class, Optional.class});
        }
        return builder.build();
    }

    private boolean matchesType(TypeMirror type, Class<?> clazz) {
        return this.env.getTypeUtils().isSameType(type, this.env.getElementUtils().getTypeElement(clazz.getCanonicalName()).asType());
    }

    private void note(String note) {
        this.env.getMessager().printMessage(Diagnostic.Kind.NOTE, note);
    }

    private static class FieldValueAndClass {
        final VariableElement value;
        final TypeElement declaringClassType;

        FieldValueAndClass(VariableElement value, TypeElement declaringClassType) {
            this.value = value;
            this.declaringClassType = declaringClassType;
        }
    }

    private static class PartitionedParameters {
        List<VariableElement> fields;
        @Nullable
        TypeElement dependency;

        private PartitionedParameters() {
        }
    }
}

