/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Predicate;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Name;
import java.util.EnumSet;
import java.util.Set;
import javax.annotation.Nullable;

@BugPattern(name="ProtoFieldNullComparison", summary="Protobuf fields cannot be null", explanation="This checker looks for comparisons of protocol buffer fields with null. If a proto field is not specified, its field accessor will return a non-null default value. Thus, the result of calling one of these accessors can never be null, and comparisons like these often indicate a nearby error.\n\nIf you need to distinguish between an unset optional value and a default value, you have two options.  In most cases, you can simply use the `hasField()` method. proto3 however does not generate `hasField()` methods for scalar fields of type `string` or `bytes`. In those cases you will need to wrap your field in `google.protobuf.StringValue` or `google.protobuf.BytesValue`, respectively.", category=BugPattern.Category.PROTOBUF, severity=BugPattern.SeverityLevel.ERROR, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public class ProtoFieldNullComparison
extends BugChecker
implements BugChecker.BinaryTreeMatcher {
    private static final Predicate<Symbol.MethodSymbol> NO_ARGS = new Predicate<Symbol.MethodSymbol>(){

        public boolean apply(Symbol.MethodSymbol input) {
            return input.params().isEmpty();
        }
    };
    private static final String PROTO_SUPER_CLASS = "com.google.protobuf.GeneratedMessage";
    private static final Matcher<ExpressionTree> protoMessageReceiverMatcher = Matchers.instanceMethod().onDescendantOf("com.google.protobuf.GeneratedMessage");
    private static final String LIST_INTERFACE = "java.util.List";
    private static final Matcher<Tree> returnsListMatcher = Matchers.isSubtypeOf((String)"java.util.List");
    private static final Set<Tree.Kind> COMPARISON_OPERATORS = EnumSet.of(Tree.Kind.EQUAL_TO, Tree.Kind.NOT_EQUAL_TO);
    private static final Matcher<BinaryTree> MATCHER = new Matcher<BinaryTree>(){

        public boolean matches(BinaryTree tree, VisitorState state) {
            if (!COMPARISON_OPERATORS.contains((Object)tree.getKind())) {
                return false;
            }
            ExpressionTree leftOperand = tree.getLeftOperand();
            ExpressionTree rightOperand = tree.getRightOperand();
            return ProtoFieldNullComparison.isNull(rightOperand) && ProtoFieldNullComparison.isProtoMessageGetInvocation(leftOperand, state) || ProtoFieldNullComparison.isNull(leftOperand) && ProtoFieldNullComparison.isProtoMessageGetInvocation(rightOperand, state);
        }
    };

    private static boolean isNull(ExpressionTree tree) {
        return tree.getKind() == Tree.Kind.NULL_LITERAL;
    }

    private static boolean isProtoMessageGetInvocation(ExpressionTree tree, VisitorState state) {
        return (ProtoFieldNullComparison.isGetMethodInvocation(tree, state) || ProtoFieldNullComparison.isGetListMethodInvocation(tree, state)) && ProtoFieldNullComparison.receiverIsProtoMessage(tree, state);
    }

    private static boolean isFieldGetMethod(String methodName) {
        return methodName.startsWith("get");
    }

    private static String getMethodName(ExpressionTree tree) {
        MethodInvocationTree method = (MethodInvocationTree)tree;
        ExpressionTree expressionTree = method.getMethodSelect();
        JCTree.JCFieldAccess access = (JCTree.JCFieldAccess)expressionTree;
        return access.sym.getQualifiedName().toString();
    }

    private static boolean isGetListMethodInvocation(ExpressionTree tree, VisitorState state) {
        if (tree.getKind() == Tree.Kind.METHOD_INVOCATION) {
            MethodInvocationTree method = (MethodInvocationTree)tree;
            if (!method.getArguments().isEmpty()) {
                return false;
            }
            if (!returnsListMatcher.matches((Tree)method, state)) {
                return false;
            }
            ExpressionTree expressionTree = method.getMethodSelect();
            if (expressionTree instanceof JCTree.JCFieldAccess) {
                JCTree.JCFieldAccess access = (JCTree.JCFieldAccess)expressionTree;
                String methodName = access.sym.getQualifiedName().toString();
                return ProtoFieldNullComparison.isFieldGetMethod(methodName);
            }
            return true;
        }
        return false;
    }

    private static boolean isGetMethodInvocation(ExpressionTree tree, VisitorState state) {
        if (tree.getKind() == Tree.Kind.METHOD_INVOCATION) {
            MethodInvocationTree method = (MethodInvocationTree)tree;
            if (!method.getArguments().isEmpty()) {
                return false;
            }
            if (returnsListMatcher.matches((Tree)method, state)) {
                return false;
            }
            ExpressionTree expressionTree = method.getMethodSelect();
            if (expressionTree instanceof JCTree.JCFieldAccess) {
                JCTree.JCFieldAccess access = (JCTree.JCFieldAccess)expressionTree;
                String methodName = access.sym.getQualifiedName().toString();
                return ProtoFieldNullComparison.isFieldGetMethod(methodName);
            }
            return true;
        }
        return false;
    }

    private static boolean receiverIsProtoMessage(ExpressionTree tree, VisitorState state) {
        return protoMessageReceiverMatcher.matches((Tree)tree, state);
    }

    private static String replaceLast(String text, String pattern, String replacement) {
        StringBuilder builder = new StringBuilder(text);
        int lastIndexOf = builder.lastIndexOf(pattern);
        return builder.replace(lastIndexOf, lastIndexOf + pattern.length(), replacement).toString();
    }

    @Nullable
    private static String createReplacement(BinaryTree tree, VisitorState state) {
        ExpressionTree leftOperand = tree.getLeftOperand();
        ExpressionTree rightOperand = tree.getRightOperand();
        ExpressionTree methodInvocation = ProtoFieldNullComparison.isNull(leftOperand) ? rightOperand : leftOperand;
        if (ProtoFieldNullComparison.isGetMethodInvocation(methodInvocation, state)) {
            String methodName = ProtoFieldNullComparison.getMethodName(methodInvocation);
            String hasMethod = methodName.replaceFirst("get", "has");
            Set hasMethods = ASTHelpers.findMatchingMethods((Name)state.getName(hasMethod), NO_ARGS, (Type)ASTHelpers.getType((Tree)ASTHelpers.getReceiver((ExpressionTree)methodInvocation)), (Types)state.getTypes());
            if (hasMethods.isEmpty()) {
                return null;
            }
            String replacement = ProtoFieldNullComparison.replaceLast(methodInvocation.toString(), methodName, hasMethod);
            replacement = tree.getKind() == Tree.Kind.EQUAL_TO ? "!" + replacement : replacement;
            return replacement;
        }
        String replacement = methodInvocation + ".isEmpty()";
        return tree.getKind() == Tree.Kind.EQUAL_TO ? replacement : "!" + replacement;
    }

    public Description matchBinary(BinaryTree tree, VisitorState state) {
        if (!MATCHER.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        String replacement = ProtoFieldNullComparison.createReplacement(tree, state);
        if (replacement == null) {
            return this.describeMatch(tree);
        }
        return this.describeMatch(tree, (Fix)SuggestedFix.replace((Tree)tree, (String)ProtoFieldNullComparison.createReplacement(tree, state)));
    }
}

