/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.vectordrawable;

import com.android.ide.common.vectordrawable.SvgNode;
import com.android.ide.common.vectordrawable.SvgTree;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Node;

class SvgGroupNode
extends SvgNode {
    private static Logger logger = Logger.getLogger(SvgGroupNode.class.getSimpleName());
    private static final String INDENT_LEVEL = "    ";
    private ArrayList<SvgNode> mChildren = new ArrayList();

    public SvgGroupNode(SvgTree svgTree, Node docNode, String name) {
        super(svgTree, docNode, name);
    }

    public void addChild(SvgNode child) {
        this.mChildren.add(child);
        child.fillEmptyAttributes(this.mVdAttributesMap);
    }

    @Override
    public void dumpNode(String indent) {
        logger.log(Level.FINE, indent + "current group is :" + this.getName());
        for (SvgNode node : this.mChildren) {
            node.dumpNode(indent + INDENT_LEVEL);
        }
    }

    @Override
    public boolean isGroupNode() {
        return true;
    }

    @Override
    public void transformIfNeeded(AffineTransform rootTransform) {
        for (SvgNode p : this.mChildren) {
            p.transformIfNeeded(rootTransform);
        }
    }

    @Override
    public void flattern(AffineTransform transform) {
        for (SvgNode n : this.mChildren) {
            this.mStackedTransform.setTransform(transform);
            this.mStackedTransform.concatenate(this.mLocalTransform);
            n.flattern(this.mStackedTransform);
        }
    }

    @Override
    public void writeXML(OutputStreamWriter writer) throws IOException {
        for (SvgNode node : this.mChildren) {
            node.writeXML(writer);
        }
    }
}

