/*
 * Decompiled with CFR 0.152.
 */
package lombok.javac;

import com.sun.source.tree.Tree;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Name;
import java.util.List;
import lombok.core.TransformationsUtil;

public class Javac {
    private Javac() {
    }

    public static List<String> toAllGetterNames(JCTree.JCVariableDecl field) {
        Name fieldName = field.name;
        boolean isBoolean = field.vartype.toString().equals("boolean");
        return TransformationsUtil.toAllGetterNames(fieldName, isBoolean);
    }

    public static String toGetterName(JCTree.JCVariableDecl field) {
        Name fieldName = field.name;
        boolean isBoolean = field.vartype.toString().equals("boolean");
        return TransformationsUtil.toGetterName(fieldName, isBoolean);
    }

    public static List<String> toAllSetterNames(JCTree.JCVariableDecl field) {
        Name fieldName = field.name;
        boolean isBoolean = field.vartype.toString().equals("boolean");
        return TransformationsUtil.toAllSetterNames(fieldName, isBoolean);
    }

    public static String toSetterName(JCTree.JCVariableDecl field) {
        Name fieldName = field.name;
        boolean isBoolean = field.vartype.toString().equals("boolean");
        return TransformationsUtil.toSetterName(fieldName, isBoolean);
    }

    public static boolean isPrimitive(JCTree.JCExpression ref) {
        String typeName = ref.toString();
        return TransformationsUtil.PRIMITIVE_TYPE_NAME_PATTERN.matcher(typeName).matches();
    }

    public static Object calculateGuess(JCTree.JCExpression expr) {
        if (expr instanceof JCTree.JCLiteral) {
            JCTree.JCLiteral lit = (JCTree.JCLiteral)expr;
            if (lit.getKind() == Tree.Kind.BOOLEAN_LITERAL) {
                return ((Number)lit.value).intValue() != 0;
            }
            return lit.value;
        }
        if (expr instanceof JCTree.JCIdent || expr instanceof JCTree.JCFieldAccess) {
            String x = expr.toString();
            if (x.endsWith(".class")) {
                x = x.substring(0, x.length() - 6);
            } else {
                int idx = x.lastIndexOf(46);
                if (idx > -1) {
                    x = x.substring(idx + 1);
                }
            }
            return x;
        }
        return null;
    }

    public static int getCtcInt(Class<?> ctcLocation, String identifier) {
        try {
            return (Integer)ctcLocation.getField(identifier).get(null);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

