/*
 * Decompiled with CFR 0.152.
 */
package autovalue.shaded.com.google$.auto.service.processor;

import autovalue.shaded.com.google;
import autovalue.shaded.com.google$.auto.common.$AnnotationMirrors;
import autovalue.shaded.com.google$.auto.common.$MoreElements;
import autovalue.shaded.com.google$.auto.common.$MoreTypes;
import autovalue.shaded.com.google$.auto.service.$AutoService;
import autovalue.shaded.com.google$.auto.service.processor.$ServicesFiles;
import autovalue.shaded.com.google$.common.collect.$HashMultimap;
import autovalue.shaded.com.google$.common.collect.$ImmutableSet;
import autovalue.shaded.com.google$.common.collect.$Multimap;
import autovalue.shaded.com.google$.common.collect.$Sets;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleAnnotationValueVisitor8;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

@SupportedOptions(value={"debug", "verify"})
public class $AutoServiceProcessor
extends AbstractProcessor {
    @google..VisibleForTesting
    static final String MISSING_SERVICES_ERROR = "No service interfaces provided for element!";
    private $Multimap<String, String> providers = $HashMultimap.create();

    public $ImmutableSet<String> getSupportedAnnotationTypes() {
        return $ImmutableSet.of($AutoService.class.getName());
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            return this.processImpl(annotations, roundEnv);
        }
        catch (Exception e) {
            StringWriter writer = new StringWriter();
            e.printStackTrace(new PrintWriter(writer));
            this.fatalError(writer.toString());
            return true;
        }
    }

    private boolean processImpl(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            this.generateConfigFiles();
        } else {
            this.processAnnotations(annotations, roundEnv);
        }
        return true;
    }

    private void processAnnotations(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Set<? extends Element> elements = roundEnv.getElementsAnnotatedWith($AutoService.class);
        this.log(annotations.toString());
        this.log(elements.toString());
        for (Element element : elements) {
            TypeElement providerImplementer = (TypeElement)element;
            AnnotationMirror annotationMirror = $MoreElements.getAnnotationMirror(element, $AutoService.class).get();
            $ImmutableSet<DeclaredType> providerInterfaces = this.getValueFieldOfClasses(annotationMirror);
            if (providerInterfaces.isEmpty()) {
                this.error(MISSING_SERVICES_ERROR, element, annotationMirror);
                continue;
            }
            for (DeclaredType providerInterface : providerInterfaces) {
                TypeElement providerType = $MoreTypes.asTypeElement(providerInterface);
                this.log("provider interface: " + providerType.getQualifiedName());
                this.log("provider implementer: " + providerImplementer.getQualifiedName());
                if (this.checkImplementer(providerImplementer, providerType)) {
                    this.providers.put(this.getBinaryName(providerType), this.getBinaryName(providerImplementer));
                    continue;
                }
                String message = "ServiceProviders must implement their service provider interface. " + providerImplementer.getQualifiedName() + " does not implement " + providerType.getQualifiedName();
                this.error(message, element, annotationMirror);
            }
        }
    }

    private void generateConfigFiles() {
        Filer filer = this.processingEnv.getFiler();
        for (String providerInterface : this.providers.keySet()) {
            String resourceFile = "META-INF/services/" + providerInterface;
            this.log("Working on resource file: " + resourceFile);
            try {
                TreeSet<String> allServices = $Sets.newTreeSet();
                try {
                    FileObject existingFile = filer.getResource(StandardLocation.CLASS_OUTPUT, "", resourceFile);
                    this.log("Looking for existing resource file at " + existingFile.toUri());
                    Set<String> oldServices = $ServicesFiles.readServiceFile(existingFile.openInputStream());
                    this.log("Existing service entries: " + oldServices);
                    allServices.addAll(oldServices);
                }
                catch (IOException e) {
                    this.log("Resource file did not already exist.");
                }
                HashSet<String> newServices = new HashSet<String>(this.providers.get(providerInterface));
                if (allServices.containsAll(newServices)) {
                    this.log("No new service entries being added.");
                    return;
                }
                allServices.addAll(newServices);
                this.log("New service file contents: " + allServices);
                FileObject fileObject = filer.createResource(StandardLocation.CLASS_OUTPUT, "", resourceFile, new Element[0]);
                OutputStream out = fileObject.openOutputStream();
                $ServicesFiles.writeServiceFile(allServices, out);
                out.close();
                this.log("Wrote to: " + fileObject.toUri());
            }
            catch (IOException e) {
                this.fatalError("Unable to create " + resourceFile + ", " + e);
                return;
            }
        }
    }

    private boolean checkImplementer(TypeElement providerImplementer, TypeElement providerType) {
        String verify = this.processingEnv.getOptions().get("verify");
        if (verify == null || !Boolean.valueOf(verify).booleanValue()) {
            return true;
        }
        Types types = this.processingEnv.getTypeUtils();
        return types.isSubtype(providerImplementer.asType(), providerType.asType());
    }

    private String getBinaryName(TypeElement element) {
        return this.getBinaryNameImpl(element, element.getSimpleName().toString());
    }

    private String getBinaryNameImpl(TypeElement element, String className) {
        Element enclosingElement = element.getEnclosingElement();
        if (enclosingElement instanceof PackageElement) {
            PackageElement pkg = (PackageElement)enclosingElement;
            if (pkg.isUnnamed()) {
                return className;
            }
            return pkg.getQualifiedName() + "." + className;
        }
        TypeElement typeElement = (TypeElement)enclosingElement;
        return this.getBinaryNameImpl(typeElement, typeElement.getSimpleName() + "$" + className);
    }

    private $ImmutableSet<DeclaredType> getValueFieldOfClasses(AnnotationMirror annotationMirror) {
        return $AnnotationMirrors.getAnnotationValue(annotationMirror, "value").accept(new SimpleAnnotationValueVisitor8<$ImmutableSet<DeclaredType>, Void>(){

            @Override
            public $ImmutableSet<DeclaredType> visitType(TypeMirror typeMirror, Void v) {
                return $ImmutableSet.of($MoreTypes.asDeclared(typeMirror));
            }

            @Override
            public $ImmutableSet<DeclaredType> visitArray(List<? extends AnnotationValue> values, Void v) {
                return values.stream().flatMap(value -> value.accept(this, null).stream()).collect($ImmutableSet.toImmutableSet());
            }
        }, null);
    }

    private void log(String msg) {
        if (this.processingEnv.getOptions().containsKey("debug")) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, msg);
        }
    }

    private void error(String msg, Element element, AnnotationMirror annotation) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, element, annotation);
    }

    private void fatalError(String msg) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "FATAL ERROR: " + msg);
    }
}

