/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.skyframe.serialization.autocodec;

import com.google.common.collect.ImmutableList;
import com.google.devtools.build.lib.skyframe.serialization.DeserializationContext;
import com.google.devtools.build.lib.skyframe.serialization.ObjectCodec;
import com.google.devtools.build.lib.skyframe.serialization.SerializationContext;
import com.google.devtools.build.lib.skyframe.serialization.SerializationException;
import com.google.devtools.build.lib.skyframe.serialization.autocodec.AutoCodec;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.MirroredTypesException;
import javax.lang.model.type.TypeMirror;

class AutoCodecUtil {
    private static final String GENERATED_CLASS_NAME_SUFFIX = "AutoCodec";
    static final Class<AutoCodec> ANNOTATION = AutoCodec.class;

    AutoCodecUtil() {
    }

    static TypeSpec.Builder initializeCodecClassBuilder(TypeElement encodedType, ProcessingEnvironment env) {
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)AutoCodecUtil.getCodecName(encodedType));
        return builder.addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(ObjectCodec.class), (TypeName[])new TypeName[]{TypeName.get((TypeMirror)env.getTypeUtils().erasure(encodedType.asType()))}));
    }

    static MethodSpec.Builder initializeGetEncodedClassMethod(TypeElement encodedType, ProcessingEnvironment env) {
        return MethodSpec.methodBuilder((String)"getEncodedClass").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Class.class), (TypeName[])new TypeName[]{TypeName.get((TypeMirror)env.getTypeUtils().erasure(encodedType.asType()))}));
    }

    static MethodSpec.Builder initializeSerializeMethodBuilder(TypeElement encodedType, AutoCodec annotation, ProcessingEnvironment env) {
        List<TypeMirror> explicitlyAllowedClasses;
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"serialize").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Void.TYPE).addAnnotation(Override.class).addException(SerializationException.class).addException(IOException.class).addParameter(SerializationContext.class, "context", new Modifier[0]).addParameter(TypeName.get((TypeMirror)env.getTypeUtils().erasure(encodedType.asType())), "input", new Modifier[0]).addParameter(CodedOutputStream.class, "codedOut", new Modifier[0]);
        if (annotation.checkClassExplicitlyAllowed()) {
            builder.addStatement("context.checkClassExplicitlyAllowed(getEncodedClass())", new Object[0]);
        }
        try {
            explicitlyAllowedClasses = Arrays.stream(annotation.explicitlyAllowClass()).map(clazz -> AutoCodecUtil.getType(clazz, env)).collect(Collectors.toList());
        }
        catch (MirroredTypesException e) {
            explicitlyAllowedClasses = e.getTypeMirrors();
        }
        for (TypeMirror typeMirror : explicitlyAllowedClasses) {
            builder.addStatement("context.addExplicitlyAllowedClass($T.class)", new Object[]{typeMirror});
        }
        return builder;
    }

    static MethodSpec.Builder initializeDeserializeMethodBuilder(TypeElement encodedType, ProcessingEnvironment env) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"deserialize").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(TypeName.get((TypeMirror)env.getTypeUtils().erasure(encodedType.asType()))).addAnnotation(Override.class).addException(SerializationException.class).addException(IOException.class).addParameter(DeserializationContext.class, "context", new Modifier[0]).addParameter(CodedInputStream.class, "codedIn", new Modifier[0]);
        return builder;
    }

    static String getGeneratedName(Element element, String suffix) {
        ImmutableList.Builder classNamesBuilder = new ImmutableList.Builder();
        classNamesBuilder.add((Object)suffix);
        do {
            classNamesBuilder.add((Object)element.getSimpleName().toString());
        } while ((element = element.getEnclosingElement()) instanceof TypeElement);
        return classNamesBuilder.build().reverse().stream().collect(Collectors.joining("_"));
    }

    private static String getCodecName(Element element) {
        return AutoCodecUtil.getGeneratedName(element, GENERATED_CLASS_NAME_SUFFIX);
    }

    static TypeMirror getType(Class<?> clazz, ProcessingEnvironment env) {
        return env.getElementUtils().getTypeElement(clazz.getCanonicalName()).asType();
    }

    static boolean isSubType(TypeMirror type, Class<?> clazz, ProcessingEnvironment env) {
        return env.getTypeUtils().isSubtype(type, AutoCodecUtil.getType(clazz, env));
    }
}

