/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.value.processor.escapevelocity;

import autovalue.shaded.com.google$.common.base.$Verify;
import autovalue.shaded.com.google$.common.collect.$ImmutableList;
import com.google.auto.value.processor.escapevelocity.EvaluationContext;
import com.google.auto.value.processor.escapevelocity.ExpressionNode;
import com.google.auto.value.processor.escapevelocity.Macro;
import com.google.auto.value.processor.escapevelocity.Node;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

abstract class DirectiveNode
extends Node {
    DirectiveNode(String resourceName, int lineNumber) {
        super(resourceName, lineNumber);
    }

    static class MacroCallNode
    extends DirectiveNode {
        private final String name;
        private final $ImmutableList<Node> thunks;
        private Macro macro;

        MacroCallNode(String resourceName, int lineNumber, String name, $ImmutableList<Node> argumentNodes) {
            super(resourceName, lineNumber);
            this.name = name;
            this.thunks = argumentNodes;
        }

        String name() {
            return this.name;
        }

        int argumentCount() {
            return this.thunks.size();
        }

        void setMacro(Macro macro) {
            this.macro = macro;
        }

        @Override
        Object evaluate(EvaluationContext context) {
            $Verify.verifyNotNull(this.macro, "Macro #%s should have been linked", this.name);
            return this.macro.evaluate(context, this.thunks);
        }
    }

    static class ForEachNode
    extends DirectiveNode {
        private final String var;
        private final ExpressionNode collection;
        private final Node body;

        ForEachNode(String resourceName, int lineNumber, String var, ExpressionNode in, Node body) {
            super(resourceName, lineNumber);
            this.var = var;
            this.collection = in;
            this.body = body;
        }

        @Override
        Object evaluate(EvaluationContext context) {
            Collection<Object> iterable;
            Object collectionValue = this.collection.evaluate(context);
            if (collectionValue instanceof Iterable) {
                iterable = (List<Object>)collectionValue;
            } else if (collectionValue instanceof Object[]) {
                iterable = Arrays.asList((Object[])collectionValue);
            } else if (collectionValue instanceof Map) {
                iterable = ((Map)collectionValue).values();
            } else {
                throw this.evaluationException("Not iterable: " + collectionValue);
            }
            Runnable undo = context.setVar(this.var, null);
            StringBuilder sb = new StringBuilder();
            Iterator it = iterable.iterator();
            Runnable undoForEach = context.setVar("foreach", new ForEachVar(it));
            while (it.hasNext()) {
                context.setVar(this.var, it.next());
                sb.append(this.body.evaluate(context));
            }
            undoForEach.run();
            undo.run();
            return sb.toString();
        }

        private static class ForEachVar {
            private final Iterator<?> iterator;

            ForEachVar(Iterator<?> iterator) {
                this.iterator = iterator;
            }

            public boolean getHasNext() {
                return this.iterator.hasNext();
            }
        }
    }

    static class IfNode
    extends DirectiveNode {
        private final ExpressionNode condition;
        private final Node truePart;
        private final Node falsePart;

        IfNode(String resourceName, int lineNumber, ExpressionNode condition, Node trueNode, Node falseNode) {
            super(resourceName, lineNumber);
            this.condition = condition;
            this.truePart = trueNode;
            this.falsePart = falseNode;
        }

        @Override
        Object evaluate(EvaluationContext context) {
            Node branch = this.condition.isDefinedAndTrue(context) ? this.truePart : this.falsePart;
            return branch.evaluate(context);
        }
    }

    static class SetNode
    extends DirectiveNode {
        private final String var;
        private final Node expression;

        SetNode(String var, Node expression) {
            super(expression.resourceName, expression.lineNumber);
            this.var = var;
            this.expression = expression;
        }

        @Override
        Object evaluate(EvaluationContext context) {
            context.setVar(this.var, this.expression.evaluate(context));
            return "";
        }
    }
}

