/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import com.sun.tools.javac.util.Assert;
import java.util.HashMap;
import java.util.Map;

public class Context {
    protected final Map<Key<?>, Object> ht = new HashMap();
    private final Map<Key<?>, Factory<?>> ft = new HashMap();
    private final Map<Class<?>, Key<?>> kt = new HashMap();

    public <T> void put(Key<T> key, Factory<T> fac) {
        Context.checkState(this.ht);
        Factory<T> old = this.ht.put(key, fac);
        if (old != null) {
            throw new AssertionError((Object)"duplicate context value");
        }
        Context.checkState(this.ft);
        this.ft.put(key, fac);
    }

    public <T> void put(Key<T> key, T data) {
        if (data instanceof Factory) {
            throw new AssertionError((Object)"T extends Context.Factory");
        }
        Context.checkState(this.ht);
        Object old = this.ht.put(key, data);
        if (old != null && !(old instanceof Factory) && old != data && data != null) {
            throw new AssertionError((Object)"duplicate context value");
        }
    }

    public <T> T get(Key<T> key) {
        Context.checkState(this.ht);
        Object o = this.ht.get(key);
        if (o instanceof Factory) {
            Factory fac = (Factory)o;
            if ((o = fac.make(this)) instanceof Factory) {
                throw new AssertionError((Object)"T extends Context.Factory");
            }
            Assert.check(this.ht.get(key) == o);
        }
        return Context.uncheckedCast(o);
    }

    protected <T> Key<T> key(Class<T> clss) {
        Context.checkState(this.kt);
        Key k = (Key)Context.uncheckedCast(this.kt.get(clss));
        if (k == null) {
            k = new Key();
            this.kt.put(clss, k);
        }
        return k;
    }

    public <T> T get(Class<T> clazz) {
        return this.get(this.key(clazz));
    }

    public <T> void put(Class<T> clazz, T data) {
        this.put(this.key(clazz), data);
    }

    public <T> void put(Class<T> clazz, Factory<T> fac) {
        this.put(this.key(clazz), (T)fac);
    }

    private static <T> T uncheckedCast(Object o) {
        return (T)o;
    }

    public void dump() {
        for (Object value : this.ht.values()) {
            System.err.println(value == null ? null : value.getClass());
        }
    }

    private static void checkState(Map<?, ?> t) {
        if (t == null) {
            throw new IllegalStateException();
        }
    }

    public static interface Factory<T> {
        public T make(Context var1);
    }

    public static class Key<T> {
    }
}

