/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.auto.value.AutoAnnotation;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dagger.internal.codegen.AutoValue_MapKeyGenerator_MapKeyCreatorSpecification;
import dagger.internal.codegen.CodeBlocks;
import dagger.internal.codegen.MapKeys;
import dagger.internal.codegen.SourceFileGenerator;
import dagger.shaded.auto.common.MoreTypes;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleTypeVisitor6;

final class MapKeyGenerator
extends SourceFileGenerator<MapKeyCreatorSpecification> {
    private static final SimpleTypeVisitor6<Void, Set<TypeElement>> TRAVERSE_NESTED_ANNOTATIONS = new SimpleTypeVisitor6<Void, Set<TypeElement>>(){

        @Override
        public Void visitDeclared(DeclaredType t, Set<TypeElement> p) {
            TypeElement typeElement = MoreTypes.asTypeElement(t);
            if (typeElement.getKind() == ElementKind.ANNOTATION_TYPE) {
                MapKeyGenerator.nestedAnnotationElements(typeElement, p);
            }
            return null;
        }
    };

    MapKeyGenerator(Filer filer, Elements elements) {
        super(filer, elements);
    }

    @Override
    ClassName nameGeneratedType(MapKeyCreatorSpecification mapKeyCreatorType) {
        return MapKeys.getMapKeyCreatorClassName(mapKeyCreatorType.mapKeyElement());
    }

    @Override
    Optional<? extends Element> getElementForErrorReporting(MapKeyCreatorSpecification mapKeyCreatorType) {
        return Optional.of((Object)mapKeyCreatorType.mapKeyElement());
    }

    @Override
    Optional<TypeSpec.Builder> write(ClassName generatedTypeName, MapKeyCreatorSpecification mapKeyCreatorType) {
        TypeSpec.Builder mapKeyCreatorBuilder = TypeSpec.classBuilder(generatedTypeName).addModifiers(Modifier.PUBLIC, Modifier.FINAL);
        mapKeyCreatorBuilder.addMethod(MethodSpec.constructorBuilder().addModifiers(Modifier.PRIVATE).build());
        for (TypeElement annotationElement : MapKeyGenerator.nestedAnnotationElements(mapKeyCreatorType.annotationElement())) {
            mapKeyCreatorBuilder.addMethod(this.buildCreateMethod(generatedTypeName, annotationElement));
        }
        return Optional.of((Object)mapKeyCreatorBuilder);
    }

    private MethodSpec buildCreateMethod(ClassName mapKeyGeneratedTypeName, TypeElement annotationElement) {
        String string = String.valueOf(annotationElement.getSimpleName());
        String createMethodName = new StringBuilder(6 + String.valueOf(string).length()).append("create").append(string).toString();
        MethodSpec.Builder createMethod = MethodSpec.methodBuilder(createMethodName).addAnnotation(AutoAnnotation.class).addModifiers(Modifier.PUBLIC, Modifier.STATIC).returns(TypeName.get(annotationElement.asType()));
        ImmutableList.Builder parameters = ImmutableList.builder();
        for (ExecutableElement annotationMember : ElementFilter.methodsIn(annotationElement.getEnclosedElements())) {
            String parameterName = annotationMember.getSimpleName().toString();
            TypeName parameterType = TypeName.get(annotationMember.getReturnType());
            createMethod.addParameter(parameterType, parameterName, new Modifier[0]);
            parameters.add((Object)CodeBlock.of("$L", parameterName));
        }
        String string2 = String.valueOf(mapKeyGeneratedTypeName.simpleName());
        ClassName autoAnnotationClass = mapKeyGeneratedTypeName.peerClass(new StringBuilder(16 + String.valueOf(string2).length() + String.valueOf(createMethodName).length()).append("AutoAnnotation_").append(string2).append("_").append(createMethodName).toString());
        createMethod.addStatement("return new $T($L)", autoAnnotationClass, CodeBlocks.makeParametersCodeBlock((Iterable<CodeBlock>)parameters.build()));
        return createMethod.build();
    }

    private static Set<TypeElement> nestedAnnotationElements(TypeElement annotationElement) {
        return MapKeyGenerator.nestedAnnotationElements(annotationElement, new LinkedHashSet<TypeElement>());
    }

    @CanIgnoreReturnValue
    private static Set<TypeElement> nestedAnnotationElements(TypeElement annotationElement, Set<TypeElement> annotationElements) {
        if (annotationElements.add(annotationElement)) {
            for (ExecutableElement method : ElementFilter.methodsIn(annotationElement.getEnclosedElements())) {
                TRAVERSE_NESTED_ANNOTATIONS.visit(method.getReturnType(), annotationElements);
            }
        }
        return annotationElements;
    }

    static abstract class MapKeyCreatorSpecification {
        MapKeyCreatorSpecification() {
        }

        abstract TypeElement mapKeyElement();

        abstract TypeElement annotationElement();

        static MapKeyCreatorSpecification wrappedMapKey(TypeElement mapKeyElement) {
            return new AutoValue_MapKeyGenerator_MapKeyCreatorSpecification(mapKeyElement, mapKeyElement);
        }

        static MapKeyCreatorSpecification unwrappedMapKeyWithAnnotationValue(TypeElement mapKeyElement, TypeElement annotationElement) {
            return new AutoValue_MapKeyGenerator_MapKeyCreatorSpecification(mapKeyElement, annotationElement);
        }
    }
}

