/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.file;

import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.file.FSInfo;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.StringUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.zip.ZipFile;
import javax.tools.JavaFileManager;
import javax.tools.StandardLocation;

public class Locations {
    private Log log;
    private FSInfo fsInfo;
    private boolean warn;
    Map<JavaFileManager.Location, LocationHandler> handlersForLocation;
    Map<Option, LocationHandler> handlersForOption;

    public Locations() {
        this.initHandlers();
    }

    public void update(Log log, Lint lint, FSInfo fSInfo) {
        this.log = log;
        this.warn = lint.isEnabled(Lint.LintCategory.PATH);
        this.fsInfo = fSInfo;
    }

    public Collection<File> bootClassPath() {
        return this.getLocation(StandardLocation.PLATFORM_CLASS_PATH);
    }

    public boolean isDefaultBootClassPath() {
        BootClassPathLocationHandler bootClassPathLocationHandler = (BootClassPathLocationHandler)this.getHandler(StandardLocation.PLATFORM_CLASS_PATH);
        return bootClassPathLocationHandler.isDefault();
    }

    boolean isDefaultBootClassPathRtJar(File file) {
        BootClassPathLocationHandler bootClassPathLocationHandler = (BootClassPathLocationHandler)this.getHandler(StandardLocation.PLATFORM_CLASS_PATH);
        return bootClassPathLocationHandler.isDefaultRtJar(file);
    }

    public Collection<File> userClassPath() {
        return this.getLocation(StandardLocation.CLASS_PATH);
    }

    public Collection<File> sourcePath() {
        Collection<File> collection = this.getLocation(StandardLocation.SOURCE_PATH);
        return collection == null || collection.isEmpty() ? null : collection;
    }

    private static Iterable<File> getPathEntries(String string) {
        return Locations.getPathEntries(string, null);
    }

    private static Iterable<File> getPathEntries(String string, File file) {
        ListBuffer<File> listBuffer = new ListBuffer<File>();
        int n = 0;
        while (n <= string.length()) {
            int n2 = string.indexOf(File.pathSeparatorChar, n);
            if (n2 == -1) {
                n2 = string.length();
            }
            if (n < n2) {
                listBuffer.add(new File(string.substring(n, n2)));
            } else if (file != null) {
                listBuffer.add(file);
            }
            n = n2 + 1;
        }
        return listBuffer;
    }

    void initHandlers() {
        LocationHandler[] locationHandlerArray;
        this.handlersForLocation = new HashMap<JavaFileManager.Location, LocationHandler>();
        this.handlersForOption = new EnumMap<Option, LocationHandler>(Option.class);
        for (LocationHandler locationHandler : locationHandlerArray = new LocationHandler[]{new BootClassPathLocationHandler(), new ClassPathLocationHandler(), new SimpleLocationHandler(StandardLocation.SOURCE_PATH, Option.SOURCEPATH), new SimpleLocationHandler(StandardLocation.ANNOTATION_PROCESSOR_PATH, Option.PROCESSORPATH), new OutputLocationHandler(StandardLocation.CLASS_OUTPUT, Option.D), new OutputLocationHandler(StandardLocation.SOURCE_OUTPUT, Option.S), new OutputLocationHandler(StandardLocation.NATIVE_HEADER_OUTPUT, Option.H)}) {
            this.handlersForLocation.put(locationHandler.location, locationHandler);
            for (Option option : locationHandler.options) {
                this.handlersForOption.put(option, locationHandler);
            }
        }
    }

    public boolean handleOption(Option option, String string) {
        LocationHandler locationHandler = this.handlersForOption.get((Object)option);
        return locationHandler == null ? false : locationHandler.handleOption(option, string);
    }

    Collection<File> getLocation(JavaFileManager.Location location) {
        LocationHandler locationHandler = this.getHandler(location);
        return locationHandler == null ? null : locationHandler.getLocation();
    }

    File getOutputLocation(JavaFileManager.Location location) {
        if (!location.isOutputLocation()) {
            throw new IllegalArgumentException();
        }
        LocationHandler locationHandler = this.getHandler(location);
        return ((OutputLocationHandler)locationHandler).outputDir;
    }

    void setLocation(JavaFileManager.Location location, Iterable<? extends File> iterable) throws IOException {
        LocationHandler locationHandler = this.getHandler(location);
        if (locationHandler == null) {
            locationHandler = location.isOutputLocation() ? new OutputLocationHandler(location, new Option[0]) : new SimpleLocationHandler(location, new Option[0]);
            this.handlersForLocation.put(location, locationHandler);
        }
        locationHandler.setLocation(iterable);
    }

    protected LocationHandler getHandler(JavaFileManager.Location location) {
        location.getClass();
        return this.handlersForLocation.get(location);
    }

    private boolean isArchive(File file) {
        String string = StringUtils.toLowerCase(file.getName());
        return this.fsInfo.isFile(file) && (string.endsWith(".jar") || string.endsWith(".zip"));
    }

    public static URL[] pathToURLs(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        URL[] uRLArray = new URL[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            URL uRL = Locations.fileToURL(new File(stringTokenizer.nextToken()));
            if (uRL == null) continue;
            uRLArray[n++] = uRL;
        }
        uRLArray = Arrays.copyOf(uRLArray, n);
        return uRLArray;
    }

    private static URL fileToURL(File file) {
        String string;
        try {
            string = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            string = file.getAbsolutePath();
        }
        string = string.replace(File.separatorChar, '/');
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        if (!file.isFile()) {
            string = string + "/";
        }
        try {
            return new URL("file", "", string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException(file.toString());
        }
    }

    private class BootClassPathLocationHandler
    extends LocationHandler {
        private Collection<File> searchPath;
        final Map<Option, String> optionValues;
        private File defaultBootClassPathRtJar;
        private boolean isDefaultBootClassPath;

        BootClassPathLocationHandler() {
            super(StandardLocation.PLATFORM_CLASS_PATH, Option.BOOTCLASSPATH, Option.XBOOTCLASSPATH, Option.XBOOTCLASSPATH_PREPEND, Option.XBOOTCLASSPATH_APPEND, Option.ENDORSEDDIRS, Option.DJAVA_ENDORSED_DIRS, Option.EXTDIRS, Option.DJAVA_EXT_DIRS);
            this.optionValues = new EnumMap<Option, String>(Option.class);
            this.defaultBootClassPathRtJar = null;
        }

        boolean isDefault() {
            this.lazy();
            return this.isDefaultBootClassPath;
        }

        boolean isDefaultRtJar(File file) {
            this.lazy();
            return file.equals(this.defaultBootClassPathRtJar);
        }

        @Override
        boolean handleOption(Option option, String string) {
            if (!this.options.contains((Object)option)) {
                return false;
            }
            option = this.canonicalize(option);
            this.optionValues.put(option, string);
            if (option == Option.BOOTCLASSPATH) {
                this.optionValues.remove((Object)Option.XBOOTCLASSPATH_PREPEND);
                this.optionValues.remove((Object)Option.XBOOTCLASSPATH_APPEND);
            }
            this.searchPath = null;
            return true;
        }

        private Option canonicalize(Option option) {
            switch (option) {
                case XBOOTCLASSPATH: {
                    return Option.BOOTCLASSPATH;
                }
                case DJAVA_ENDORSED_DIRS: {
                    return Option.ENDORSEDDIRS;
                }
                case DJAVA_EXT_DIRS: {
                    return Option.EXTDIRS;
                }
            }
            return option;
        }

        @Override
        Collection<File> getLocation() {
            this.lazy();
            return this.searchPath;
        }

        @Override
        void setLocation(Iterable<? extends File> iterable) {
            if (iterable == null) {
                this.searchPath = null;
            } else {
                this.defaultBootClassPathRtJar = null;
                this.isDefaultBootClassPath = false;
                Path path = new Path().addFiles(iterable, false);
                this.searchPath = Collections.unmodifiableCollection(path);
                this.optionValues.clear();
            }
        }

        Path computePath() {
            this.defaultBootClassPathRtJar = null;
            Path path = new Path();
            String string = this.optionValues.get((Object)Option.BOOTCLASSPATH);
            String string2 = this.optionValues.get((Object)Option.ENDORSEDDIRS);
            String string3 = this.optionValues.get((Object)Option.EXTDIRS);
            String string4 = this.optionValues.get((Object)Option.XBOOTCLASSPATH_PREPEND);
            String string5 = this.optionValues.get((Object)Option.XBOOTCLASSPATH_APPEND);
            path.addFiles(string4);
            if (string2 != null) {
                path.addDirectories(string2);
            } else {
                path.addDirectories(System.getProperty("java.endorsed.dirs"), false);
            }
            if (string != null) {
                path.addFiles(string);
            } else {
                String string6 = System.getProperty("sun.boot.class.path");
                path.addFiles(string6, false);
                File file = new File("rt.jar");
                for (File file2 : Locations.getPathEntries(string6)) {
                    if (!new File(file2.getName()).equals(file)) continue;
                    this.defaultBootClassPathRtJar = file2;
                }
            }
            path.addFiles(string5);
            if (string3 != null) {
                path.addDirectories(string3);
            } else {
                path.addDirectories(System.getProperty("java.ext.dirs"), false);
            }
            this.isDefaultBootClassPath = string4 == null && string == null && string5 == null;
            return path;
        }

        private void lazy() {
            if (this.searchPath == null) {
                this.searchPath = Collections.unmodifiableCollection(this.computePath());
            }
        }
    }

    private class ClassPathLocationHandler
    extends SimpleLocationHandler {
        ClassPathLocationHandler() {
            super(StandardLocation.CLASS_PATH, Option.CLASSPATH, Option.CP);
        }

        @Override
        Collection<File> getLocation() {
            this.lazy();
            return this.searchPath;
        }

        @Override
        protected Path computePath(String string) {
            String string2 = string;
            if (string2 == null) {
                string2 = System.getProperty("env.class.path");
            }
            if (string2 == null && System.getProperty("application.home") == null) {
                string2 = System.getProperty("java.class.path");
            }
            if (string2 == null) {
                string2 = ".";
            }
            return this.createPath().addFiles(string2);
        }

        @Override
        protected Path createPath() {
            return new Path().expandJarClassPaths(true).emptyPathDefault(new File("."));
        }

        private void lazy() {
            if (this.searchPath == null) {
                this.setLocation(null);
            }
        }
    }

    private class SimpleLocationHandler
    extends LocationHandler {
        protected Collection<File> searchPath;

        SimpleLocationHandler(JavaFileManager.Location location, Option ... optionArray) {
            super(location, optionArray);
        }

        @Override
        boolean handleOption(Option option, String string) {
            if (!this.options.contains((Object)option)) {
                return false;
            }
            this.searchPath = string == null ? null : Collections.unmodifiableCollection(this.createPath().addFiles(string));
            return true;
        }

        @Override
        Collection<File> getLocation() {
            return this.searchPath;
        }

        @Override
        void setLocation(Iterable<? extends File> iterable) {
            Path path = iterable == null ? this.computePath(null) : this.createPath().addFiles(iterable);
            this.searchPath = Collections.unmodifiableCollection(path);
        }

        protected Path computePath(String string) {
            return this.createPath().addFiles(string);
        }

        protected Path createPath() {
            return new Path();
        }
    }

    private class OutputLocationHandler
    extends LocationHandler {
        private File outputDir;

        OutputLocationHandler(JavaFileManager.Location location, Option ... optionArray) {
            super(location, optionArray);
        }

        @Override
        boolean handleOption(Option option, String string) {
            if (!this.options.contains((Object)option)) {
                return false;
            }
            this.outputDir = string == null ? null : new File(string);
            return true;
        }

        @Override
        Collection<File> getLocation() {
            return this.outputDir == null ? null : Collections.singleton(this.outputDir);
        }

        @Override
        void setLocation(Iterable<? extends File> iterable) throws IOException {
            if (iterable == null) {
                this.outputDir = null;
            } else {
                Iterator<? extends File> iterator = iterable.iterator();
                if (!iterator.hasNext()) {
                    throw new IllegalArgumentException("empty path for directory");
                }
                File file = iterator.next();
                if (iterator.hasNext()) {
                    throw new IllegalArgumentException("path too long for directory");
                }
                if (!file.exists()) {
                    throw new FileNotFoundException(file + ": does not exist");
                }
                if (!file.isDirectory()) {
                    throw new IOException(file + ": not a directory");
                }
                this.outputDir = file;
            }
        }
    }

    protected abstract class LocationHandler {
        final JavaFileManager.Location location;
        final Set<Option> options;

        protected LocationHandler(JavaFileManager.Location location, Option ... optionArray) {
            this.location = location;
            this.options = optionArray.length == 0 ? EnumSet.noneOf(Option.class) : EnumSet.copyOf(Arrays.asList(optionArray));
        }

        abstract boolean handleOption(Option var1, String var2);

        abstract Collection<File> getLocation();

        abstract void setLocation(Iterable<? extends File> var1) throws IOException;
    }

    private class Path
    extends LinkedHashSet<File> {
        private static final long serialVersionUID = 0L;
        private boolean expandJarClassPaths = false;
        private final Set<File> canonicalValues = new HashSet<File>();
        private File emptyPathDefault = null;

        private Path() {
        }

        public Path expandJarClassPaths(boolean bl) {
            this.expandJarClassPaths = bl;
            return this;
        }

        public Path emptyPathDefault(File file) {
            this.emptyPathDefault = file;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Path addDirectories(String string, boolean bl) {
            boolean bl2 = this.expandJarClassPaths;
            this.expandJarClassPaths = true;
            try {
                if (string != null) {
                    for (File file : Locations.getPathEntries(string)) {
                        this.addDirectory(file, bl);
                    }
                }
                Path path = this;
                return path;
            }
            finally {
                this.expandJarClassPaths = bl2;
            }
        }

        public Path addDirectories(String string) {
            return this.addDirectories(string, Locations.this.warn);
        }

        private void addDirectory(File file, boolean bl) {
            if (!file.isDirectory()) {
                if (bl) {
                    Locations.this.log.warning(Lint.LintCategory.PATH, "dir.path.element.not.found", file);
                }
                return;
            }
            File[] fileArray = file.listFiles();
            if (fileArray == null) {
                return;
            }
            for (File file2 : fileArray) {
                if (!Locations.this.isArchive(file2)) continue;
                this.addFile(file2, bl);
            }
        }

        public Path addFiles(String string, boolean bl) {
            if (string != null) {
                this.addFiles(Locations.getPathEntries(string, this.emptyPathDefault), bl);
            }
            return this;
        }

        public Path addFiles(String string) {
            return this.addFiles(string, Locations.this.warn);
        }

        public Path addFiles(Iterable<? extends File> iterable, boolean bl) {
            if (iterable != null) {
                for (File file : iterable) {
                    this.addFile(file, bl);
                }
            }
            return this;
        }

        public Path addFiles(Iterable<? extends File> iterable) {
            return this.addFiles(iterable, Locations.this.warn);
        }

        public void addFile(File file, boolean bl) {
            if (this.contains(file)) {
                return;
            }
            if (!Locations.this.fsInfo.exists(file)) {
                if (bl) {
                    Locations.this.log.warning(Lint.LintCategory.PATH, "path.element.not.found", file);
                }
                super.add(file);
                return;
            }
            File file2 = Locations.this.fsInfo.getCanonicalFile(file);
            if (this.canonicalValues.contains(file2)) {
                return;
            }
            if (Locations.this.fsInfo.isFile(file) && !Locations.this.isArchive(file)) {
                try {
                    ZipFile zipFile = new ZipFile(file);
                    zipFile.close();
                    if (bl) {
                        Locations.this.log.warning(Lint.LintCategory.PATH, "unexpected.archive.file", file);
                    }
                }
                catch (IOException iOException) {
                    if (bl) {
                        Locations.this.log.warning(Lint.LintCategory.PATH, "invalid.archive.file", file);
                    }
                    return;
                }
            }
            super.add(file);
            this.canonicalValues.add(file2);
            if (this.expandJarClassPaths && Locations.this.fsInfo.isFile(file)) {
                this.addJarClassPath(file, bl);
            }
        }

        private void addJarClassPath(File file, boolean bl) {
            try {
                for (File file2 : Locations.this.fsInfo.getJarClassPath(file)) {
                    this.addFile(file2, bl);
                }
            }
            catch (IOException iOException) {
                Locations.this.log.error("error.reading.file", file, JavacFileManager.getMessage(iOException));
            }
        }
    }
}

